/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.AbstractBarElement;
import com.sas.graphics.silk.base.BarParmElement;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.silk.xml.parsers.BarParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class BarParmParser
extends ChartParser {
    protected SILKElementInfoReader barInfo = null;

    public BarParmParser() {
        this(null);
    }

    public BarParmParser(PropertyInterface instance) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/barparm.config";
        this.barInfo = new SILKElementInfoReader(configFile);
        this.barInfo.setInstance(instance);
    }

    @Override
    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String stmt;
        if (element != null && element.hasAttribute("_stmt") && (stmt = element.getAttribute("_stmt")).equalsIgnoreCase("barchart")) {
            BarParser bp = new BarParser();
            return bp.getFromXML(context, element, instance);
        }
        if (element != null && element.hasAttribute("orient")) {
            String orient = element.getAttribute("orient");
            this.barInfo = "HORIZONTAL".equalsIgnoreCase(orient) ? new SILKElementInfoReader("com/sas/graphics/silk/xml/parsers/config/hBarParm.config") : new SILKElementInfoReader("com/sas/graphics/silk/xml/parsers/config/barparm.config");
        }
        return super.getFromXML(context, element, instance);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        Object obj;
        Element fillAttrs;
        Object obj2;
        Element outlineAttrs;
        ParserUtils.parseElement(context, element, this.barInfo);
        if (this.barInfo.getXmlTarget() instanceof PropertyInterface) {
            int end;
            int start;
            PropertyInterface bar = (PropertyInterface)this.barInfo.getXmlTarget();
            String displayBarRangeStart = element.getAttribute("displayBarRangeStart");
            String displayBarRangeEnd = element.getAttribute("displayBarRangeEnd");
            if (displayBarRangeStart != null && displayBarRangeStart.length() > 0 && displayBarRangeEnd != null && displayBarRangeEnd.length() > 0 && (start = ParserUtils.getIntValue((String)displayBarRangeStart)) < (end = ParserUtils.getIntValue((String)displayBarRangeEnd))) {
                bar.setPropertyValue(809, (Object)new int[]{start, end});
            }
        }
        if (element.hasAttribute("outlineAttrs") && this.getObject() instanceof BaseElement) {
            ((BaseElement)this.getObject()).setStyleElement("LINE_ATTRS", element.getAttribute("lineAttrs"));
        }
        if ((outlineAttrs = ParserUtils.getChildWithTagName((String)"OutlineAttrs", (Element)element)) != null && this.getObject() instanceof PropertyInterface && (obj2 = ((PropertyInterface)this.getObject()).getPropertyValue(19009)) instanceof StyleElementAttrs) {
            ParserUtils.parseLineAttrs(outlineAttrs, ((StyleElementAttrs)obj2).getOverrides(true));
        }
        if (element.hasAttribute("fillAttrs") && this.getObject() instanceof BaseElement) {
            ((BaseElement)this.getObject()).setStyleElement("FILL_ATTRS", element.getAttribute("fillAttrs"));
        }
        if ((fillAttrs = ParserUtils.getChildWithTagName((String)"FillAttrs", (Element)element)) != null && this.getObject() instanceof PropertyInterface && (obj = ((PropertyInterface)this.getObject()).getPropertyValue(19010)) instanceof StyleElementAttrs) {
            ParserUtils.parseFillAttrs(fillAttrs, ((StyleElementAttrs)obj).getOverrides(true));
        }
        if (element.hasAttribute("showGraphedLabels") && this.getObject() instanceof AbstractBarElement) {
            ((BarParmElement)this.getObject()).setShowGraphedLabel(ParserUtils.getBooleanValue((String)element.getAttribute("showGraphedLabels")));
        }
        if (element.hasAttribute("groupDisplayType") && this.getObject() instanceof AbstractBarElement) {
            String value = ParserUtils.getString((Object)element.getAttribute("groupDisplayType"));
            if (value.equalsIgnoreCase("STACKED")) {
                ((AbstractBarElement)this.getObject()).setGroupDisplayType(0);
            } else if (value.equalsIgnoreCase("CLUSTERED")) {
                ((AbstractBarElement)this.getObject()).setGroupDisplayType(1);
            }
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.toXML("BarChartParm", context, object, this.barInfo);
        this.getChartXML(rc, object);
        return rc;
    }

    protected void getChartXML(Element elem, Object object) {
        Comparable<Boolean> val;
        int[] range;
        PropertyInterface bar = null;
        bar = object != null && object instanceof PropertyInterface ? (PropertyInterface)object : (PropertyInterface)this.barInfo.getXmlTarget();
        if (bar.hasUserSetValue(809) && object != null && (range = (int[])bar.getPropertyValue(809)) != null && range.length == 2) {
            elem.setAttribute("displayBarRangeStart", Integer.toString(range[0]));
            elem.setAttribute("displayBarRangeEnd", Integer.toString(range[1]));
        }
        if (object != null && bar.hasUserSetValue(817)) {
            val = (Boolean)bar.getPropertyValue(817);
            elem.setAttribute("showGraphedLabels", ((Boolean)val).toString());
        }
        if (object != null && bar.hasUserSetValue(820)) {
            val = (Integer)bar.getPropertyValue(820);
            if (val != null && (Integer)val == 1) {
                elem.setAttribute("groupDisplayType", "Clustered");
            } else {
                elem.removeAttribute("groupDisplayType");
            }
        }
    }

    @Override
    public Object getObject() {
        return this.barInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        this.barInfo.setInstance(instance);
        return true;
    }
}

