/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Image;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class BackgroundParser
implements ElementParserInterface {
    GraphBackgroundInterface instance;

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        if (instance != null && instance instanceof GraphBackgroundInterface) {
            this.instance = (GraphBackgroundInterface)instance;
        }
        this.instance = BackgroundParser.parseBackgroundElement(element, this.instance, context);
        return this.instance;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return this.putToXML(context, instance, null, "Background");
    }

    public Element putToXML(Hashtable context, Object instance, String tagName) {
        return this.putToXML(context, instance, null, tagName);
    }

    public Element putToXML(Hashtable context, Object instance, Element element) {
        return this.putToXML(context, instance, element, "Background");
    }

    public Element putToXML(Hashtable context, Object instance, Element element, String tagName) {
        PropertyInterface background;
        Object[] back;
        if (!(instance instanceof PropertyInterface)) {
            return null;
        }
        Element rc = element;
        if (rc == null) {
            rc = ParserUtils.newElement((Hashtable)context, (String)tagName);
        }
        if ((back = (Object[])(background = (PropertyInterface)instance).getPropertyValue(10)) == null || back.length == 0) {
            return null;
        }
        if (back[0] instanceof Color) {
            if (background.hasUserSetValue(21)) {
                rc.setAttribute("fillColor", ColorParse.getColorStrg((Color)((Color)back[0]), (boolean)false));
            }
        } else if (back[0] instanceof GradientPaint) {
            if (instance instanceof PropertyInterface) {
                Object color1 = ((PropertyInterface)instance).getPropertyValue(13);
                Object neutralColor = null;
                Object color2 = ((PropertyInterface)instance).getPropertyValue(14);
                Object direction = ((PropertyInterface)instance).getPropertyValue(15);
                if (color1 != null && color1 instanceof Color) {
                    rc.setAttribute("fillGradientStartColor", ColorParse.getColorStrg((Color)((Color)color1), (boolean)false));
                }
                if (neutralColor != null && neutralColor instanceof Color) {
                    rc.setAttribute("fillGradientNeutralColor", ColorParse.getColorStrg((Color)neutralColor, (boolean)false));
                }
                if (color2 != null && color2 instanceof Color) {
                    rc.setAttribute("fillGradientEndColor", ColorParse.getColorStrg((Color)((Color)color2), (boolean)false));
                }
                if (direction != null && direction instanceof Number) {
                    rc.setAttribute("fillGradientType", GraphBackground.getGradientTypeAsString(((Number)direction).intValue()));
                }
            }
        } else if (back[0] instanceof Image) {
            // empty if block
        }
        if (rc.getAttributes().getLength() == 0) {
            return null;
        }
        return rc;
    }

    public Object getObject() {
        return this.instance;
    }

    public static GraphBackgroundInterface parseBackgroundElement(Element element, GraphBackgroundInterface backgroundIn, Hashtable context) {
        String fillFile;
        String fillColor;
        GraphBackgroundInterface rc = new GraphBackground();
        if (backgroundIn != null) {
            rc = backgroundIn;
        }
        if ((fillColor = element.getAttribute("fillColor")) != null && fillColor.length() > 0) {
            rc.setSolidBackground(ColorParse.getColorFromString((String)fillColor));
        }
        String fillGradientStartColor = element.getAttribute("fillGradientStartColor");
        String fillGradientEndColor = element.getAttribute("fillGradientEndColor");
        String fillGradientNeutralColor = element.getAttribute("fillGradientNeutralColor");
        if (fillGradientStartColor != null && fillGradientStartColor.length() > 0 && fillGradientEndColor != null && fillGradientEndColor.length() > 0) {
            String dir = element.getAttribute("fillGradientType");
            int direction = 0;
            if (dir != null) {
                if (dir.equalsIgnoreCase("LeftToRight")) {
                    direction = 0;
                } else if (dir.equalsIgnoreCase("RightToLeft")) {
                    direction = 1;
                } else if (dir.equalsIgnoreCase("TopToBottom")) {
                    direction = 2;
                } else if (dir.equalsIgnoreCase("BottomToTop")) {
                    direction = 3;
                } else if (dir.equalsIgnoreCase("Diagonal")) {
                    direction = 4;
                }
            }
            rc.setGradientBackground(ColorParse.getColorFromString((String)fillGradientStartColor), ColorParse.getColorFromString((String)fillGradientEndColor), new Integer(direction));
        }
        if ((fillFile = element.getAttribute("fillFile")) != null && fillFile.length() > 0) {
            Image image = null;
            if (rc instanceof Component) {
                image = ResourceLoader.getImage((Component)((Component)((Object)rc)), (String)fillFile);
            }
            if (image != null) {
                String fillImageFitStyle = element.getAttribute("fillImageFitStyle");
                String fillImageX = element.getAttribute("fillImageX");
                String fillImageY = element.getAttribute("fillImageY");
                String fillImageBlend = element.getAttribute("fillImageBlend");
                int fitStyle = GraphBackground.getFitStyleFromString(fillImageFitStyle);
                int x = 0;
                if (fillImageX != null && fillImageX.length() > 0) {
                    x = ParserUtils.getIntValue((String)fillImageX);
                }
                int y = 0;
                if (fillImageY != null && fillImageY.length() > 0) {
                    y = ParserUtils.getIntValue((String)fillImageY);
                }
                double blend = 1.0;
                if (fillImageBlend != null && fillImageBlend.length() > 0) {
                    blend = ParserUtils.getDoubleValue((String)fillImageBlend);
                }
                rc.setImageBackground(image, new Integer(fitStyle), x, y, blend);
            }
        }
        return rc;
    }
}

