/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.AreaBarComponent;
import com.sas.graphics.silk.BarComponent;
import com.sas.graphics.silk.bar.AreaBar;
import com.sas.graphics.silk.interfaces.BarInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class AreaBarParser
extends ChartParser {
    protected SILKElementInfoReader barInfo = null;

    public AreaBarParser() {
        this(null);
    }

    public AreaBarParser(AreaBarComponent instance) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/areaBar.config";
        this.barInfo = new SILKElementInfoReader(configFile);
        this.barInfo.setInstance(instance);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        int end;
        int start;
        String orient;
        ParserUtils.parseElement(context, element, this.barInfo);
        AreaBarComponent bar = (AreaBarComponent)this.barInfo.getXmlTarget();
        BarInterface bi = bar.getChart();
        if (bi instanceof AreaBar) {
            String axisRoleStr = element.getAttribute("axisRole");
            Integer axisRole = axisRoleStr.equalsIgnoreCase(RoleInterface.ROLE_WIDTH.toString()) ? RoleInterface.ROLE_WIDTH : RoleInterface.ROLE_CATEGORY;
            ((AreaBar)bi).setAxisRole(axisRole);
            if (element.hasAttribute("showInnerLabels")) {
                String value = ParserUtils.getString((Object)element.getAttribute("showInnerLabels"));
                ((AreaBar)bar.getChart()).setInnerLabelOn(Boolean.valueOf(value));
            }
        }
        if ((orient = element.getAttribute("orient")).length() > 0 && orient.equalsIgnoreCase("Horizontal")) {
            bar.getChart().setChartType(orient);
        }
        String displayBarRangeStart = element.getAttribute("displayBarRangeStart");
        String displayBarRangeEnd = element.getAttribute("displayBarRangeEnd");
        if (displayBarRangeStart != null && displayBarRangeStart.length() > 0 && displayBarRangeEnd != null && displayBarRangeEnd.length() > 0 && (start = ParserUtils.getIntValue((String)displayBarRangeStart)) < (end = ParserUtils.getIntValue((String)displayBarRangeEnd))) {
            bar.getChart().setDisplayBarRange(start, end);
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element elem = ParserUtils.toXML("AreaBar", context, object, this.barInfo);
        this.getChartXML(elem, object);
        return elem;
    }

    protected void getChartXML(Element elem, Object object) {
        BarInterface bi;
        if (object != null && object instanceof AreaBarComponent && ((AreaBarComponent)object).getChart() != null && (bi = ((AreaBarComponent)object).getChart()) instanceof AreaBar) {
            PropertyInterface areaBar;
            Number axisRole = ((AreaBar)bi).getAxisRole();
            String axisRoleStr = axisRole.toString();
            elem.setAttribute("axisRole", axisRoleStr);
            if (object != null && object instanceof AreaBarComponent && ((AreaBarComponent)object).getChart() != null && (areaBar = (PropertyInterface)object).hasUserSetValue(819)) {
                boolean innerLabelOn = ((AreaBar)bi).isInnerLabelsOn();
                if (!innerLabelOn) {
                    elem.setAttribute("showInnerLabels", String.valueOf(innerLabelOn));
                } else {
                    elem.removeAttribute("showInnerLabels");
                }
            }
        }
        BarComponent bar = null;
        bar = object != null && object instanceof BarComponent ? (BarComponent)object : (BarComponent)this.barInfo.getXmlTarget();
        if (object != null && object instanceof BarComponent && ((BarComponent)object).getChart() != null) {
            String orient = ((BarComponent)object).getChart().getChartType();
            elem.setAttribute("orient", orient);
        }
        if (bar.hasUserSetValue(809) && object != null && object instanceof BarComponent && ((BarComponent)object).getChart() != null) {
            int[] range = ((BarComponent)object).getChart().getDisplayBarRange();
            elem.setAttribute("displayBarRangeStart", Integer.toString(range[0]));
            elem.setAttribute("displayBarRangeEnd", Integer.toString(range[1]));
        }
    }

    @Override
    public Object getObject() {
        return this.barInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof AreaBarComponent)) {
            return false;
        }
        this.barInfo.setInstance(instance);
        return true;
    }
}

