/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.data;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.LinearRing;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;
import com.sas.graphics.xml.data.DataValueParserInterface;
import java.io.CharArrayWriter;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MultiPolygonParser
implements DataValueParserInterface {
    Stack wkbStack = new Stack();
    CharArrayWriter content = new CharArrayWriter();
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.xml.data.silk_xml_data_NLS");

    public void init(Hashtable context) {
    }

    public void startElement(String tagName, Attributes atts) throws SAXException {
        this.content.reset();
        if (tagName.equalsIgnoreCase("LinearRing")) {
            LinearRing ring = new LinearRing();
            this.wkbStack.push(ring);
        } else if (tagName.equalsIgnoreCase("Polygon")) {
            WKBPolygon poly = new WKBPolygon();
            this.wkbStack.push(poly);
        } else if (tagName.equalsIgnoreCase("MultiPolygon")) {
            WKBMultiPolygon poly = new WKBMultiPolygon();
            this.wkbStack.push(poly);
        }
    }

    public void endElement(String tagName) throws SAXException {
        if (tagName.equalsIgnoreCase("coordinates")) {
            String coords = this.content.toString().trim();
            StringTokenizer st = new StringTokenizer(coords, " ");
            Vector<Vec3d> points = new Vector<Vec3d>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(token, ",");
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                String num = null;
                if (st1.hasMoreTokens()) {
                    num = st1.nextToken().trim();
                    try {
                        x = Double.valueOf(num);
                    }
                    catch (NumberFormatException e) {
                        x = Double.NaN;
                    }
                }
                if (st1.hasMoreTokens()) {
                    num = st1.nextToken().trim();
                    try {
                        y = Double.valueOf(num);
                    }
                    catch (NumberFormatException e) {
                        y = Double.NaN;
                    }
                }
                if (st1.hasMoreTokens()) {
                    num = st1.nextToken().trim();
                    try {
                        z = Double.valueOf(num);
                    }
                    catch (NumberFormatException e) {
                        z = Double.NaN;
                    }
                }
                points.addElement(new Vec3d(x, y, z));
            }
            if (this.wkbStack.peek() instanceof LinearRing) {
                Object[] pts = new Vec3d[points.size()];
                points.copyInto(pts);
                LinearRing ring = (LinearRing)this.wkbStack.peek();
                ring.numPoints = pts.length;
                ring.points = pts;
            }
        } else if (tagName.equalsIgnoreCase("Polygon")) {
            Vector vector = new Vector();
            Object object = this.wkbStack.pop();
            while (!(object instanceof WKBPolygon)) {
                if (object instanceof LinearRing) {
                    vector.addElement(object);
                }
                object = this.wkbStack.pop();
            }
            if (!(object instanceof WKBPolygon)) {
                throw new SAXException(ResourceLoader.getResourceString((Object)this.rb, (String)"DataHandler.Invalid_Polygon_Specification.txt", (String)"Invalid Polygon Specification"));
            }
            LinearRing[] rings = new LinearRing[vector.size()];
            int i = vector.size() - 1;
            int j = 0;
            while (i >= 0) {
                rings[j] = (LinearRing)vector.elementAt(i);
                --i;
                ++j;
            }
            ((WKBPolygon)object).numRings = rings.length;
            ((WKBPolygon)object).rings = rings;
            this.wkbStack.push(object);
        } else if (tagName.equalsIgnoreCase("MultiPolygon")) {
            Vector vector = new Vector();
            Object object = this.wkbStack.pop();
            while (!(object instanceof WKBMultiPolygon)) {
                if (object instanceof WKBPolygon) {
                    vector.addElement(object);
                }
                object = this.wkbStack.pop();
            }
            if (!(object instanceof WKBMultiPolygon)) {
                throw new SAXException(ResourceLoader.getResourceString((Object)this.rb, (String)"DataHandler.Invalid_Polygon_Specification.txt", (String)"Invalid Polygon Specification"));
            }
            WKBPolygon[] polys = new WKBPolygon[vector.size()];
            int i = vector.size() - 1;
            int j = 0;
            while (i >= 0) {
                polys[j] = (WKBPolygon)vector.elementAt(i);
                --i;
                ++j;
            }
            ((WKBMultiPolygon)object).num_wkbPolygons = polys.length;
            ((WKBMultiPolygon)object).WKBPolygons = polys;
            this.wkbStack.push(object);
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.content.write(buf, offset, len);
    }

    public Object getDataValue() {
        return this.wkbStack.pop();
    }
}

