/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.table;

import com.sas.graphics.silk.interfaces.SILKHeaderRendererInterface;
import com.sas.graphics.silk.util.table.GTableModel;
import com.sas.graphics.silk.util.table.GTableSummary;
import com.sas.graphics.silk.util.table.TableMap;
import com.sas.graphics.util.StringCompare;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    private static final long serialVersionUID = -8586998729787645276L;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int DATAORDER = 2;
    public static final int xThreshold = 3;
    public static final int yThreshold = 3;
    public static int xPress = 0;
    public static int yPress = 0;
    public static int xRel = 0;
    public static int yRel = 0;
    public static int prevColumnHeaderIndex = -1;
    Integer iVal = new Integer(0);
    Double dVal = new Double(0.0);
    Long lVal = new Long(0L);
    Float fVal = new Float(0.0);
    Class iClass = this.iVal.getClass();
    Class dClass = this.dVal.getClass();
    Class lClass = this.lVal.getClass();
    Class fClass = this.fVal.getClass();
    int[] indexes;
    int[] reverseIndexes;
    Vector sortingColumns = new Vector();
    int dataOrder = 2;
    boolean statistics = false;
    int compares;
    int sortColumnIndex = Integer.MIN_VALUE;
    int[] sortState;
    Object[] minValue;
    Object[] maxValue;
    Object[] totalValue;
    GTableModel gModel = null;
    protected GTableSummary summary;
    protected String name;
    Cursor handCursor = new Cursor(12);
    Cursor defaultCursor = new Cursor(0);
    AppletContext context = null;
    URL docBase = null;
    String target;
    MouseAdapter headerMouseListener;
    MouseMotionAdapter headerMotionListener;
    private int oldMetaColCount = this.getMetaColumnCount();
    private boolean sortingEvent = false;

    public TableSorter() {
        this.indexes = new int[0];
        this.reverseIndexes = new int[0];
    }

    public TableSorter(GTableModel model, String name, boolean stats) {
        this.name = new String(name);
        this.statistics = stats;
        this.setModel(model);
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        if (model instanceof GTableModel) {
            this.gModel = (GTableModel)model;
        }
        this.reallocateIndexes();
        this.initializeSortState();
        this.computeColumnMetaData();
        this.summary = new GTableSummary(this);
    }

    public void setAppletContext(AppletContext appletContext, URL docuBase, String urlTarget) {
        this.context = appletContext;
        this.docBase = docuBase;
        this.target = urlTarget;
    }

    @Override
    public String getLink(int row, int column) {
        if (row >= this.getRowCount() - this.getMetaRowCount()) {
            return null;
        }
        this.checkModel();
        String link = super.getLink(this.indexes[row], column);
        if (link != null && link.trim().length() > 0) {
            return link;
        }
        return null;
    }

    @Override
    public Color getCellItemColor(int row, int column) {
        if (row >= this.getRowCount() - this.getMetaRowCount()) {
            return null;
        }
        this.checkModel();
        return super.getCellItemColor(this.indexes[row], column);
    }

    public int getModelRowFromView(int viewRow) {
        if (viewRow >= this.getRowCount() - this.getMetaRowCount()) {
            return viewRow;
        }
        this.checkModel();
        return this.indexes[viewRow];
    }

    public int getViewRowFromModel(int sortedRow) {
        if (sortedRow < 0 || sortedRow >= this.getRowCount() - this.getMetaRowCount()) {
            return sortedRow;
        }
        this.checkModel();
        return this.reverseIndexes[sortedRow];
    }

    public int getSortColumnIndex() {
        int index = this.sortColumnIndex;
        if (this.obsNumberColumnVisible) {
            if (index == 0) {
                return 0;
            }
            --index;
        }
        return this.getColumnIndexInVisibleModel(index);
    }

    public void clearSort() {
        this.reallocateIndexes();
        this.initializeSortState();
        this.sortColumnIndex = Integer.MIN_VALUE;
    }

    public int getSortState(int index) {
        if (index != this.sortColumnIndex) {
            return 0;
        }
        if (index < 0 || index >= this.sortState.length) {
            return 0;
        }
        return this.sortState[index];
    }

    public boolean getAscending() {
        return this.dataOrder == 0;
    }

    public int getSortOrder() {
        return this.dataOrder;
    }

    public int compareRowsByColumn(int row1, int row2, int visColumn) {
        Object v2;
        String s2;
        boolean isObsColumn;
        boolean bl = isObsColumn = visColumn == 0 && this.obsNumberColumnVisible;
        if (isObsColumn) {
            return this.compareNumber((Number)this.getObsNumberValueAt(row1), (Number)this.getObsNumberValueAt(row2));
        }
        int column = visColumn;
        if (this.obsNumberColumnVisible) {
            --column;
        }
        Class type = this.getFullModelColumnClass(visColumn);
        boolean o1IsMissing = false;
        boolean o2IsMissing = false;
        Object o1 = super.getFullModelValueAt(row1, column);
        Object o2 = super.getFullModelValueAt(row2, column);
        if (o1 == null) {
            o1IsMissing = true;
        }
        if (o2 == null) {
            o2IsMissing = true;
        }
        if (o1IsMissing && o2IsMissing) {
            return 0;
        }
        if (o1IsMissing) {
            return -1;
        }
        if (o2IsMissing) {
            return 1;
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class || o1 instanceof Number && o2 instanceof Number) {
            Number n1 = (Number)super.getFullModelValueAt(row1, column);
            Number n2 = (Number)super.getFullModelValueAt(row2, column);
            return this.compareNumber(n1, n2);
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)super.getFullModelValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)super.getFullModelValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)super.getFullModelValueAt(row1, column);
            int result = this.compareString(s1, s22 = (String)super.getFullModelValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)super.getFullModelValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)super.getFullModelValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        if (type == Image.class) {
            return -1;
        }
        if (type == ImageIcon.class) {
            return -1;
        }
        Object v1 = super.getFullModelValueAt(row1, column);
        String s1 = v1.toString();
        int result = this.compareString(s1, s2 = (v2 = super.getFullModelValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    protected int compareNumber(Number n1, Number n2) {
        double d1 = n1.doubleValue();
        double d2 = n2.doubleValue();
        if (Double.isNaN(d1) && Double.isNaN(d2)) {
            return 0;
        }
        if (Double.isNaN(d1)) {
            return -1;
        }
        if (Double.isNaN(d2)) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.getAscending() ? result : -result;
        }
        return 0;
    }

    public int compareString(String s1, String s2) {
        return StringCompare.compareTo((String)s1, (String)s2);
    }

    public void reallocateIndexes() {
        int rowCount = this.getRowCount() - this.getMetaRowCount();
        this.indexes = new int[rowCount];
        this.reverseIndexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
            this.reverseIndexes[row] = row;
        }
    }

    public void initializeSortState() {
        int columnCount = this.getFullModelColumnCount();
        this.sortState = new int[columnCount];
        for (int col = 0; col < columnCount; ++col) {
            this.sortState[col] = 0;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        this.initializeSortState();
        this.computeColumnMetaData();
        if (this.statistics) {
            if (this.metaFlag[0]) {
                this.columnMeta[0] = this.summary.getSum(this.byVariable);
            }
            if (this.metaFlag[1]) {
                this.columnMeta[1] = this.summary.getAverage(this.byVariable);
            }
            if (this.metaFlag[2]) {
                this.columnMeta[2] = this.summary.getMedian(this.byVariable);
            }
            if (this.metaFlag[3]) {
                this.columnMeta[3] = this.summary.getMode(this.byVariable);
            }
            if (this.metaFlag[4]) {
                this.columnMeta[4] = this.summary.getStandardDeviation(this.byVariable);
            }
            if (this.metaFlag[5]) {
                this.columnMeta[5] = this.summary.getNonMissingValues(this.byVariable);
            }
        }
        int newMetaColCount = this.getMetaColumnCount();
        this.sortColumnIndex += newMetaColCount - this.oldMetaColCount;
        this.oldMetaColCount = newMetaColCount;
        super.tableChanged(e);
    }

    public void checkModel() {
        if (this.indexes.length != this.getRowCount() - this.getMetaRowCount()) {
            // empty if block
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.resetIndexes();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        this.createReverseIndexMap();
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount() - this.getMetaRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount() - this.getMetaRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        if (aRow < this.getRowCount() - this.getMetaRowCount()) {
            this.checkModel();
            if (aRow < this.indexes.length) {
                return super.getValueAt(this.indexes[aRow], aColumn);
            }
            if (this.getSortOrder() == 2) {
                return super.getValueAt(aRow, aColumn);
            }
            return null;
        }
        return super.getValueAt(aRow, aColumn);
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void setColumnSortState(JTable tableView, int colIndex, boolean ascending) {
        int sortOrder = ascending ? 0 : 1;
        this.setColumnSortState(tableView, colIndex, sortOrder);
    }

    public void setColumnSortState(JTable tableView, int colIndex, int sortOrder) {
        int columnCount = this.getColumnCount();
        if (colIndex < 0 || colIndex >= columnCount) {
            return;
        }
        this.sortByColumn(tableView, colIndex, sortOrder, false);
    }

    public void sortByColumn(JTable tableView, int column, boolean ascending, boolean fireEvent) {
        int sortOrder = ascending ? 0 : 1;
        this.sortByColumn(tableView, column, sortOrder, fireEvent);
    }

    @Override
    public void setObsNumberColumnVisible(boolean visible) {
        if (this.obsNumberColumnVisible != visible && this.sortingColumns.size() > 0) {
            for (int i = 0; i < this.sortingColumns.size(); ++i) {
                int column = ((Number)this.sortingColumns.elementAt(i)).intValue();
                column = this.obsNumberColumnVisible ? column - 1 : column + 1;
                this.sortingColumns.setElementAt(new Integer(column), i);
            }
            this.sortColumnIndex = this.obsNumberColumnVisible ? this.sortColumnIndex - 1 : this.sortColumnIndex + 1;
        }
        super.setObsNumberColumnVisible(visible);
    }

    protected int transformIndexToSortSpaceColumn(int column) {
        int sortColumn = this.getColumnIndexInModel(column);
        if (this.obsNumberColumnVisible && column != 0) {
            ++sortColumn;
        }
        return sortColumn;
    }

    protected void sortByColumn(JTable tableView, int column, int sortOrder, boolean fireEvent) {
        if (column < 0) {
            return;
        }
        this.sortColumnIndex = this.transformIndexToSortSpaceColumn(column);
        this.dataOrder = sortOrder;
        this.sortingColumns.removeAllElements();
        if (this.dataOrder != 2) {
            this.sortingColumns.addElement(new Integer(this.sortColumnIndex));
            this.sort(this);
        } else {
            this.reallocateIndexes();
        }
        TableColumnModel columnModel = tableView.getColumnModel();
        int columnCount = this.getFullModelColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.sortState[i] = 0;
        }
        int cIndex = this.sortColumnIndex;
        if (cIndex >= 0) {
            switch (this.dataOrder) {
                case 0: {
                    this.sortState[cIndex] = 1;
                    break;
                }
                case 1: {
                    this.sortState[cIndex] = 2;
                    break;
                }
                default: {
                    this.sortState[cIndex] = 0;
                }
            }
        }
        for (int i = 0; i < columnCount; ++i) {
            int viewCol;
            TableColumn tableColumn;
            TableCellRenderer tcr;
            int visCol = this.obsNumberColumnVisible ? (i == 0 ? i : this.getColumnIndexInVisibleModel(i - 1)) : this.getColumnIndexInVisibleModel(i);
            if (visCol < 0 || !((tcr = (tableColumn = columnModel.getColumn(viewCol = tableView.convertColumnIndexToView(visCol))).getHeaderRenderer()) instanceof SILKHeaderRendererInterface)) continue;
            ((SILKHeaderRendererInterface)tcr).setState(viewCol, this.sortState[i]);
        }
        JTableHeader tableHeader = tableView.getTableHeader();
        if (tableHeader != null) {
            tableHeader.resizeAndRepaint();
        }
        this.sortingEvent = true;
        if (fireEvent) {
            super.tableChanged(new TableModelEvent(this));
        }
        this.sortingEvent = false;
    }

    public boolean isSortingEvent() {
        return this.sortingEvent;
    }

    public Object getColumnMinValue(int column) {
        return this.minValue[column];
    }

    public Object getColumnMaxValue(int column) {
        return this.maxValue[column];
    }

    public Object getTotalValue(int column) {
        return this.totalValue[column];
    }

    public void getColumnMinMaxValues(int columnId, Class columnClass, int rowCount, Object[] minValue, Object[] maxValue) {
        boolean number = false;
        for (Class cc = columnClass; cc != null && cc != Object.class; cc = cc.getSuperclass()) {
            if (cc != Number.class) continue;
            number = true;
            break;
        }
        if (number) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            double total = 0.0;
            for (int i = 0; i < rowCount; ++i) {
                double d;
                Object obj = super.getValueAt(i, columnId);
                if (!(obj instanceof Number) || Double.isNaN(d = ((Number)obj).doubleValue())) continue;
                min = Math.min(min, d);
                max = Math.max(max, d);
                total += d;
            }
            minValue[columnId] = new Double(min);
            maxValue[columnId] = new Double(max);
            this.totalValue[columnId] = new Double(total);
        } else {
            minValue[columnId] = null;
            maxValue[columnId] = null;
        }
    }

    private void computeColumnMetaData() {
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount() - this.getMetaRowCount();
        this.minValue = new Object[columnCount];
        this.maxValue = new Object[columnCount];
        this.totalValue = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Class columnClass = this.getColumnClass(i);
            this.getColumnMinMaxValues(i, columnClass, rowCount, this.minValue, this.maxValue);
        }
    }

    public void addMouseListenerToHeaderInTable(JTable table, ImageIcon aIcon, ImageIcon dIcon, ImageIcon lIcon) {
        JTable tableView = table;
        JTableHeader th = tableView.getTableHeader();
        if (th == null) {
            return;
        }
        tableView.setColumnSelectionAllowed(false);
        th.removeMouseMotionListener(this.headerMotionListener);
        this.headerMotionListener = new HeaderMotionListener(table);
        th.removeMouseListener(this.headerMouseListener);
        this.headerMouseListener = new HeaderMouseListener(table);
        th.addMouseListener(this.headerMouseListener);
        th.addMouseMotionListener(this.headerMotionListener);
    }

    public void removeMouseListenerToHeaderInTable(JTable table) {
        if (table == null) {
            return;
        }
        JTable tableView = table;
        JTableHeader th = tableView.getTableHeader();
        if (th == null) {
            return;
        }
        th.removeMouseMotionListener(this.headerMotionListener);
        th.removeMouseListener(this.headerMouseListener);
    }

    private void resetIndexes() {
        if (this.indexes == null) {
            return;
        }
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = i;
        }
    }

    private void createReverseIndexMap() {
        if (this.reverseIndexes.length != this.indexes.length) {
            this.reverseIndexes = new int[this.indexes.length];
        }
        for (int i = 0; i < this.indexes.length; ++i) {
            this.reverseIndexes[this.indexes[i]] = i;
        }
    }

    private boolean isCursorOnHeaderEdge(JTable table, int viewColumn, Point p) {
        if (table.getTableHeader() == null) {
            return false;
        }
        Rectangle r = table.getTableHeader().getHeaderRect(viewColumn);
        r.grow(-3, 0);
        if (!r.contains(p)) {
            int columnIndex;
            int midPoint = r.x + r.width / 2;
            if (table.getTableHeader().getComponentOrientation().isLeftToRight()) {
                columnIndex = p.x < midPoint ? viewColumn - 1 : viewColumn;
            } else {
                int n = columnIndex = p.x < midPoint ? viewColumn : viewColumn - 1;
            }
            if (columnIndex >= 0) {
                return true;
            }
        }
        return false;
    }

    class HeaderMouseListener
    extends MouseAdapter {
        int xDelta;
        int yDelta;
        Cursor cursor;
        JTable table;
        Cursor resizeCursor;

        public HeaderMouseListener(JTable table) {
            this.table = table;
            this.resizeCursor = Cursor.getPredefinedCursor(11);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.table.getTableHeader() == null) {
                return;
            }
            int viewColumn = this.table.getColumnModel().getColumnIndexAtX(e.getX());
            int visColumn = this.table.convertColumnIndexToModel(viewColumn);
            int modelColumn = TableSorter.this.getColumnIndexInModel(visColumn) + TableSorter.this.getMetaColumnCount();
            if (TableSorter.this.isCursorOnHeaderEdge(this.table, viewColumn, e.getPoint())) {
                this.table.getTableHeader().setCursor(this.resizeCursor);
            } else if (modelColumn != prevColumnHeaderIndex) {
                prevColumnHeaderIndex = modelColumn;
                if (TableSorter.this.gModel != null) {
                    String link = TableSorter.this.gModel.getColumnLink(modelColumn);
                    if (link != null) {
                        this.table.getTableHeader().setCursor(TableSorter.this.handCursor);
                        if (TableSorter.this.context != null) {
                            TableSorter.this.context.showStatus(link);
                        }
                        return;
                    }
                    if (TableSorter.this.context != null) {
                        TableSorter.this.context.showStatus(" ");
                    }
                }
                this.table.getTableHeader().setCursor(TableSorter.this.defaultCursor);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.table.getTableHeader() == null) {
                return;
            }
            this.cursor = this.table.getTableHeader().getCursor();
            prevColumnHeaderIndex = -1;
            if (TableSorter.this.context != null) {
                TableSorter.this.context.showStatus(" ");
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            xPress = e.getX();
            yPress = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.table.getTableHeader() == null) {
                return;
            }
            xRel = e.getX();
            yRel = e.getY();
            this.xDelta = Math.abs(xRel - xPress);
            this.yDelta = Math.abs(yRel - yPress);
            if (this.xDelta > 3 || this.yDelta > 3) {
                return;
            }
            if (this.table.getTableHeader().getCursor() != this.resizeCursor) {
                String link;
                int viewColumn = this.table.getColumnModel().getColumnIndexAtX(e.getX());
                int visColumn = this.table.convertColumnIndexToModel(viewColumn);
                int modelColumn = TableSorter.this.transformIndexToSortSpaceColumn(visColumn);
                if (TableSorter.this.getColumnName(visColumn).equals(TableMap.META_HEADER)) {
                    return;
                }
                if (TableSorter.this.gModel != null && (link = TableSorter.this.gModel.getColumnLink(modelColumn)) != null) {
                    try {
                        URL url = new URL(TableSorter.this.docBase, link);
                        if (TableSorter.this.context != null) {
                            TableSorter.this.context.showDocument(url, TableSorter.this.target);
                        }
                    }
                    catch (MalformedURLException url) {
                        // empty catch block
                    }
                    return;
                }
                int state = 0;
                if (TableSorter.this.getColumnClass(visColumn) == Image.class || TableSorter.this.getColumnClass(visColumn) == ImageIcon.class) {
                    return;
                }
                if (e.getClickCount() == 1 && visColumn != -1) {
                    boolean ascending;
                    int columnCount = TableSorter.this.getFullModelColumnCount();
                    state = TableSorter.this.sortState[modelColumn];
                    for (int i = 0; i < columnCount; ++i) {
                        TableSorter.this.sortState[i] = 0;
                    }
                    TableSorter.this.sortState[modelColumn] = state;
                    Class columnClass = TableSorter.this.getFullModelColumnClass(modelColumn);
                    if (columnClass == String.class) {
                        ascending = true;
                        if (TableSorter.this.sortState[modelColumn] == 1) {
                            ascending = false;
                            TableSorter.this.sortState[modelColumn] = 2;
                        } else {
                            ascending = true;
                            TableSorter.this.sortState[modelColumn] = 1;
                        }
                    } else {
                        ascending = false;
                        if (TableSorter.this.sortState[modelColumn] == 2) {
                            ascending = true;
                            TableSorter.this.sortState[modelColumn] = 1;
                        } else {
                            ascending = false;
                            TableSorter.this.sortState[modelColumn] = 2;
                        }
                    }
                    TableSorter.this.sortByColumn(this.table, visColumn, ascending, true);
                }
            }
        }
    }

    class HeaderMotionListener
    extends MouseMotionAdapter {
        Cursor cursor;
        TableColumnModel columnModel = null;
        JTable table;
        Cursor resizeCursor = null;

        public HeaderMotionListener(JTable table) {
            this.table = table;
            this.columnModel = table.getColumnModel();
            this.resizeCursor = Cursor.getPredefinedCursor(11);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int viewColumn = this.columnModel.getColumnIndexAtX(e.getX());
            int visColumn = this.table.convertColumnIndexToModel(viewColumn);
            int modelColumn = TableSorter.this.getColumnIndexInModel(visColumn) + TableSorter.this.getMetaColumnCount();
            if (this.table.getTableHeader() == null) {
                return;
            }
            if (TableSorter.this.isCursorOnHeaderEdge(this.table, viewColumn, e.getPoint())) {
                this.table.getTableHeader().setCursor(this.resizeCursor);
            } else if (modelColumn != prevColumnHeaderIndex) {
                prevColumnHeaderIndex = modelColumn;
                if (TableSorter.this.gModel != null) {
                    String link = TableSorter.this.gModel.getColumnLink(modelColumn);
                    if (link != null) {
                        this.table.getTableHeader().setCursor(TableSorter.this.handCursor);
                        if (TableSorter.this.context != null) {
                            TableSorter.this.context.showStatus(link);
                        }
                        return;
                    }
                    if (TableSorter.this.context != null) {
                        TableSorter.this.context.showStatus(" ");
                    }
                    this.table.getTableHeader().setCursor(TableSorter.this.defaultCursor);
                }
            }
        }
    }
}

