/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.table;

import com.sas.graphics.silk.interfaces.SILKHeaderRendererInterface;
import com.sas.graphics.silk.util.table.SILKTableInterface;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class HeaderTextPaneRenderer
extends JTextPane
implements TableCellRenderer,
SILKHeaderRendererInterface {
    private static final long serialVersionUID = 7838251611462696273L;
    private ImageIcon ascendingIcon = null;
    private ImageIcon descendingIcon = null;
    private ImageIcon linkIcon = null;
    Color defaultForeColor;
    Color selectedForeColor;
    Color defaultBackColor;
    Color selectedBackColor;
    Font defaultFont;
    Font linkFont;
    private static int count = 0;
    private TableStyle style;
    private String[] link;
    private int columnCount = 0;
    private StyledDocument doc = null;
    private SILKTableInterface tableInterface = null;
    private int state = 0;
    private int cWidth = 0;

    public HeaderTextPaneRenderer() {
        ++count;
        this.style = new TableStyle(0);
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ttm.registerComponent(this);
        ttm.setInitialDelay(0);
        this.setEditorKit(new WrapEditorKit());
    }

    public HeaderTextPaneRenderer(ImageIcon aIcon, ImageIcon dIcon, ImageIcon lIcon, SILKTableInterface panel, TableSorter sortModel, TableStyle styleIn) {
        this();
        this.ascendingIcon = aIcon;
        this.descendingIcon = dIcon;
        this.linkIcon = lIcon;
        this.doc = this.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = this.doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style ascIcon = this.doc.addStyle("ascIcon", regular);
        StyleConstants.setAlignment(ascIcon, 0);
        if (this.ascendingIcon != null) {
            StyleConstants.setIcon(ascIcon, this.ascendingIcon);
        }
        Style desIcon = this.doc.addStyle("desIcon", regular);
        StyleConstants.setAlignment(desIcon, 0);
        if (this.descendingIcon != null) {
            StyleConstants.setIcon(desIcon, this.descendingIcon);
        }
        Style lnkIcon = this.doc.addStyle("lnkIcon", regular);
        StyleConstants.setAlignment(lnkIcon, 0);
        if (this.linkIcon != null) {
            StyleConstants.setIcon(lnkIcon, this.linkIcon);
        }
        this.tableInterface = panel;
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.style = styleIn;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(this.style.headerForeColor);
        this.setBackground(this.style.headerBackColor);
        try {
            this.doc.remove(0, this.doc.getLength());
            this.doc.insertString(0, value.toString(), this.doc.getStyle("regular"));
            if (this.link != null && this.link[column] != null) {
                this.doc.insertString(this.doc.getLength(), " ", this.doc.getStyle("lnkIcon"));
            } else {
                switch (this.state) {
                    case 1: {
                        this.doc.insertString(this.doc.getLength(), "  ", this.doc.getStyle("regular"));
                        this.doc.insertString(this.doc.getLength(), " ", this.doc.getStyle("ascIcon"));
                        break;
                    }
                    case 2: {
                        this.doc.insertString(this.doc.getLength(), "  ", this.doc.getStyle("regular"));
                        this.doc.insertString(this.doc.getLength(), " ", this.doc.getStyle("desIcon"));
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.tableInterface != null) {
            int width;
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn viewColumn = columnModel.getColumn(column);
            this.cWidth = width = viewColumn.getWidth();
            this.setSize(width, 12);
            int heightWanted = super.getPreferredSize().height;
            this.tableInterface.setHeaderHeight(heightWanted);
        }
        return this;
    }

    @Override
    public void setState(int column, int state) {
        switch (state) {
            case 0: 
            case 1: 
            case 2: {
                this.state = state;
            }
        }
    }

    @Override
    public void setLinks(String[] headerLink, int count) {
        this.columnCount = count;
        this.link = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.link[i] = headerLink[i];
        }
    }

    @Override
    public void setStyle(TableStyle newStyle) {
        if (newStyle != null) {
            this.style = newStyle;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d != null && this.cWidth != 0) {
            d.width = this.cWidth;
        }
        return d;
    }

    class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory;

        WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }
}

