/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.table;

import com.sas.MissingValues;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.Filter2TableModel;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.table.TableConstants;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class GTableModel
extends AbstractTableModel
implements TableModelListener,
DataFilterReadInterface {
    private static final long serialVersionUID = -352776004890069195L;
    boolean hasLinks;
    boolean hasBackColor;
    boolean buildColumnClass = true;
    int rowCount;
    int columnCount;
    int maxRowCount;
    String[] columnNames;
    String[] columnFormats;
    String[] columnLink;
    int[] renderModes;
    int[] colWidth;
    int[] colTrans;
    boolean[] colStat;
    boolean[] colWrap;
    boolean headerWrap;
    String[] columnDescriptions;
    Object[][] data;
    Class[] colClass;
    String[][] link;
    Color[][] cellBackColor;
    TableModel tableModel = null;
    Hashtable cellImages = new Hashtable();
    public JApplet applet = null;
    public static final String DEFAULT_NUMERIC_FORMAT = "best8.";
    public static final String DEFAULT_CHAR_FORMAT = "NONE";
    private Vector dataFilterListeners = new Vector();
    private Hashtable linkMap = new Hashtable();
    protected boolean dataChanged = false;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.xml.data.silk_xml_data_NLS");

    public GTableModel(TableModel tabModel, boolean hasLinks, boolean hasBackColor) {
        if (tabModel == null) {
            return;
        }
        this.tableModel = tabModel;
        this.tableModel.addTableModelListener(this);
        this.hasLinks = hasLinks;
        this.hasBackColor = hasBackColor;
        this.rowCount = this.tableModel.getRowCount();
        this.columnCount = this.tableModel.getColumnCount();
        this.maxRowCount = this.tableModel.getRowCount();
        this.initDataStructures(hasLinks, hasBackColor);
    }

    public GTableModel(int maxRowCount, int columnCount, boolean hasLinks, boolean hasBackColor) {
        int i;
        this.columnCount = columnCount;
        this.maxRowCount = maxRowCount;
        this.hasLinks = hasLinks;
        this.hasBackColor = hasBackColor;
        this.rowCount = 0;
        this.initDataStructures(hasLinks, hasBackColor);
        this.data = new Object[maxRowCount][columnCount];
        this.columnNames = new String[columnCount];
        for (i = 0; i < columnCount; ++i) {
            this.columnNames[i] = new String(" ");
        }
        this.columnLink = new String[columnCount];
        for (i = 0; i < columnCount; ++i) {
            this.columnLink[i] = null;
        }
    }

    public void linkColumn(int datacol, int linkcol) {
        this.hasLinks = true;
        if (this.link == null) {
            this.link = new String[this.rowCount][this.columnCount];
        }
        this.linkMap.put(this.getColumnName(datacol), this.getColumnName(linkcol));
        for (int i = 0; i < this.rowCount; ++i) {
            this.link[i][datacol] = this.getValueAt(i, linkcol).toString();
        }
    }

    public Object getLinkColumn(Object dataCol) {
        return this.linkMap.get(dataCol);
    }

    public String[][] getLinks() {
        return this.link;
    }

    public void setImageColumn(int col) {
        for (int i = 0; i < this.rowCount; ++i) {
            String name = null;
            try {
                name = this.tableModel != null ? this.tableModel.getValueAt(i, col).toString() : this.data[i][col].toString();
                if (this.cellImages.containsKey(name)) continue;
                URL imageURL = null;
                if (this.applet == null || name.startsWith("http://")) {
                    imageURL = new URL(name);
                } else if (name.startsWith("/")) {
                    String protocol = this.applet.getDocumentBase().getProtocol();
                    String host = this.applet.getDocumentBase().getHost();
                    int port = this.applet.getDocumentBase().getPort();
                    imageURL = new URL(protocol, host, port, name);
                } else {
                    imageURL = new URL(this.applet.getDocumentBase(), name);
                }
                ImageIcon icon = new ImageIcon(imageURL);
                this.cellImages.put(name, icon);
                continue;
            }
            catch (MalformedURLException ex) {
                System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"Table.Error.MalformedURLException.txt", (String)"Malformed URL exception:"));
                String msg = ResourceLoader.getResourceString((Object)this.rb, (String)"Table.Error.MalformedURLException2.fmt.txt", (String)"Malformed URL : {0} not found");
                System.out.println(MessageFormat.format(msg, name));
            }
        }
        this.colClass[col] = ImageIcon.class;
        this.fireTableStructureChanged();
    }

    public void setColumnNames(String[] names) {
        if (names != null) {
            if (this.columnNames == null) {
                this.columnNames = new String[names.length];
            }
            for (int i = 0; i < names.length; ++i) {
                this.columnNames[i] = names[i];
            }
        }
    }

    public void setColumnLinks(String[] link) {
        if (link != null) {
            for (int i = 0; i < link.length; ++i) {
                this.columnLink[i] = link[i];
            }
        }
    }

    public void setColumnLink(String link, int col) {
        if (this.columnLink == null) {
            this.columnLink = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                this.columnLink[i] = null;
            }
        }
        if (col >= 0 && col < this.columnLink.length) {
            this.columnLink[col] = link;
        }
    }

    public void setColumnFormats(String[] formats) {
        if (formats != null) {
            for (int i = 0; i < formats.length; ++i) {
                this.columnFormats[i] = formats[i];
            }
        }
    }

    public void setRenderModes(int[] modes) {
        if (modes != null) {
            if (modes.length != this.renderModes.length) {
                this.renderModes = new int[modes.length];
            }
            for (int i = 0; i < modes.length; ++i) {
                this.renderModes[i] = modes[i];
            }
        }
    }

    public void setColumnDescriptions(String[] des) {
        if (des != null) {
            for (int i = 0; i < des.length; ++i) {
                this.columnDescriptions[i] = des[i];
            }
        }
    }

    public void setColumnWidths(int[] width) {
        if (width != null) {
            int length = Math.min(width.length, this.columnCount);
            for (int i = 0; i < length; ++i) {
                this.colWidth[i] = width[i];
            }
        }
    }

    public void setHeaderWrap(boolean wrap) {
        this.headerWrap = wrap;
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void setColumnWrap(boolean[] wrap) {
        if (wrap != null) {
            int length = Math.min(wrap.length, this.columnCount);
            for (int i = 0; i < length; ++i) {
                this.colWrap[i] = wrap[i];
            }
        }
    }

    public void setColumnWrap(String name, boolean wrap) {
        int index = this.getColumnIndex(name);
        if (index >= 0 && index < this.getColumnCount()) {
            this.colWrap[index] = wrap;
        }
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void setColumnTrans(int[] trans) {
        if (trans != null) {
            int length = Math.min(trans.length, this.columnCount);
            for (int i = 0; i < length; ++i) {
                this.colTrans[i] = trans[i];
            }
        }
    }

    public void setColumnStats(boolean[] stat) {
        if (stat != null) {
            int length = Math.min(stat.length, this.columnCount);
            for (int i = 0; i < length; ++i) {
                this.colStat[i] = stat[i];
            }
        }
    }

    public void setLinks(String[][] lnk) {
        if (this.link != null && lnk != null) {
            for (int i = 0; i < this.rowCount; ++i) {
                for (int j = 0; j < this.columnCount; ++j) {
                    this.link[i][j] = lnk[i][j];
                    if (this.link[i][j] == null) continue;
                    this.hasLinks = true;
                }
            }
        }
    }

    public void setBackColor(Color[][] backColor) {
        if (this.cellBackColor != null && backColor != null) {
            for (int i = 0; i < this.rowCount; ++i) {
                for (int j = 0; j < this.columnCount; ++j) {
                    this.cellBackColor[i][j] = backColor[i][j];
                }
            }
        }
    }

    public void appendRow(Object[] row, String[] lnk, Color[] backColor) {
        int i;
        int lMax = Math.min(this.columnCount, row.length);
        if (this.rowCount >= this.maxRowCount) {
            return;
        }
        if (row != null) {
            for (i = 0; i < lMax; ++i) {
                this.data[this.rowCount][i] = row[i];
            }
        }
        if (this.link != null && lnk != null) {
            for (i = 0; i < lMax; ++i) {
                this.link[this.rowCount][i] = lnk[i];
            }
        }
        if (this.cellBackColor != null && backColor != null) {
            for (i = 0; i < lMax; ++i) {
                this.cellBackColor[this.rowCount][i] = backColor[i];
            }
        }
        ++this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getColumnName(int col) {
        if (this.tableModel != null) {
            return this.tableModel.getColumnName(col);
        }
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object rc = null;
        if (this.tableModel != null && row >= 0 && row < this.tableModel.getRowCount() && col >= 0 && col < this.tableModel.getColumnCount()) {
            rc = this.tableModel.getValueAt(row, col);
        } else if (this.data != null && row < this.data.length && this.data[0] != null && col < this.data[0].length) {
            rc = this.data[row][col];
        }
        if (this.colClass != null && col < this.colClass.length && this.colClass[col] == ImageIcon.class && rc instanceof String) {
            rc = this.cellImages.get(rc);
        }
        return rc;
    }

    public Class getColumnClass(int c) {
        if (this.buildColumnClass) {
            this.buildColumnClassData();
        }
        if (c >= this.colClass.length) {
            return null;
        }
        return this.colClass[c];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.tableModel != null) {
            return this.tableModel.isCellEditable(row, col);
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.tableModel != null) {
            this.tableModel.setValueAt(value, row, col);
        } else if (this.data[0][col] instanceof Integer && !(value instanceof Integer)) {
            try {
                this.data[row][col] = new Integer(value.toString());
                this.fireTableCellUpdated(row, col);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    public String getColumnLink(int col) {
        if (col < 0) {
            return null;
        }
        if (this.columnLink != null && col < this.columnLink.length) {
            return this.columnLink[col];
        }
        return null;
    }

    public String getColumnFormat(int col) {
        if (col < 0 || col >= this.columnFormats.length) {
            return DEFAULT_CHAR_FORMAT;
        }
        if (this.columnFormats[col] == null) {
            if (this.isNumericVariable(col)) {
                return DEFAULT_NUMERIC_FORMAT;
            }
            return DEFAULT_CHAR_FORMAT;
        }
        return this.columnFormats[col];
    }

    public int getRenderMode(int col) {
        if (this.renderModes != null && col < this.renderModes.length) {
            return this.renderModes[col];
        }
        return TableConstants.RENDERMODE_TEXT;
    }

    public String getColumnDescription(int col) {
        return this.columnDescriptions[col];
    }

    public int getColumnWidth(int col) {
        if (col < this.columnCount && col >= 0) {
            return this.colWidth[col];
        }
        return -1;
    }

    public boolean isHeaderWrapped() {
        return this.headerWrap;
    }

    public boolean getColumnWrap(String colName) {
        int index = this.getColumnIndex(colName);
        if (index >= 0 && index < this.getColumnCount()) {
            return this.getColumnWrap(index);
        }
        return false;
    }

    public boolean getColumnWrap(int col) {
        if (col < this.columnCount && col >= 0) {
            return this.colWrap[col];
        }
        return false;
    }

    public int getColumnTrans(int col) {
        if (col < this.columnCount && col >= 0) {
            return this.colTrans[col];
        }
        return 0;
    }

    public boolean getColumnStat(int col) {
        if (col < this.columnCount && col >= 0) {
            return this.colStat[col];
        }
        return true;
    }

    public int getColumnIndex(String colName) {
        int i;
        int rc = -1;
        if (this.tableModel != null) {
            for (i = 0; i < this.tableModel.getColumnCount(); ++i) {
                if (!StringCompare.equals((String)this.tableModel.getColumnName(i), (String)colName)) continue;
                rc = i;
            }
        }
        if (rc < 0) {
            for (i = 0; i < this.columnNames.length; ++i) {
                if (!StringCompare.equals((String)this.columnNames[i], (String)colName)) continue;
                rc = i;
            }
        }
        return rc;
    }

    public String getLink(int row, int column) {
        Object o2;
        int type;
        int n;
        Object o;
        DataFilterReadInterface f;
        int arow = row;
        if (this.tableModel instanceof Filter2TableModel && (f = ((Filter2TableModel)this.tableModel).getFilter()) != null && (o = f.getSubsetList()) != null && row < (n = Extract.getNumberItems((Object)o, (int)(type = Extract.getSourceType((Object)o)))) && (o2 = Extract.getObject((Object)o, (int)row, (int)type)) instanceof Number) {
            arow = ((Number)o2).intValue();
        }
        if (this.link != null) {
            return this.link[arow][column];
        }
        return null;
    }

    public Color getCellItemColor(int row, int column) {
        if (this.cellBackColor != null) {
            return this.cellBackColor[row][column];
        }
        return null;
    }

    private void initDataStructures(boolean hasLinks, boolean hasBackColor) {
        int i;
        this.colClass = new Class[this.columnCount];
        this.columnFormats = new String[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.columnFormats[i] = this.isNumericVariable(i) ? new String(DEFAULT_NUMERIC_FORMAT) : new String(DEFAULT_CHAR_FORMAT);
        }
        this.renderModes = new int[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.renderModes[i] = TableConstants.RENDERMODE_TEXT;
        }
        this.columnDescriptions = new String[this.columnCount];
        this.colWidth = new int[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.colWidth[i] = -1;
        }
        this.colWrap = new boolean[this.columnCount];
        this.headerWrap = false;
        this.colTrans = new int[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.colTrans[i] = 0;
        }
        this.colStat = new boolean[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.colStat[i] = true;
        }
        if (hasLinks) {
            this.link = new String[this.maxRowCount][this.columnCount];
        }
        if (hasBackColor) {
            this.cellBackColor = new Color[this.maxRowCount][this.columnCount];
        }
    }

    private void buildColumnClassData() {
        Object obj = null;
        for (int col = 0; col < this.columnCount; ++col) {
            this.colClass[col] = null;
            for (int row = 0; row < this.rowCount; ++row) {
                obj = this.getValueAt(row, col);
                if (obj == null) continue;
                this.colClass[col] = obj.getClass();
                break;
            }
            this.buildColumnClass = this.buildColumnClass && this.colClass[col] == null;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.tableModel != null) {
            this.rowCount = this.tableModel.getRowCount();
            this.columnCount = this.tableModel.getColumnCount();
            this.maxRowCount = this.tableModel.getRowCount();
        }
        if (e.getSource() instanceof Filter2TableModel) {
            this.setDataChanged(true);
            this.fireTableDataChanged();
            this.setDataChanged(false);
        }
    }

    public boolean addDataFilterListener(Object listener) {
        if (listener == null) {
            return false;
        }
        this.dataFilterListeners.addElement(listener);
        return true;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        return false;
    }

    public Object getExactVariableId(Object id) {
        return id;
    }

    public Object getFormat(Object variableId, Class returnType) {
        if (variableId == null) {
            return null;
        }
        int idx = this.getColumnIndex(variableId.toString());
        String formatName = this.getColumnFormat(idx);
        if (formatName.equals(DEFAULT_CHAR_FORMAT)) {
            return null;
        }
        if (returnType == SASFormat.class) {
            return SASFormat.getInstance((String)formatName);
        }
        return formatName;
    }

    public String getFormattedValue(Object variableId, Object value, Object format) {
        if (value == null) {
            return null;
        }
        SASFormat fmt = null;
        fmt = format != null && format instanceof SASFormat ? (SASFormat)format : (SASFormat)this.getFormat(variableId, SASFormat.class);
        if (fmt == null) {
            return value.toString();
        }
        return fmt.format(value);
    }

    public String getFormattedValue(Object variableId, long iobs, SortContext sort, Object format) {
        return this.getFormattedValue(variableId, this.getSortedIndex(iobs, sort), format);
    }

    public String getFormattedValue(Object variableId, long iobs, Object format) {
        return this.getFormattedValue(variableId, this.getValue(variableId, iobs), format);
    }

    public int getNumberObservations(int idx) {
        return this.rowCount;
    }

    public int getNumberObservations(Object id) {
        return this.rowCount;
    }

    public int getNumberVariables() {
        return this.columnCount;
    }

    public double getNumericValue(int idx, long iobs) {
        if (!this.isNumericVariable(idx)) {
            return Double.NaN;
        }
        return ((Number)this.getValue(idx, iobs)).doubleValue();
    }

    public double getNumericValue(int idx, long iobs, SortContext sort) {
        return this.getNumericValue(idx, this.getSortedIndex(iobs, sort));
    }

    public double getNumericValue(Object variableId, long iobs) {
        if (variableId == null) {
            return Double.NaN;
        }
        return this.getNumericValue(this.getColumnIndex(variableId.toString()), iobs);
    }

    public double getNumericValue(Object variableId, long iobs, SortContext sort) {
        return this.getNumericValue(variableId, this.getSortedIndex(iobs, sort));
    }

    public Color getObservationColor(long iobs) {
        return null;
    }

    public Color getObservationColor(long iobs, SortContext sort) {
        return null;
    }

    public int getObservationNumber(int index) {
        return index;
    }

    public int getRowValues(long iobs, Object[] outValues) {
        return -1;
    }

    public int getRowValues(long iobs, Object[] outValues, SortContext sort) {
        return -1;
    }

    public Object[] getRowValues(long iobs) {
        return null;
    }

    public Object[] getRowValues(long iobs, SortContext sort) {
        return null;
    }

    public Object getSource() {
        return this;
    }

    public Object getSubsetList() {
        return null;
    }

    public boolean isIndexInCurrentSubset(int index) {
        return true;
    }

    public Object getValue(int idx, long iobs) {
        return this.getValueAt((int)iobs, idx);
    }

    public Object getValue(int idx, long iobs, SortContext sort) {
        return this.getValue(idx, this.getSortedIndex(iobs, sort));
    }

    public Object getValue(Object variableId, long iobs) {
        if (variableId == null) {
            return null;
        }
        return this.getValueAt((int)iobs, this.getColumnIndex(variableId.toString()));
    }

    public Object getValue(Object variableId, long iobs, SortContext sort) {
        return this.getValue(variableId, this.getSortedIndex(iobs, sort));
    }

    public Class getVariableClass(int idx) {
        return this.getColumnClass(idx);
    }

    public Class getVariableClass(Object id) {
        if (id == null) {
            return null;
        }
        return this.getColumnClass(this.getVariableIndex(id));
    }

    public Object getVariableDescription(int idx) {
        return this.getColumnDescription(idx);
    }

    public Object getVariableDescription(Object id) {
        if (id == null) {
            return null;
        }
        return this.getVariableDescription(this.getColumnIndex(id.toString()));
    }

    public Object getVariableId(int idx) {
        return this.getColumnName(idx);
    }

    public int getVariableIndex(Object id) {
        if (id == null) {
            return -1;
        }
        return this.getColumnIndex(id.toString());
    }

    public String getWhereClause() {
        return null;
    }

    public boolean isGraphed(long iobs) {
        return false;
    }

    public boolean isGraphed(long iobs, SortContext sort) {
        return false;
    }

    public boolean isMissing(int idx, Object value) {
        return value == null || value instanceof MissingValues || value instanceof Double && ((Double)value).isNaN();
    }

    public boolean isMissing(Object id, Object value) {
        return this.isMissing(-1, value);
    }

    public boolean isNumericVariable(int idx) {
        Class cls = null;
        Class superCls = null;
        if (idx < 0 || idx >= this.getColumnCount()) {
            throw new IllegalArgumentException(ResourceLoader.getResourceString((Object)ResourceLoader.loadBundle((String)"com.sas.graphics.data.Resources_SGCommon"), (String)"JTableDataFilter.Invalid_variable_index.txt", (String)"Invalid variable index"));
        }
        cls = this.getColumnClass(idx);
        if (cls != null) {
            superCls = cls.getSuperclass();
        }
        if (cls == Number.class) {
            return true;
        }
        if (superCls != null && superCls == Number.class) {
            return true;
        }
        if (cls == String.class) {
            return false;
        }
        Object o = this.getValueAt(0, idx);
        if (o != null) {
            return o instanceof Number;
        }
        return false;
    }

    public boolean isNumericVariable(Object id) {
        if (id == null) {
            return false;
        }
        return this.isNumericVariable(this.getColumnIndex(id.toString()));
    }

    public boolean isSelected(long iobs) {
        return false;
    }

    public boolean isSelected(long iobs, SortContext sort) {
        return false;
    }

    public boolean removeDataFilterListener(Object listener) {
        this.dataFilterListeners.remove(listener);
        return true;
    }

    public boolean removeSource() {
        return false;
    }

    public void sendEvent(Object event) {
    }

    public void setAllGraphed(boolean graph) {
    }

    public void setGraphed(long iobs, boolean graphed) {
    }

    public void setGraphed(long iobs, SortContext sort, boolean graphed) {
    }

    public void setGraphed(Object list, boolean graphed, IOBSInterface operator) {
    }

    public void setGraphed(Object list, SortContext sort, boolean graphed) {
    }

    public void setGraphed(Object list, SortContext sort, boolean graphed, IOBSInterface operator) {
    }

    public void setGraphed(Object list, boolean graphed) {
    }

    public boolean setObservationColor(long iobs, Color c) {
        return false;
    }

    public void setObservationColor(Object list, Color c, IOBSInterface operator) {
    }

    public boolean setObservationColor(long iobs, SortContext sort, Color c) {
        return false;
    }

    public void setObservationColor(Object list, SortContext sort, Color c) {
    }

    public void setObservationColor(Object list, SortContext sort, Color c, IOBSInterface operator) {
    }

    public void setObservationColor(Object list, Color c) {
    }

    public void setSelected(long iobs, boolean selected) {
    }

    public void setSelected(long iobs, SortContext sort, boolean selected) {
    }

    public void setSelected(Object list, boolean selected, IOBSInterface operator) {
    }

    public void setSelected(Object list, boolean selected) {
    }

    public void setSelected(Object list, SortContext sort, boolean selected) {
    }

    public void setSelected(Object list, SortContext sort, boolean selected, IOBSInterface operator) {
    }

    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected, boolean useFormat) {
    }

    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected) {
    }

    public void setGraphed(String[] variables, DataRange[] boundingBox, boolean graphed, boolean useFormat) {
    }

    public void setGraphed(String[] variables, DataRange[] ranges, boolean[] graphed, boolean[] useFormat, boolean extendCurrentGraphedState, boolean setOrClearAll) {
    }

    public boolean setSource(Object source, Locale localeIn) {
        return false;
    }

    public boolean setSource(Object source) {
        return false;
    }

    public boolean setSubsetList(Object list) {
        return false;
    }

    public void unselectAll() {
    }

    public boolean verifyVariable(Object id) {
        if (id == null) {
            return false;
        }
        return this.getColumnIndex(id.toString()) > 0;
    }

    public Object getMetaData() {
        return null;
    }

    public boolean setMetaData(Object metaData) {
        return false;
    }

    public boolean areSelectionsLocal() {
        return false;
    }

    public void setSelectionsLocal(boolean local) {
    }

    public SelectionIterator getSelections() {
        return null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public Object getAdapter(Class type) {
        return null;
    }

    protected long getSortedIndex(long iobs, SortContext sort) {
        if (sort == null) {
            return iobs;
        }
        if (sort.getSource() != this.getSource()) {
            return iobs;
        }
        return sort.getSortedIndex((int)iobs, (DataFilterReadInterface)this);
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    public boolean hasDataChanged() {
        return this.dataChanged;
    }

    public boolean isGraphedLocal() {
        return false;
    }

    public void setGraphedLocal(boolean local) {
    }
}

