/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.table;

import com.sas.graphics.silk.interfaces.SILKHeaderRendererInterface;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class ColumnHeaderRenderer
extends DefaultTableCellRenderer
implements SILKHeaderRendererInterface {
    private static final long serialVersionUID = -1391265327185132539L;
    private ImageIcon icon = null;
    private ImageIcon ascendingIcon = null;
    private ImageIcon descendingIcon = null;
    private ImageIcon linkIcon = null;
    private static int count = 0;
    private TableStyle style;
    private String[] link;
    private int columnCount = 0;

    public ColumnHeaderRenderer() {
        ++count;
        this.style = new TableStyle(0);
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ttm.registerComponent(this);
        ttm.setInitialDelay(0);
    }

    public ColumnHeaderRenderer(ImageIcon aIcon, ImageIcon dIcon, ImageIcon lIcon, TableSorter sortModel, TableStyle styleIn) {
        this();
        this.ascendingIcon = aIcon;
        this.descendingIcon = dIcon;
        this.linkIcon = lIcon;
        this.setHorizontalTextPosition(2);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.style = styleIn;
    }

    public ColumnHeaderRenderer(ImageIcon aIcon, ImageIcon dIcon, ImageIcon lIcon, JTable table) {
        this();
        this.ascendingIcon = aIcon;
        this.descendingIcon = dIcon;
        this.linkIcon = lIcon;
        this.setHorizontalTextPosition(2);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        if (table.getTableHeader() != null) {
            this.setFont(table.getTableHeader().getFont());
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        if (this.link != null && this.link[column] != null) {
            this.setIcon(this.linkIcon);
        } else {
            this.setIcon(this.icon);
        }
        this.setHorizontalAlignment(2);
        this.setHorizontalAlignment(0);
        this.setForeground(this.style.headerForeColor);
        this.setBackground(this.style.headerBackColor);
        return this;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    public void setState(int column, int state) {
        this.icon = state == 0 ? null : (state == 1 ? this.ascendingIcon : this.descendingIcon);
    }

    @Override
    public void setLinks(String[] headerLink, int count) {
        this.columnCount = count;
        this.link = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.link[i] = headerLink[i];
        }
    }

    @Override
    public void setStyle(TableStyle newStyle) {
        if (newStyle != null) {
            this.style = newStyle;
        }
    }
}

