/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.util.DynamicIntArray;

public class UserSetPropertyBitMask {
    int[] propertyIndexList = null;
    boolean[] bits = null;

    public UserSetPropertyBitMask(int[] properties) {
        this.propertyIndexList = properties;
        this.bits = new boolean[this.propertyIndexList.length];
    }

    public boolean hasProperty(int id) {
        return this.mapProperty(id) >= 0;
    }

    public int[] getSupportedProperties() {
        return this.propertyIndexList;
    }

    public void appendProperties(int[] newProperties) {
        int i;
        if (newProperties == null) {
            return;
        }
        DynamicIntArray dia = new DynamicIntArray();
        for (int i2 = 0; i2 < newProperties.length; ++i2) {
            boolean b = false;
            for (int j = 0; j < this.propertyIndexList.length; ++j) {
                if (newProperties[i2] != this.propertyIndexList[j]) continue;
                b = true;
            }
            if (b) continue;
            dia.add(newProperties[i2]);
        }
        int[] temp = new int[this.propertyIndexList.length + dia.getNumberElements()];
        for (i = 0; i < this.propertyIndexList.length; ++i) {
            temp[i] = this.propertyIndexList[i];
        }
        for (i = 0; i < dia.getNumberElements(); ++i) {
            temp[this.propertyIndexList.length + i] = dia.get(i);
        }
        boolean[] btemp = new boolean[temp.length];
        for (int i3 = 0; i3 < this.propertyIndexList.length; ++i3) {
            btemp[i3] = this.bits[i3];
        }
        this.propertyIndexList = temp;
        this.bits = btemp;
    }

    public boolean get(int property) {
        int index = this.mapProperty(property);
        if (index >= 0) {
            return this.bits[index];
        }
        return false;
    }

    public void set(int property) {
        int index = this.mapProperty(property);
        if (index >= 0) {
            this.bits[index] = true;
        }
    }

    public void clear(int property) {
        int index = this.mapProperty(property);
        if (index >= 0) {
            this.bits[index] = false;
        }
    }

    private int mapProperty(int property) {
        for (int i = 0; i < this.propertyIndexList.length; ++i) {
            if (property != this.propertyIndexList[i]) continue;
            return i;
        }
        return -1;
    }

    public void setAll() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = true;
        }
    }

    public void clearAll() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = false;
        }
    }
}

