/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.SortKeyInterface;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class UniqueValueMapper
implements CompareInterface {
    protected Class keyType = null;
    protected LinkedHashMap uniqueValues = new LinkedHashMap();
    protected boolean isSortKeyInterface = false;

    public void removeAllValues() {
        if (this.uniqueValues != null) {
            this.uniqueValues.clear();
        }
        this.isSortKeyInterface = false;
    }

    public boolean addValue(Object value) {
        if (this.uniqueValues == null || value == null) {
            return false;
        }
        if (this.uniqueValues.size() <= 0) {
            if (value instanceof SortKeyInterface) {
                this.keyType = ((SortKeyInterface)value).getKeyType() == 0 ? Double.class : String.class;
                this.isSortKeyInterface = true;
            } else {
                this.keyType = value instanceof Number ? Double.class : String.class;
            }
        }
        if (!this.uniqueValues.containsKey(value)) {
            this.uniqueValues.put(value, new ValueMapData(value));
        } else {
            ValueMapData vmd = (ValueMapData)this.uniqueValues.get(value);
            if (vmd != null) {
                ++vmd.count;
            }
        }
        return true;
    }

    public int getNumberValues() {
        if (this.uniqueValues == null) {
            return 0;
        }
        return this.uniqueValues.size();
    }

    public boolean getValues(Object[] values, int sort) {
        int i = 0;
        if (this.uniqueValues == null || values == null) {
            return false;
        }
        Collection c = this.uniqueValues.values();
        if (c == null) {
            return false;
        }
        if (c.size() > values.length) {
            return false;
        }
        Iterator itr = (c = CollectionSorter.getValues(this.keyType, c, sort, this)).iterator();
        if (itr == null) {
            return false;
        }
        while (itr.hasNext()) {
            ValueMapData vmd = (ValueMapData)itr.next();
            values[i] = vmd == null ? null : vmd.value;
            ++i;
        }
        return true;
    }

    public Object[] getValues(int sort) {
        Object[] out = null;
        if (this.uniqueValues == null) {
            return null;
        }
        int n = this.uniqueValues.size();
        if (n <= 0) {
            return null;
        }
        out = new Object[n];
        if (out == null) {
            return null;
        }
        if (!this.getValues(out, sort)) {
            return null;
        }
        return out;
    }

    public int getOrderIndex(Object value) {
        if (this.uniqueValues == null) {
            return -1;
        }
        ValueMapData vmd = (ValueMapData)this.uniqueValues.get(value);
        if (vmd == null) {
            return -1;
        }
        return vmd.index;
    }

    public int getCount(Object value) {
        if (this.uniqueValues == null) {
            return 0;
        }
        ValueMapData vmd = (ValueMapData)this.uniqueValues.get(value);
        if (vmd == null) {
            return 0;
        }
        return vmd.count;
    }

    public boolean reindexValues(Object[] values) {
        if (this.uniqueValues == null || values == null) {
            return false;
        }
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            ValueMapData vmd = (ValueMapData)this.uniqueValues.get(values[i]);
            if (vmd == null) continue;
            vmd.index = i;
        }
        return true;
    }

    public boolean reindexValues(int order) {
        if (this.uniqueValues == null) {
            return false;
        }
        Object[] values = this.getValues(order);
        if (values == null) {
            return false;
        }
        return this.reindexValues(values);
    }

    public LinkedHashMap getMapValues() {
        return this.uniqueValues;
    }

    public double getNumericElement(Object entry) {
        if (entry == null) {
            return Double.NaN;
        }
        ValueMapData vmd = (ValueMapData)entry;
        if (this.isSortKeyInterface) {
            return ((SortKeyInterface)vmd.value).getNumericKeyValue();
        }
        return ((Number)vmd.value).doubleValue();
    }

    public String getStringElement(Object entry) {
        if (entry == null) {
            return null;
        }
        ValueMapData vmd = (ValueMapData)entry;
        if (this.isSortKeyInterface) {
            return ((SortKeyInterface)vmd.value).getKeyValue().toString();
        }
        return vmd.value.toString();
    }

    class ValueMapData {
        public int index;
        public int count;
        public Object value;

        public ValueMapData(Object value, int index) {
            this.value = value;
            this.index = index;
            this.count = 1;
        }

        public ValueMapData(Object value) {
            this.value = value;
            this.index = UniqueValueMapper.this.uniqueValues == null ? 0 : UniqueValueMapper.this.uniqueValues.size();
            this.count = 1;
        }
    }
}

