/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.interfaces.TransformInterface;
import java.awt.Rectangle;

public class TransformObject
implements TransformInterface {
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private boolean xRangeSet = false;
    private boolean yRangeSet = false;
    private Rectangle screenBounds = new Rectangle(0, 0, 1, 1);
    private boolean xReverse = false;
    private boolean yReverse = false;
    private boolean valid = true;
    private int xTransformType = 1;
    private int yTransformType = 1;
    private double xLogBase = 10.0;
    private double yLogBase = 10.0;

    public TransformObject() {
        this(0.0, 1.0, 0.0, 1.0);
        this.xRangeSet = false;
        this.yRangeSet = false;
    }

    public TransformObject(DataRange xRange, DataRange yRange) {
        this.setXRange(xRange);
        this.setYRange(yRange);
    }

    public TransformObject(double xMin, double xMax, double yMin, double yMax) {
        this.setXRange(xMin, xMax);
        this.setYRange(yMin, yMax);
    }

    public void setScreenBounds(int x, int y, int width, int height) {
        this.screenBounds.x = x;
        this.screenBounds.width = width;
        this.screenBounds.y = y;
        this.screenBounds.height = height;
    }

    public Rectangle getScreenBounds() {
        return this.screenBounds;
    }

    public void setXRange(DataRange range) {
        if (range instanceof ContinuousRange) {
            this.setXRange(((ContinuousRange)range).getMin(), ((ContinuousRange)range).getMax());
        } else if (range instanceof DiscreteRange) {
            this.setXRange(0.0, ((DiscreteRange)range).getValuesSize() - 1);
        }
    }

    public void setXRange(double xMin, double xMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.xRangeSet = true;
    }

    public void setYRange(DataRange range) {
        if (range instanceof ContinuousRange) {
            this.setYRange(((ContinuousRange)range).getMin(), ((ContinuousRange)range).getMax());
        } else if (range instanceof DiscreteRange) {
            this.setYRange(0.0, ((DiscreteRange)range).getValuesSize() - 1);
        }
    }

    public void setYRange(double yMin, double yMax) {
        this.yMin = yMin;
        this.yMax = yMax;
        this.yRangeSet = true;
    }

    private double scaleData(int dim, double value, double min, double max) {
        double d = Double.NaN;
        switch (dim) {
            case 1: {
                switch (this.xTransformType) {
                    default: {
                        return (value - min) / (max - min);
                    }
                    case 2: 
                }
                if (value == 0.0) {
                    return 0.0;
                }
                d = (this.getLogToBase(value, this.xLogBase) - this.getLogToBase(min, this.xLogBase)) / (this.getLogToBase(max, this.xLogBase) - this.getLogToBase(min, this.xLogBase));
                return d;
            }
            case 2: {
                switch (this.yTransformType) {
                    default: {
                        return (value - min) / (max - min);
                    }
                    case 2: 
                }
                if (value == 0.0) {
                    return 0.0;
                }
                d = (this.getLogToBase(value, this.yLogBase) - this.getLogToBase(min, this.yLogBase)) / (this.getLogToBase(max, this.yLogBase) - this.getLogToBase(min, this.yLogBase));
                return d;
            }
        }
        return d;
    }

    private double getLogToBase(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    @Override
    public double[] project(double x, double y, double z, double[] out) {
        double[] results;
        double[] dArray = results = out == null ? new double[3] : out;
        results[0] = !this.xRangeSet ? (double)this.screenBounds.x : (Double.isNaN(this.xMin) || Double.isNaN(this.xMax) ? (double)this.screenBounds.x : (this.xMin == this.xMax ? (x == this.xMin ? (double)(this.screenBounds.x + this.screenBounds.width / 2) : (double)this.screenBounds.x) : (this.xReverse ? (double)this.screenBounds.width * this.scaleData(1, x, this.xMax, this.xMin) + (double)this.screenBounds.x : (double)this.screenBounds.width * this.scaleData(1, x, this.xMin, this.xMax) + (double)this.screenBounds.x)));
        results[1] = !this.yRangeSet ? (double)this.screenBounds.y : (Double.isNaN(this.yMin) || Double.isNaN(this.yMax) ? (double)this.screenBounds.y : (this.yMin == this.yMax ? (y == this.yMin ? (double)(this.screenBounds.y + this.screenBounds.height / 2) : (double)this.screenBounds.y) : (this.yReverse ? (double)this.screenBounds.height - (double)this.screenBounds.height * this.scaleData(2, y, this.yMax, this.yMin) + (double)this.screenBounds.y : (double)this.screenBounds.height - (double)this.screenBounds.height * this.scaleData(2, y, this.yMin, this.yMax) + (double)this.screenBounds.y)));
        results[2] = 0.0;
        return results;
    }

    @Override
    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        double exp;
        double[] results;
        double[] dArray = results = out == null ? new double[3] : out;
        if (Double.isNaN(this.xMin) || Double.isNaN(this.xMax)) {
            results[0] = Double.NaN;
        } else if (this.xTransformType == 1) {
            results[0] = this.xReverse ? (this.xMin - this.xMax) * (pixelX - (double)this.screenBounds.x) / (double)this.screenBounds.width + this.xMax : (this.xMax - this.xMin) * (pixelX - (double)this.screenBounds.x) / (double)this.screenBounds.width + this.xMin;
        } else if (this.xTransformType == 2) {
            exp = 0.0;
            exp = this.xReverse ? (this.getLogToBase(this.xMin, this.xLogBase) - this.getLogToBase(this.xMax, this.xLogBase)) * (pixelX - (double)this.screenBounds.x) / (double)this.screenBounds.width + this.getLogToBase(this.xMax, this.xLogBase) : (this.getLogToBase(this.xMax, this.xLogBase) - this.getLogToBase(this.xMin, this.xLogBase)) * (pixelX - (double)this.screenBounds.x) / (double)this.screenBounds.width + this.getLogToBase(this.xMin, this.xLogBase);
            results[0] = Math.pow(this.xLogBase, exp);
        }
        if (Double.isNaN(this.yMin) || Double.isNaN(this.yMax)) {
            results[1] = Double.NaN;
        } else if (this.yTransformType == 1) {
            results[1] = this.yReverse ? (this.yMax - this.yMin) * (pixelY - (double)this.screenBounds.y) / (double)this.screenBounds.height + this.yMin : (this.yMin - this.yMax) * (pixelY - (double)this.screenBounds.y) / (double)this.screenBounds.height + this.yMax;
        } else if (this.yTransformType == 2) {
            exp = 0.0;
            exp = this.yReverse ? (this.getLogToBase(this.yMax, this.yLogBase) - this.getLogToBase(this.yMin, this.yLogBase)) * (pixelY - (double)this.screenBounds.y) / (double)this.screenBounds.height + this.getLogToBase(this.yMin, this.yLogBase) : (this.getLogToBase(this.yMin, this.yLogBase) - this.getLogToBase(this.yMax, this.yLogBase)) * (pixelY - (double)this.screenBounds.y) / (double)this.screenBounds.height + this.getLogToBase(this.yMax, this.yLogBase);
            results[1] = Math.pow(this.yLogBase, exp);
        }
        results[2] = 0.0;
        return results;
    }

    @Override
    public void setReverse(int axis, boolean flag) {
        switch (axis) {
            case 0: 
            case 3: {
                this.xReverse = flag;
                break;
            }
            case 1: 
            case 4: {
                this.yReverse = flag;
            }
        }
    }

    @Override
    public boolean isReverse(int axis) {
        boolean rc = false;
        switch (axis) {
            case 0: 
            case 3: {
                rc = this.xReverse;
                break;
            }
            case 1: 
            case 4: {
                rc = this.yReverse;
            }
        }
        return rc;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setTransformType(int axis, int type, Object transInfo) {
        switch (type) {
            case 1: {
                if (axis == 0 || axis == 3) {
                    this.xTransformType = type;
                    break;
                }
                this.yTransformType = type;
                break;
            }
            case 2: {
                if (axis == 0 || axis == 3) {
                    this.xTransformType = type;
                    if (!(transInfo instanceof Number)) break;
                    this.xLogBase = ((Number)transInfo).doubleValue();
                    break;
                }
                this.yTransformType = type;
                if (!(transInfo instanceof Number)) break;
                this.yLogBase = ((Number)transInfo).doubleValue();
            }
        }
    }

    public int getTransformType(int axis) {
        if (axis == 0 || axis == 3) {
            return this.xTransformType;
        }
        return this.yTransformType;
    }

    public Object getTransformInfo(int axis) {
        if (axis == 0 || axis == 3) {
            return new Double(this.xLogBase);
        }
        return new Double(this.yLogBase);
    }
}

