/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.ToolTipDefaults;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ToolTip
implements TipInterface,
GraphBackgroundInterface,
PropertyInterface {
    public static final int TOOLTIP_TEXT_TYPE_TABLE = 0;
    public static final int TOOLTIP_TEXT_TYPE_FREEFLOW = 1;
    private int tooltipTextType = 0;
    ToolTipDefaults defaults = new ToolTipDefaults();
    protected Font userSetFont = null;
    protected Font computedFont = null;
    Color solidBackground = new Color(245, 245, 220);
    Color gradient1 = null;
    Color gradient2 = null;
    double transparency = 1.0;
    Color textColor = Color.black;
    Color borderColor = Color.black;
    private PropertyList pending = new PropertyList();
    protected static int columnSpacing = 5;
    protected static int rowSpacing = 3;
    UserSetPropertyBitMask userSetProperties = null;
    Style style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
    private boolean useHTMLRenderer = false;
    private JLabel htmlRenderer = null;
    private boolean enabled = true;

    public ToolTip() {
        TextStyleElement tse = this.style.getTextStyleElement("ValueText");
        this.computedFont = tse.getFont();
        this.userSetProperties = new UserSetPropertyBitMask(this.getSupportedProperties());
    }

    public Dimension getSize(Object text, Graphics2D g, Component component) {
        if (text == null || g == null) {
            return null;
        }
        if (this.useHTMLRenderer && this.htmlRenderer != null) {
            this.htmlRenderer.setText("<html>" + text + "</html>");
            return this.htmlRenderer.getPreferredSize();
        }
        Font textFont = this.getFont(component);
        String[][] parsedText = null;
        parsedText = text instanceof String[][] ? (String[][])text : ToolTip.parseText(text.toString());
        if (parsedText == null) {
            return new Dimension(50, 50);
        }
        Dimension d = new Dimension((parsedText.length + 1) * columnSpacing, 2 * rowSpacing);
        String[][] columns = parsedText;
        FontRenderContext frc = g.getFontRenderContext();
        int textHeight = (int)textFont.getStringBounds("T", frc).getHeight();
        d.height = columns == null || columns.length == 0 ? 0 : textHeight * columns[0].length + rowSpacing * (2 + columns[0].length);
        for (int i = 0; i < columns.length; ++i) {
            d.width += this.getMaxStringWidth(columns[i], textFont, g, frc);
        }
        return d;
    }

    private Font getFont(Component component) {
        if (this.userSetFont != null) {
            return this.userSetFont;
        }
        if (component == null) {
            return this.computedFont;
        }
        double d = Math.min(component.getWidth(), component.getHeight());
        int computedSize = (int)(d * this.defaults.fraction * this.defaults.fontSizeAdjustment);
        computedSize = (int)Math.max(Math.min((double)this.defaults.maxFontSize * this.defaults.fontSizeAdjustment, (double)computedSize), (double)this.defaults.minFontSize * this.defaults.fontSizeAdjustment);
        this.computedFont = this.computedFont.deriveFont((float)computedSize);
        return this.computedFont;
    }

    public void paint(JComponent component, Graphics2D g, Point origin, Object text) {
        if (g == null || origin == null || text == null || !this.enabled) {
            return;
        }
        Font font = this.getFont(component);
        Dimension size = this.getSize(text, g, component);
        origin.x -= size.width + columnSpacing;
        origin.y -= size.height + rowSpacing;
        if (origin.x < 0) {
            origin.x = 0;
        }
        if (origin.y < 0) {
            origin.y = 0;
        }
        Graphics2D g2 = g;
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, (float)this.getChartTipOpacity()));
        if (this.useHTMLRenderer) {
            g.translate(origin.x, origin.y);
            this.htmlRenderer.setText("<html>" + text + "</html>");
            this.htmlRenderer.setSize(size);
            this.htmlRenderer.paint(g);
            g.translate(-origin.x, -origin.y);
            return;
        }
        if (this.getSolidBackground() != null) {
            g.setColor(this.getSolidBackground());
        } else {
            g.setPaint(new GradientPaint(origin.x, origin.y, this.gradient1, origin.x + size.width, origin.y + size.height, this.gradient2));
        }
        g.fillRect(origin.x, origin.y, size.width, size.height);
        Color borderColor = Color.black;
        if (this.getChartTipBorderColor() != null) {
            borderColor = this.getChartTipBorderColor();
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(borderColor);
        g.drawRect(origin.x, origin.y, size.width - 1, size.height - 1);
        Color textColor = null;
        textColor = this.getChartTipTextColor();
        g.setColor(textColor);
        g.setFont(font);
        if (text == null) {
            text = "";
        }
        FontRenderContext frc = g.getFontRenderContext();
        String[][] textArray = this.getText(text);
        int textHeight = (int)font.getStringBounds("T", frc).getHeight();
        int xPos = origin.x + columnSpacing;
        int yPos = origin.y + rowSpacing + textHeight;
        for (int i = 0; i < textArray.length; ++i) {
            yPos = origin.y + rowSpacing + textHeight;
            if (this.tooltipTextType == 0) {
                xPos += this.getMaxStringWidth(textArray[i], font, g2, frc);
            }
            for (int j = 0; j < textArray[i].length; ++j) {
                if (textArray[i][j] != null && textArray[i][j].length() > 0) {
                    if (this.tooltipTextType == 0) {
                        g.drawString(textArray[i][j], xPos - (int)font.getStringBounds(textArray[i][j], frc).getWidth(), yPos);
                    } else {
                        g.drawString(textArray[i][j], xPos, yPos);
                    }
                }
                yPos += textHeight + rowSpacing;
            }
            if (this.tooltipTextType == 1) {
                xPos += this.getMaxStringWidth(textArray[i], font, g2, frc);
            }
            xPos += columnSpacing;
        }
        g2.setComposite(composite);
    }

    private String[][] getText(Object text) {
        if (text == null) {
            return null;
        }
        if (text instanceof String[][]) {
            return (String[][])text;
        }
        return ToolTip.parseText(text.toString());
    }

    private static String[][] parseText(String text) {
        if (text == null) {
            return null;
        }
        StringTokenizer lineParser = new StringTokenizer(text, "\n");
        String[][] rc = new String[lineParser.countTokens()][];
        int maxCols = 0;
        int i = 0;
        while (lineParser.hasMoreTokens()) {
            StringTokenizer colParser = new StringTokenizer(lineParser.nextToken(), "\t");
            rc[i] = new String[colParser.countTokens()];
            if (colParser.countTokens() > maxCols) {
                maxCols = colParser.countTokens();
            }
            int j = 0;
            while (colParser.hasMoreTokens()) {
                rc[i][j] = colParser.nextToken();
                ++j;
            }
            ++i;
        }
        String[][] temp = rc;
        rc = new String[maxCols][];
        for (i = 0; i < maxCols; ++i) {
            rc[i] = ToolTip.getCol(i, temp);
        }
        return rc;
    }

    private static String[] getCol(int i, String[][] arr) {
        String[] rc = new String[arr.length];
        for (int j = 0; j < arr.length; ++j) {
            rc[j] = arr[j].length > i ? arr[j][i].trim() : new String("");
        }
        return rc;
    }

    protected int getMaxStringWidth(String[] strs, Font style, Graphics2D g, FontRenderContext frc) {
        int rc = 0;
        for (int i = 0; i < strs.length; ++i) {
            int width = (int)style.getStringBounds(strs[i], frc).getWidth();
            if (rc >= width) continue;
            rc = width;
        }
        return rc;
    }

    public void applyStyle(Style style) {
        if (style == null) {
            return;
        }
        LineStyleElement lse = style.getLineStyleElement("BorderLines");
        this.setChartTipBorderColor(lse.getLineColor());
        this.userSetProperties.clear(5);
        TextStyleElement tse = style.getTextStyleElement("ValueText");
        this.setChartTipTextColor(tse.getTextColor());
        this.computedFont = tse.getFont();
        this.userSetProperties.clear(4);
        FillStyleElement fse = style.getFillStyleElement("WallFill");
        this.setSolidBackground(fse.getFillColor());
        this.userSetProperties.clear(6);
        if (this.htmlRenderer != null) {
            this.htmlRenderer.setBackground(this.getSolidBackground());
            this.htmlRenderer.setBorder(BorderFactory.createLineBorder(this.getChartTipBorderColor()));
            this.htmlRenderer.setForeground(this.getChartTipTextColor());
        }
    }

    public boolean isPropertySupported(int id) {
        return id == 3 || id == 4 || id == 5 || id == 6 || id == 8;
    }

    public int[] getSupportedProperties() {
        return new int[]{3, 4, 5, 6, 8};
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 3: {
                rc = this.getFontObject();
                break;
            }
            case 4: {
                rc = this.textColor;
                break;
            }
            case 5: {
                rc = this.borderColor;
                break;
            }
            case 6: {
                rc = this.getSolidBackground();
                break;
            }
            case 7: {
                rc = this;
                break;
            }
            case 8: {
                rc = new Double(this.transparency);
                break;
            }
            case 10: {
                rc = this.getGraphBackground();
            }
        }
        return rc;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (value == null) {
            return false;
        }
        return this.pending.store(id, value);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() == 0) {
            return false;
        }
        block7: for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            switch (key) {
                case 3: {
                    if (!(value instanceof Font)) continue block7;
                    this.setFontObject((Font)value);
                    continue block7;
                }
                case 4: {
                    if (!(value instanceof Color)) continue block7;
                    this.setChartTipTextColor((Color)value);
                    continue block7;
                }
                case 5: {
                    if (!(value instanceof Color)) continue block7;
                    this.setChartTipBorderColor((Color)value);
                    continue block7;
                }
                case 6: {
                    if (!(value instanceof Color)) continue block7;
                    this.setSolidBackground(value);
                    continue block7;
                }
                case 8: {
                    if (!(value instanceof Number)) continue block7;
                    this.setChartTipOpacity(((Number)value).doubleValue());
                }
            }
        }
        this.pending.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    @Override
    public Object[] getGraphBackground() {
        Object[] rc = new Object[]{this.solidBackground != null ? this.solidBackground : new GradientPaint(0.0f, 0.0f, this.gradient1, 10.0f, 10.0f, this.gradient2)};
        return rc;
    }

    @Override
    public boolean supportsGradientBackground() {
        return true;
    }

    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        if (startColor == null || endColor == null || !(startColor instanceof Color) || !(endColor instanceof Color)) {
            return false;
        }
        this.gradient1 = (Color)startColor;
        this.gradient2 = (Color)endColor;
        this.solidBackground = null;
        return true;
    }

    @Override
    public boolean supportsImageBackground() {
        return false;
    }

    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        return false;
    }

    @Override
    public Color getSolidBackground() {
        return this.solidBackground;
    }

    @Override
    public boolean setSolidBackground(Object c) {
        if (c == null || !(c instanceof Color)) {
            return false;
        }
        this.gradient1 = null;
        this.gradient2 = null;
        if (c.equals(this.solidBackground)) {
            return true;
        }
        this.solidBackground = (Color)c;
        this.userSetProperties.set(6);
        return true;
    }

    @Override
    public void redrawGraphBackground(Component c) {
    }

    @Override
    public double getChartTipOpacity() {
        return this.transparency;
    }

    @Override
    public boolean setChartTipOpacity(double opacity) {
        if (opacity == this.transparency) {
            return true;
        }
        this.transparency = opacity;
        this.userSetProperties.set(8);
        return true;
    }

    @Override
    public GraphBackgroundInterface getChartTipBackground() {
        return this;
    }

    @Override
    public Color getChartTipBorderColor() {
        return this.borderColor;
    }

    @Override
    public boolean setChartTipBorderColor(Object newColor) {
        if (newColor == null || !(newColor instanceof Color)) {
            return false;
        }
        if (newColor.equals(this.borderColor)) {
            return true;
        }
        this.borderColor = (Color)newColor;
        this.userSetProperties.set(5);
        return true;
    }

    @Override
    public Color getChartTipTextColor() {
        return this.textColor;
    }

    @Override
    public boolean setChartTipTextColor(Object newColor) {
        if (newColor == null || !(newColor instanceof Color)) {
            return false;
        }
        if (newColor.equals(this.textColor)) {
            return true;
        }
        this.textColor = (Color)newColor;
        this.userSetProperties.set(4);
        return true;
    }

    @Override
    public boolean setFontObject(Font f) {
        this.userSetFont = f;
        this.userSetProperties.set(3);
        return true;
    }

    @Override
    public Font getFontObject() {
        return this.userSetFont;
    }

    public boolean isUseHTMLRenderer() {
        return this.useHTMLRenderer;
    }

    public void setUseHTMLRenderer(boolean useHTMLRenderer) {
        this.useHTMLRenderer = useHTMLRenderer;
        if (useHTMLRenderer && this.htmlRenderer == null) {
            this.htmlRenderer = new JLabel();
            this.htmlRenderer.addNotify();
            this.htmlRenderer.setOpaque(true);
            this.htmlRenderer.setBackground(this.getSolidBackground());
            this.htmlRenderer.setBorder(BorderFactory.createLineBorder(this.getChartTipBorderColor()));
            this.htmlRenderer.setForeground(this.getChartTipTextColor());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public int getTooltipTextType() {
        return this.tooltipTextType;
    }

    public void setTooltipTextType(int tooltipTextType) {
        this.tooltipTextType = tooltipTextType;
    }
}

