/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.SILKXYComponent;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.UIResource;

public class ToolPallet
extends JComponent
implements ActionListener {
    protected int orientation;
    public static final int HORIZONTAL = -1000086;
    public static final int VERTICAL = -1000087;
    protected int position;
    public static final int TOP_LEFT = -1000088;
    public static final int TOP_RIGHT = -1000089;
    public static final int RIGHT_TOP = -1000090;
    public static final int RIGHT_BOT = -1000091;
    public static final int BOT_LEFT = -1000092;
    public static final int BOT_RIGHT = -1000093;
    public static final int LEFT_TOP = -1000094;
    public static final int LEFT_BOT = -1000095;
    private static final long serialVersionUID = -176855799878469827L;
    protected Vector listeners = new Vector();
    protected Insets outerMargin;
    protected ButtonGroup bg;
    protected int buttonW = 16;
    protected int buttonH = 16;
    private DefaultToolBarLayout layout;
    protected boolean brushIsVisible;
    protected boolean selectIsVisible;
    protected boolean zoomIsVisible;
    protected boolean panIsVisible;
    protected JToggleButton select = null;
    protected JToggleButton brush = null;
    protected JToggleButton zoom = null;
    protected JToggleButton pan = null;
    private static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private static String TOP_LEFT_eng = "Top Left";
    private static String TOP_RIGHT_eng = "Top Right";
    private static String BOTTOM_LEFT_eng = "Bottom Left";
    private static String BOTTOM_RIGHT_eng = "Bottom Right";
    private static String LEFT_TOP_eng = "Left Top";
    private static String LEFT_BOTTOM_eng = "Left Bottom";
    private static String RIGHT_TOP_eng = "Right Top";
    private static String RIGHT_BOTTOM_eng = "Right Bottom";
    private static String TOP_LEFT_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.TopLeft.txt", (String)TOP_LEFT_eng);
    private static String TOP_RIGHT_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.TopRight.txt", (String)TOP_RIGHT_eng);
    private static String BOTTOM_LEFT_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.BottomLeft.txt", (String)BOTTOM_LEFT_eng);
    private static String BOTTOM_RIGHT_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.BottomRight.txt", (String)BOTTOM_RIGHT_eng);
    private static String LEFT_TOP_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.LeftTop.txt", (String)LEFT_TOP_eng);
    private static String LEFT_BOTTOM_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.LeftBottom.txt", (String)LEFT_BOTTOM_eng);
    private static String RIGHT_TOP_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.RightTop.txt", (String)RIGHT_TOP_eng);
    private static String RIGHT_BOTTOM_nls = ResourceLoader.getResourceString((Object)rb, (String)"ToolPallet.RightBottom.txt", (String)RIGHT_BOTTOM_eng);
    private boolean blockUpdate = false;

    public ToolPallet(boolean showBrush, boolean showSelect, boolean showZoom, boolean showPan, int requestPosition, int requestOrientation) {
        this.brushIsVisible = showBrush;
        this.selectIsVisible = showSelect;
        this.zoomIsVisible = showZoom;
        this.panIsVisible = showPan;
        this.initButtons(this.buttonW, this.buttonH);
        this.setPosition(requestPosition);
        this.setOrientation(requestOrientation);
    }

    private void initButtons(int buttonX, int buttonY) {
        this.removeAll();
        if (this.brushIsVisible) {
            this.brush = new JToggleButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/Brush.gif")));
            this.brush.setPreferredSize(new Dimension(buttonX, buttonY));
            this.brush.setToolTipText(ResourceLoader.getResourceString((Object)rb, (String)"SILKToolbar.Brush.txt", (String)"Brush"));
            this.brush.addActionListener(this);
            this.brush.setEnabled(true);
            this.brush.setVisible(true);
            this.brush.setFocusable(false);
            this.add(this.brush);
        }
        if (this.selectIsVisible) {
            this.select = new JToggleButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/Pointer.gif")));
            this.select.setPreferredSize(new Dimension(buttonX, buttonY));
            this.select.setToolTipText(ResourceLoader.getResourceString((Object)rb, (String)"SILKToolbar.Select.txt", (String)"Select"));
            this.select.addActionListener(this);
            this.select.setEnabled(true);
            this.select.setVisible(true);
            this.select.setFocusable(false);
            this.add(this.select);
        }
        if (this.zoomIsVisible) {
            this.zoom = new JToggleButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/Zoom_std.gif")));
            this.zoom.setPreferredSize(new Dimension(buttonX, buttonY));
            this.zoom.setToolTipText(ResourceLoader.getResourceString((Object)rb, (String)"SILKToolbar.Viewport.txt", (String)"Viewport"));
            this.zoom.addActionListener(this);
            this.zoom.setEnabled(true);
            this.zoom.setVisible(true);
            this.zoom.setFocusable(false);
            this.add(this.zoom);
        }
        if (this.panIsVisible) {
            this.pan = new JToggleButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/Pan.gif")));
            this.pan.setPreferredSize(new Dimension(buttonX, buttonY));
            this.pan.setToolTipText(ResourceLoader.getResourceString((Object)rb, (String)"SILKToolbar.Pan.txt", (String)"Pan"));
            this.pan.addActionListener(this);
            this.pan.setEnabled(true);
            this.pan.setVisible(true);
            this.pan.setFocusable(false);
            this.add(this.pan);
        }
        this.bg = new ButtonGroup();
        this.bg.add(this.brush);
        this.bg.add(this.select);
        this.bg.add(this.pan);
        this.bg.add(this.zoom);
    }

    public void setButtonsVisible(boolean showBrush, boolean showSelect, boolean showZoom, boolean showPan) {
        this.brushIsVisible = showBrush;
        this.selectIsVisible = showSelect;
        this.zoomIsVisible = showZoom;
        this.panIsVisible = showPan;
        this.initButtons(16, 16);
    }

    public void makeSpaceForYourself(Insets outerMargin) {
        if (!this.isVisible()) {
            return;
        }
        switch (this.position) {
            case -1000089: 
            case -1000088: {
                outerMargin.top += this.getHeight();
                break;
            }
            case -1000093: 
            case -1000092: {
                outerMargin.bottom += this.getHeight();
                break;
            }
            case -1000095: 
            case -1000094: {
                outerMargin.left += this.getWidth();
                break;
            }
            case -1000091: 
            case -1000090: {
                outerMargin.right += this.getWidth();
            }
        }
    }

    public int getPosition() {
        return this.position;
    }

    public static String getStringPosition(int staticPosition) {
        switch (staticPosition) {
            default: {
                return TOP_RIGHT_nls;
            }
            case -1000088: {
                return TOP_LEFT_nls;
            }
            case -1000094: {
                return LEFT_TOP_nls;
            }
            case -1000090: {
                return RIGHT_TOP_nls;
            }
            case -1000092: {
                return BOTTOM_LEFT_nls;
            }
            case -1000095: {
                return LEFT_BOTTOM_nls;
            }
            case -1000093: {
                return BOTTOM_RIGHT_nls;
            }
            case -1000091: 
        }
        return RIGHT_BOTTOM_nls;
    }

    public static String getEnglishStringPosition(int staticPosition) {
        switch (staticPosition) {
            default: {
                return TOP_RIGHT_eng;
            }
            case -1000088: {
                return TOP_LEFT_eng;
            }
            case -1000094: {
                return LEFT_TOP_eng;
            }
            case -1000090: {
                return RIGHT_TOP_eng;
            }
            case -1000092: {
                return BOTTOM_LEFT_eng;
            }
            case -1000095: {
                return LEFT_BOTTOM_eng;
            }
            case -1000093: {
                return BOTTOM_RIGHT_eng;
            }
            case -1000091: 
        }
        return RIGHT_BOTTOM_eng;
    }

    public static String getEnglishStringPosition(String position) {
        if (TOP_LEFT_nls.equalsIgnoreCase(position)) {
            return TOP_LEFT_eng;
        }
        if (LEFT_TOP_nls.equalsIgnoreCase(position)) {
            return LEFT_TOP_eng;
        }
        if (RIGHT_TOP_nls.equalsIgnoreCase(position)) {
            return RIGHT_TOP_eng;
        }
        if (BOTTOM_LEFT_nls.equalsIgnoreCase(position)) {
            return BOTTOM_LEFT_eng;
        }
        if (LEFT_BOTTOM_nls.equalsIgnoreCase(position)) {
            return LEFT_BOTTOM_eng;
        }
        if (BOTTOM_RIGHT_nls.equalsIgnoreCase(position)) {
            return BOTTOM_RIGHT_eng;
        }
        if (RIGHT_BOTTOM_nls.equalsIgnoreCase(position)) {
            return RIGHT_BOTTOM_eng;
        }
        return TOP_RIGHT_eng;
    }

    public void setStringPosition(String position) {
        int pos = this.getPosition();
        if (TOP_LEFT_nls.equalsIgnoreCase(position) || TOP_LEFT_eng.equalsIgnoreCase(position)) {
            pos = -1000088;
        } else if (LEFT_TOP_nls.equalsIgnoreCase(position) || LEFT_TOP_eng.equalsIgnoreCase(position)) {
            pos = -1000094;
        } else if (TOP_RIGHT_nls.equalsIgnoreCase(position) || TOP_RIGHT_eng.equalsIgnoreCase(position)) {
            pos = -1000089;
        } else if (RIGHT_TOP_nls.equalsIgnoreCase(position) || RIGHT_TOP_eng.equalsIgnoreCase(position)) {
            pos = -1000090;
        } else if (BOTTOM_LEFT_nls.equalsIgnoreCase(position) || BOTTOM_LEFT_eng.equalsIgnoreCase(position)) {
            pos = -1000092;
        } else if (LEFT_BOTTOM_nls.equalsIgnoreCase(position) || LEFT_BOTTOM_eng.equalsIgnoreCase(position)) {
            pos = -1000095;
        } else if (BOTTOM_RIGHT_nls.equalsIgnoreCase(position) || BOTTOM_RIGHT_eng.equalsIgnoreCase(position)) {
            pos = -1000093;
        } else if (RIGHT_BOTTOM_nls.equalsIgnoreCase(position) || RIGHT_BOTTOM_eng.equalsIgnoreCase(position)) {
            pos = -1000091;
        }
        this.setPosition(pos);
    }

    public void setPosition(int intValue) {
        switch (intValue) {
            case -1000093: 
            case -1000092: 
            case -1000089: 
            case -1000088: {
                this.position = intValue;
                this.setOrientation(-1000086);
                break;
            }
            case -1000095: 
            case -1000094: 
            case -1000091: 
            case -1000090: {
                this.position = intValue;
                this.setOrientation(-1000087);
                break;
            }
            default: {
                this.position = -1000088;
                this.setOrientation(-1000086);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int intValue) {
        this.orientation = intValue == -1000087 ? -1000087 : -1000086;
        if (this.layout == null || this.orientation != this.layout.getOrientation()) {
            this.layout = new DefaultToolBarLayout(this.orientation);
            this.setLayout(this.layout);
            this.addPropertyChangeListener(this.layout);
            int numberOfButtons = this.getComponentCount();
            switch (this.orientation) {
                case -1000086: {
                    this.setSize((numberOfButtons + 2) * this.buttonW, this.buttonH);
                    break;
                }
                case -1000087: {
                    this.setSize((int)((double)this.buttonW * 1.5), (numberOfButtons + 2) * this.buttonH);
                }
            }
            this.doLayout();
        }
    }

    public void updateXYPosition(Component parent) {
        if (!this.isVisible()) {
            return;
        }
        if (this.outerMargin == null && parent instanceof SILKXYComponent) {
            this.outerMargin = ((SILKXYComponent)parent).getOuterMargin();
        }
        switch (this.position) {
            case -1000088: {
                if (this.outerMargin != null) {
                    this.setLocation(this.outerMargin.left - 1, this.outerMargin.top - this.getHeight());
                    break;
                }
                this.setLocation(0, 0);
                break;
            }
            case -1000094: {
                if (this.outerMargin != null) {
                    this.setLocation(this.outerMargin.left, this.outerMargin.top);
                    break;
                }
                this.setLocation(0, 1);
                break;
            }
            case -1000089: {
                if (this.outerMargin != null) {
                    this.setLocation(parent.getWidth() - this.getWidth() - this.outerMargin.right + 1, this.outerMargin.top - this.getHeight());
                    break;
                }
                this.setLocation(parent.getWidth() - this.getWidth(), 0);
                break;
            }
            case -1000090: {
                if (this.outerMargin != null) {
                    this.setLocation(parent.getWidth() - this.getWidth() - 5, this.outerMargin.top - 1);
                    break;
                }
                this.setLocation(parent.getWidth() - this.getWidth(), 1);
                break;
            }
            case -1000095: 
            case -1000092: {
                if (this.outerMargin != null) {
                    this.setLocation(0, parent.getHeight() - this.getHeight());
                    break;
                }
                this.setLocation(0, parent.getHeight() - this.getHeight());
                break;
            }
            case -1000093: {
                if (this.outerMargin != null) {
                    this.setLocation(parent.getWidth() - this.outerMargin.right - this.getWidth(), parent.getHeight() - this.outerMargin.bottom - this.getHeight());
                    break;
                }
                this.setLocation(parent.getWidth() - this.getWidth(), parent.getHeight() - this.getHeight());
                break;
            }
            case -1000091: {
                if (this.outerMargin != null) {
                    this.setLocation(parent.getWidth() - this.getWidth() - 5, parent.getHeight() - this.outerMargin.bottom - this.getHeight() + 1);
                    break;
                }
                this.setLocation(parent.getWidth() - this.getWidth(), parent.getHeight() - this.getHeight());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int action = -1;
        Object source = e.getSource();
        this.blockUpdate = true;
        action = source == this.brush ? 1 : (source == this.zoom ? 2 : (source == this.pan ? 4 : (source == this.select ? 6 : 0)));
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphInterface)this.listeners.elementAt(i)).setActionMode(action);
        }
        this.blockUpdate = false;
    }

    public void addListener(GraphInterface l) {
        if (this.listeners.isEmpty()) {
            this.updateState(l);
        }
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void removeListener(GraphInterface l) {
        this.listeners.remove(l);
    }

    public void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    public void updateState(GraphInterface l) {
        if (this.blockUpdate) {
            return;
        }
        switch (l.getActionMode()) {
            case 0: 
            case 1: {
                this.brush.setSelected(true);
                break;
            }
            case 2: {
                this.zoom.setSelected(true);
                break;
            }
            case 4: {
                this.pan.setSelected(true);
                break;
            }
            case 5: {
                this.brush.setSelected(true);
                break;
            }
            case 6: {
                this.select.setSelected(true);
            }
        }
    }

    private class DefaultToolBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        private static final long serialVersionUID = 1L;
        LayoutManager lm;
        private int thisOrientation;

        DefaultToolBarLayout(int orientation) {
            if (orientation == -1000087) {
                this.lm = new BoxLayout(ToolPallet.this, 3);
                this.thisOrientation = orientation;
            } else {
                this.lm = new BoxLayout(ToolPallet.this, 2);
                this.thisOrientation = -1000086;
            }
        }

        public int getOrientation() {
            return this.thisOrientation;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.lm.preferredLayoutSize(target);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.lm.minimumLayoutSize(target);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            if (this.lm instanceof LayoutManager2) {
                return ((LayoutManager2)this.lm).maximumLayoutSize(target);
            }
            return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        }

        @Override
        public void layoutContainer(Container target) {
            this.lm.layoutContainer(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            if (this.lm instanceof LayoutManager2) {
                return ((LayoutManager2)this.lm).getLayoutAlignmentX(target);
            }
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            if (this.lm instanceof LayoutManager2) {
                return ((LayoutManager2)this.lm).getLayoutAlignmentY(target);
            }
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
            if (this.lm instanceof LayoutManager2) {
                ((LayoutManager2)this.lm).invalidateLayout(target);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("orientation")) {
                int o = (Integer)e.getNewValue();
                this.lm = o == -1000087 ? new BoxLayout(ToolPallet.this, 3) : new BoxLayout(ToolPallet.this, 2);
            }
        }
    }
}

