/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import java.util.Vector;

public class SubstitutionPattern {
    protected static final int LITERAL = 1;
    protected static final int TAG = 2;
    protected static final int TAG_REPEAT_START = 3;
    protected static final int TAG_REPEAT_END = 4;
    protected static final int CONDITIONAL = 5;
    protected static final int ROLE_NAME = 1;
    protected static final int ROLE_DESC = 2;
    protected static final int ROLE_VALUE = 3;
    protected static final int VAR_NAME = 4;
    protected static final int VAR_DESC = 5;
    protected static final int VAR_VALUE = 6;
    protected static final String defaultPattern = "{&L[CAT,RESP,GRP,SGRP,SIZE,COLOR,SHAPE,TIP,OPACITY,LABEL]{&G_*DESC}{&-\t=\t}{&G_*VALUE}{&-\n}}";
    protected String pattern;
    protected Vector parsedPattern = new Vector();

    public SubstitutionPattern(String pat) {
        this.setPattern(defaultPattern);
        if (pat != null) {
            this.setPattern(pat);
        }
    }

    public SubstitutionPattern() {
        this(null);
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean setPattern(String pat) {
        Vector v = new Vector();
        if (pat == null) {
            pat = defaultPattern;
        }
        if (!this.parse(pat, v)) {
            return false;
        }
        this.pattern = pat;
        this.parsedPattern = v;
        return true;
    }

    protected String getTag(String tag, RoleInterface roles, DataFilterReadInterface filter) {
        int id = 0;
        String s = null;
        String out = null;
        if ((tag = tag.toUpperCase()).startsWith("G_CAT")) {
            s = "Category";
        } else if (tag.startsWith("G_RESP")) {
            s = "Response";
        } else if (tag.startsWith("G_GRP")) {
            s = "Group";
        } else if (tag.startsWith("G_SGRP")) {
            s = "Subgroup";
        } else if (tag.startsWith("G_SIZE")) {
            s = "Size";
        } else if (tag.startsWith("G_COLOR")) {
            s = "Color";
        } else if (tag.startsWith("G_SHAPE")) {
            s = "Shape";
        } else if (tag.startsWith("G_TIP")) {
            s = "Tip";
        } else if (tag.startsWith("G_OPACITY")) {
            s = "Opacity";
        } else if (tag.startsWith("G_LABEL")) {
            s = "Label";
        } else {
            return null;
        }
        if (tag.endsWith("NAME")) {
            id = 1;
        } else if (tag.endsWith("DESC")) {
            id = 2;
        } else if (tag.endsWith("VALUE")) {
            id = 3;
        }
        switch (id) {
            case 1: 
            case 2: {
                Object o = roles.getVariable(s);
                if (o == null) break;
                if (id == 2 && filter != null) {
                    if ((o = filter.getVariableDescription(o)) == null) break;
                    out = o.toString();
                    break;
                }
                out = o.toString();
                break;
            }
            case 3: {
                Object o = roles.getRoleValue(s, 2);
                if (o == null) break;
                out = o.toString();
            }
        }
        return out;
    }

    public int doSubstitution(RoleInterface roles, String[] result) {
        return this.doSubstitution(roles, null, result);
    }

    public int doSubstitution(RoleInterface roles, DataFilterReadInterface filter, String[] result) {
        int n;
        int rptIdx = -1;
        int nLines = 0;
        String s = "";
        String prev = null;
        if (roles == null || result == null) {
            return 0;
        }
        if (this.parsedPattern == null || (n = this.parsedPattern.size()) <= 0) {
            return 0;
        }
        block7: for (int i = 0; i < n; ++i) {
            PatternEntry pe = (PatternEntry)this.parsedPattern.elementAt(i);
            if (pe == null || pe.pattern == null) continue;
            switch (pe.type) {
                case 3: {
                    rptIdx = i;
                    continue block7;
                }
                case 4: {
                    ++pe.count;
                    if (pe.count >= pe.limit) {
                        pe.count = 0;
                        continue block7;
                    }
                    if (rptIdx < 0) continue block7;
                    i = rptIdx;
                    continue block7;
                }
                case 5: {
                    if (prev == null) continue block7;
                }
                case 1: {
                    int newLineIdx;
                    String s2 = pe.pattern;
                    while ((newLineIdx = s2.indexOf(10)) >= 0) {
                        if (newLineIdx > 0) {
                            s = s + s2.substring(0, newLineIdx);
                        }
                        result[nLines] = s;
                        ++nLines;
                        s = "";
                        s2 = s2.substring(newLineIdx + 1);
                    }
                    s = s + s2;
                    continue block7;
                }
                case 2: {
                    prev = this.getTag(pe.pattern, roles, filter);
                    if (prev == null) continue block7;
                    s = s + prev;
                    continue block7;
                }
            }
        }
        if (s != null && s.length() > 0) {
            result[nLines] = s;
            ++nLines;
        }
        return nLines;
    }

    protected String replace(char wildcard, String target, String replacement) {
        String out;
        if (target == null) {
            return null;
        }
        int idx = target.indexOf(wildcard);
        if (idx < 0) {
            return target;
        }
        if (idx == target.length() - 1) {
            return target.substring(0, target.length() - 1) + replacement;
        }
        switch (idx) {
            case 0: {
                out = replacement + target.substring(1);
                break;
            }
            default: {
                out = target.substring(0, idx) + replacement + target.substring(idx + 1);
            }
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getWord(String cur) {
        boolean leftBrace = false;
        int i = 0;
        int inTag = 0;
        if (cur == null) return 0;
        int len = cur.length();
        if (len < 1) {
            return 0;
        }
        if (cur.startsWith("{&")) {
            ++inTag;
            i = 2;
        }
        while (i < len) {
            char c = cur.charAt(i);
            if (c == '{') {
                if (inTag <= 0) return i;
                leftBrace = true;
            } else if (c == '}') {
                if (inTag > 0 && --inTag <= 0) {
                    break;
                }
            } else if (leftBrace) {
                if (c == '&') {
                    ++inTag;
                }
                leftBrace = false;
            }
            ++i;
        }
        if (inTag <= 0) return Math.min(i + 1, len);
        return -1;
    }

    protected int getListElements(String s, Vector v) {
        int last = -1;
        if (s == null || v == null) {
            return -1;
        }
        int start = s.indexOf(91);
        int end = s.indexOf(93);
        if (start < 0 || end < 0 || start >= end - 1) {
            return -1;
        }
        String sub = s.substring(start + 1, end);
        int n = sub.length();
        for (int i = 0; i < n; ++i) {
            if (sub.charAt(i) != ',') continue;
            String word = sub.substring(last + 1, i);
            v.addElement(word);
            last = i;
        }
        if (n - 1 - last > 1) {
            v.addElement(sub.substring(last + 1, n));
        }
        return end;
    }

    protected int getRepeatCount(String tag) {
        int count = 1;
        if (tag == null) {
            return 1;
        }
        if (tag.length() <= 1) {
            return 1;
        }
        String s = tag.substring(1);
        try {
            count = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            count = 1;
        }
        return Math.max(1, count);
    }

    protected boolean storeTag(String tag, Vector v) {
        String s;
        int type = tag.startsWith("{&-") ? 5 : (tag.startsWith("{&RS") || tag.startsWith("{&rs") ? 3 : (tag.startsWith("{&RE") || tag.startsWith("{&re") ? 4 : (tag.startsWith("{&") ? 2 : 1)));
        switch (type) {
            default: {
                s = tag;
                break;
            }
            case 2: {
                s = tag.substring(2, tag.length() - 1);
                break;
            }
            case 3: 
            case 4: {
                s = tag.substring(3, tag.length() - 1);
                s = s.toUpperCase();
                break;
            }
            case 5: {
                s = tag.substring(3, tag.length() - 1);
            }
        }
        if (type == 2 && (s.charAt(0) == 'l' || s.charAt(0) == 'L')) {
            Vector list = new Vector();
            int listEnd = this.getListElements(s, list);
            if (listEnd < 0) {
                return false;
            }
            Vector vv = new Vector();
            if (!this.parse(s.substring(listEnd + 1), vv)) {
                return false;
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                int n2 = vv.size();
                for (int j = 0; j < n2; ++j) {
                    PatternEntry pe = (PatternEntry)vv.elementAt(j);
                    PatternEntry pe2 = new PatternEntry(pe.type, this.replace('*', pe.pattern, (String)list.elementAt(i)));
                    if (pe.type == 4) {
                        pe.limit = this.getRepeatCount(pe2.pattern);
                    }
                    v.addElement(pe2);
                }
            }
            return true;
        }
        PatternEntry pe = new PatternEntry(type, s);
        if (type == 4) {
            pe.limit = this.getRepeatCount(pe.pattern);
        }
        v.addElement(pe);
        return true;
    }

    protected boolean parse(String pat, Vector v) {
        int len;
        if (v == null || pat == null) {
            return false;
        }
        while ((len = this.getWord(pat)) > 0) {
            String s = pat.substring(0, len);
            pat = pat.substring(len);
            this.storeTag(s, v);
        }
        return len >= 0;
    }

    class PatternEntry {
        public int type;
        public int limit = 1;
        public int count = 0;
        public String pattern;

        public PatternEntry(int typeIn, String patIn) {
            this.type = typeIn;
            this.pattern = patIn;
        }
    }
}

