/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.StyleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.StringCompare;
import java.awt.Color;
import java.util.Properties;

public class Style
implements StyleInterface {
    protected String name;
    protected String displayName;
    protected TextStyleInterface[] textStyle;
    protected Object[] itemValues;
    protected static String[] itemNames = new String[]{"BackgroundImage", "BackgroundImageBlend", "BackgroundImageFit", "ChartBorderLineWidth", "ChartBorderOn", "ChartOpacity", "ColorScheme", "GridLinesOn", "GridLinesWidth", "ShowWall", "WallOpacity", "LegendOpacity"};

    public Style(String resourceName, String styleName) {
        this.name = null;
        this.displayName = null;
        this.textStyle = null;
        this.itemValues = new Object[12];
        if (this.itemValues == null) {
            return;
        }
        this.itemValues[0] = null;
        this.itemValues[1] = new Double(1.0);
        this.itemValues[2] = "Tile";
        this.itemValues[3] = new Integer(1);
        this.itemValues[4] = new Boolean(false);
        this.itemValues[5] = new Double(1.0);
        this.itemValues[6] = null;
        this.itemValues[7] = new Boolean(true);
        this.itemValues[8] = new Integer(1);
        this.itemValues[9] = new Boolean(true);
        this.itemValues[10] = new Double(1.0);
        this.itemValues[11] = new Double(1.0);
        this.init(resourceName, styleName);
        this.textStyle = new TextAttrib[3];
        if (this.textStyle != null) {
            for (int i = 0; i < 3; ++i) {
                this.textStyle[i] = new TextAttrib(null, FontManager.getFont((String)"Serif", (int)12, (int)1));
                if (this.textStyle[i] != null) continue;
            }
        }
    }

    public Style(String styleName) {
        this("Styles.config", styleName);
    }

    public Style(Style someStyle) {
        int i;
        this.name = new String(someStyle.name);
        this.displayName = new String(someStyle.displayName);
        if (someStyle.itemValues != null && (this.itemValues = new Object[someStyle.itemValues.length]) != null) {
            for (i = 0; i < someStyle.itemValues.length; ++i) {
                this.itemValues[i] = i == 6 ? new ColorScheme((ColorScheme)someStyle.itemValues[i]) : someStyle.itemValues[i];
            }
        }
        if (someStyle.textStyle != null && (this.textStyle = new TextAttrib[someStyle.textStyle.length]) != null) {
            for (i = 0; i < someStyle.textStyle.length; ++i) {
                this.textStyle[i] = someStyle.textStyle[i];
            }
        }
    }

    public Style() {
        this("Money");
    }

    protected void init(String resName, String styleName) {
        Double unitValue = new Double(1.0);
        if (resName == null || styleName == null) {
            return;
        }
        this.name = styleName;
        this.displayName = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.util.silk_util_NLS", (String)("Styles." + this.name + ".DisplayName.txt"), (String)this.name);
        if (this.itemValues == null) {
            return;
        }
        Properties props = ResourceLoader.loadProperties((String)resName);
        this.itemValues[5] = Style.clamp(Style.getObjectValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".ChartOpacity"), null), unitValue), 0.0, 1.0, null);
        this.itemValues[9] = new Boolean(Style.getBooleanValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".ShowWall"), null), true));
        this.itemValues[10] = Style.clamp(Style.getObjectValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".WallOpacity"), null), unitValue), 0.0, 1.0, null);
        this.itemValues[4] = new Boolean(Style.getBooleanValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".ChartBorderOn"), null), false));
        this.itemValues[3] = new Integer(Style.getIntegerValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".ChartBorderLineWidth"), null), 1));
        this.itemValues[6] = new ColorScheme(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".ColorScheme"), null));
        this.itemValues[0] = ResourceLoader.getResourceString((Object)props, (String)(this.name + ".BackgroundImage"), null);
        this.itemValues[1] = new Double(Style.clamp(Style.getDoubleValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".BackgroundImageBlend"), null), 1.0), 0.0, 1.0));
        this.itemValues[2] = ResourceLoader.getResourceString((Object)props, (String)(this.name + ".BackgroundImageFit"), (String)"Tile");
        this.itemValues[7] = new Boolean(Style.getBooleanValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".GridLinesOn"), null), true));
        this.itemValues[11] = Style.clamp(Style.getObjectValue(ResourceLoader.getResourceString((Object)props, (String)(this.name + ".LegendOpacity"), null), unitValue), 0.0, 1.0, null);
    }

    @Override
    public boolean setItemValue(int item, Object value) {
        boolean rc = false;
        switch (item) {
            case 4: 
            case 7: 
            case 9: {
                if (!(value instanceof Boolean)) break;
                this.itemValues[item] = value;
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: {
                if (!(value instanceof Number)) break;
                this.itemValues[item] = Style.clamp(value, 0.0, 1.0, null);
                break;
            }
            case 3: 
            case 8: {
                if (!(value instanceof Number)) break;
                this.itemValues[item] = value;
                break;
            }
            case 6: {
                if (value instanceof ColorSchemeInterface) {
                    this.itemValues[item] = value;
                    break;
                }
                if (!(value instanceof String)) break;
                this.itemValues[item] = new ColorScheme((String)value);
                break;
            }
            case 0: 
            case 2: {
                this.itemValues[item] = value.toString();
            }
        }
        return rc;
    }

    protected static boolean getBooleanValue(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("Yes") || s.equalsIgnoreCase("Y") || s.equalsIgnoreCase("On")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("No") || s.equalsIgnoreCase("N") || s.equalsIgnoreCase("Off")) {
            return false;
        }
        return defaultValue;
    }

    protected static int getIntegerValue(String s, int defValue) {
        Integer i = null;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() <= 0) {
            return defValue;
        }
        try {
            i = Integer.valueOf(s);
            if (i == null) {
                return defValue;
            }
        }
        catch (NumberFormatException e) {
            return defValue;
        }
        return i;
    }

    protected static double getDoubleValue(String s, double defValue) {
        Double d = null;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() <= 0) {
            return defValue;
        }
        try {
            d = Double.valueOf(s);
            if (d == null) {
                return defValue;
            }
        }
        catch (NumberFormatException e) {
            return defValue;
        }
        return d;
    }

    protected static Object getObjectValue(String s, Object defValue) {
        double def1;
        double def2;
        int idx = -1;
        Double d1 = null;
        Double d2 = null;
        String left = null;
        String right = null;
        Object out = defValue;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() <= 0 || defValue == null) {
            return out;
        }
        idx = s.indexOf(44);
        if (idx < 0) {
            left = s;
        } else {
            left = s.substring(0, idx);
            right = s.substring(idx + 1);
        }
        if (defValue instanceof Number) {
            def1 = def2 = ((Number)defValue).doubleValue();
        } else if (defValue instanceof double[] && ((double[])defValue).length > 2) {
            def1 = ((double[])defValue)[0];
            def2 = ((double[])defValue)[1];
        } else {
            return out;
        }
        d1 = new Double(Style.getDoubleValue(left, def1));
        if (right != null) {
            d2 = new Double(Style.getDoubleValue(right, def2));
        }
        if (d1 != null && d2 != null) {
            double[] dArray = new double[2];
            out = dArray;
            if (dArray == null) {
                return out;
            }
            ((double[])out)[0] = d1;
            ((double[])out)[1] = d2;
        } else {
            out = d1;
        }
        return out;
    }

    protected static double clamp(double v, double min, double max) {
        if (Double.isNaN(v)) {
            return max;
        }
        if (Double.isInfinite(v)) {
            if (v == Double.NEGATIVE_INFINITY) {
                return min;
            }
            return max;
        }
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    protected static Object clamp(Object v, double min, double max, Object defValue) {
        double[] out = null;
        if (v instanceof Number) {
            return new Double(Style.clamp(((Number)v).doubleValue(), min, max));
        }
        int type = Extract.getSourceType((Object)v);
        if (type <= 0) {
            return defValue;
        }
        if (Extract.getNumberItems((Object)v, (int)type) < 2) {
            return defValue;
        }
        out = new double[2];
        if (out == null) {
            return defValue;
        }
        out[0] = Style.clamp(Extract.getNumeric((Object)v, (int)0, (int)type), min, max);
        out[1] = Style.clamp(Extract.getNumeric((Object)v, (int)1, (int)type), min, max);
        return out;
    }

    public String toString() {
        if (this.displayName == null) {
            if (this.name != null) {
                return this.name;
            }
            return super.toString();
        }
        return this.displayName;
    }

    protected int getItemValue(String name) {
        if (name == null || itemNames == null) {
            return -1;
        }
        int idx = Style.binarylookup(name.replace(' ', '_'), itemNames, -1, true);
        if (idx < 0) {
            return -1;
        }
        return idx;
    }

    protected static int compareString(String val, String vecval) {
        int ret = StringCompare.compareTo((String)val, (String)vecval);
        if (ret < 0) {
            return -1;
        }
        if (ret > 0) {
            return 1;
        }
        return 0;
    }

    protected static int binarylookup(String val, String[] vec, int uselen, boolean ignoreCase) {
        int len = uselen;
        String compareValue = null;
        String vecEntry = null;
        if (len < 0) {
            len = vec.length;
        }
        if (val == null) {
            return -1;
        }
        compareValue = ignoreCase ? val.toUpperCase() : val;
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = ignoreCase ? vec[mi].toUpperCase() : vec[mi];
            ret = Style.compareString(compareValue, vecEntry);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    @Override
    public String getStyleDisplayName() {
        return this.name;
    }

    @Override
    public String getStyleName() {
        return this.name;
    }

    @Override
    public ColorSchemeInterface getColorScheme() {
        return (ColorScheme)this.getItem(6);
    }

    @Override
    public Object[] getItems(boolean copy) {
        int n = 0;
        Object[] out = this.itemValues;
        if (copy) {
            if (this.itemValues == null || (n = this.itemValues.length) <= 0) {
                return null;
            }
            out = new Color[n];
            if (out == null) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                out[i] = this.itemValues[i];
            }
        }
        return out;
    }

    @Override
    public Object getItem(int item) {
        if (this.itemValues == null || item < 0 || item >= this.itemValues.length) {
            return null;
        }
        return this.itemValues[item];
    }

    @Override
    public Object getItemByName(String name) {
        return this.getItem(this.getItemValue(name));
    }

    @Override
    public String getStringItem(int item) {
        Object o = this.getItem(item);
        if (o == null || !(o instanceof String)) {
            return null;
        }
        return (String)o;
    }

    @Override
    public String getStringItemByName(String name) {
        return this.getStringItem(this.getItemValue(name));
    }

    @Override
    public double getNumericItem(int item) {
        Object o = this.getItem(item);
        if (o == null || !(o instanceof Number)) {
            return Double.NaN;
        }
        return ((Number)o).doubleValue();
    }

    @Override
    public double getNumericItemByName(String name) {
        return this.getNumericItem(this.getItemValue(name));
    }

    @Override
    public boolean getBooleanItem(int item, boolean defaultValue) {
        Object o = this.getItem(item);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    @Override
    public boolean getBooleanItemByName(String name, boolean defaultValue) {
        return this.getBooleanItem(this.getItemValue(name), defaultValue);
    }

    @Override
    public TextStyleInterface getTextStyle(int level) {
        if (this.textStyle == null || level < 0 || level >= this.textStyle.length) {
            return null;
        }
        return this.textStyle[level];
    }

    @Override
    public boolean setTextStyle(int level, TextStyleInterface text) {
        if (this.textStyle == null || level < 0 || level >= this.textStyle.length || text == null) {
            return false;
        }
        this.textStyle[level] = text;
        return true;
    }
}

