/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.data.StableHeapSort;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.StringCompare;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SortDecorator
implements TableModel,
TableModelListener {
    private TableModel realModel;
    private int[] indexes;
    public int sortedCol = -1;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NONE = 2;
    public int currentSort = 2;

    public SortDecorator(TableModel model) {
        if (model == null) {
            throw new IllegalArgumentException(ResourceLoader.getResourceString((Object)ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS"), (String)"SortDecorator.Model_must_not_be_null.txt", (String)""));
        }
        this.realModel = model;
        this.realModel.addTableModelListener(this);
        this.allocate();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.realModel.getValueAt(this.indexes[row], col);
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        this.realModel.setValueAt(obj, this.indexes[row], col);
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        this.allocate();
    }

    public void sort(int col) {
        this.sort(col, 0);
    }

    public void sort(int col, int dir) {
        this.sortedCol = col;
        this.currentSort = dir;
        int rowCount = this.getRowCount();
        ArrayList<Object> values = new ArrayList<Object>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.indexes[i] = i;
            values.add(this.getValueAt(i, col));
        }
        int sortOrder = 0;
        switch (this.currentSort) {
            case 0: {
                sortOrder = 1;
                break;
            }
            case 1: {
                sortOrder = -1;
            }
        }
        StableHeapSort.heapSort(values, this.indexes, sortOrder, 0, values.size() - 1);
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public int compare(int i, int j, int col) {
        Object io = this.realModel.getValueAt(i, col);
        Object jo = this.realModel.getValueAt(j, col);
        int c = StringCompare.compareTo((String)jo.toString(), (String)io.toString());
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    private void allocate() {
        this.indexes = new int[this.getRowCount()];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = i;
        }
    }

    @Override
    public int getRowCount() {
        return this.realModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.realModel.getColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.realModel.getColumnName(col);
    }

    public Class getColumnClass(int col) {
        return this.realModel.getColumnClass(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.realModel.isCellEditable(this.indexes[row], col);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.realModel.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.realModel.removeTableModelListener(l);
    }
}

