/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import java.util.Vector;

public class SelectionFilter
implements DataFilterListenerInterface {
    private DataFilterReadInterface filter = null;
    private int filterAction = 2;
    private Vector targetFilters = new Vector();

    public SelectionFilter(DataFilterReadInterface selectionSource, int filterAction) {
        this.filter = selectionSource;
        this.filterAction = filterAction;
        this.filter.addDataFilterListener((Object)this);
    }

    public void addTarget(DataFilterReadInterface filter) {
        if (filter == null || this.targetFilters.contains(filter)) {
            return;
        }
        this.targetFilters.addElement(filter);
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.source != this.filter) {
            return;
        }
        if (evt.type == 2) {
            this.processSelections();
        }
    }

    private void processSelections() {
        int i;
        SelectionIterator si = this.filter.getSelections();
        int[] selections = new int[si.cardinality()];
        for (i = 0; i < selections.length && si.hasMoreSelections(); ++i) {
            selections[i] = si.nextSelectedIndex();
        }
        block6: for (i = 0; i < this.targetFilters.size(); ++i) {
            DataFilterReadInterface tfilter = (DataFilterReadInterface)this.targetFilters.elementAt(i);
            if (tfilter.getSource() != this.filter.getSource()) continue;
            switch (this.filterAction) {
                case 2: {
                    tfilter.setAllGraphed(false);
                    tfilter.setGraphed((Object)selections, true);
                    continue block6;
                }
                case 0: {
                    tfilter.setSubsetList((Object)selections);
                    continue block6;
                }
                case 3: {
                    tfilter.setAllGraphed(true);
                    tfilter.setGraphed((Object)selections, false);
                }
            }
        }
    }
}

