/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import java.net.URL;

public class SILKInfo {
    protected static String[] jars = new String[]{"sas.graph.silk.jar", "sas.graph.silkext.jar", "sas.graph.core.jar", "sas.text.jar", "sas.sg.dataimpl.jar", "sas.sg.datadef.jar", "sas.core.jar", "sas.ads.core.jar", "nld.jar", "j2d.jar"};
    protected static String[] classes = new String[]{"com.sas.graphics.silk.pie.Slice", "com.sas.graphics.silk.dtree.PolyLine", "com.sas.graphics.util.Markers", "com.sas.text.SASNumericFormat", "com.sas.sg.datamodel.impl.SgDataModel", "com.sas.sg.datamodel.DataModelEvent", "com.sas.MissingValues", "com.sas.table.TableException", "com.sas.graphics.util.nld.NLDBase", "com.sas.graphics.util.j2d.Point3"};

    public static Package GetJARBuildDate(String jar) {
        int i;
        Class<?> classObj = null;
        int n = Math.min(jars.length, classes.length);
        if (jar == null) {
            i = 0;
        } else {
            for (i = 0; i < n && !jar.equalsIgnoreCase(jars[i]); ++i) {
            }
        }
        if (i >= n) {
            return null;
        }
        try {
            classObj = Class.forName(classes[i]);
            if (classObj == null) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return classObj.getPackage();
    }

    public static void printSILKInfo(Package p, String jarfileName) {
        if (p == null) {
            return;
        }
        System.out.println(SILKInfo.getSILKInfo(p, jarfileName));
        System.out.flush();
    }

    public static String getSILKInfo(Package p, String jarfileName) {
        return p.getImplementationTitle() + " - " + jarfileName + "\nVersion:    " + p.getSpecificationVersion() + "\nBuild Date: " + p.getImplementationVersion() + "\n--------------------------------------------\n";
    }

    public static void printSILKAllInfo() {
        System.out.println(SILKInfo.getSILKAllInfo());
        System.out.flush();
    }

    public static String getSILKAllInfo() {
        String rc = "";
        int n = Math.min(jars.length, classes.length);
        for (int i = 0; i < n; ++i) {
            Package p = SILKInfo.GetJARBuildDate(jars[i]);
            if (p == null) continue;
            rc = rc + SILKInfo.getSILKInfo(p, jars[i]);
        }
        return rc;
    }

    protected static String getClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        String s = fullClassName.trim();
        if (s.endsWith(".class")) {
            s = s.substring(0, s.length() - 6);
        }
        s = s.replace('\\', '/');
        s = s.replace('.', '/');
        return s;
    }

    public static URL findClass(Object fullClassName) {
        String s = null;
        Class<?> classObj = null;
        if (fullClassName == null) {
            return null;
        }
        if (!(fullClassName instanceof String)) {
            classObj = fullClassName.getClass();
            if (classObj == null) {
                return null;
            }
            s = SILKInfo.getClassName(classObj.getName());
        } else {
            s = SILKInfo.getClassName((String)fullClassName);
        }
        if (s == null) {
            return null;
        }
        if (!(s = s + ".class").startsWith("/")) {
            s = "/" + s;
        }
        return SILKInfo.class.getResource(s);
    }
}

