/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.util.Properties;

public class SILKDefaults {
    protected Properties props = null;

    public SILKDefaults(String configFileIn) {
        String configFile = configFileIn == null ? "SILK.config" : configFileIn;
        this.props = ResourceLoader.loadProperties((String)configFile);
    }

    public SILKDefaults() {
        this(null);
    }

    public String getResourceString(String keyName, String defaultValue) {
        if (this.props == null) {
            return defaultValue;
        }
        String s = this.props.getProperty(keyName);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    protected boolean getResourceBoolean(String keyName, boolean defaultValue) {
        boolean out = defaultValue;
        String s = this.getResourceString(keyName, null);
        if (s != null) {
            if ((s = s.trim().toUpperCase()).equals("TRUE") || s.equals("T") || s.equals("ON") || s.equals("YES") || s.equals("Y")) {
                out = true;
            } else if (s.equals("FALSE") || s.equals("F") || s.equals("OFF") || s.equals("NO") || s.equals("N")) {
                out = false;
            }
        }
        return out;
    }

    protected Color getResourceColor(String keyName, Color defaultValue) {
        Color out = defaultValue;
        String s = this.getResourceString(keyName, null);
        if (s != null) {
            if ((s = s.trim()).equalsIgnoreCase("NONE")) {
                return null;
            }
            out = ColorParse.getColorFromString((String)s);
            if (out == null) {
                return defaultValue;
            }
        }
        return out;
    }

    protected static int getIntegerValue(String s, int defaultValue) {
        Integer i = null;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() <= 0) {
            return defaultValue;
        }
        try {
            i = Integer.valueOf(s);
            if (i == null) {
                return defaultValue;
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        return i;
    }

    protected double getNumericValue(String s, double defaultValue) {
        Double d = null;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() <= 0) {
            return defaultValue;
        }
        try {
            d = Double.valueOf(s);
            if (d == null) {
                return defaultValue;
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        return d;
    }

    protected int getResourceInteger(String keyName, int defaultValue) {
        String s = this.getResourceString(keyName, null);
        if (s == null) {
            return defaultValue;
        }
        return SILKDefaults.getIntegerValue(s, defaultValue);
    }

    protected double getResourceDouble(String keyName, double defaultValue) {
        String s = this.getResourceString(keyName, null);
        if (s == null) {
            return defaultValue;
        }
        return this.getNumericValue(s, defaultValue);
    }
}

