/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SortedVector;
import com.sas.graphics.util.SortKeyInterface;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class Roles {
    protected ResourceBundle rb;
    protected SILKNumber descendingOrder;
    protected SILKNumber dataOrder;
    protected SILKNumber ascendingOrder;
    protected SortedVector roles;
    protected Vector listeners = new Vector();
    private static Hashtable instances = new Hashtable();

    public static Roles getInstance(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!instances.containsKey(locale)) {
            instances.put(locale, new Roles(locale));
        }
        return (Roles)instances.get(locale);
    }

    public Roles() {
        this(Locale.getDefault());
    }

    public Roles(Locale locale) {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS", (Locale)locale);
        this.descendingOrder = new SILKNumber(-1, ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.DescendingOrder.txt", (String)"Descending"), "Descending");
        this.dataOrder = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.DataOrder.txt", (String)"Data"), "Data");
        this.ascendingOrder = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.AscendingOrder.txt", (String)"Ascending"), "Ascending");
        this.roles = new SortedVector();
        this.roles.setSortingOn(false);
        String s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Category.txt", (String)"Category");
        this.roles.addElement(new RoleEntry("ROLE_CATEGORY", new SILKNumber(1, s, "Category")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Color.txt", (String)"Color");
        this.roles.addElement(new RoleEntry("ROLE_COLOR", new SILKNumber(2, s, "Color")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Color_Index.txt", (String)"Color Index");
        this.roles.addElement(new RoleEntry("ROLE_COLOR_INDEX", new SILKNumber(3, s, "Color Index")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Error_Low.txt", (String)"Error Low");
        this.roles.addElement(new RoleEntry("ROLE_ERROR_LOW", new SILKNumber(4, s, "Error Low")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Error_High.txt", (String)"Error High");
        this.roles.addElement(new RoleEntry("ROLE_ERROR_HIGH", new SILKNumber(5, s, "Error High")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Group.txt", (String)"Group");
        this.roles.addElement(new RoleEntry("ROLE_GROUP", new SILKNumber(6, s, "Group")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Group_Index.txt", (String)"Group Index");
        this.roles.addElement(new RoleEntry("ROLE_GROUP_INDEX", new SILKNumber(7, s, "Group Index")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Label.txt", (String)"Label");
        this.roles.addElement(new RoleEntry("ROLE_LABEL", new SILKNumber(8, s, "Label")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_ID.txt", (String)"Map ID");
        this.roles.addElement(new RoleEntry("ROLE_MAP_ID", new SILKNumber(9, s, "Map ID")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_Response_ID.txt", (String)"Map Response ID");
        this.roles.addElement(new RoleEntry("ROLE_MAP_RESPONSE_ID", new SILKNumber(10, s, "Map Response ID")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_Color.txt", (String)"Map Color");
        this.roles.addElement(new RoleEntry("ROLE_MAP_COLOR", new SILKNumber(2, s, "Map Color")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_Color_Index.txt", (String)"Map Color Index");
        this.roles.addElement(new RoleEntry("ROLE_MAP_COLOR_INDEX", new SILKNumber(3, s, "Map Color Index")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_Label.txt", (String)"Map Label");
        this.roles.addElement(new RoleEntry("ROLE_MAP_LABEL", new SILKNumber(8, s, "Map Label")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Opacity.txt", (String)"Opacity");
        this.roles.addElement(new RoleEntry("ROLE_OPACITY", new SILKNumber(11, s, "Opacity")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_Opacity.txt", (String)"Map Opacity");
        this.roles.addElement(new RoleEntry("ROLE_MAP_OPACITY", new SILKNumber(11, s, "Map Opacity")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_Level.txt", (String)"Map Level");
        this.roles.addElement(new RoleEntry("ROLE_MAP_LEVEL", new SILKNumber(12, s, "Map Level")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Marker_X.txt", (String)"Marker X");
        this.roles.addElement(new RoleEntry("ROLE_MARKER_X", new SILKNumber(13, s, "Marker X")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Marker_Y.txt", (String)"Marker Y");
        this.roles.addElement(new RoleEntry("ROLE_MARKER_Y", new SILKNumber(14, s, "Marker Y")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Marker_Color.txt", (String)"Marker Color");
        this.roles.addElement(new RoleEntry("ROLE_MARKER_COLOR", new SILKNumber(15, s, "Marker Color")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Marker_Color_Index.txt", (String)"Marker Color Index");
        this.roles.addElement(new RoleEntry("ROLE_MARKER_COLOR_INDEX", new SILKNumber(40, s, "Marker Color Index")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Marker_Level.txt", (String)"Marker Level");
        this.roles.addElement(new RoleEntry("ROLE_MARKER_LEVEL", new SILKNumber(16, s, "Marker Level")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Response.txt", (String)"Response");
        this.roles.addElement(new RoleEntry("ROLE_RESPONSE", new SILKNumber(17, s, "Response")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Shape.txt", (String)"Shape");
        this.roles.addElement(new RoleEntry("ROLE_SHAPE", new SILKNumber(18, s, "Shape")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Size.txt", (String)"Size");
        this.roles.addElement(new RoleEntry("ROLE_SIZE", new SILKNumber(19, s, "Size")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Marker_Size.txt", (String)"Marker Size");
        this.roles.addElement(new RoleEntry("ROLE_MARKER_SIZE", new SILKNumber(19, s, "Marker Size")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Spatial.txt", (String)"Spatial");
        this.roles.addElement(new RoleEntry("ROLE_SPATIAL", new SILKNumber(20, s, "Spatial")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Subgroup.txt", (String)"Subgroup");
        this.roles.addElement(new RoleEntry("ROLE_SUBGROUP", new SILKNumber(21, s, "Subgroup")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Tip.txt", (String)"Tip");
        this.roles.addElement(new RoleEntry("ROLE_TIP", new SILKNumber(22, s, "Tip")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Watermark.txt", (String)"Watermark");
        this.roles.addElement(new RoleEntry("ROLE_WATERMARK", new SILKNumber(23, s, "Watermark")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.X.txt", (String)"X");
        this.roles.addElement(new RoleEntry("ROLE_X", new SILKNumber(24, s, "X")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Y.txt", (String)"Y");
        this.roles.addElement(new RoleEntry("ROLE_Y", new SILKNumber(25, s, "Y")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.ID.txt", (String)"ID");
        this.roles.addElement(new RoleEntry("ROLE_ID", new SILKNumber(26, s, "ID")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Parent.txt", (String)"Parent");
        this.roles.addElement(new RoleEntry("ROLE_PARENT", new SILKNumber(27, s, "Parent")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Text.txt", (String)"Node Text");
        this.roles.addElement(new RoleEntry("ROLE_NODE_TEXT", new SILKNumber(28, s, "Node Text")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Size.txt", (String)"Node Size");
        this.roles.addElement(new RoleEntry("ROLE_NODE_SIZE", new SILKNumber(19, s, "Node Size")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Color.txt", (String)"Node Color");
        this.roles.addElement(new RoleEntry("ROLE_NODE_COLOR", new SILKNumber(2, s, "Node Color")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_Width.txt", (String)"Link Width");
        this.roles.addElement(new RoleEntry("ROLE_LINK_WIDTH", new SILKNumber(29, s, "Link Width")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Above_Text.txt", (String)"Above Text");
        this.roles.addElement(new RoleEntry("ROLE_ABOVE_TEXT", new SILKNumber(30, s, "Above Text")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Below_Text.txt", (String)"Below Text");
        this.roles.addElement(new RoleEntry("ROLE_BELOW_TEXT", new SILKNumber(31, s, "Below Text")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Surrogate.txt", (String)"Surrogate");
        this.roles.addElement(new RoleEntry("ROLE_SURROGATE", new SILKNumber(32, s, "Surrogate")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Tool_Tip.txt", (String)"Tool Tip");
        this.roles.addElement(new RoleEntry("ROLE_TOOLTIP_TEXT", new SILKNumber(22, s, "Tool Tip")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Graph_Variable.txt", (String)"Graph Variable");
        this.roles.addElement(new RoleEntry("ROLE_GRAPH_VAR", new SILKNumber(33, s, "Graph Variable")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Graph_ID.txt", (String)"Graph ID");
        this.roles.addElement(new RoleEntry("ROLE_GRAPH_ID", new SILKNumber(34, s, "Graph ID")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Statistic.txt", (String)"Statistic");
        this.roles.addElement(new RoleEntry("ROLE_STATISTIC", new SILKNumber(35, s, "Statistic")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Lattice_X.txt", (String)"Lattice-X");
        this.roles.addElement(new RoleEntry("ROLE_LATTICE_X", new SILKNumber(36, s, "Lattice-X")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Lattice_Y.txt", (String)"Lattice-Y");
        this.roles.addElement(new RoleEntry("ROLE_LATTICE_Y", new SILKNumber(37, s, "Lattice-Y")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.StatisticType.txt", (String)"StatisticType");
        this.roles.addElement(new RoleEntry("ROLE_STATISTIC_TYPE", new SILKNumber(38, s, "StatisticType")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.MatrixVar.txt", (String)"MatrixVar");
        this.roles.addElement(new RoleEntry("ROLE_MATRIX_VAR", new SILKNumber(39, s, "MatrixVar")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.URL.txt", (String)"URL");
        this.roles.addElement(new RoleEntry("ROLE_URL", new SILKNumber(41, s, "URL")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Marker_URL.txt", (String)"Marker URL");
        this.roles.addElement(new RoleEntry("ROLE_MARKER_URL", new SILKNumber(42, s, "Marker URL")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_ID.txt", (String)"Node ID");
        this.roles.addElement(new RoleEntry("ROLE_NODE_ID", new SILKNumber(26, s, "Node ID")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Value.txt", (String)"Node Value");
        this.roles.addElement(new RoleEntry("ROLE_NODE_VALUE", new SILKNumber(43, s, "Node Value")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Label.txt", (String)"Node Label");
        this.roles.addElement(new RoleEntry("ROLE_NODE_LABEL", new SILKNumber(28, s, "Node Label")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Tip.txt", (String)"Node Tip");
        this.roles.addElement(new RoleEntry("ROLE_NODE_TIP", new SILKNumber(22, s, "Node Tip")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_URL.txt", (String)"Node URL");
        this.roles.addElement(new RoleEntry("ROLE_NODE_URL", new SILKNumber(41, s, "Node URL")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_X.txt", (String)"Node X");
        this.roles.addElement(new RoleEntry("ROLE_NODE_X", new SILKNumber(24, s, "Node X")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Y.txt", (String)"Node Y");
        this.roles.addElement(new RoleEntry("ROLE_NODE_Y", new SILKNumber(25, s, "Node Y")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_ID.txt", (String)"Link ID");
        this.roles.addElement(new RoleEntry("ROLE_LINK_ID", new SILKNumber(44, s, "Link ID")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_From.txt", (String)"Link From");
        this.roles.addElement(new RoleEntry("ROLE_LINK_FROM", new SILKNumber(45, s, "Link From")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_To.txt", (String)"Link To");
        this.roles.addElement(new RoleEntry("ROLE_LINK_TO", new SILKNumber(46, s, "Link To")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_Value.txt", (String)"Link Value");
        this.roles.addElement(new RoleEntry("ROLE_LINK_VALUE", new SILKNumber(47, s, "Link Value")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_Color.txt", (String)"Link Color");
        this.roles.addElement(new RoleEntry("ROLE_LINK_COLOR", new SILKNumber(48, s, "Link Color")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_Label.txt", (String)"Link Label");
        this.roles.addElement(new RoleEntry("ROLE_LINK_LABEL", new SILKNumber(49, s, "Link Label")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_Tip.txt", (String)"Link Tip");
        this.roles.addElement(new RoleEntry("ROLE_LINK_TIP", new SILKNumber(50, s, "Link Tip")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Z.txt", (String)"Z");
        this.roles.addElement(new RoleEntry("ROLE_Z", new SILKNumber(51, s, "Z")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Z.txt", (String)"Node Z");
        this.roles.addElement(new RoleEntry("ROLE_NODE_Z", new SILKNumber(51, s, "Node Z")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Shape.txt", (String)"Node Shape");
        this.roles.addElement(new RoleEntry("ROLE_NODE_SHAPE", new SILKNumber(18, s, "Node Shape")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Transparency.txt", (String)"Transparency");
        this.roles.addElement(new RoleEntry("ROLE_TRANSPARENCY", new SILKNumber(52, s, "Transparency")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Map_Transparency.txt", (String)"Map Transparency");
        this.roles.addElement(new RoleEntry("ROLE_MAP_TRANSPARENCY", new SILKNumber(52, s, "Map Transparency")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Axis.txt", (String)"Axis");
        this.roles.addElement(new RoleEntry("ROLE_AXIS", new SILKNumber(53, s, "Axis")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Band.txt", (String)"Band");
        this.roles.addElement(new RoleEntry("ROLE_BAND", new SILKNumber(54, s, "Band")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.UpperBand.txt", (String)"Upper Band");
        this.roles.addElement(new RoleEntry("ROLE_UPPER_BAND", new SILKNumber(56, s, "Upper Band")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.LowerBand.txt", (String)"Lower Band");
        this.roles.addElement(new RoleEntry("ROLE_LOWER_BAND", new SILKNumber(57, s, "Lower Band")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Series.txt", (String)"Series");
        this.roles.addElement(new RoleEntry("ROLE_SERIES", new SILKNumber(58, s, "Series")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Segment.txt", (String)"Segment");
        this.roles.addElement(new RoleEntry("ROLE_SEGMENT", new SILKNumber(59, s, "Segment")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Image.txt", (String)"Node Image");
        this.roles.addElement(new RoleEntry("ROLE_NODE_IMAGE", new SILKNumber(63, s, "Node Image")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Icon.txt", (String)"Node Icon");
        this.roles.addElement(new RoleEntry("ROLE_NODE_ICON", new SILKNumber(64, s, "Node Icon")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Name.txt", (String)"Name");
        this.roles.addElement(new RoleEntry("ROLE_NAME", new SILKNumber(65, s, "Name")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Height.txt", (String)"Height");
        this.roles.addElement(new RoleEntry("ROLE_HEIGHT", new SILKNumber(66, s, "Height")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Width.txt", (String)"Width");
        this.roles.addElement(new RoleEntry("ROLE_WIDTH", new SILKNumber(67, s, "Width")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Color_Index.txt", (String)"Node Color Index");
        this.roles.addElement(new RoleEntry("ROLE_NODE_COLOR_INDEX", new SILKNumber(68, s, "Node Color Index")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Has_Children.txt", (String)"Node Has Children");
        this.roles.addElement(new RoleEntry("ROLE_NODE_HAS_CHILDREN", new SILKNumber(69, s, "Node Has Children")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Frequency.txt", (String)"Frequency");
        this.roles.addElement(new RoleEntry("ROLE_FREQUENCY", new SILKNumber(70, s, "Frequency")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Vector_X_From.txt", (String)"Vector X From");
        this.roles.addElement(new RoleEntry("ROLE_VECTOR_X_FROM", new SILKNumber(71, s, "Vector X From")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Vector_X_To.txt", (String)"Vector X To");
        this.roles.addElement(new RoleEntry("ROLE_VECTOR_X_TO", new SILKNumber(24, s, "Vector X To")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Vector_Y_From.txt", (String)"Vector Y From");
        this.roles.addElement(new RoleEntry("ROLE_VECTOR_Y_FROM", new SILKNumber(72, s, "Vector Y From")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Vector_Y_To.txt", (String)"Vector Y To");
        this.roles.addElement(new RoleEntry("ROLE_VECTOR_Y_TO", new SILKNumber(25, s, "Vector Y To")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Parent_ID.txt", (String)"Node Parent ID");
        this.roles.addElement(new RoleEntry("ROLE_NODE_PARENT_ID", new SILKNumber(27, s, "Node Parent ID")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Node_Group.txt", (String)"Node Group");
        this.roles.addElement(new RoleEntry("ROLE_NODE_GROUP", new SILKNumber(6, s, "Node Group")));
        s = ResourceLoader.getResourceString((Object)this.rb, (String)"Roles.Link_Group.txt", (String)"Link Group");
        this.roles.addElement(new RoleEntry("ROLE_LINK_GROUP", new SILKNumber(73, s, "Link Group")));
        this.roles.setSortingOn(true);
        this.rb = null;
    }

    public SILKNumber getRoleObject(String key) {
        int idx = -1;
        if (this.roles == null) {
            return null;
        }
        idx = this.roles.indexOf(key);
        if (idx < 0) {
            return null;
        }
        boolean sorted = this.roles.isRetrieveInSortedOrder();
        this.roles.setRetrieveInSortedOrder(false);
        RoleEntry entry = (RoleEntry)this.roles.elementAt(idx);
        this.roles.setRetrieveInSortedOrder(sorted);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public SILKNumber getRoleObjectForUSName(String usName) {
        if (usName == null || this.roles == null) {
            return null;
        }
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleEntry re = (RoleEntry)this.roles.elementAt(i);
            if (!usName.equalsIgnoreCase(re.value.getEnglishName())) continue;
            return re.value;
        }
        return null;
    }

    public String getRoleUSName(String key) {
        int idx = -1;
        if (this.roles == null) {
            return null;
        }
        idx = this.roles.indexOf(key);
        if (idx < 0) {
            return null;
        }
        boolean sorted = this.roles.isRetrieveInSortedOrder();
        this.roles.setRetrieveInSortedOrder(false);
        RoleEntry entry = (RoleEntry)this.roles.elementAt(idx);
        this.roles.setRetrieveInSortedOrder(sorted);
        if (entry == null) {
            return null;
        }
        return entry.value.getEnglishName();
    }

    public String getRoleNLSName(String key) {
        SILKNumber num = this.getRoleObject(key);
        if (num == null) {
            return null;
        }
        return num.toString();
    }

    public boolean equalsRoleNLSName(String key, String nameIn) {
        SILKNumber num = this.getRoleObject(key);
        if (num == null || nameIn == null) {
            return false;
        }
        return nameIn.equalsIgnoreCase(num.toString());
    }

    public SILKNumber getSortObject(String key) {
        if (key == null) {
            return null;
        }
        if (key.equalsIgnoreCase("ROLE_SORT_DESCENDING")) {
            return this.descendingOrder;
        }
        if (key.equalsIgnoreCase("ROLE_SORT_DATA")) {
            return this.dataOrder;
        }
        if (key.equalsIgnoreCase("ROLE_SORT_ASCENDING")) {
            return this.ascendingOrder;
        }
        return null;
    }

    public String getSortNLSName(String key) {
        SILKNumber num = this.getSortObject(key);
        if (num == null) {
            return null;
        }
        return num.toString();
    }

    public boolean equalsSortNLSName(String key, String nameIn) {
        SILKNumber num = this.getSortObject(key);
        if (num == null || nameIn == null) {
            return false;
        }
        return nameIn.equalsIgnoreCase(num.toString());
    }

    public void addRoleListener(RoleListenerInterface listener) {
        if (this.listeners == null || this.listeners.contains(listener) || listener == null) {
            return;
        }
        this.listeners.addElement(listener);
    }

    public void removeRoleListener(RoleListenerInterface listener) {
        if (this.listeners == null || !this.listeners.contains(listener) || listener == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public void throwRoleEvent(RoleEvent e) {
        int n = 0;
        if (this.listeners == null || (n = this.listeners.size()) <= 0) {
            return;
        }
        Object[] outList = new Object[n];
        if (outList == null) {
            return;
        }
        this.listeners.copyInto(outList);
        for (int i = 0; i < n; ++i) {
            if (outList[i] == null) continue;
            ((RoleListenerInterface)outList[i]).roleChanged(e);
        }
    }

    class RoleEntry
    implements SortKeyInterface {
        public String key;
        public SILKNumber value;

        public RoleEntry(String key, SILKNumber value) {
            this.key = key;
            this.value = value;
        }

        public int getKeyType() {
            return 1;
        }

        public Object getKeyValue() {
            return this.key;
        }

        public double getNumericKeyValue() {
            return Double.NaN;
        }
    }
}

