/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.util.MultipleBoundedRangeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeModel
implements ChangeListener,
PropertyChangeListener {
    private MultipleBoundedRangeModel _model;
    private PropertyChangeSupport _changes = new PropertyChangeSupport(this);
    private Object _minimum;
    private Object _maximum;
    private ArrayList _range = new ArrayList(5);
    private Object _visibleMinimum = null;
    private Object _visibleMaximum = null;
    private Object _precision = null;
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";
    public static final String ADD_RANGE = "addRange";
    public static final String REMOVE_RANGE = "removeRange";
    public static final String LOW_VALUE = "lowValue";
    public static final String LOW_INCLUSIVE = "lowInclusive";
    public static final String HIGH_VALUE = "highValue";
    public static final String HIGH_INCLUSIVE = "highInclusive";
    public static final String LOW_STYLE = "lowStyle";
    public static final String HIGH_STYLE = "highStyle";
    public static final String TEXT_STYLE = "textStyle";
    public static final String FILL_COLOR = "fillColor";
    public static final String MULTIPLE_VALUES = "multipleValues";
    public static final String PRECISION = "precision";
    protected boolean _isSpanning = false;
    private boolean _changeEventFromMBRM = false;
    private boolean _ignoreChangeEvent = false;
    private boolean _ignorePropertyChangeEvent = false;
    private double _multiplier = 1.0;
    private static final int SCALE_THRESHOLD = 100000;
    private double _decimals = 2.0;
    private boolean _minimumSet = false;
    private boolean _maximumSet = false;
    private boolean _confirmRanges = true;
    private boolean prevValueIsAdjusting = false;
    private PropertyChangeEvent lastPropertyEvent = null;

    public RangeModel() {
        this(new MultipleBoundedRangeModel());
    }

    public RangeModel(MultipleBoundedRangeModel m) {
        this._minimum = new Double(0.0);
        this._maximum = new Double(1000.0);
        this._visibleMinimum = new Double(0.0);
        this._visibleMaximum = new Double(1000.0);
        this._model = m != null ? m : new MultipleBoundedRangeModel();
        this._model.addChangeListener((ChangeListener)this);
    }

    public MultipleBoundedRangeModel getModel() {
        return this._model;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._changes.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ReferenceRange rr = null;
        if (this._changeEventFromMBRM) {
            this.lastPropertyEvent = evt;
        }
        if (!this._ignorePropertyChangeEvent) {
            String propName = evt.getPropertyName();
            Object oVal = evt.getOldValue();
            Object nVal = evt.getNewValue();
            int index = -1;
            this._ignoreChangeEvent = true;
            if (oVal instanceof Object[] && nVal instanceof Object[]) {
                Object[] objs = (Object[])oVal;
                Object o1 = objs[0];
                Object[] objs2 = (Object[])nVal;
                Object o3 = objs2[0];
                if (o1 instanceof ReferenceRange && o3 instanceof ReferenceRange && o1.equals(o3)) {
                    rr = (ReferenceRange)o1;
                    index = this.getRangeIndex(rr);
                }
            }
            if (index >= 0 && index < this.ranges() && rr != null) {
                if (propName.equalsIgnoreCase(LOW_VALUE)) {
                    int lowVal1 = this._model.getValue(index);
                    int lowVal2 = this.getInt(rr.getLowValue());
                    int newExt = this._model.getExtent(index) + (lowVal1 - lowVal2);
                    this._model.setRange(index, lowVal2, rr.getLowInclusive(), newExt, rr.getHighInclusive());
                } else if (propName.equalsIgnoreCase(LOW_INCLUSIVE)) {
                    this._model.setValueInclusive(index, rr.getLowInclusive());
                } else if (propName.equalsIgnoreCase(HIGH_VALUE)) {
                    this._model.setExtent(index, this.getInt(rr.getHighValue()) - this._model.getValue(index));
                } else if (propName.equalsIgnoreCase(HIGH_INCLUSIVE)) {
                    this._model.setExtentInclusive(index, rr.getHighInclusive());
                } else if (propName.equalsIgnoreCase(MULTIPLE_VALUES)) {
                    int lowVal = this.getInt(rr.getLowValue());
                    int extent = this.getInt(rr.getHighValue()) - lowVal;
                    this._model.setRange(index, lowVal, rr.getLowInclusive(), extent, rr.getHighInclusive());
                }
            }
            this._ignoreChangeEvent = false;
        }
        boolean rangeValid = true;
        if (rr != null) {
            rangeValid = this.confirmRangeValue(rr, this.getRangeIndex(rr));
        }
        if (rangeValid) {
            this._changes.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        block15: {
            block13: {
                block14: {
                    if (this._ignoreChangeEvent) {
                        return;
                    }
                    this._changeEventFromMBRM = true;
                    if (this._model.ranges() == this.ranges()) break block13;
                    if (this._model.ranges() <= this.ranges()) break block14;
                    int index = this._model.ranges() - 1;
                    int value = this._model.getValue(index);
                    int extent = this._model.getExtent(index);
                    this.add(this.getObject(value), this._model.getValueInclusive(index), this.getObject(value + extent), this._model.getExtentInclusive(index));
                    break block15;
                }
                boolean found = false;
                for (int i = 0; i < this._model.ranges(); ++i) {
                    int iVal;
                    ReferenceRange rr = (ReferenceRange)this._range.get(i);
                    int dVal = this.getInt(rr.getLowValue());
                    if (dVal == (iVal = this._model.getValue(i))) continue;
                    this.remove(i);
                    found = true;
                    break;
                }
                if (found) break block15;
                this.remove(this._model.ranges());
                break block15;
            }
            if (this.getInt(this._minimum) != this._model.getMinimum()) {
                this.setMinimum(this.getObject(this._model.getMinimum()));
            } else if (this.getInt(this._maximum) != this._model.getMaximum()) {
                this.setMaximum(this.getObject(this._model.getMaximum()));
            } else {
                for (int i = 0; i < this.ranges(); ++i) {
                    ReferenceRange rr = (ReferenceRange)this._range.get(i);
                    int dLow = this.getInt(rr.getLowValue());
                    int dHigh = this.getInt(rr.getHighValue());
                    int iLow = this._model.getValue(i);
                    int iHigh = iLow + this._model.getExtent(i);
                    this._ignorePropertyChangeEvent = true;
                    if (dLow != iLow && ((Number)rr.getLowValue()).doubleValue() != Double.NEGATIVE_INFINITY) {
                        rr.setLowValue(this.getObject(iLow));
                    }
                    if (dHigh != iHigh && ((Number)rr.getHighValue()).doubleValue() != Double.POSITIVE_INFINITY) {
                        rr.setHighValue(this.getObject(iHigh));
                    }
                    if (rr.getLowInclusive() != this._model.getValueInclusive(i)) {
                        rr.setLowInclusive(this._model.getValueInclusive(i));
                    }
                    if (rr.getHighInclusive() != this._model.getExtentInclusive(i)) {
                        rr.setHighInclusive(this._model.getExtentInclusive(i));
                    }
                    this._ignorePropertyChangeEvent = false;
                }
            }
        }
        if (this.prevValueIsAdjusting && !this._model.getValueIsAdjusting() && this.lastPropertyEvent != null) {
            this.prevValueIsAdjusting = this._model.getValueIsAdjusting();
            this._changes.firePropertyChange(this.lastPropertyEvent.getPropertyName(), this.lastPropertyEvent.getOldValue(), this.lastPropertyEvent.getNewValue());
            this.lastPropertyEvent = null;
        } else {
            this.prevValueIsAdjusting = this._model.getValueIsAdjusting();
        }
        this._changeEventFromMBRM = false;
    }

    public boolean isAdjusting() {
        return this._model.getValueIsAdjusting();
    }

    public void setAdjusting(boolean b) {
        this._ignoreChangeEvent = true;
        this._model.setValueIsAdjusting(b);
        this._ignoreChangeEvent = false;
    }

    public ReferenceRange getRangeAt(int i) {
        ReferenceRange r = null;
        if (0 <= i && i < this.ranges()) {
            r = (ReferenceRange)this._range.get(i);
        }
        return r;
    }

    private int getRangeIndex(ReferenceRange r) {
        return this._range.indexOf(r);
    }

    public Object getMinimum() {
        return this._minimum;
    }

    public void setMinimum(Object minimum) {
        if (!this._minimumSet || !this._minimum.equals(minimum)) {
            Object old = this._minimum;
            this._minimum = minimum;
            this._minimumSet = true;
            this._ignoreChangeEvent = true;
            int[] minmax = this.computeScaledMinMax();
            if (minmax != null) {
                this.setModelMinMax(minmax[0], minmax[1]);
                this._confirmRanges = false;
                if (this._precision != null) {
                    this.setPrecision(this._precision);
                }
                this._confirmRanges = true;
            }
            this.updateMappedValues();
            this._ignoreChangeEvent = false;
            this._changes.firePropertyChange(MINIMUM, old, this._minimum);
        }
    }

    public Object getMaximum() {
        return this._maximum;
    }

    public void setMaximum(Object maximum) {
        if (!this._maximumSet || !this._maximum.equals(maximum)) {
            Object old = this._maximum;
            this._maximum = maximum;
            this._maximumSet = true;
            this._ignoreChangeEvent = true;
            int[] minmax = this.computeScaledMinMax();
            if (minmax != null) {
                this.setModelMinMax(minmax[0], minmax[1]);
                this._confirmRanges = false;
                if (this._precision != null) {
                    this.setPrecision(this._precision);
                }
                this._confirmRanges = true;
            }
            this.updateMappedValues();
            this._ignoreChangeEvent = false;
            this._changes.firePropertyChange(MAXIMUM, old, this._maximum);
        }
    }

    private int[] computeScaledMinMax() {
        double newMax;
        double newMin;
        double max;
        if (!(this._minimum instanceof Number) || !(this._maximum instanceof Number)) {
            return null;
        }
        double min = ((Number)this._minimum).doubleValue();
        if (min > (max = ((Number)this._maximum).doubleValue())) {
            return null;
        }
        int[] minmax = new int[2];
        double precision = this._precision != null ? ((Number)this._precision).doubleValue() : 0.0;
        int scaleIncrease = (int)Math.pow(10.0, this._decimals);
        if (max - min > 100000.0) {
            double minMultiplier = 1.0;
            double maxMultiplier = 1.0;
            double prec = precision;
            min /= 10.0;
            prec /= 10.0;
            while (min != 0.0 && min - (double)((int)min) == 0.0 && prec - (double)((int)prec) == 0.0) {
                minMultiplier /= 10.0;
                min /= 10.0;
                prec /= 10.0;
            }
            min *= 10.0;
            prec = precision;
            max /= 10.0;
            prec /= 10.0;
            while (max != 0.0 && max - (double)((int)max) == 0.0 && prec - (double)((int)prec) == 0.0) {
                maxMultiplier /= 10.0;
                max /= 10.0;
                prec /= 10.0;
            }
            max *= 10.0;
            if (minMultiplier == maxMultiplier) {
                newMin = min;
                newMax = max;
                this._multiplier = minMultiplier;
            } else if (minMultiplier < maxMultiplier) {
                newMin = min;
                newMax = max * (minMultiplier / maxMultiplier);
                this._multiplier = minMultiplier;
            } else {
                newMin = min * (maxMultiplier / minMultiplier);
                newMax = max;
                this._multiplier = maxMultiplier;
            }
            if ((double)scaleIncrease * newMin < -2.147483648E9 || (double)scaleIncrease * newMax > 2.147483647E9) {
                scaleIncrease = 1;
            }
        } else {
            long minMultiplier = 1L;
            long maxMultiplier = 1L;
            double multiplierLimit = 2.147483647E9 / Math.max(1.0, max - min) / (double)(100 * scaleIncrease);
            while (min - (double)((int)min) > 0.0 && (double)minMultiplier < multiplierLimit) {
                minMultiplier *= 10L;
                min *= 10.0;
            }
            while (max - (double)((int)max) > 0.0 && (double)maxMultiplier < multiplierLimit) {
                maxMultiplier *= 10L;
                max *= 10.0;
            }
            if (minMultiplier == maxMultiplier) {
                newMin = min;
                newMax = max;
                this._multiplier = (int)minMultiplier;
            } else if (minMultiplier > maxMultiplier) {
                newMin = min;
                newMax = max * (double)(minMultiplier / maxMultiplier);
                this._multiplier = (int)minMultiplier;
            } else {
                newMin = min * (double)(maxMultiplier / minMultiplier);
                newMax = max;
                this._multiplier = (int)maxMultiplier;
            }
        }
        newMax *= (double)scaleIncrease;
        this._multiplier *= (double)scaleIncrease;
        if ((newMin *= (double)scaleIncrease) < -2.147483648E9 || newMax > 2.147483647E9) {
            return null;
        }
        minmax[0] = (int)newMin;
        minmax[1] = (int)newMax;
        return minmax;
    }

    public Object getVisibleMinimum() {
        return this._visibleMinimum;
    }

    public void setVisibleMinimum(Object visibleMinimum) {
        this._visibleMinimum = visibleMinimum;
        int visMin = this.getInt(this._visibleMinimum);
        if (visMin == this._model.getVisibleMinimum()) {
            return;
        }
        this._ignoreChangeEvent = true;
        this._model.setVisibleMinimum(visMin);
        this._ignoreChangeEvent = false;
        if (this._precision != null) {
            for (int i = 0; i < this.ranges(); ++i) {
                ReferenceRange range = this.getRangeAt(i);
                this.confirmRangeValue(range, i);
            }
        }
    }

    public Object getVisibleMaximum() {
        return this._visibleMaximum;
    }

    public void setVisibleMaximum(Object visibleMaximum) {
        this._visibleMaximum = visibleMaximum;
        int visMax = this.getInt(this._visibleMaximum);
        if (visMax == this._model.getVisibleMaximum()) {
            return;
        }
        this._ignoreChangeEvent = true;
        this._model.setVisibleMaximum(visMax);
        this._ignoreChangeEvent = false;
        if (this._precision != null) {
            for (int i = 0; i < this.ranges(); ++i) {
                ReferenceRange range = this.getRangeAt(i);
                this.confirmRangeValue(range, i);
            }
        }
    }

    private void updateMappedValues() {
        int i;
        if (this.getInt(this._maximum) <= this.getInt(this._minimum)) {
            return;
        }
        for (i = 0; i < this.ranges(); ++i) {
            this._model.remove(0);
        }
        for (i = 0; i < this.ranges(); ++i) {
            ReferenceRange range = this.getRangeAt(i);
            this.addToMultipleBoundedRangeModel(range);
        }
    }

    public ReferenceRange add(Object lowValue, boolean lowInclusive, Object highValue, boolean highInclusive) {
        if (lowValue == null || highValue == null) {
            return null;
        }
        ReferenceRange rr = new ReferenceRange(lowValue, lowInclusive, highValue, highInclusive);
        return this.add(rr);
    }

    public ReferenceRange add(Object refValue) {
        if (refValue == null && !(refValue instanceof Number)) {
            return null;
        }
        double val = ((Number)refValue).doubleValue() - 1.0;
        ReferenceRange rr = new ReferenceRange(refValue, true, new Double(val), false);
        return this.add(rr);
    }

    public ReferenceRange add(ReferenceRange r) {
        if (r == null || !(r instanceof ReferenceRange)) {
            return null;
        }
        ReferenceRange rr = r;
        if (this._range.indexOf(rr) >= 0) {
            return rr;
        }
        rr.addPropertyChangeListener(this);
        this._range.add(rr);
        if (!this._changeEventFromMBRM) {
            this.addToMultipleBoundedRangeModel(rr);
        }
        Object[] oldObject = new Object[]{null, new Integer(this.ranges() - 1)};
        Object[] newObject = new Object[]{rr, new Integer(this._model.ranges())};
        this._changes.firePropertyChange(ADD_RANGE, oldObject, newObject);
        return rr;
    }

    public void removeAll() {
        if (this.ranges() == 0) {
            return;
        }
        for (int i = this.ranges() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean remove(ReferenceRange r) {
        return this.remove(this.getRangeIndex(r));
    }

    private boolean remove(int index) {
        if (index < 0 || index >= this.ranges()) {
            return false;
        }
        ReferenceRange rr = (ReferenceRange)this._range.get(index);
        rr.removePropertyChangeListener(this);
        this._range.remove(index);
        if (!this._changeEventFromMBRM) {
            this._ignoreChangeEvent = true;
            this._model.remove(index);
            this._ignoreChangeEvent = false;
        }
        Object[] oldObject = new Object[]{rr, new Integer(this.ranges() + 1)};
        Object[] newObject = new Object[]{null, new Integer(this._model.ranges())};
        this._changes.firePropertyChange(REMOVE_RANGE, oldObject, newObject);
        return true;
    }

    private void addToMultipleBoundedRangeModel(ReferenceRange range) {
        if (range == null) {
            return;
        }
        Object low = range.getLowValue();
        Object high = range.getHighValue();
        if (low instanceof Number && high instanceof Number) {
            int lowVal = this.getInt(low);
            int extent = this.getInt(high) - lowVal;
            this._ignoreChangeEvent = true;
            this._model.add(lowVal, range.getLowInclusive(), extent, range.getHighInclusive());
            this._ignoreChangeEvent = false;
            this.confirmRangeValue(range, this._model.ranges() - 1);
        }
    }

    private boolean confirmRangeValue(ReferenceRange range, int index) {
        if (this._minimumSet && this._maximumSet) {
            int startVal = this._model.getValue(index);
            int endVal = startVal + this._model.getExtent(index);
            Object l = this.getObject(startVal);
            Object h = this.getObject(endVal);
            double iLow = ((Number)l).doubleValue();
            double iHigh = ((Number)h).doubleValue();
            double dLow = ((Number)range.getLowValue()).doubleValue();
            double dHigh = ((Number)range.getHighValue()).doubleValue();
            if (!this.areEqual(dLow, iLow) && (dLow != Double.NEGATIVE_INFINITY || this.isBounded()) && this.isPrecise(iLow, this._precision)) {
                this._ignorePropertyChangeEvent = true;
                range.setLowValue(l);
                this._ignorePropertyChangeEvent = false;
            }
            if (!this.areEqual(dHigh, iHigh) && (dHigh != Double.POSITIVE_INFINITY || this.isBounded()) && this.isPrecise(iHigh, this._precision)) {
                this._ignorePropertyChangeEvent = true;
                range.setHighValue(h);
                this._ignorePropertyChangeEvent = false;
                return false;
            }
        }
        return true;
    }

    private boolean areEqual(double d1, double d2) {
        if (this._minimum instanceof Number && this._maximum instanceof Number) {
            double min = ((Number)this._minimum).doubleValue();
            double max = ((Number)this._maximum).doubleValue();
            double err = (max - min) * 1.0E-4;
            return Math.abs(d2 - d1) < err;
        }
        return d1 == d2;
    }

    private int getInt(Object value) {
        int val = 0;
        if (this._minimum instanceof Double) {
            int imin = this._model.getMinimum();
            int imax = this._model.getMaximum();
            double dmin = ((Number)this._minimum).doubleValue();
            double dmax = ((Number)this._maximum).doubleValue();
            double dval = ((Number)value).doubleValue();
            if (dval == Double.POSITIVE_INFINITY) {
                return 0x3FFFFFFF;
            }
            if (dval == Double.NEGATIVE_INFINITY) {
                return -1073741824;
            }
            if (dmax > dmin) {
                val = imin + (int)Math.round((double)(imax - imin) * ((dval - dmin) / (dmax - dmin)));
            }
        }
        return val;
    }

    private Object getObject(int value) {
        double dvalue = 0.0;
        if (this._minimum instanceof Double) {
            int imin = this._model.getMinimum();
            int imax = this._model.getMaximum();
            double dmin = (Double)this._minimum;
            double dmax = (Double)this._maximum;
            if (imax > imin) {
                dvalue = dmin + (dmax - dmin) * (1.0 * (double)(value - imin) / (double)(imax - imin));
            }
            if (this._precision != null) {
                dvalue = this.roundToPrecision(dvalue);
            }
        }
        return new Double(dvalue);
    }

    public int ranges() {
        return this._range.size();
    }

    public void setBounded(boolean bounded) {
        this._model.setBounded(bounded);
    }

    public boolean isBounded() {
        return this._model.isBounded();
    }

    public void setOverlap(boolean overlap) {
        this._model.setOverlap(overlap);
    }

    public boolean isOverlap() {
        return this._model.isOverlap();
    }

    public boolean setPrecision(Object precision) {
        if (this.verifyPrecision(precision)) {
            Object old = null;
            this._precision = precision;
            this._changes.firePropertyChange(PRECISION, old, this._precision);
            if (this._confirmRanges) {
                for (int i = 0; i < this.ranges(); ++i) {
                    ReferenceRange range = this.getRangeAt(i);
                    this.confirmRangeValue(range, i);
                }
            }
            this._model.setSpacing(this.getMappedPrecision());
            return true;
        }
        return false;
    }

    public Object getPrecision() {
        return this._precision;
    }

    public int getMappedPrecision() {
        int minorTick = -1;
        if (this._precision != null) {
            double prec = ((Number)this._precision).doubleValue();
            double diffRes = (((Number)this._maximum).doubleValue() - ((Number)this._minimum).doubleValue()) / prec;
            if ((int)diffRes != 0) {
                minorTick = (int)((double)(this._model.getMaximum() - this._model.getMinimum()) / diffRes);
            }
            if (minorTick == 0) {
                minorTick = -1;
            }
        }
        return minorTick;
    }

    private boolean verifyPrecision(Object precision) {
        if (!this._minimumSet || !this._maximumSet) {
            return true;
        }
        if (this._minimum instanceof Number && this._maximum instanceof Number && precision instanceof Number) {
            double prec;
            double min = ((Number)this._minimum).doubleValue();
            double max = ((Number)this._maximum).doubleValue();
            double diff = max - min;
            if (diff < (prec = ((Number)precision).doubleValue())) {
                return false;
            }
            return this.isPrecise(min, precision) && this.isPrecise(max, precision) && this.isPrecise(diff, precision);
        }
        return false;
    }

    private boolean isPrecise(double d, Object precision) {
        if (precision == null) {
            return true;
        }
        double res = Math.abs(d / ((Number)precision).doubleValue());
        double roundedRes = this.roundToPrecision(res);
        return !(res - (double)((int)res) > 0.0);
    }

    private double roundToPrecision(double dvalue) {
        double m = dvalue * this._multiplier;
        double round = Math.round(m);
        dvalue = round / this._multiplier;
        return dvalue;
    }

    private void setModelMinMax(int min, int max) {
        boolean bounded = this.isBounded();
        boolean overlap = this.isOverlap();
        this.setBounded(false);
        this.setOverlap(false);
        this._model.setMinimum(min);
        this._model.setMaximum(max);
        this.setOverlap(overlap);
        this.setBounded(bounded);
    }

    public double getMultiplier() {
        return this._multiplier;
    }
}

