/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.data.StableHeapSort;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class RangeMerger
implements RangeChangeListener,
ViewportListenerInterface {
    public static final int X = 1;
    public static final int Y = 2;
    public static final int Z = 3;
    public static final int COLOR = 4;
    public static final int ALL = -1;
    private int type;
    private ArrayList rangeItems;
    private ArrayList viewportItems;
    private boolean updatingRanges = false;
    private boolean enableMerging = true;
    private boolean trackViewportEvents = false;
    private boolean blockViewportEvents = false;
    private DataRange range = null;
    private EventListenerList propertyListeners = null;
    public static final String RANGE_MERGED = "RangeMerged";
    private DataRange colorRange = null;

    public RangeMerger() {
        this(-1);
    }

    public RangeMerger(int type) {
        this.setType(type);
        this.rangeItems = new ArrayList(5);
        this.viewportItems = new ArrayList(5);
    }

    public void setType(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.type = type;
                break;
            }
        }
    }

    public boolean addRangeItem(CellItemInterface c) {
        if (c == null) {
            return false;
        }
        if (!this.rangeItems.contains(c)) {
            this.rangeItems.add(c);
            this.updateRanges(this.type);
            if (c instanceof RangeChangeInterface) {
                ((RangeChangeInterface)c).addRangeChangeListener((RangeChangeListener)this);
            }
        }
        if (c instanceof GraphInterface && c instanceof ViewportInterface) {
            ((GraphInterface)c).addViewportListener(this);
            this.viewportItems.add(c);
        }
        return true;
    }

    public boolean removeRangeItem(CellItemInterface c) {
        if (c == null) {
            return false;
        }
        this.rangeItems.remove(c);
        if (c instanceof RangeChangeInterface) {
            ((RangeChangeInterface)c).removeRangeChangeListener((RangeChangeListener)this);
        }
        this.updateRanges(this.type);
        if (c instanceof GraphInterface && c instanceof ViewportInterface) {
            ((GraphInterface)c).removeViewportListener(this);
            this.viewportItems.remove(c);
        }
        return true;
    }

    public boolean addRangeItems(Collection c) {
        if (c == null) {
            return false;
        }
        Iterator it = c.iterator();
        if (it == null) {
            return false;
        }
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof CellItemInterface) {
                this.rangeItems.add(o);
                if (o instanceof RangeChangeInterface) {
                    ((RangeChangeInterface)o).addRangeChangeListener((RangeChangeListener)this);
                }
            }
            if (!(o instanceof GraphInterface) || !(o instanceof ViewportInterface)) continue;
            this.viewportItems.add(o);
            ((GraphInterface)o).addViewportListener(this);
        }
        this.updateRanges(this.type);
        return true;
    }

    public void removeAllRangeItems() {
        Object o;
        int i;
        if (this.rangeItems != null) {
            for (i = 0; i < this.rangeItems.size(); ++i) {
                o = this.rangeItems.get(i);
                if (!(o instanceof RangeChangeInterface)) continue;
                ((RangeChangeInterface)o).removeRangeChangeListener((RangeChangeListener)this);
            }
            this.rangeItems.removeAll(this.rangeItems);
        }
        if (this.viewportItems != null) {
            for (i = 0; i < this.viewportItems.size(); ++i) {
                o = this.viewportItems.get(i);
                if (!(o instanceof GraphInterface)) continue;
                ((GraphInterface)o).removeViewportListener(this);
            }
            this.viewportItems.removeAll(this.rangeItems);
        }
    }

    private void updateRanges(int type) {
        if (this.updatingRanges) {
            return;
        }
        this.updatingRanges = true;
        switch (type) {
            case -1: {
                this.mergeRanges((byte)1);
                this.mergeRanges((byte)2);
                this.mergeRanges((byte)3);
                this.mergeRanges((byte)4);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mergeRanges((byte)type);
            }
        }
        this.updatingRanges = false;
    }

    private void mergeRanges(byte dim) {
        CellItemInterface item;
        int i;
        DataRange range = null;
        for (i = 0; i < this.rangeItems.size(); ++i) {
            item = (CellItemInterface)this.rangeItems.get(i);
            DataRangeInterface dri = item.getRangeSource(dim, 0);
            if (dri == null) continue;
            DataRange itemRange = dri.getDataRange(dim);
            range = RangeMerger.mergeRange(range, itemRange);
        }
        this.range = range;
        if (dim == 4) {
            if (this.colorRange != null && this.colorRange.equals(range)) {
                return;
            }
            this.colorRange = range;
        }
        if (range != null) {
            for (i = 0; i < this.rangeItems.size(); ++i) {
                item = (CellItemInterface)this.rangeItems.get(i);
                if (item instanceof RangeChangeInterface) {
                    ((RangeChangeInterface)item).removeRangeChangeListener((RangeChangeListener)this);
                }
                item.setRange(dim, 0, range);
                if (!(item instanceof RangeChangeInterface)) continue;
                ((RangeChangeInterface)item).addRangeChangeListener((RangeChangeListener)this);
            }
        }
        this.firePropertyChange(RANGE_MERGED);
    }

    public static DataRange mergeRange(DataRange range1, DataRange range2) {
        OrdinalRange mergedRange = null;
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        if (range1 instanceof OrdinalRange && range2 instanceof OrdinalRange) {
            OrdinalRange or = new OrdinalRange((OrdinalRange)range1);
            or.union(range2);
            mergedRange = or;
        } else if (range1 instanceof DiscreteRange && range2 instanceof DiscreteRange) {
            DiscreteRange dr1 = (DiscreteRange)range1;
            DiscreteRange dr2 = (DiscreteRange)range2;
            if (dr1.getSort() != dr2.getSort()) {
                return null;
            }
            mergedRange = new DiscreteRange(range1);
            mergedRange.union(range2);
            int sortOrder = dr1.getSort();
            int heapSortOrder = 0;
            switch (sortOrder) {
                case -3: 
                case -2: 
                case 0: {
                    return mergedRange;
                }
                case 1: {
                    heapSortOrder = 1;
                    break;
                }
                case -1: {
                    heapSortOrder = -1;
                }
            }
            Vector list = ((DiscreteRange)mergedRange).getValues();
            int[] sortedIndices = new int[list.size()];
            for (int i = list.size() - 1; i >= 0; --i) {
                sortedIndices[i] = i;
            }
            StableHeapSort.heapSort(list, sortedIndices, heapSortOrder, 0, list.size() - 1);
            Object[] sortedList = new Object[list.size()];
            for (int i = list.size() - 1; i >= 0; --i) {
                sortedList[i] = list.get(sortedIndices[i]);
            }
            mergedRange = new DiscreteRange(sortedList);
            ((DiscreteRange)mergedRange).setSort(sortOrder);
        } else if (range1 instanceof ContinuousRange && range2 instanceof ContinuousRange) {
            ContinuousRange r1 = (ContinuousRange)range1;
            ContinuousRange r2 = (ContinuousRange)range2;
            double min = Double.NaN;
            min = Double.isNaN(r1.getMin()) ? r2.getMin() : (Double.isNaN(r2.getMin()) ? r1.getMin() : Math.min(r1.getMin(), r2.getMin()));
            double max = Double.NaN;
            max = Double.isNaN(r1.getMax()) ? r2.getMax() : (Double.isNaN(r2.getMax()) ? r1.getMax() : Math.max(r1.getMax(), r2.getMax()));
            mergedRange = new ContinuousRange(min, max);
        }
        return mergedRange;
    }

    public void rangeChanged(RangeChangedEvent e) {
        Object o = e.getSource();
        if (!this.enableMerging) {
            return;
        }
        if (this.rangeItems.contains(o)) {
            this.updateRanges(this.type);
        }
    }

    public void setMergingEnabled(boolean enable) {
        boolean e = this.enableMerging;
        this.enableMerging = enable;
        if (this.enableMerging && e != this.enableMerging) {
            this.updateRanges(this.type);
        }
    }

    public void trackViewportEvents(boolean trackEvents) {
        this.trackViewportEvents = trackEvents;
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (!this.trackViewportEvents) {
            return;
        }
        if (this.blockViewportEvents) {
            return;
        }
        this.blockViewportEvents = true;
        if (evt.type == 0) {
            for (int i = 0; i < this.viewportItems.size(); ++i) {
                if (evt.source.equals(this.viewportItems.get(i))) continue;
                ((ViewportInterface)this.viewportItems.get(i)).resetViewport();
            }
        } else {
            double xmin = Double.NaN;
            double xmax = Double.NaN;
            double ymin = Double.NaN;
            double ymax = Double.NaN;
            double zmin = Double.NaN;
            double zmax = Double.NaN;
            switch (this.type) {
                case -1: {
                    xmin = evt.xMin;
                    xmax = evt.xMax;
                    ymin = evt.yMin;
                    ymax = evt.yMax;
                    zmin = evt.zMin;
                    zmax = evt.zMax;
                    break;
                }
                case 1: {
                    xmin = evt.xMin;
                    xmax = evt.xMax;
                    break;
                }
                case 2: {
                    ymin = evt.yMin;
                    ymax = evt.yMax;
                    break;
                }
                case 3: {
                    zmin = evt.zMin;
                    zmax = evt.zMax;
                }
            }
            for (int i = 0; i < this.viewportItems.size(); ++i) {
                if (evt.source.equals(this.viewportItems.get(i))) continue;
                ((ViewportInterface)this.viewportItems.get(i)).setViewport(evt.type, xmin, xmax, ymin, ymax, zmin, zmax);
            }
        }
        this.blockViewportEvents = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new EventListenerList();
        }
        this.propertyListeners.add(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(PropertyChangeListener.class, listener);
        }
    }

    private void firePropertyChange(String change) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, change, null, this.range);
        EventListener[] arr = this.propertyListeners.getListeners(PropertyChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            ((PropertyChangeListener)arr[i]).propertyChange(evt);
        }
    }
}

