/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.CompositeChartPrintInterface;
import com.sas.graphics.silk.interfaces.PrintPreviewInterface;
import com.sas.graphics.silk.util.CompositePrintDialog;
import com.sas.graphics.silk.util.DefaultPageable;
import com.sas.graphics.silk.util.SILKGlobal;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.SwingUtilities;

public class Print {
    private static CompositePrintDialog compositeDialog = null;

    private static void printPrintable(Printable printable, boolean showPageDialog) {
        if (printable == null) {
            return;
        }
        if (printable instanceof Pageable) {
            Print.printPageable((Pageable)((Object)printable), showPageDialog);
        } else {
            Print.printPageable(new DefaultPageable(printable), showPageDialog);
        }
    }

    private static void printPageable(Pageable pageable, boolean showPageDialog) {
        if (pageable == null) {
            return;
        }
        boolean proceed = true;
        if (pageable instanceof CompositeChartPrintInterface) {
            proceed = Print.showCompositeDialog((CompositeChartPrintInterface)((Object)pageable));
        }
        if (!proceed) {
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(pageable);
        if (pageable instanceof PrintPreviewInterface && Print.compositeDialog.isPreviewMode) {
            final Pageable p = pageable;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PageFormat pf = p.getPageFormat(0);
                    if (pf == null) {
                        pf = (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
                    }
                    ((PrintPreviewInterface)((Object)p)).printPreview(pf, true);
                }
            });
        } else if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    private static boolean showCompositeDialog(CompositeChartPrintInterface composite) {
        if (compositeDialog == null) {
            compositeDialog = new CompositePrintDialog();
        }
        compositeDialog.showDialog(composite);
        return !compositeDialog.isCancelled();
    }

    public static void print(Object printObj, boolean showPageDialog) {
        if (printObj instanceof Pageable) {
            Print.printPageable((Pageable)printObj, showPageDialog);
        } else if (printObj instanceof Printable) {
            Print.printPrintable((Printable)printObj, showPageDialog);
        }
    }

    private static void printPrintable(Printable printable) {
        if (printable instanceof Pageable) {
            Print.printPageable((Pageable)((Object)printable));
        } else {
            Print.print(printable, true);
        }
    }

    private static void printPageable(Pageable pageable) {
        Print.print(pageable, true);
    }

    public static void print(Object printObj) {
        if (printObj instanceof Pageable) {
            Print.printPageable((Pageable)printObj);
        } else if (printObj instanceof Printable) {
            Print.printPrintable((Printable)printObj);
        }
    }
}

