/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.EventListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MenuUtilities {
    public static JPopupMenu getPopupMenu(InputStream xml, ActionListener listener) {
        if (xml == null) {
            return null;
        }
        JPopupMenu rc = new JPopupMenu();
        MenuUtilities.parse(xml, (Object)rc, listener);
        return rc;
    }

    public static JPopupMenu getPopupMenu(Element e, ActionListener listener) {
        if (e == null) {
            return null;
        }
        JPopupMenu rc = new JPopupMenu();
        MenuUtilities.parse(e, (Object)rc, listener);
        return rc;
    }

    public static JMenu getMenu(InputStream xml, ActionListener listener) {
        if (xml == null) {
            return null;
        }
        JMenu rc = new JMenu();
        MenuUtilities.parse(xml, (Object)rc, listener);
        return rc;
    }

    public static JMenu getMenu(Element e, ActionListener listener) {
        if (e == null) {
            return null;
        }
        JMenu rc = new JMenu();
        MenuUtilities.parse(e, (Object)rc, listener);
        return rc;
    }

    private static void parse(InputStream xml, Object menu, ActionListener listener) {
        if (xml == null || menu == null) {
            return;
        }
        Element e = SILKParser.getElement(xml);
        if (e.getTagName().equalsIgnoreCase("Menu")) {
            MenuUtilities.parseMenu(e, menu, listener, null);
        }
    }

    private static void parse(Element e, Object menu, ActionListener listener) {
        if (e == null || menu == null) {
            return;
        }
        if (e.getTagName().equalsIgnoreCase("Menu")) {
            MenuUtilities.parseMenu(e, menu, listener, null);
        }
    }

    private static void parseMenu(Element menuElement, Object menu, ActionListener listener, ButtonGroup group) {
        Image i;
        ResourceBundle rb = ResourceLoader.loadBundle((String)menuElement.getAttribute("resourceBundle"));
        String icon = menuElement.getAttribute("icon");
        if (icon != null && icon.length() > 0 && (i = ResourceLoader.getImage((Component)((Component)menu), (String)icon)) != null && menu instanceof JMenu) {
            ((JMenu)menu).setIcon(new ImageIcon(i));
        }
        NodeList list = menuElement.getChildNodes();
        int num = list.getLength();
        for (int i2 = 0; i2 < num; ++i2) {
            Element ce;
            Node child = list.item(i2);
            if (child.getNodeType() != 1 || (ce = (Element)child).hasAttribute("debug") && ParserUtils.getBooleanValue((String)ce.getAttribute("debug")) && !SILKGlobal.isDebug() || ce.hasAttribute("test") && ParserUtils.getBooleanValue((String)ce.getAttribute("test")) && !SILKGlobal.isTestMode()) continue;
            if (ce.getTagName().equalsIgnoreCase("MenuItem") || ce.getTagName().equalsIgnoreCase("RadioMenuItem") || ce.getTagName().equalsIgnoreCase("CheckBoxMenuItem")) {
                JMenuItem item = MenuUtilities.parseMenuItem((Element)child, rb, ce.getTagName());
                if (listener != null) {
                    item.addActionListener(listener);
                }
                if (menu instanceof JMenu) {
                    ((JMenu)menu).add(item);
                } else if (menu instanceof JPopupMenu) {
                    ((JPopupMenu)menu).add(item);
                }
                if (group == null) continue;
                group.add(item);
                continue;
            }
            if (ce.getTagName().equalsIgnoreCase("Seperator")) {
                if (menu instanceof JMenu) {
                    ((JMenu)menu).addSeparator();
                    continue;
                }
                if (!(menu instanceof JPopupMenu)) continue;
                ((JPopupMenu)menu).addSeparator();
                continue;
            }
            if (ce.getTagName().equalsIgnoreCase("Menu")) {
                JMenu submenu = new JMenu(ResourceLoader.getResourceString((Object)rb, (String)ce.getAttribute("DisplayNameKey"), (String)""));
                Object field = MenuUtilities.getField(ce.getAttribute("id"));
                if (field != null) {
                    submenu.setActionCommand(field.toString());
                }
                MenuUtilities.parseMenu((Element)child, submenu, listener, null);
                if (menu instanceof JMenu) {
                    ((JMenu)menu).add(submenu);
                    continue;
                }
                if (!(menu instanceof JPopupMenu)) continue;
                ((JPopupMenu)menu).add(submenu);
                continue;
            }
            if (!ce.getTagName().equalsIgnoreCase("MenuGroup")) continue;
            MenuUtilities.parseMenu(ce, menu, listener, new ButtonGroup());
        }
        if (menuElement.hasAttribute("DisplayNameKey")) {
            String menuTitle = ResourceLoader.getResourceString((Object)rb, (String)menuElement.getAttribute("DisplayNameKey"), (String)"");
            if (menu instanceof JMenu) {
                ((JMenu)menu).setText(menuTitle);
            }
        }
    }

    private static JMenuItem parseMenuItem(Element node, ResourceBundle rb, String type) {
        Object field;
        Image i;
        if (node == null) {
            return null;
        }
        JMenuItem rc = null;
        if (type == null || type.equalsIgnoreCase("MenuItem")) {
            rc = new JMenuItem(ResourceLoader.getResourceString((Object)rb, (String)node.getAttribute("DisplayNameKey"), (String)""));
        } else if (type.equalsIgnoreCase("RadioMenuItem")) {
            rc = new JRadioButtonMenuItem(ResourceLoader.getResourceString((Object)rb, (String)node.getAttribute("DisplayNameKey"), (String)""));
            if (node.hasAttribute("selected") && ParserUtils.getBooleanValue((String)node.getAttribute("selected"))) {
                ((JRadioButtonMenuItem)rc).setSelected(true);
            }
        } else if (type.equalsIgnoreCase("CheckBoxMenuItem")) {
            rc = new JCheckBoxMenuItem(ResourceLoader.getResourceString((Object)rb, (String)node.getAttribute("DisplayNameKey"), (String)""));
            if (node.hasAttribute("selected") && ParserUtils.getBooleanValue((String)node.getAttribute("selected"))) {
                ((JCheckBoxMenuItem)rc).setSelected(true);
            }
        } else {
            return null;
        }
        String icon = node.getAttribute("icon");
        if (icon != null && icon.length() > 0 && (i = ResourceLoader.getImage((Component)rc, (String)icon)) != null) {
            rc.setIcon(new ImageIcon(i));
        }
        if ((field = MenuUtilities.getField(node.getAttribute("id"))) != null) {
            rc.setActionCommand(field.toString());
        }
        return rc;
    }

    private static Object getField(String name) {
        int first = name.indexOf(46);
        int last = name.lastIndexOf(46);
        if (first < 0 || last < 0) {
            return null;
        }
        String fieldName = name.substring(last + 1);
        String interfaceName = name.substring(0, last);
        if (first == last) {
            interfaceName = "com.sas.graphics.silk.interfaces." + interfaceName;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(interfaceName);
        }
        catch (ClassNotFoundException e) {
            return name;
        }
        if (cls == null) {
            return name;
        }
        Field field = null;
        try {
            field = cls.getField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
        if (field == null) {
            return null;
        }
        Object rc = null;
        try {
            rc = field.get(null);
        }
        catch (Exception e) {
            return null;
        }
        return rc;
    }

    public static void setFontOnMenu(Component c, Font f) {
        int i;
        Component[] arr;
        if (f == null) {
            return;
        }
        c.setFont(f);
        if (c instanceof JMenu) {
            arr = ((JMenu)c).getMenuComponents();
            for (i = 0; i < arr.length; ++i) {
                MenuUtilities.setFontOnMenu(arr[i], f);
            }
        }
        if (c instanceof JPopupMenu) {
            arr = ((JPopupMenu)c).getComponents();
            for (i = 0; i < arr.length; ++i) {
                MenuUtilities.setFontOnMenu(arr[i], f);
            }
        }
    }

    public static JMenuItem getMenuItem(JMenu menu, String actionCommand) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getItemCount();
            for (int i = 0; i < count; ++i) {
                Component c;
                JMenuItem jmi = menu.getItem(i);
                if (!(jmi != null ? actionCommand.equalsIgnoreCase(jmi.getActionCommand()) : (c = menu.getMenuComponent(i)) instanceof JMenu && (jmi = MenuUtilities.getMenuItem((JMenu)c, actionCommand)) != null)) continue;
                return jmi;
            }
        }
        return null;
    }

    public static JMenuItem getMenuItem(JPopupMenu menu, String actionCommand) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getComponentCount();
            for (int i = 0; i < count; ++i) {
                JMenuItem jmi;
                Component c = menu.getComponent(i);
                if (!(c instanceof JMenu ? (jmi = MenuUtilities.getMenuItem((JMenu)c, actionCommand)) != null : c instanceof JMenuItem && actionCommand.equalsIgnoreCase((jmi = (JMenuItem)c).getActionCommand()))) continue;
                return jmi;
            }
        }
        return null;
    }

    public static JMenu getSubMenu(JPopupMenu menu, String actionCommand) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = menu.getComponent(i);
                if (!(c instanceof JMenu)) continue;
                JMenu jm = (JMenu)c;
                if (actionCommand.equalsIgnoreCase(jm.getActionCommand())) {
                    return jm;
                }
                JMenu jmi = MenuUtilities.getSubMenu((JMenu)c, actionCommand);
                if (jmi == null) continue;
                return jmi;
            }
        }
        return null;
    }

    public static JMenu getSubMenu(JMenu menu, String actionCommand) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getItemCount();
            for (int i = 0; i < count; ++i) {
                Component c = menu.getMenuComponent(i);
                if (!(c instanceof JMenu)) continue;
                JMenu jm = (JMenu)c;
                if (actionCommand.equalsIgnoreCase(jm.getActionCommand())) {
                    return jm;
                }
                jm = MenuUtilities.getSubMenu((JMenu)c, actionCommand);
                if (jm == null) continue;
                return jm;
            }
        }
        return null;
    }

    public static boolean setMenuItemSelected(JMenu menu, String actionCommand, boolean selected) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getItemCount();
            for (int i = 0; i < count; ++i) {
                JMenuItem jmi = menu.getItem(i);
                if (jmi != null) {
                    int l;
                    if (!actionCommand.equalsIgnoreCase(jmi.getActionCommand())) continue;
                    EventListener[] al = jmi.getListeners(ActionListener.class);
                    if (al != null) {
                        for (l = 0; l < al.length; ++l) {
                            jmi.removeActionListener((ActionListener)al[l]);
                        }
                    }
                    jmi.setSelected(selected);
                    if (al != null) {
                        for (l = 0; l < al.length; ++l) {
                            jmi.addActionListener((ActionListener)al[l]);
                        }
                    }
                    return true;
                }
                Component c = menu.getMenuComponent(i);
                if (!(c instanceof JMenu) || !MenuUtilities.setMenuItemSelected((JMenu)c, actionCommand, selected)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean setMenuItemSelected(JPopupMenu menu, String actionCommand, boolean selected) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getComponentCount();
            for (int i = 0; i < count; ++i) {
                int l;
                JMenuItem jmi;
                Component c = menu.getComponent(i);
                if (c instanceof JMenu) {
                    if (!MenuUtilities.setMenuItemSelected((JMenu)c, actionCommand, selected)) continue;
                    return true;
                }
                if (!(c instanceof JMenuItem) || !actionCommand.equalsIgnoreCase((jmi = (JMenuItem)c).getActionCommand())) continue;
                EventListener[] al = jmi.getListeners(ActionListener.class);
                if (al != null) {
                    for (l = 0; l < al.length; ++l) {
                        jmi.removeActionListener((ActionListener)al[l]);
                    }
                }
                jmi.setSelected(selected);
                if (al != null) {
                    for (l = 0; l < al.length; ++l) {
                        jmi.addActionListener((ActionListener)al[l]);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean removeMenuItem(JMenu menu, String actionCommand) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getItemCount();
            for (int i = 0; i < count; ++i) {
                JMenuItem jmi;
                JMenuItem c = menu.getItem(i);
                if (c instanceof JMenu) {
                    JMenu cMenu = (JMenu)c;
                    if (actionCommand.equalsIgnoreCase(cMenu.getActionCommand())) {
                        menu.remove(cMenu);
                        return true;
                    }
                    if (!MenuUtilities.removeMenuItem(cMenu, actionCommand)) continue;
                    return true;
                }
                if (!(c instanceof JMenuItem) || !actionCommand.equalsIgnoreCase((jmi = c).getActionCommand())) continue;
                menu.remove(jmi);
                return true;
            }
        }
        return false;
    }

    public static boolean removeMenuItem(JPopupMenu menu, String actionCommand) {
        if (menu != null && actionCommand != null && actionCommand.trim().length() != 0) {
            int count = menu.getComponentCount();
            for (int i = 0; i < count; ++i) {
                JMenuItem jmi;
                Component c = menu.getComponent(i);
                if (c instanceof JMenu) {
                    JMenu cMenu = (JMenu)c;
                    if (actionCommand.equalsIgnoreCase(cMenu.getActionCommand())) {
                        menu.remove(cMenu);
                        return true;
                    }
                    if (!MenuUtilities.removeMenuItem(cMenu, actionCommand)) continue;
                    return true;
                }
                if (!(c instanceof JMenuItem) || !actionCommand.equalsIgnoreCase((jmi = (JMenuItem)c).getActionCommand())) continue;
                menu.remove(jmi);
                return true;
            }
        }
        return false;
    }

    public static void trim(JMenu menu) {
        if (menu != null) {
            int i;
            int count = menu.getComponentCount();
            Component lastComponent = null;
            Vector<Component> remove = new Vector<Component>();
            for (i = 0; i < count; ++i) {
                Component c = menu.getComponent(i);
                if (c instanceof JMenu) {
                    MenuUtilities.trim((JMenu)c);
                } else if (c instanceof JSeparator && (lastComponent instanceof JSeparator || i == count - 1)) {
                    remove.add(c);
                }
                lastComponent = c;
            }
            for (i = 0; i < remove.size(); ++i) {
                menu.remove((Component)remove.elementAt(i));
            }
        }
    }

    public static void trim(JPopupMenu menu) {
        if (menu != null) {
            int i;
            int count = menu.getComponentCount();
            Component lastComponent = null;
            Vector<Component> remove = new Vector<Component>();
            for (i = 0; i < count; ++i) {
                Component c = menu.getComponent(i);
                if (c instanceof JMenu) {
                    MenuUtilities.trim((JMenu)c);
                } else if (c instanceof JSeparator) {
                    if (lastComponent instanceof JSeparator && i == count - 1) {
                        remove.add(c);
                        remove.add(lastComponent);
                    } else if (lastComponent instanceof JSeparator || i == count - 1 || i == 0) {
                        remove.add(c);
                    }
                }
                lastComponent = c;
            }
            for (i = 0; i < remove.size(); ++i) {
                menu.remove((Component)remove.elementAt(i));
            }
        }
    }
}

