/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;

public class MarkerAttrib
implements MarkerStyleInterface {
    boolean visible;
    boolean fill;
    boolean shadowsOn;
    int shadowOffset;
    double shadowSoftness;
    double opacity;
    Color color;
    Color shadowColor;
    Object shape;
    int shapeInt;
    LineAttrib outline;

    public MarkerAttrib() {
        this.init(null);
    }

    public MarkerAttrib(boolean viz, Color clr) {
        this.init(clr);
        this.visible = viz;
    }

    public MarkerAttrib(MarkerStyleInterface attribs) {
        if (attribs == null) {
            this.init(null);
            return;
        }
        this.setVisible(attribs.isVisible());
        this.setFilled(attribs.isFilled());
        this.setShadowsOn(attribs.areShadowsOn());
        this.setColor(attribs.getColor());
        this.outline = new LineAttrib(attribs.getOutline());
        this.setShadowColor(attribs.getShadowColor());
        this.setShadowOffset(attribs.getShadowOffset());
        this.setShadowSoftness(attribs.getShadowSoftness());
        this.setTransparency(attribs.getTransparency());
        this.setShape(attribs.getShape());
    }

    protected void init(Color clr) {
        this.visible = true;
        this.fill = true;
        this.shadowsOn = false;
        this.color = clr;
        this.outline = new LineAttrib(true, Color.black, 1);
        this.shadowColor = Color.black;
        this.shadowOffset = 2;
        this.shadowSoftness = 0.5;
        this.opacity = 1.0;
        this.shape = null;
        this.shapeInt = 19;
    }

    @Override
    public boolean areShadowsOn() {
        return this.shadowsOn;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public LineStyleInterface getOutline() {
        return this.outline;
    }

    @Override
    public Color getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public int getShadowOffset() {
        return this.shadowOffset;
    }

    @Override
    public double getShadowSoftness() {
        return this.shadowSoftness;
    }

    @Override
    public int getShapeInt() {
        if (this.shape == null || !(this.shape instanceof Number)) {
            return this.shapeInt;
        }
        return ((Number)this.shape).intValue();
    }

    @Override
    public Object getShape() {
        return this.shape;
    }

    @Override
    public double getTransparency() {
        double trans = 1.0 - this.opacity;
        trans = Math.min(Math.max(trans, 0.0), 1.0);
        return trans;
    }

    @Override
    public boolean isFilled() {
        return this.fill;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean setColor(Object clr) {
        Color c = null;
        if (clr == null) {
            this.color = null;
            return true;
        }
        if (clr instanceof Color) {
            c = (Color)clr;
        } else if (clr instanceof String) {
            c = ColorParse.getColorFromString((String)((String)clr));
        }
        if (c == null) {
            return false;
        }
        this.color = c;
        return true;
    }

    public boolean setColorObject(Color c) {
        this.color = c;
        return true;
    }

    @Override
    public void setFilled(boolean fill) {
        this.fill = fill;
    }

    @Override
    public boolean setOutline(Object ol) {
        if (ol == null) {
            return false;
        }
        if (this.outline == null) {
            return false;
        }
        if (ol instanceof Boolean) {
            this.outline.setVisible((Boolean)ol);
        } else if (ol instanceof Color || ol instanceof String) {
            this.outline.setColor(ol);
        } else if (ol instanceof Number) {
            this.outline.setWidth(((Number)ol).intValue());
        } else if (ol instanceof LineStyleInterface) {
            this.outline = new LineAttrib((LineStyleInterface)ol);
        } else {
            return false;
        }
        return true;
    }

    public boolean setOutlineColor(Color c) {
        if (c == null || this.outline == null) {
            return false;
        }
        return this.outline.setColorObject(c);
    }

    @Override
    public boolean setShadowColor(Object clr) {
        Color c = null;
        if (clr == null) {
            this.shadowColor = null;
            return true;
        }
        if (clr instanceof Color) {
            c = (Color)clr;
        } else if (clr instanceof String) {
            c = ColorParse.getColorFromString((String)((String)clr));
        }
        if (c == null) {
            return false;
        }
        this.shadowColor = c;
        return true;
    }

    @Override
    public boolean setShadowOffset(int offset) {
        this.shadowOffset = offset;
        return true;
    }

    @Override
    public boolean setShadowSoftness(double softness) {
        if (Double.isNaN(softness) || Double.isInfinite(softness)) {
            return false;
        }
        this.shadowSoftness = softness;
        this.shadowSoftness = Math.max(Math.min(softness, 1.0), 0.0);
        return true;
    }

    @Override
    public void setShadowsOn(boolean on) {
        this.shadowsOn = on;
    }

    @Override
    public boolean setShape(Object shapeIn) {
        this.shape = shapeIn;
        return true;
    }

    public boolean setShape(int shape) {
        this.shapeInt = shape;
        return true;
    }

    @Override
    public boolean setTransparency(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return false;
        }
        this.opacity = 1.0 - d;
        this.opacity = Math.max(Math.min(d, 1.0), 0.0);
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.fill ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.opacity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.outline == null ? 0 : this.outline.hashCode());
        result = 31 * result + (this.shadowColor == null ? 0 : this.shadowColor.hashCode());
        result = 31 * result + this.shadowOffset;
        temp = Double.doubleToLongBits(this.shadowSoftness);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.shadowsOn ? 1231 : 1237);
        result = 31 * result + (this.shape == null ? 0 : this.shape.hashCode());
        result = 31 * result + this.shapeInt;
        result = 31 * result + (this.visible ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MarkerAttrib)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MarkerAttrib other = (MarkerAttrib)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.fill != other.fill) {
            return false;
        }
        if (Double.doubleToLongBits(this.opacity) != Double.doubleToLongBits(other.opacity)) {
            return false;
        }
        if (this.outline == null ? other.outline != null : !this.outline.equals(other.outline)) {
            return false;
        }
        if (this.shadowColor == null ? other.shadowColor != null : !this.shadowColor.equals(other.shadowColor)) {
            return false;
        }
        if (this.shadowOffset != other.shadowOffset) {
            return false;
        }
        if (Double.doubleToLongBits(this.shadowSoftness) != Double.doubleToLongBits(other.shadowSoftness)) {
            return false;
        }
        if (this.shadowsOn != other.shadowsOn) {
            return false;
        }
        if (this.shape == null ? other.shape != null : !this.shape.equals(other.shape)) {
            return false;
        }
        if (this.shapeInt != other.shapeInt) {
            return false;
        }
        return this.visible == other.visible;
    }
}

