/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.util.HControl;
import com.sas.graphics.silk.util.Marker2;
import com.sas.graphics.silk.util.UniqueValueMapper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class Marker3
extends Marker2 {
    protected int count;
    protected double dataOpacity;
    protected double opacity;
    protected double dataSize;
    protected double errLow;
    protected double errHigh;
    protected String label;
    protected HControl knot;

    public Marker3() {
        this.init(-1, null, null, null, null, -1, Double.NaN, Double.NaN, 1.0, null, Double.NaN, Double.NaN);
    }

    public Marker3(int indexIn, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        this.init(indexIn, img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
    }

    @Override
    public void init(int indexIn, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        super.init(indexIn, img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
        this.count = 0;
        this.dataOpacity = dataOpacity;
        this.opacity = opacity;
        this.dataSize = dataSize;
        this.label = label;
        this.errLow = errLow;
        this.errHigh = errHigh;
        this.knot = null;
    }

    @Override
    public void adjustShape(UniqueValueMapper xMapper, UniqueValueMapper yMapper) {
        super.adjustShape(xMapper, yMapper);
        if (this.knot != null) {
            this.knot.Pt.x = this.x;
        }
        if (this.knot != null) {
            this.knot.Pt.y = this.y;
        }
    }

    @Override
    public void setX(Object newX) {
        super.setX(newX);
        if (this.knot != null) {
            this.knot.Pt.x = this.x;
        }
    }

    @Override
    protected void setY(Object newY) {
        super.setY(newY);
        if (this.knot != null) {
            this.knot.Pt.y = this.y;
        }
    }

    @Override
    public Object getKnot() {
        if (this.knot == null) {
            this.knot = new HControl();
            this.knot.Pt.x = this.x;
            this.knot.Pt.y = this.y;
        }
        return this.knot;
    }

    @Override
    public double getErrorLow() {
        return this.errLow;
    }

    @Override
    public double getErrorHigh() {
        return this.errHigh;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int newCount) {
        this.count = newCount;
    }

    @Override
    public double getDataSize() {
        return this.dataSize;
    }

    @Override
    public void setDataSize(double newDataSize) {
        this.dataSize = newDataSize;
    }

    @Override
    public double getDataOpacity() {
        return this.dataOpacity;
    }

    @Override
    public void draw(int type, int size, Graphics2D g, FontRenderContext fr, Font f, boolean fill, Color color, boolean outlineOn, Color outlineColor, int grow, Color shadowColor, double softness, int offset, Color labelColor, TextStyleInterface lblAttribs, boolean useSimple, boolean resize) {
        int hj = 0;
        int vj = 4;
        Color c = null;
        Composite composite = null;
        Font font = f;
        if (this.opacity < 1.0) {
            composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)this.opacity));
        }
        super.draw(type, size, g, fr, f, fill, color, outlineOn, outlineColor, grow, shadowColor, softness, offset, labelColor, lblAttribs, useSimple, resize);
        if (this.label != null && this.label.length() > 0 && fr != null) {
            TextLayout tl;
            this.label = this.label.trim();
            int halfSize = (int)((double)size * 0.5);
            if (lblAttribs != null) {
                hj = lblAttribs.getHorizontalJustification();
                vj = lblAttribs.getVerticalJustification();
            }
            if (font == null) {
                font = g.getFont();
            }
            if (font != null && (tl = new TextLayout(this.label, font, fr)) != null) {
                int y;
                int x;
                int width = (int)tl.getVisibleAdvance();
                switch (hj) {
                    default: {
                        x = this.screenX - width / 2;
                        break;
                    }
                    case 1: {
                        x = this.screenX - halfSize - width;
                        break;
                    }
                    case 2: {
                        x = this.screenX + halfSize;
                    }
                }
                switch (vj) {
                    default: {
                        y = (int)((float)(this.screenY - halfSize) - tl.getLeading() - tl.getDescent());
                        break;
                    }
                    case 0: {
                        y = this.screenY + (int)((tl.getAscent() + tl.getDescent()) / 2.0f);
                        break;
                    }
                    case 8: {
                        y = (int)((float)(this.screenY + halfSize) + tl.getAscent());
                    }
                }
                if (labelColor != null) {
                    c = g.getColor();
                    g.setColor(labelColor);
                }
                if (f != null) {
                    font = g.getFont();
                    g.setFont(f);
                }
                g.drawString(this.label, x, y);
                if (f != null) {
                    g.setFont(font);
                }
                if (c != null) {
                    g.setColor(c);
                }
            }
        }
        if (composite != null) {
            g.setComposite(composite);
        }
    }

    @Override
    public int projectMarkerSize(TransformInterface transObj, double[] temp) {
        transObj.project(this.x, this.y, 0.0, temp);
        int cx = (int)temp[0];
        transObj.project((double)this.x + this.dataSize, this.y, 0.0, temp);
        return (int)(temp[0] - (double)cx);
    }
}

