/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyEvent;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.ColorParse;
import com.sas.graphics.silk.util.PropertyList;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;

public class LineAttrib
implements LineStyleInterface,
PropertyInterface {
    protected boolean visible;
    protected int width;
    protected Color color;
    protected int pattern;
    protected double transparency = 0.0;
    protected PropertyList pendingProperties = new PropertyList();
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(supportedProperties);
    public static int[] supportedProperties = new int[]{9502, 9501, 9503, 9504};

    public LineAttrib(LineStyleInterface ls) {
        this.init(true, null, 1, 0);
        if (ls == null) {
            return;
        }
        this.setVisible(ls.isVisible());
        this.setWidth(ls.getWidth());
        this.setColor(ls.getColor());
        this.setPattern(ls.getPattern());
        if (ls instanceof LineAttrib) {
            LineAttrib la = (LineAttrib)ls;
            for (int i = 0; i < la.userSetProperties.propertyIndexList.length; ++i) {
                if (la.userSetProperties.get(la.userSetProperties.propertyIndexList[i])) {
                    this.userSetProperties.set(la.userSetProperties.propertyIndexList[i]);
                    continue;
                }
                this.userSetProperties.clear(la.userSetProperties.propertyIndexList[i]);
            }
        }
    }

    public LineAttrib(boolean visible, Object color, int width, int pattern) {
        Color c = Color.black;
        if (color instanceof Color) {
            c = (Color)color;
        } else if (color instanceof String) {
            c = ColorParse.getColorFromString((String)((String)color));
        }
        this.init(visible, c, width, pattern);
    }

    public LineAttrib(boolean visible, Object color, int width) {
        this(visible, color, width, 0);
    }

    public LineAttrib(Object color, int width) {
        this(true, color, width);
    }

    public LineAttrib() {
        this(Color.black, 1);
    }

    public LineAttrib(Object color) {
        this(color, 1);
    }

    protected void init(boolean visible, Color color, int width, int pattern) {
        this.visible = visible;
        this.width = width;
        if (width < 0) {
            width = 1;
        }
        this.color = color;
        this.pattern = pattern;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.userSetProperties.set(9501);
    }

    @Override
    public Color getColor() {
        if (this.transparency > 0.0) {
            return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)(255.0 * this.transparency));
        }
        return this.color;
    }

    @Override
    public boolean setColor(Object color) {
        Color c = null;
        if (color == null) {
            return false;
        }
        if (color instanceof Color) {
            c = (Color)color;
        } else if (color instanceof String) {
            c = ColorParse.getColorFromString((String)((String)color));
        }
        if (c == null) {
            return false;
        }
        if (c.equals(this.color)) {
            return true;
        }
        this.color = c;
        this.userSetProperties.set(9502);
        return true;
    }

    public boolean setColorObject(Color color) {
        if (color == null) {
            return false;
        }
        if (color.equals(this.color)) {
            return true;
        }
        this.color = color;
        this.userSetProperties.set(9502);
        return true;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean setWidth(int newWidth) {
        if (newWidth < 0) {
            return false;
        }
        if (this.width == newWidth) {
            return true;
        }
        this.width = newWidth;
        this.userSetProperties.set(9503);
        return true;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        Vector v = this.pendingProperties.getChangesBySource(source);
        block6: for (int i = 0; i < v.size(); ++i) {
            PropertyEvent pe = (PropertyEvent)((Object)v.elementAt(i));
            switch (pe.id) {
                case 9502: {
                    this.setColor(pe.value);
                    continue block6;
                }
                case 9501: {
                    if (!(pe.value instanceof Boolean)) continue block6;
                    this.setVisible((Boolean)pe.value);
                    continue block6;
                }
                case 9503: {
                    if (!(pe.value instanceof Number)) continue block6;
                    this.setWidth(((Number)pe.value).intValue());
                    continue block6;
                }
                case 9504: {
                    if (!(pe.value instanceof Number)) continue block6;
                    this.setPattern(((Number)pe.value).intValue());
                }
            }
        }
        this.pendingProperties.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pendingProperties.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pendingProperties.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pendingProperties.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Serializable rc = null;
        switch (id) {
            case 9502: {
                rc = this.getColor();
                break;
            }
            case 9501: {
                rc = new Boolean(this.visible);
                break;
            }
            case 9503: {
                rc = new Integer(this.width);
                break;
            }
            case 9504: {
                rc = new Integer(this.pattern);
            }
        }
        return rc;
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    public void setCurrentValueAsDefault(int id) {
        this.userSetProperties.clear(id);
    }

    public boolean isPropertyPending(int id) {
        return this.pendingProperties.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        for (int i = 0; i < supportedProperties.length; ++i) {
            if (id != supportedProperties[i]) continue;
            return true;
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        return this.pendingProperties.store(id, value);
    }

    @Override
    public int getPattern() {
        return this.pattern;
    }

    @Override
    public boolean setPattern(int pattern) {
        if (this.pattern == pattern) {
            return true;
        }
        this.userSetProperties.set(9504);
        this.pattern = pattern;
        return true;
    }

    public String toString() {
        return super.toString() + "[ pattern =  " + this.pattern + " color= " + this.color + " width = " + this.width + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + this.pattern;
        result = 31 * result + (this.visible ? 1231 : 1237);
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineAttrib)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LineAttrib other = (LineAttrib)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.pattern != other.pattern) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        return this.width == other.width;
    }

    @Override
    public double getTransparency() {
        return this.transparency;
    }

    @Override
    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }
}

