/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class LegendObject
implements LegendInterface,
PropertyInterface,
RenderInterface,
TextListenerInterface {
    protected boolean redrawRequired;
    protected boolean updateRequired;
    protected boolean isContinuous;
    protected boolean inside;
    protected int borderStyle;
    protected int down;
    protected int across;
    protected int minLabelFontSize;
    protected int legendPosition;
    protected int insideLegendPosition;
    protected double bgOpacity;
    protected Color backColor1;
    protected Color backColor2;
    protected Color defaultColor;
    protected Font defaultLabelFont;
    protected Font defaultTitleFont;
    protected LineAttrib border;
    protected Text title;
    protected Text label;
    protected String nlsEast;
    protected String nlsWest;
    protected String nlsNorth;
    protected String nlsNorthWest;
    protected String nlsNorthEast;
    protected String nlsSouth;
    protected String nlsSouthWest;
    protected String nlsSouthEast;
    protected String nlsBdrNone;
    protected String nlsBdrLine;
    protected String nlsBdrDropShadow;
    protected SASFormat defaultFormat;
    protected GlobalDefaults gblDefaults;
    protected PropertyList pendingProperties;
    protected ResourceBundle rb;
    protected boolean supportsInsideLegend = true;
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(supportedProperties);
    public static int[] supportedProperties = new int[]{401, 442, 443, 402, 420, 421, 422, 423, 424, 425, 426, 427, 428, 431, 432, 433, 434, 435, 436, 437, 438, 439, 428, 441, 39};

    public LegendObject() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");
        this.nlsEast = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionEast.txt", (String)"East");
        this.nlsWest = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionWest.txt", (String)"West");
        this.nlsNorth = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionNorth.txt", (String)"North");
        this.nlsNorthWest = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionNorthWest.txt", (String)"Northwest");
        this.nlsNorthEast = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionNorthEast.txt", (String)"Northeast");
        this.nlsSouth = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionSouth.txt", (String)"South");
        this.nlsSouthWest = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionSouthWest.txt", (String)"Southwest");
        this.nlsSouthEast = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.PositionSouthEast.txt", (String)"Southeast");
        this.nlsBdrNone = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.BorderNone.txt", (String)"None");
        this.nlsBdrLine = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.BorderLine.txt", (String)"Line");
        this.nlsBdrDropShadow = ResourceLoader.getResourceString((Object)this.rb, (String)"Legend.BorderDropShadow.txt", (String)"Drop Shadow");
        this.gblDefaults = new GlobalDefaults();
        this.defaultFormat = this.gblDefaults.defaultNumericFormat;
        this.pendingProperties = new PropertyList();
        this.isContinuous = false;
        this.legendPosition = 2;
        this.insideLegendPosition = 6;
        this.borderStyle = 101;
        this.redrawRequired = false;
        this.updateRequired = false;
        this.minLabelFontSize = 6;
        this.down = 0;
        this.across = 0;
        this.bgOpacity = 1.0;
        this.backColor1 = Color.white;
        this.backColor2 = null;
        this.defaultColor = Color.black;
        this.defaultLabelFont = FontManager.getFont((String)"Serif", (int)0, (int)12);
        this.defaultTitleFont = FontManager.getFont((String)"Serif", (int)1, (int)12);
        this.border = new LineAttrib();
        this.title = new Text();
        this.title.setPropertyValue(9018, "LabelText");
        this.title.applyPropertyChanges();
        this.title.setVisible(false);
        this.title.setCurrentValueAsDefault(9000);
        this.title.setColor(this.defaultColor);
        this.title.setFormatSupported(false);
        this.title.setEffectsSupported(false);
        this.title.addTextListener(this);
        this.title.setJustification(1, 8);
        this.label = new Text();
        this.label.setPropertyValue(9018, "ValueText");
        this.label.applyPropertyChanges();
        this.label.setColor(this.defaultColor);
        this.label.setJustifySupported(false);
        this.label.setFormatSupported(false);
        this.label.addTextListener(this);
        this.label.setEffectsSupported(false);
    }

    public boolean isUpdateRequired() {
        return this.updateRequired;
    }

    public boolean isRedrawRequired() {
        return this.redrawRequired;
    }

    protected Color getBorderColor() {
        Color c = null;
        if (this.border != null) {
            c = this.border.getColor();
        }
        if (c == null) {
            return Color.black;
        }
        return c;
    }

    protected String getTitleString() {
        if (this.title == null) {
            return null;
        }
        return this.title.getTextString();
    }

    protected int getTitleJustification() {
        if (this.title == null) {
            return -1;
        }
        return this.title.getHorizontalJustification();
    }

    protected Font getTitleFont() {
        if (this.title == null) {
            return this.defaultTitleFont.deriveFont((float)SILKUtilities.adjustFontSize(this.defaultTitleFont.getSize()));
        }
        Font f = this.title.getFont();
        if (f == null) {
            return this.defaultTitleFont.deriveFont((float)SILKUtilities.adjustFontSize(this.defaultTitleFont.getSize()));
        }
        return f.deriveFont((float)SILKUtilities.adjustFontSize(f.getSize()));
    }

    protected Color getTitleColor() {
        if (this.title == null) {
            return Color.black;
        }
        return this.title.getColor();
    }

    protected Font getLabelFont() {
        if (this.label == null) {
            return this.defaultLabelFont.deriveFont((float)SILKUtilities.adjustFontSize(this.defaultLabelFont.getSize()));
        }
        Font f = this.label.getFont();
        if (f == null) {
            return this.defaultLabelFont.deriveFont((float)SILKUtilities.adjustFontSize(this.defaultLabelFont.getSize()));
        }
        return f.deriveFont((float)SILKUtilities.adjustFontSize(f.getSize()));
    }

    protected Color getLabelColor() {
        if (this.label == null) {
            return Color.black;
        }
        return this.label.getColor();
    }

    protected Object fetchProperty(int id) {
        Object out = null;
        if (this.isPropertyPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        switch (id) {
            case 441: {
                out = new Boolean(this.isContinuous);
                break;
            }
            case 433: {
                out = this.getValues();
                break;
            }
            case 39: {
                out = new Boolean(this.supportsInsideLegend);
                break;
            }
            case 432: {
                out = new Boolean(this.isInside());
                break;
            }
            case 401: {
                if (this.pendingProperties.isPending(432)) {
                    Object inside = this.pendingProperties.getValueById(432);
                    if (inside != null && inside instanceof Boolean && ((Boolean)inside).booleanValue()) {
                        out = this.getLegendNumber(this.insideLegendPosition);
                        break;
                    }
                    out = this.getLegendNumber(this.legendPosition);
                    break;
                }
                out = this.getLegendNumber(this.getPosition());
                break;
            }
            case 442: {
                out = this.getLegendNumber(this.insideLegendPosition);
                break;
            }
            case 443: {
                out = this.getLegendNumber(this.legendPosition);
                break;
            }
            case 402: {
                out = new Boolean(true);
                break;
            }
            case 420: {
                out = new Boolean(this.isVisible());
                break;
            }
            case 421: {
                out = this.getBackgroundColor();
                break;
            }
            case 422: {
                out = new Double(this.getBackgroundOpacity());
                break;
            }
            case 423: {
                out = this.getBorderColor();
                break;
            }
            case 424: {
                out = this.getLegendNumber(this.getBorderStyle());
                break;
            }
            case 427: {
                out = this.getTitle();
                break;
            }
            case 440: {
                out = this.getBorder();
                break;
            }
            case 425: {
                if (this.title == null) {
                    return null;
                }
                out = new Boolean(this.title.isVisible());
                break;
            }
            case 426: {
                if (this.title == null) {
                    return null;
                }
                out = this.title.getTextString();
                break;
            }
            case 428: {
                out = this.getLabel();
                break;
            }
            case 435: {
                out = new Integer(this.across);
                break;
            }
            case 436: {
                out = new Integer(this.down);
            }
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleProperty(int id, Object value, boolean execute, boolean verify) {
        if (!execute && this.pendingProperties == null) {
            return false;
        }
        switch (id) {
            case 433: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof LegendEntryInterface[])) {
                    return false;
                }
                if (!execute) break;
                this.setValues((LegendEntryInterface[])value, this.isContinuous);
                break;
            }
            case 39: {
                if (verify) {
                    return true;
                }
                if (!(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.supportsInsideLegend = (Boolean)value;
                break;
            }
            case 401: 
            case 442: 
            case 443: {
                int intval;
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof String) && !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                if (value instanceof Number) {
                    intval = ((Number)value).intValue();
                } else {
                    if (!(value instanceof String)) return false;
                    String s = (String)value;
                    if (s.equalsIgnoreCase(this.nlsEast) || s.equalsIgnoreCase("East")) {
                        intval = 3;
                    } else if (s.equalsIgnoreCase(this.nlsWest) || s.equalsIgnoreCase("West")) {
                        intval = 4;
                    } else if (s.equalsIgnoreCase(this.nlsNorth) || s.equalsIgnoreCase("North")) {
                        intval = 1;
                    } else if (s.equalsIgnoreCase(this.nlsNorthEast) || s.equalsIgnoreCase("Northeast")) {
                        intval = 6;
                    } else if (s.equalsIgnoreCase(this.nlsNorthWest) || s.equalsIgnoreCase("Northwest")) {
                        intval = 7;
                    } else if (s.equalsIgnoreCase(this.nlsSouth) || s.equalsIgnoreCase("South")) {
                        intval = 2;
                    } else if (s.equalsIgnoreCase(this.nlsSouthEast) || s.equalsIgnoreCase("Southeast")) {
                        intval = 8;
                    } else {
                        if (!s.equalsIgnoreCase(this.nlsSouthWest) && !s.equalsIgnoreCase("Southwest")) return false;
                        intval = 9;
                    }
                }
                this.setPosition(intval);
                break;
            }
            case 402: {
                if (!verify) break;
                return true;
            }
            case 432: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setInside((Boolean)value);
                break;
            }
            case 420: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setVisible((Boolean)value);
                break;
            }
            case 421: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Color)) {
                    return false;
                }
                if (!execute) break;
                this.setBackgroundColor(value);
                break;
            }
            case 422: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setBackgroundOpacity(((Number)value).doubleValue());
                break;
            }
            case 423: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Color)) {
                    return false;
                }
                if (!execute || this.border == null) break;
                this.border.setColor(value);
                break;
            }
            case 424: {
                int intval;
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number) && !(value instanceof String)) {
                    return false;
                }
                if (!execute) break;
                if (value instanceof Number) {
                    intval = ((Number)value).intValue();
                } else {
                    if (!(value instanceof String)) return false;
                    String s = (String)value;
                    if (s.equalsIgnoreCase(this.nlsBdrNone) || s.equalsIgnoreCase("None")) {
                        intval = 100;
                    } else if (s.equalsIgnoreCase(this.nlsBdrLine) || s.equalsIgnoreCase("Line")) {
                        intval = 101;
                    } else {
                        if (!s.equalsIgnoreCase(this.nlsBdrDropShadow) && !s.equalsIgnoreCase("Drop Shadow")) return false;
                        intval = 102;
                    }
                }
                this.setBorderStyle(intval);
                break;
            }
            case 427: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute) break;
                this.setTitle(value);
                break;
            }
            case 440: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute) break;
                this.setBorder(value);
                break;
            }
            case 425: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute || this.title == null) break;
                this.redrawRequired = true;
                this.updateRequired = true;
                this.title.setVisible((Boolean)value);
                break;
            }
            case 426: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof String)) {
                    return false;
                }
                if (!execute || this.title == null) break;
                this.redrawRequired = true;
                this.updateRequired = true;
                this.title.setText((String)value);
                break;
            }
            case 428: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute || this.label == null) break;
                this.setLabel(value);
                break;
            }
            case 435: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute || !(value instanceof Number)) break;
                this.setAcross(((Number)value).intValue());
                break;
            }
            case 436: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute || !(value instanceof Number)) break;
                this.setDown(((Number)value).intValue());
                break;
            }
            default: {
                return false;
            }
        }
        if (execute) return true;
        this.pendingProperties.store(id, value);
        return true;
    }

    public void applyStyle(Style style) {
        if (style == null) {
            return;
        }
        this.setBackgroundColor(style.getFillStyleElement("LegendFill").getFillColor());
        this.userSetProperties.clear(421);
        this.setBorder(style.getLineStyleElement("Outlines").getLineColor());
        this.border.setCurrentValueAsDefault(9502);
        this.label.applyStyle(style);
        this.title.applyStyle(style);
    }

    public boolean isPropertySupported(int id) {
        return this.handleProperty(id, null, false, true);
    }

    public boolean isPropertyPending(int id) {
        if (this.pendingProperties == null) {
            return false;
        }
        return this.pendingProperties.isPending(id);
    }

    public Object getPropertyValue(int idx) {
        return this.fetchProperty(idx);
    }

    public boolean setPropertyValue(int idx, Object value) {
        return this.handleProperty(idx, value, false, false);
    }

    public int getNumberPendingProperties() {
        if (this.pendingProperties == null) {
            return 0;
        }
        return this.pendingProperties.getNumberPending(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.pendingProperties == null) {
            return false;
        }
        Vector v = this.pendingProperties.getChangesBySource(source);
        if (v == null || v.size() <= 0) {
            return false;
        }
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            PropertyEvent pe = (PropertyEvent)v.elementAt(i);
            if (pe == null) continue;
            this.handleProperty(pe.id, pe.value, true, false);
        }
        this.pendingProperties.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        if (this.pendingProperties != null) {
            this.pendingProperties.removeChangesBySource(source);
        }
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        if (this.pendingProperties == null) {
            return null;
        }
        return this.pendingProperties.getPending(source);
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    public void setCurrentValueAsDefault(int id) {
        this.userSetProperties.clear(id);
    }

    @Override
    public TextStyleInterface getTitle() {
        return this.title;
    }

    @Override
    public boolean setTitle(Object newTitle) {
        if (this.title == null) {
            return false;
        }
        if (newTitle == null || newTitle instanceof String) {
            if (!this.title.setText(newTitle)) {
                return false;
            }
            this.updateRequired = true;
        } else if (newTitle instanceof Font) {
            if (!this.title.setFont(newTitle)) {
                return false;
            }
            this.updateRequired = true;
        } else if (newTitle instanceof Color) {
            if (!this.title.setColor(newTitle)) {
                return false;
            }
        } else if (newTitle instanceof Number) {
            if (!this.title.setJustification(((Number)newTitle).intValue(), this.title.getVerticalJustification())) {
                return false;
            }
            this.updateRequired = true;
        } else if (newTitle instanceof TextStyleInterface) {
            this.title = new Text((TextStyleInterface)newTitle);
            this.title.addTextListener(this);
            this.updateRequired = true;
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public TextStyleInterface getLabel() {
        return this.label;
    }

    @Override
    public boolean setLabel(Object l) {
        if (this.label == null) {
            return false;
        }
        if (l == null) {
            return false;
        }
        if (l instanceof String || l instanceof SASFormat) {
            if (!this.label.setFormat(l)) {
                return false;
            }
            this.updateRequired = true;
        } else if (l instanceof Color) {
            if (!this.label.setColor(l)) {
                return false;
            }
        } else if (l instanceof Font) {
            if (!this.label.setFont(l)) {
                return false;
            }
            this.updateRequired = true;
        } else if (l instanceof TextStyleInterface) {
            this.label = new Text((TextStyleInterface)l);
            this.label.addTextListener(this);
            this.updateRequired = true;
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backColor1;
    }

    @Override
    public boolean setBackgroundColor(Object newColor) {
        Color c;
        if (newColor == null) {
            return false;
        }
        if (newColor instanceof Color) {
            c = (Color)newColor;
        } else if (newColor instanceof String) {
            c = ColorParse.getColorFromString((String)((String)newColor));
            if (c == null) {
                return false;
            }
        } else {
            return false;
        }
        if (c != null && c.equals(this.backColor1)) {
            return true;
        }
        this.backColor1 = c;
        this.userSetProperties.set(421);
        this.redrawRequired = true;
        return true;
    }

    @Override
    public double getBackgroundOpacity() {
        return this.bgOpacity;
    }

    @Override
    public boolean setBackgroundOpacity(double newOpacity) {
        if (Double.isNaN(newOpacity) || Double.isInfinite(newOpacity) || newOpacity < 0.0 || newOpacity > 1.0) {
            return false;
        }
        if (this.bgOpacity == newOpacity) {
            return true;
        }
        this.bgOpacity = newOpacity;
        this.userSetProperties.set(422);
        this.redrawRequired = true;
        return true;
    }

    @Override
    public LineStyleInterface getBorder() {
        return this.border;
    }

    @Override
    public boolean setBorder(Object b) {
        if (this.border == null || b == null) {
            return false;
        }
        if (b instanceof Color) {
            if (!this.border.setColor(b)) {
                return false;
            }
        } else if (b instanceof Number) {
            if (!this.border.setWidth(((Number)b).intValue())) {
                return false;
            }
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public int getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public boolean setBorderStyle(int newStyle) {
        switch (newStyle) {
            case 100: 
            case 101: 
            case 102: {
                if (this.borderStyle == newStyle) {
                    return true;
                }
                this.redrawRequired = true;
                this.borderStyle = newStyle;
                this.userSetProperties.set(424);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getAcross() {
        return this.across;
    }

    @Override
    public void setAcross(int a) {
        if (a != this.across) {
            this.updateRequired = true;
        }
        if (this.across == a) {
            return;
        }
        this.across = a;
        this.down = 0;
        this.userSetProperties.set(435);
        this.userSetProperties.clear(436);
        this.redrawRequired = true;
    }

    @Override
    public int getDown() {
        return this.down;
    }

    @Override
    public void setDown(int d) {
        if (this.down != d) {
            this.updateRequired = true;
        }
        if (this.down == d) {
            return;
        }
        this.down = d;
        this.across = 0;
        this.userSetProperties.set(436);
        this.userSetProperties.clear(435);
        this.redrawRequired = true;
    }

    @Override
    public int getPosition() {
        if (this.isInside()) {
            return this.insideLegendPosition;
        }
        return this.legendPosition;
    }

    @Override
    public void setPosition(int pos) {
        if (this.isInside() && pos != this.insideLegendPosition || pos != this.legendPosition) {
            this.updateRequired = true;
            this.redrawRequired = true;
        }
        if (this.isInside()) {
            if (this.insideLegendPosition == pos) {
                return;
            }
            this.insideLegendPosition = pos;
            this.userSetProperties.set(401);
        } else {
            if (this.legendPosition == pos) {
                return;
            }
            this.legendPosition = pos;
            this.userSetProperties.set(401);
        }
    }

    @Override
    public Object getLegendNumber(int num) {
        String s = null;
        String english = null;
        switch (num) {
            case 3: {
                s = this.nlsEast;
                english = "East";
                break;
            }
            case 4: {
                s = this.nlsWest;
                english = "West";
                break;
            }
            case 1: {
                s = this.nlsNorth;
                english = "North";
                break;
            }
            case 6: {
                s = this.nlsNorthEast;
                english = "NorthEast";
                break;
            }
            case 7: {
                s = this.nlsNorthWest;
                english = "NorthWest";
                break;
            }
            case 2: {
                s = this.nlsSouth;
                english = "South";
                break;
            }
            case 8: {
                s = this.nlsSouthEast;
                english = "SouthEast";
                break;
            }
            case 9: {
                s = this.nlsSouthWest;
                english = "SouthWest";
                break;
            }
            case 100: {
                s = this.nlsBdrNone;
                english = "None";
                break;
            }
            case 101: {
                s = this.nlsBdrLine;
                english = "Line";
                break;
            }
            case 102: {
                s = this.nlsBdrDropShadow;
                english = "DropShadow";
                break;
            }
        }
        return new SILKNumber(num, s, english);
    }

    @Override
    public boolean isInside() {
        return this.inside;
    }

    @Override
    public void setInside(boolean inside) {
        boolean bl = this.redrawRequired = inside != this.inside;
        if (inside == this.inside) {
            return;
        }
        this.inside = inside;
        this.userSetProperties.set(432);
    }

    public boolean isInCorner() {
        int pos = this.getPosition();
        boolean rc = false;
        switch (pos) {
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                rc = true;
            }
        }
        return rc;
    }

    @Override
    public void textUpdated(DvrTextEvent e) {
        this.updateRequired = true;
        this.redrawRequired = true;
    }
}

