/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;

public class Layout {
    protected Title titles;
    protected Footnote footnotes;
    protected Vector legends = new Vector();
    protected Rectangle chartArea;
    protected Rectangle componentBounds = null;
    public int INNER_MARGIN = 7;
    public double LEGEND_PERCENTAGE = 0.3;
    protected GlobalDefaults silkDefaults = new GlobalDefaults();
    protected boolean drawBorder = false;
    protected Color borderColor = Color.black;
    protected int borderLineStyle = 1;
    protected int borderThickness = 1;
    protected LineBorder lineBorder = new LineBorder(this.borderColor, this.borderThickness);

    public void applyStyle(Style style) {
        Footnote f;
        Title t = this.getTitle();
        if (t != null) {
            t.applyStyle(style);
        }
        if ((f = this.getFootnote()) != null) {
            f.applyStyle(style);
        }
        LineStyleElement lse = style.getLineStyleElement("BorderLines");
        this.borderColor = lse.getLineColor();
        this.borderLineStyle = lse.getLineStyle();
        this.borderThickness = lse.getLineThickness().getSizeValue();
        this.lineBorder = new LineBorder(this.borderColor, this.borderThickness);
    }

    public void setTitle(Title title) {
        this.titles = title;
    }

    public Title getTitle() {
        return this.titles;
    }

    public void setFootnote(Footnote footnote) {
        this.footnotes = footnote;
    }

    public Footnote getFootnote() {
        return this.footnotes;
    }

    public void addLegend(LegendInterface legend) {
        if (legend != null) {
            this.legends.addElement(legend);
        }
    }

    public boolean removeLegend(LegendInterface legend) {
        if (legend == null || !this.legends.contains(legend)) {
            return false;
        }
        return this.legends.removeElement(legend);
    }

    public LegendInterface[] getLegends() {
        Object[] rc = new LegendInterface[this.legends.size()];
        this.legends.copyInto(rc);
        return rc;
    }

    public void draw(Graphics g) {
        if (SILKGlobal.isFlagSet(5)) {
            g.setColor(Color.RED);
            int compXMargin = SILKGlobal.isFlagSet(4) ? this.silkDefaults.statgraphComponentXMargin : this.silkDefaults.componentXMargin;
            int compYMargin = SILKGlobal.isFlagSet(4) ? this.silkDefaults.statgraphComponentYMargin : this.silkDefaults.componentYMargin;
            compXMargin = (int)((double)compXMargin * SILKUtilities.getDPIScaleFactor());
            compYMargin = (int)((double)compYMargin * SILKUtilities.getDPIScaleFactor());
            Rectangle2D.Double r = new Rectangle2D.Double(compXMargin, compYMargin, this.componentBounds.width - 2 * compXMargin, this.componentBounds.height - 2 * compYMargin);
            Area a = new Area(this.componentBounds);
            a.subtract(new Area(r));
            if (this.componentBounds != null) {
                ((Graphics2D)g).fill(a);
            }
        }
        if (this.drawBorder) {
            Stroke oldStroke = null;
            if (g instanceof Graphics2D) {
                oldStroke = ((Graphics2D)g).getStroke();
                ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)this.borderLineStyle, (int)this.borderThickness));
            }
            this.lineBorder.paintBorder(null, g, this.componentBounds.x, this.componentBounds.y, this.componentBounds.width, this.componentBounds.height);
            if (oldStroke != null) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
        }
        this.titles.draw(g, false);
        this.footnotes.draw(g, false);
        for (int i = 0; i < this.legends.size(); ++i) {
            Object obj = this.legends.elementAt(i);
            if (!(obj instanceof RenderInterface)) continue;
            ((RenderInterface)obj).draw(g, false);
        }
    }

    public void drawHighlight(Graphics g) {
        for (int i = 0; i < this.legends.size(); ++i) {
            Object obj = this.legends.elementAt(i);
            if (!(obj instanceof RenderInterface)) continue;
            ((RenderInterface)obj).draw(g, true);
        }
    }

    public void doLayout(JComponent component) {
        this.doLayout(component.getBounds());
    }

    public void doLayout(Rectangle r) {
        this.componentBounds = r;
        int compXMargin = SILKGlobal.isFlagSet(4) ? this.silkDefaults.statgraphComponentXMargin : this.silkDefaults.componentXMargin;
        int compYMargin = SILKGlobal.isFlagSet(4) ? this.silkDefaults.statgraphComponentYMargin : this.silkDefaults.componentYMargin;
        compXMargin = (int)((double)compXMargin * SILKUtilities.getDPIScaleFactor());
        compYMargin = (int)((double)compYMargin * SILKUtilities.getDPIScaleFactor());
        this.titles.setComponentBounds(new Rectangle(compXMargin, compYMargin, this.componentBounds.width - 2 * compXMargin, this.componentBounds.height - 2 * compYMargin));
        this.footnotes.setComponentBounds(new Rectangle(compXMargin, compYMargin, this.componentBounds.width - 2 * compXMargin, this.componentBounds.height - 2 * compYMargin));
        Rectangle titlesArea = this.titles.getBounds();
        Rectangle footnotesArea = this.footnotes.getBounds();
        this.chartArea = new Rectangle(compXMargin, compYMargin + titlesArea.height, this.componentBounds.width - 2 * compXMargin, this.componentBounds.height - 2 * compYMargin - titlesArea.height - footnotesArea.height);
        if (this.fitLegendsSouth(this.chartArea, false)) {
            this.chartArea.height -= 2 * this.INNER_MARGIN;
        }
        if (this.fitLegendsNorth(this.chartArea, false)) {
            this.chartArea.y += this.INNER_MARGIN;
            this.chartArea.height -= this.INNER_MARGIN;
        }
        if (this.fitLegendsEast(this.chartArea, false)) {
            this.chartArea.width -= this.INNER_MARGIN;
        }
        if (this.fitLegendsWest(this.chartArea, false)) {
            this.chartArea.x += this.INNER_MARGIN;
            this.chartArea.width -= this.INNER_MARGIN;
        }
        this.fitLegendsSouth(this.chartArea, true);
        this.fitLegendsNorth(this.chartArea, true);
        this.fitLegendsEast(this.chartArea, true);
        this.fitLegendsWest(this.chartArea, true);
    }

    public boolean containsLegend(Object legend) {
        return this.legends.contains(legend);
    }

    public void setDataRegion(Rectangle r) {
        Rectangle dr = new Rectangle(r);
        this.fitLegendsSouth(dr, true);
        this.fitLegendsNorth(dr, true);
        this.fitLegendsEast(dr, true);
        this.fitLegendsWest(dr, true);
    }

    private boolean fitLegendsSouth(Rectangle bounds, boolean inside) {
        LegendInterface[] legs = this.getLegends(2, inside, true);
        int height = this.fitLegendsHorizontally(legs, bounds, inside);
        int margin = inside ? 0 : this.INNER_MARGIN;
        int SWwidth = this.positionLegendsHorizontally(this.getLegends(9, inside, false), new Rectangle(bounds.x, bounds.y + bounds.height - height - margin, bounds.width, height), 7);
        int SEwidth = this.positionLegendsHorizontally(this.getLegends(8, inside, false), new Rectangle(bounds.x + SWwidth, bounds.y + bounds.height - height - margin, bounds.width - SWwidth, height), 3);
        this.positionLegendsHorizontally(this.getLegends(2, inside, false), new Rectangle(bounds.x + SWwidth, bounds.y + bounds.height - height - margin, bounds.width - SWwidth - SEwidth, height), 0);
        if (!inside) {
            bounds.height -= height;
        }
        return height > 0;
    }

    private boolean fitLegendsNorth(Rectangle bounds, boolean inside) {
        LegendInterface[] legs = this.getLegends(1, inside, true);
        int height = this.fitLegendsHorizontally(legs, bounds, inside);
        int margin = inside ? this.INNER_MARGIN : 0;
        int NWwidth = this.positionLegendsHorizontally(this.getLegends(7, inside, false), new Rectangle(bounds.x, bounds.y + margin, bounds.width, height), 7);
        int NEwidth = this.positionLegendsHorizontally(this.getLegends(6, inside, false), new Rectangle(bounds.x + NWwidth, bounds.y + margin, bounds.width - NWwidth, height), 3);
        this.positionLegendsHorizontally(this.getLegends(1, inside, false), new Rectangle(bounds.x + NWwidth, bounds.y + margin, bounds.width - NWwidth - NEwidth, height), 0);
        if (!inside) {
            bounds.y += height;
            bounds.height -= height;
        }
        return height > 0;
    }

    private int positionLegendsHorizontally(LegendInterface[] legs, Rectangle rect, int justification) {
        if (legs == null || legs.length == 0 || rect.width <= 0 || rect.height <= 0) {
            return 0;
        }
        Vector<LegendInterface> toBeProcessed = new Vector<LegendInterface>();
        for (int i = 0; i < legs.length; ++i) {
            if (legs[i].getPreferredSize().width <= 0) continue;
            toBeProcessed.addElement(legs[i]);
        }
        Object[] legends = new LegendInterface[toBeProcessed.size()];
        toBeProcessed.copyInto(legends);
        int sum = 0;
        for (int i = 0; i < legends.length; ++i) {
            sum += legends[i].getPreferredSize().width;
        }
        int diff = rect.width - sum;
        int margin = 0;
        int xMargin = SILKGlobal.isFlagSet(4) ? this.silkDefaults.statgraphComponentXMargin : this.silkDefaults.componentXMargin;
        switch (justification) {
            case 3: 
            case 7: {
                margin = xMargin;
                break;
            }
            case 0: {
                margin = (int)((double)diff / ((double)legends.length * 2.0));
            }
        }
        int curr = 0;
        switch (justification) {
            case 7: {
                curr = rect.x + margin;
                break;
            }
            case 0: {
                curr = rect.x + xMargin + margin;
                break;
            }
            case 3: {
                curr = rect.x + rect.width;
            }
        }
        for (int i = 0; i < legends.length; ++i) {
            int y = (int)((double)rect.y + ((double)rect.height - (double)legends[i].getPreferredSize().height) / 2.0);
            int x = curr;
            curr = justification == 3 ? (curr -= legends[i].getPreferredSize().width + margin) : (curr += legends[i].getPreferredSize().width + margin);
            if (justification == 3) {
                x = curr;
            }
            legends[i].setStartPoint(x, y);
        }
        int rc = 0;
        switch (justification) {
            case 3: 
            case 7: {
                rc = sum + margin * legends.length;
                break;
            }
            default: {
                rc = rect.width;
            }
        }
        return rc;
    }

    private int fitLegendsHorizontally(LegendInterface[] legs, Rectangle bounds, boolean inside) {
        int i;
        int i2;
        if (legs == null || legs.length == 0) {
            return 0;
        }
        int numLegends = legs.length;
        for (int i3 = 0; i3 < legs.length; ++i3) {
            if (!(legs[i3] instanceof RenderInterface) || ((RenderInterface)((Object)legs[i3])).isVisible()) continue;
            --numLegends;
        }
        int height = (int)(bounds.getHeight() * 0.3);
        if (inside) {
            height = (int)bounds.getHeight();
        }
        int xMargin = SILKGlobal.isFlagSet(4) ? this.silkDefaults.statgraphComponentXMargin : this.silkDefaults.componentXMargin;
        int width = (int)((bounds.getWidth() - (double)xMargin) / (double)numLegends - (double)xMargin);
        boolean allFit = false;
        Vector<LegendInterface> vec = new Vector<LegendInterface>();
        for (i2 = 0; i2 < legs.length; ++i2) {
            vec.addElement(legs[i2]);
        }
        while (!allFit) {
            for (i2 = 0; i2 < vec.size(); ++i2) {
                ((LegendInterface)vec.elementAt(i2)).setMaximumSize(width, height);
            }
            int sum = 0;
            for (i = 0; i < vec.size(); ++i) {
                sum += ((LegendInterface)vec.elementAt((int)i)).getPreferredSize().width;
            }
            if (vec.size() == 0 || (double)sum <= bounds.getWidth()) {
                allFit = true;
                continue;
            }
            int target = 0;
            for (int i4 = 0; i4 < vec.size(); ++i4) {
                if (((LegendInterface)vec.elementAt((int)i4)).getPreferredSize().width <= ((LegendInterface)vec.elementAt((int)target)).getPreferredSize().width) continue;
                target = i4;
            }
            vec.remove(target);
        }
        int rc = -1;
        for (i = 0; i < legs.length; ++i) {
            if (rc >= legs[i].getPreferredSize().height || height < legs[i].getPreferredSize().height) continue;
            rc = legs[i].getPreferredSize().height;
        }
        return rc;
    }

    private boolean fitLegendsEast(Rectangle bounds, boolean inside) {
        LegendInterface[] legs = this.getLegends(3, inside, true);
        int width = this.fitLegendsVertical(legs, bounds, inside);
        int margin = inside ? this.INNER_MARGIN : 0;
        this.positionLegendsVertical(legs, new Rectangle(bounds.x + bounds.width - width - margin, bounds.y, width, bounds.height));
        if (!inside) {
            bounds.width -= width;
        }
        return width > 0;
    }

    private boolean fitLegendsWest(Rectangle bounds, boolean inside) {
        LegendInterface[] legs = this.getLegends(4, inside, true);
        int width = this.fitLegendsVertical(legs, bounds, inside);
        int margin = inside ? this.INNER_MARGIN : 0;
        this.positionLegendsVertical(legs, new Rectangle(bounds.x + margin, bounds.y, width, bounds.height));
        if (!inside) {
            bounds.x += width;
            bounds.width -= width;
        }
        return width > 0;
    }

    private int fitLegendsVertical(LegendInterface[] legs, Rectangle bounds, boolean inside) {
        int i;
        int i2;
        if (legs == null || legs.length == 0) {
            return 0;
        }
        int numLegends = legs.length;
        for (int i3 = 0; i3 < legs.length; ++i3) {
            if (!(legs[i3] instanceof RenderInterface) || ((RenderInterface)((Object)legs[i3])).isVisible()) continue;
            --numLegends;
        }
        int yMargin = SILKGlobal.isFlagSet(4) ? this.silkDefaults.statgraphComponentYMargin : this.silkDefaults.componentYMargin;
        int height = (int)((bounds.getHeight() - (double)yMargin) / (double)numLegends - (double)yMargin);
        int width = (int)(bounds.getWidth() * 0.3);
        boolean allFit = false;
        Vector<LegendInterface> vec = new Vector<LegendInterface>();
        for (i2 = 0; i2 < legs.length; ++i2) {
            vec.addElement(legs[i2]);
        }
        while (!allFit) {
            for (i2 = 0; i2 < vec.size(); ++i2) {
                ((LegendInterface)vec.elementAt(i2)).setMaximumSize(width, height);
            }
            int sum = 0;
            for (i = 0; i < vec.size(); ++i) {
                sum += ((LegendInterface)vec.elementAt((int)i)).getPreferredSize().height;
            }
            if (vec.size() == 0 || (double)sum <= bounds.getHeight()) {
                allFit = true;
                continue;
            }
            int target = 0;
            for (int i4 = 0; i4 < vec.size(); ++i4) {
                if (((LegendInterface)vec.elementAt((int)i4)).getPreferredSize().height <= ((LegendInterface)vec.elementAt((int)target)).getPreferredSize().height) continue;
                target = i4;
            }
            vec.remove(target);
        }
        int rc = -1;
        for (i = 0; i < legs.length; ++i) {
            if (rc >= legs[i].getPreferredSize().width) continue;
            rc = legs[i].getPreferredSize().width;
        }
        return rc;
    }

    private void positionLegendsVertical(LegendInterface[] legs, Rectangle rect) {
        if (legs == null || legs.length == 0 || rect.width <= 0 || rect.height <= 0) {
            return;
        }
        Vector<LegendInterface> toBeProcessed = new Vector<LegendInterface>();
        for (int i = 0; i < legs.length; ++i) {
            if (legs[i].getPreferredSize().width <= 0) continue;
            toBeProcessed.addElement(legs[i]);
        }
        Object[] legends = new LegendInterface[toBeProcessed.size()];
        toBeProcessed.copyInto(legends);
        int sum = 0;
        for (int i = 0; i < legends.length; ++i) {
            sum += legends[i].getPreferredSize().height;
        }
        int diff = rect.height - sum;
        int margin = (int)((double)diff / ((double)legends.length * 2.0));
        int curr = rect.y + margin;
        for (int i = 0; i < legends.length; ++i) {
            int y = curr;
            int x = (int)((double)rect.x + ((double)rect.width - (double)legends[i].getPreferredSize().width) / 2.0);
            curr += legends[i].getPreferredSize().height + margin;
            legends[i].setStartPoint(x, y);
        }
    }

    protected LegendInterface[] getLegends(int position, boolean inside, boolean combo) {
        Vector vec = new Vector();
        block5: for (int i = 0; i < this.legends.size(); ++i) {
            if (((LegendInterface)this.legends.elementAt(i)).isInside() != inside) continue;
            int pos = ((LegendInterface)this.legends.elementAt(i)).getPosition();
            switch (position) {
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    if (position != pos) continue block5;
                    vec.addElement(this.legends.elementAt(i));
                    continue block5;
                }
                case 2: {
                    if (pos != 2 && (!combo || pos != 8) && (!combo || pos != 9)) continue block5;
                    vec.addElement(this.legends.elementAt(i));
                    continue block5;
                }
                case 1: {
                    if (pos != 1 && (!combo || pos != 6) && (!combo || pos != 7)) continue block5;
                    vec.addElement(this.legends.elementAt(i));
                }
            }
        }
        if (vec.size() == 0) {
            return null;
        }
        Object[] rc = new LegendInterface[vec.size()];
        vec.copyInto(rc);
        return rc;
    }

    public Rectangle getChartArea() {
        return this.chartArea;
    }

    public void setComponentXMargin(int componentXMargin) {
        this.silkDefaults.componentXMargin = componentXMargin;
        this.silkDefaults.statgraphComponentXMargin = componentXMargin;
    }

    public void setComponentYMargin(int componentYMargin) {
        this.silkDefaults.componentYMargin = componentYMargin;
        this.silkDefaults.statgraphComponentYMargin = componentYMargin;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }
}

