/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JButton;

public class ImagePreviewButton
extends JButton {
    private static final long serialVersionUID = -5007369810684513763L;
    boolean imageReady = false;
    int displayWidth = -1;
    int displayHeight = -1;
    protected Image originalImage = null;
    protected Image displayImage = null;

    public ImagePreviewButton() {
        this.setSize(464, 280);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        int ix = 0;
        int iy = 0;
        if (g == null) {
            return;
        }
        int cw = this.getWidth();
        int ch = this.getHeight();
        if (this.displayImage == null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, cw, ch);
            return;
        }
        int w = this.displayImage.getWidth(this);
        int h = this.displayImage.getHeight(this);
        if (this.imageReady) {
            if (w > 0 && h > 0) {
                if (w < cw) {
                    ix = (cw - w) / 2;
                }
                if (h < ch) {
                    iy = (ch - h) / 2;
                }
            }
            if (w < cw || h < ch) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, cw, ch);
            }
            g.drawImage(this.displayImage, ix, iy, this);
        }
    }

    public Image getImage() {
        return this.originalImage;
    }

    public boolean setImage(Image imgIn) {
        Rectangle rect = this.getBounds();
        this.originalImage = imgIn;
        this.imageReady = false;
        if (this.originalImage == null || rect == null) {
            this.displayImage = imgIn;
        } else {
            int w = imgIn.getWidth(this);
            int h = imgIn.getHeight(this);
            if (w > 0 && h > 0) {
                if ((double)w > rect.getWidth()) {
                    w = (int)rect.getWidth();
                }
                if ((double)h > rect.getHeight()) {
                    h = (int)rect.getHeight();
                }
                this.displayImage = imgIn.getScaledInstance(w, h, 1);
                this.displayImage.getWidth(this);
            } else {
                this.displayImage = imgIn;
            }
        }
        return true;
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0xC0) != 0) {
            return false;
        }
        if ((flags & 0x20) != 0) {
            if (img == this.displayImage) {
                this.displayImage = img;
                this.imageReady = true;
                this.repaint();
            }
            return false;
        }
        return true;
    }
}

