/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.silk.util.ImageMapArea;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ImageMapGraphicsImpl
extends Graphics2D
implements URLConsumerInterface {
    Graphics componentGraphics = null;
    Vector imageMapAreas = new Vector();
    private Object currentURL = null;
    private String currentAlt = null;

    public ImageMapGraphicsImpl(Graphics g, URLSourceInterface urlSource) {
        this.componentGraphics = g;
    }

    public Element getImageMapHTML() {
        Element rc = null;
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return null;
        }
        rc = document.createElement("Map");
        for (int i = 0; i < this.imageMapAreas.size(); ++i) {
            ImageMapArea ima = (ImageMapArea)this.imageMapAreas.elementAt(i);
            rc.appendChild(ima.toHTML(document));
        }
        return rc;
    }

    @Override
    public void beginURL(Object context, Object url, String alt) {
        this.currentURL = url;
        this.currentAlt = alt;
    }

    @Override
    public void endURL(Object context) {
        this.currentURL = null;
        this.currentAlt = null;
    }

    private void handleShape(Shape s) {
        if (s == null || this.currentURL == null && this.currentAlt == null) {
            return;
        }
        ImageMapArea ima = new ImageMapArea();
        ima.type = 2;
        if (this.currentURL != null) {
            ima.href = this.currentURL.toString();
        }
        if (this.currentAlt != null) {
            ima.alt = this.currentAlt;
        }
        PathIterator pi = s.getPathIterator(this.getTransform());
        FlatteningPathIterator fpi = new FlatteningPathIterator(pi, 0.5, 3);
        double[] coords = new double[6];
        Vector<Point> points = new Vector<Point>();
        while (!fpi.isDone()) {
            int type = fpi.currentSegment(coords);
            if (type == 4) {
                points.addElement(new Point((Point)points.elementAt(0)));
            } else {
                points.addElement(new Point((int)coords[0], (int)coords[1]));
            }
            fpi.next();
        }
        ima.coords = new int[points.size() * 2];
        int i = 0;
        int j = 0;
        while (i < ima.coords.length) {
            Point p = (Point)points.elementAt(j);
            ima.coords[i] = p.x;
            ima.coords[i + 1] = p.y;
            i += 2;
            ++j;
        }
        this.imageMapAreas.addElement(ima);
    }

    private void handleRect(int x, int y, int w, int h) {
        this.handleShape(new Rectangle(x, y, w, h));
    }

    private void handleLine(int x1, int y1, int x2, int y2) {
        Polygon s = new Polygon();
        int quadrant = -1;
        quadrant = x1 == x2 && y1 == y2 ? 1 : (x1 == x2 ? 1 : (y1 == y2 ? 2 : (x2 > x1 && y2 > y1 || x2 < x1 && y2 < y1 ? 3 : 4)));
        switch (quadrant) {
            case 1: {
                s.addPoint(x1 + 1, y1);
                s.addPoint(x2 + 1, y2);
                s.addPoint(x2 - 1, y2);
                s.addPoint(x1 - 1, y1);
                break;
            }
            case 2: {
                s.addPoint(x1, y1 + 1);
                s.addPoint(x2, y2 + 1);
                s.addPoint(x2, y2 - 1);
                s.addPoint(x1, y1 - 1);
                break;
            }
            case 3: {
                s.addPoint(x1 - 1, y1 - 1);
                s.addPoint(x1 + 1, y1 + 1);
                s.addPoint(x2 + 1, y2 + 1);
                s.addPoint(x2 - 1, y1 - 1);
                break;
            }
            case 4: {
                s.addPoint(x1 + 1, y1 - 1);
                s.addPoint(x2 + 1, y2 - 1);
                s.addPoint(x2 - 1, y2 + 1);
                s.addPoint(x1 - 1, y1 + 1);
            }
        }
        this.handleShape(s);
        if (this.componentGraphics != null) {
            ((Graphics2D)this.componentGraphics).fill(s);
        }
    }

    public void addRenderingHints(Map arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).addRenderingHints(arg0);
        }
    }

    @Override
    public void clip(Shape arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).clip(arg0);
        }
    }

    @Override
    public void draw(Shape arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).draw(arg0);
        }
        this.handleShape(arg0);
    }

    @Override
    public void draw3DRect(int arg0, int arg1, int arg2, int arg3, boolean arg4) {
        if (this.componentGraphics != null) {
            this.componentGraphics.draw3DRect(arg0, arg1, arg2, arg3, arg4);
        }
        this.handleRect(arg0, arg1, arg2, arg3);
    }

    @Override
    public void drawGlyphVector(GlyphVector arg0, float arg1, float arg2) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawGlyphVector(arg0, arg1, arg2);
        }
    }

    @Override
    public void drawImage(BufferedImage arg0, BufferedImageOp arg1, int arg2, int arg3) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawImage(arg0, arg1, arg2, arg3);
        }
        if (arg1 != null) {
            this.handleRect(arg2, arg3, (int)arg1.getBounds2D(arg0).getWidth(), (int)arg1.getBounds2D(arg0).getHeight());
        } else if (arg0 != null) {
            this.handleRect(arg2, arg3, arg0.getWidth(), arg0.getHeight());
        }
    }

    @Override
    public boolean drawImage(Image arg0, AffineTransform arg1, ImageObserver arg2) {
        boolean rc = false;
        if (this.componentGraphics instanceof Graphics2D) {
            rc = ((Graphics2D)this.componentGraphics).drawImage(arg0, arg1, arg2);
        }
        Rectangle r = new Rectangle(0, 0, arg0.getWidth(arg2), arg0.getHeight(arg2));
        if (arg1 != null) {
            Point p1 = r.getLocation();
            Point p2 = new Point(p1.x + r.width, p1.y + r.height);
            Point p3 = new Point();
            Point p4 = new Point();
            arg1.transform(p1, p3);
            arg1.transform(p2, p4);
            this.handleRect(p3.x, p3.y, p4.x - p3.x, p4.y - p3.y);
        } else {
            this.handleRect(r.x, r.y, r.width, r.height);
        }
        return rc;
    }

    @Override
    public void drawRenderableImage(RenderableImage arg0, AffineTransform arg1) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawRenderableImage(arg0, arg1);
        }
    }

    @Override
    public void drawRenderedImage(RenderedImage arg0, AffineTransform arg1) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawRenderedImage(arg0, arg1);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator arg0, float arg1, float arg2) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawString(arg0, arg1, arg2);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator arg0, int arg1, int arg2) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawString(arg0, arg1, arg2);
        }
    }

    @Override
    public void drawString(String arg0, float arg1, float arg2) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawString(arg0, arg1, arg2);
        }
    }

    @Override
    public void drawString(String arg0, int arg1, int arg2) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).drawString(arg0, arg1, arg2);
        }
    }

    @Override
    public void fill(Shape arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).fill(arg0);
        }
        this.handleShape(arg0);
    }

    @Override
    public void fill3DRect(int arg0, int arg1, int arg2, int arg3, boolean arg4) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fill3DRect(arg0, arg1, arg2, arg3, arg4);
        }
        this.handleRect(arg0, arg1, arg2, arg3);
    }

    @Override
    public Color getBackground() {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getBackground();
        }
        return null;
    }

    @Override
    public Composite getComposite() {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getComposite();
        }
        return null;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getDeviceConfiguration();
        }
        return null;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getFontRenderContext();
        }
        return new FontRenderContext(null, true, true);
    }

    @Override
    public Paint getPaint() {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getPaint();
        }
        return null;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getRenderingHint(arg0);
        }
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getRenderingHints();
        }
        return null;
    }

    @Override
    public Stroke getStroke() {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).getStroke();
        }
        return null;
    }

    @Override
    public AffineTransform getTransform() {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).getTransform();
        }
        return new AffineTransform();
    }

    @Override
    public boolean hit(Rectangle arg0, Shape arg1, boolean arg2) {
        if (this.componentGraphics instanceof Graphics2D) {
            return ((Graphics2D)this.componentGraphics).hit(arg0, arg1, arg2);
        }
        return false;
    }

    @Override
    public void rotate(double arg0, double arg1, double arg2) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).rotate(arg0, arg1, arg2);
        }
    }

    @Override
    public void rotate(double arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).rotate(arg0);
        }
    }

    @Override
    public void scale(double arg0, double arg1) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).scale(arg0, arg1);
        }
    }

    @Override
    public void setBackground(Color arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).setBackground(arg0);
        }
    }

    @Override
    public void setComposite(Composite arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).setComposite(arg0);
        }
    }

    @Override
    public void setPaint(Paint arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).setPaint(arg0);
        }
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).setRenderingHint(arg0, arg1);
        }
    }

    public void setRenderingHints(Map arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).setRenderingHints(arg0);
        }
    }

    @Override
    public void setStroke(Stroke arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).setStroke(arg0);
        }
    }

    @Override
    public void setTransform(AffineTransform arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).setTransform(arg0);
        }
    }

    @Override
    public void shear(double arg0, double arg1) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).shear(arg0, arg1);
        }
    }

    @Override
    public void transform(AffineTransform arg0) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).transform(arg0);
        }
    }

    @Override
    public void translate(double arg0, double arg1) {
        if (this.componentGraphics instanceof Graphics2D) {
            ((Graphics2D)this.componentGraphics).translate(arg0, arg1);
        }
    }

    @Override
    public void translate(int arg0, int arg1) {
        if (this.componentGraphics != null) {
            this.componentGraphics.translate(arg0, arg1);
        }
    }

    @Override
    public void clearRect(int arg0, int arg1, int arg2, int arg3) {
        if (this.componentGraphics != null) {
            this.componentGraphics.clearRect(arg0, arg1, arg2, arg3);
        }
    }

    @Override
    public void clipRect(int arg0, int arg1, int arg2, int arg3) {
        if (this.componentGraphics != null) {
            this.componentGraphics.clipRect(arg0, arg1, arg2, arg3);
        }
    }

    @Override
    public void copyArea(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        if (this.componentGraphics != null) {
            this.componentGraphics.copyArea(arg0, arg1, arg2, arg3, arg4, arg5);
        }
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public Graphics create(int arg0, int arg1, int arg2, int arg3) {
        return null;
    }

    @Override
    public void dispose() {
        if (this.componentGraphics != null) {
            this.componentGraphics.dispose();
        }
    }

    @Override
    public void drawArc(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawArc(arg0, arg1, arg2, arg3, arg4, arg5);
        }
        Arc2D.Double arc = new Arc2D.Double(arg0, arg1, arg2, arg3, arg4, arg5, 2);
        this.handleShape(arc);
    }

    @Override
    public void drawBytes(byte[] arg0, int arg1, int arg2, int arg3, int arg4) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawBytes(arg0, arg1, arg2, arg3, arg4);
        }
    }

    @Override
    public void drawChars(char[] arg0, int arg1, int arg2, int arg3, int arg4) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawChars(arg0, arg1, arg2, arg3, arg4);
        }
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, Color arg3, ImageObserver arg4) {
        this.handleRect(arg1, arg2, arg0.getWidth(arg4), arg0.getHeight(arg4));
        if (this.componentGraphics != null) {
            return this.componentGraphics.drawImage(arg0, arg1, arg2, arg3, arg4);
        }
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, ImageObserver arg3) {
        this.handleRect(arg1, arg2, arg0.getWidth(arg3), arg0.getHeight(arg3));
        if (this.componentGraphics != null) {
            return this.componentGraphics.drawImage(arg0, arg1, arg2, arg3);
        }
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, Color arg5, ImageObserver arg6) {
        this.handleRect(arg1, arg2, arg3, arg4);
        if (this.componentGraphics != null) {
            return this.componentGraphics.drawImage(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, ImageObserver arg5) {
        this.handleRect(arg1, arg2, arg3, arg4);
        if (this.componentGraphics != null) {
            return this.componentGraphics.drawImage(arg0, arg1, arg2, arg3, arg4, arg5);
        }
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.handleRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.handleRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void drawLine(int arg0, int arg1, int arg2, int arg3) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawLine(arg0, arg1, arg2, arg3);
        }
        this.handleLine(arg0, arg1, arg2, arg3);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawOval(x, y, width, height);
        }
        this.handleShape(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawPolygon(int[] arg0, int[] arg1, int arg2) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fillPolygon(arg0, arg1, arg2);
        }
        Polygon p = new Polygon(arg0, arg1, arg2);
        this.handleShape(p);
    }

    @Override
    public void drawPolygon(Polygon arg0) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawPolygon(arg0);
        }
        this.handleShape(arg0);
    }

    @Override
    public void drawPolyline(int[] arg0, int[] arg1, int arg2) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawPolyline(arg0, arg1, arg2);
        }
    }

    @Override
    public void drawRect(int arg0, int arg1, int arg2, int arg3) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawRect(arg0, arg1, arg2, arg3);
        }
        this.handleRect(arg0, arg1, arg2, arg3);
    }

    @Override
    public void drawRoundRect(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        if (this.componentGraphics != null) {
            this.componentGraphics.drawRoundRect(arg0, arg1, arg2, arg3, arg4, arg5);
        }
        this.handleRect(arg0, arg1, arg2, arg3);
    }

    @Override
    public void fillArc(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fillArc(arg0, arg1, arg2, arg3, arg4, arg5);
        }
        Arc2D.Double arc = new Arc2D.Double(arg0, arg1, arg2, arg3, arg4, arg5, 2);
        this.handleShape(arc);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fillOval(x, y, width, height);
        }
        this.handleShape(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillPolygon(int[] arg0, int[] arg1, int arg2) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fillPolygon(arg0, arg1, arg2);
        }
        Polygon p = new Polygon(arg0, arg1, arg2);
        this.handleShape(p);
    }

    @Override
    public void fillPolygon(Polygon arg0) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fillPolygon(arg0);
        }
        this.handleShape(arg0);
    }

    @Override
    public void fillRect(int arg0, int arg1, int arg2, int arg3) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fillRect(arg0, arg1, arg2, arg3);
        }
        this.handleRect(arg0, arg1, arg2, arg3);
    }

    @Override
    public void fillRoundRect(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        if (this.componentGraphics != null) {
            this.componentGraphics.fillRoundRect(arg0, arg1, arg2, arg3, arg4, arg5);
        }
        this.handleRect(arg0, arg1, arg2, arg3);
    }

    @Override
    @SuppressWarnings(value={"FI_PUBLIC_SHOULD_BE_PROTECTED"}, justification="Cannot change the visiblity as the class extends the java.awt.Graphics class that defines the finalize() method as public")
    public void finalize() {
        if (this.componentGraphics != null) {
            this.componentGraphics.finalize();
        }
        super.finalize();
    }

    @Override
    public Shape getClip() {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getClip();
        }
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getClipBounds();
        }
        return null;
    }

    @Override
    public Rectangle getClipBounds(Rectangle arg0) {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getClipBounds(arg0);
        }
        return null;
    }

    @Override
    public Rectangle getClipRect() {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getClipRect();
        }
        return null;
    }

    @Override
    public Color getColor() {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getColor();
        }
        return null;
    }

    @Override
    public Font getFont() {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getFont();
        }
        return null;
    }

    @Override
    public FontMetrics getFontMetrics() {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getFontMetrics();
        }
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font arg0) {
        if (this.componentGraphics != null) {
            return this.componentGraphics.getFontMetrics(arg0);
        }
        return null;
    }

    @Override
    public boolean hitClip(int arg0, int arg1, int arg2, int arg3) {
        if (this.componentGraphics != null) {
            return this.componentGraphics.hitClip(arg0, arg1, arg2, arg3);
        }
        return false;
    }

    @Override
    public void setClip(int arg0, int arg1, int arg2, int arg3) {
        if (this.componentGraphics != null) {
            this.componentGraphics.setClip(arg0, arg1, arg2, arg3);
        }
    }

    @Override
    public void setClip(Shape arg0) {
        if (this.componentGraphics != null) {
            this.componentGraphics.setClip(arg0);
        }
    }

    @Override
    public void setColor(Color arg0) {
        if (this.componentGraphics != null) {
            this.componentGraphics.setColor(arg0);
        }
    }

    @Override
    public void setFont(Font arg0) {
        if (this.componentGraphics != null) {
            this.componentGraphics.setFont(arg0);
        }
    }

    @Override
    public void setPaintMode() {
        if (this.componentGraphics != null) {
            this.componentGraphics.setPaintMode();
        }
    }

    @Override
    public void setXORMode(Color arg0) {
        if (this.componentGraphics != null) {
            this.componentGraphics.setXORMode(arg0);
        }
    }

    @Override
    public String toString() {
        return ParserUtils.toString((Node)this.getImageMapHTML());
    }
}

