/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyMulticaster;
import java.awt.Component;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;

public class GraphGroup {
    private SILKToolbar toolbar = null;
    private Vector graphs = new Vector();
    private TabbedPropertiesDialog propertiesDialog = null;
    private RangeMerger merger = null;

    public int size() {
        if (this.graphs == null) {
            return 0;
        }
        return this.graphs.size();
    }

    public boolean mergeRanges(int type) {
        if (this.merger != null) {
            return false;
        }
        this.merger = new RangeMerger(type);
        this.merger.addRangeItems(this.graphs);
        return true;
    }

    public void dispose() {
        if (this.toolbar != null) {
            this.toolbar.dispose();
        }
        this.graphs.removeAllElements();
        this.graphs = null;
        this.propertiesDialog = null;
    }

    public boolean addChart(Object chart) {
        if (chart == null) {
            return false;
        }
        this.graphs.addElement(chart);
        if (this.toolbar != null && chart instanceof GraphInterface) {
            this.toolbar.addListener((GraphInterface)chart);
        }
        return true;
    }

    public SILKToolbar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new SILKToolbar(null);
            for (int i = 0; i < this.graphs.size(); ++i) {
                if (!(this.graphs.elementAt(i) instanceof GraphInterface)) continue;
                this.toolbar.addListener((GraphInterface)this.graphs.elementAt(i));
            }
        }
        return this.toolbar;
    }

    public Enumeration graphs() {
        return this.graphs.elements();
    }

    public PropertyMulticaster getMulticaster() {
        if (this.size() == 0) {
            return null;
        }
        PropertyMulticaster pm = null;
        for (int i = 0; i < this.graphs.size() && this.graphs.elementAt(i) instanceof PropertyInterface; ++i) {
            if (pm == null) {
                pm = new PropertyMulticaster((PropertyInterface)this.graphs.elementAt(i));
                continue;
            }
            pm.addListener((PropertyInterface)this.graphs.elementAt(i));
        }
        return pm;
    }

    public TabbedPropertiesDialog getPropertyDialog(Frame parentFrame, Component component, Object listener) {
        return this.getPropertyDialog(parentFrame, component, listener, null);
    }

    public TabbedPropertiesDialog getPropertyDialog(Frame parentFrame, Component component, Object listener, Object tabs) {
        if (this.size() == 0) {
            return null;
        }
        if (this.propertiesDialog != null) {
            return this.propertiesDialog;
        }
        Component c = component;
        if (listener != null && listener instanceof Component) {
            c = (Component)listener;
        }
        this.propertiesDialog = new TabbedPropertiesDialog(parentFrame, c, ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.silk_NLS", (String)"SILKComponent.Properties.txt", (String)"Properties"));
        if (tabs == null) {
            tabs = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(5)};
        }
        Enumeration e = Extract.elements((Object)tabs);
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof Number)) continue;
            int tab = ((Number)obj).intValue();
            for (int i = 0; i < this.graphs.size(); ++i) {
                if (!(this.graphs.elementAt(i) instanceof ComponentInterface)) continue;
                ((ComponentInterface)this.graphs.elementAt(i)).addTabs("Properties", this.propertiesDialog, tab);
            }
        }
        return this.propertiesDialog;
    }
}

