/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.CompoundText;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.TitleDefaults;
import java.awt.Color;

public class Footnote
extends CompoundText {
    public static final int NUM_FOOTNOTES = 5;
    public int MIN_FOOTNOTE_SIZE;
    public int MAX_FOOTNOTE_SIZE;
    public int FOOTNOTE_SUPPRESSION_SIZE;
    public double FOOTNOTE_FRACTION;
    public double adjustFactor;

    public Footnote(Color c) {
        super(c, 5, 1);
        TitleDefaults td = new TitleDefaults();
        this.adjustFactor = td.fontSizeAdjust;
        this.MIN_FOOTNOTE_SIZE = td.fnMinAdjustedFontSize;
        this.MAX_FOOTNOTE_SIZE = td.fnMaxAdjustedFontSize;
        this.FOOTNOTE_SUPPRESSION_SIZE = td.footnoteSuppressSize;
        this.FOOTNOTE_FRACTION = td.footnoteFraction;
        for (int i = 0; i < this.texts.length; ++i) {
            ((Text)this.texts[i]).setFormatSupported(false);
            this.texts[i].setVisible(false);
            if (SILKGlobal.isFlagSet(4)) {
                ((Text)this.texts[i]).setJustification(0, this.texts[i].getVerticalJustification());
            }
            ((Text)this.texts[i]).setCurrentValueAsDefault(9000);
        }
    }

    public Footnote() {
        this(null);
    }

    public TextStyleInterface getFootnote(int idx) {
        return this.getText(idx);
    }

    public boolean setFootnote(int idx, String textString) {
        if (idx < 0 || idx >= 5) {
            return false;
        }
        return this.setText(idx, textString);
    }

    public boolean setFootnote(int idx, TextStyleInterface textObj) {
        if (idx < 0 || idx >= 5) {
            return false;
        }
        if (this.defaultFonts[idx] == null) {
            if (textObj != null && textObj instanceof Text && !((Text)textObj).isDefaultFont()) {
                this.userSetFont[idx] = true;
            }
        } else if (textObj != null && textObj.getFont() != null && !textObj.getFont().equals(this.defaultFonts[idx])) {
            this.userSetFont[idx] = true;
        }
        this.setText(idx, textObj);
        return true;
    }

    @Override
    protected int getFontSize(int idx, int origialSize) {
        int size = 0;
        if (this.compBounds == null || this.compBounds.height <= 0 || UIUtilities.useStyleFontSizes()) {
            size = origialSize;
        } else {
            int ht = this.compBounds.height;
            switch (idx) {
                case 0: 
                case 1: {
                    size = (int)((double)ht * this.FOOTNOTE_FRACTION * this.adjustFactor);
                    size = size < this.FOOTNOTE_SUPPRESSION_SIZE ? -1 : Math.max(this.MIN_FOOTNOTE_SIZE, Math.min(size, this.MAX_FOOTNOTE_SIZE));
                }
            }
        }
        return size;
    }
}

