/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.CompositeChartPrintInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class CompositePrintDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 2653751406878224827L;
    CompositeChartPrintInterface composite = null;
    JRadioButton onePage = null;
    JRadioButton chartPerPage = null;
    JRadioButton spanPages = null;
    JRadioButton bookFormat = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");
    JButton okButton = null;
    JButton cancelButton = null;
    JButton printPreviewButton = null;
    JPanel panel = null;
    JPanel okPanel = null;
    boolean cancelled = true;
    boolean isPreviewMode = false;

    public CompositePrintDialog() {
        this.onePage = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.Print_to_one_page.txt", (String)"Print to one page"));
        this.onePage.addActionListener(this);
        this.chartPerPage = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.Print_chart_per_page.txt", (String)"Print each chart to a seperate page"));
        this.chartPerPage.addActionListener(this);
        this.spanPages = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.Print_same_size.txt", (String)"Print same size as screen (may span multiple pages)"));
        this.spanPages.addActionListener(this);
        this.bookFormat = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.Print_book_format.txt", (String)"Print in Book Format"));
        this.bookFormat.addActionListener(this);
        this.okButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.ok.txt", (String)"OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.cancel.txt", (String)"Cancel"));
        this.cancelButton.addActionListener(this);
        this.printPreviewButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.printPreview.txt", (String)"Print Preview"));
        this.printPreviewButton.addActionListener(this);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(BorderFactory.createEtchedBorder());
        optionPanel.setLayout(new BoxLayout(optionPanel, 1));
        optionPanel.add(this.onePage);
        optionPanel.add(this.chartPerPage);
        optionPanel.add(this.spanPages);
        optionPanel.add(this.bookFormat);
        this.okPanel = new JPanel(new FlowLayout(2));
        this.okPanel.add(this.okButton);
        this.okPanel.add(this.printPreviewButton);
        this.okPanel.add(this.cancelButton);
        this.okPanel.setSize(375, 30);
        this.panel.add((Component)optionPanel, "Center");
        this.panel.add((Component)this.okPanel, "South");
        this.getContentPane().add(this.panel);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.onePage);
        bg.add(this.chartPerPage);
        bg.add(this.spanPages);
        bg.add(this.bookFormat);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"CompositePrintDialog.Dialog_Title.txt", (String)"Select a print mode"));
        this.setModal(true);
        this.setSize(375, 200);
        UIUtilities.center(this);
    }

    public void showDialog(CompositeChartPrintInterface compositeIn) {
        if (compositeIn == null) {
            return;
        }
        this.composite = compositeIn;
        this.initFromSource();
        this.cancelled = true;
        this.setVisible(true);
    }

    private void initFromSource() {
        if (this.composite == null) {
            return;
        }
        int mode = this.composite.getPrintMode();
        this.printPreviewButton.setEnabled(false);
        switch (mode) {
            case 1: {
                this.spanPages.setSelected(true);
                break;
            }
            case 2: {
                this.chartPerPage.setSelected(true);
                break;
            }
            case 3: {
                this.onePage.setSelected(true);
                break;
            }
            case 4: {
                this.bookFormat.setSelected(true);
                this.printPreviewButton.setEnabled(true);
            }
        }
        this.onePage.setEnabled(false);
        this.chartPerPage.setEnabled(false);
        this.spanPages.setEnabled(false);
        this.bookFormat.setEnabled(false);
        int[] supportedPrintModes = this.composite.getSupportedPrintModes();
        if (supportedPrintModes == null) {
            this.onePage.setEnabled(true);
            this.chartPerPage.setEnabled(true);
            this.spanPages.setEnabled(true);
            this.bookFormat.setEnabled(true);
        } else {
            block12: for (int i = 0; i < supportedPrintModes.length; ++i) {
                switch (supportedPrintModes[i]) {
                    case 3: {
                        this.onePage.setEnabled(true);
                        continue block12;
                    }
                    case 2: {
                        this.chartPerPage.setEnabled(true);
                        continue block12;
                    }
                    case 1: {
                        this.spanPages.setEnabled(true);
                        continue block12;
                    }
                    case 4: {
                        this.bookFormat.setEnabled(true);
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.setVisible(false);
            this.cancelled = false;
            this.isPreviewMode = false;
        }
        if (source == this.printPreviewButton) {
            this.setVisible(false);
            this.cancelled = false;
            this.isPreviewMode = true;
        } else if (source == this.cancelButton) {
            this.setVisible(false);
        } else if (source == this.spanPages) {
            this.composite.setPrintMode(1);
        } else if (source == this.chartPerPage) {
            this.composite.setPrintMode(2);
        } else if (source == this.onePage) {
            this.composite.setPrintMode(3);
        } else if (source == this.bookFormat) {
            this.composite.setPrintMode(4);
        }
        this.initFromSource();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isPreview() {
        return this.isPreviewMode;
    }
}

