/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.StyleElement;
import java.awt.Color;

public class ColorScheme
implements ColorSchemeInterface {
    private Style style = null;
    private static Style defaultStyle = PredefinedStyles.getPredefinedStyle((String)"Default");

    public ColorScheme(String resourceName, String schemeName, Color[] customDataColors, Color[] customItemColors) {
    }

    public ColorScheme(String schemeName, Color[] customDataColors, Color[] customItemColors) {
    }

    public ColorScheme(String resourceName, String schemeName) {
    }

    public ColorScheme(Style style) {
        this.style = style;
        if (style == null) {
            this.style = ((StyleCollection)SILKGlobal.getInstance().getPropertyValue(48)).getStyle("SILKDefault");
        }
    }

    public ColorScheme(String schemeName) {
        this(((StyleCollection)SILKGlobal.getInstance().getPropertyValue(48)).getStyle(schemeName));
    }

    public ColorScheme(ColorScheme someScheme) {
    }

    public ColorScheme() {
        this("Default");
    }

    @Override
    public String getSchemeName() {
        if (this.style == null) {
            return null;
        }
        return this.style.getSchemeName();
    }

    @Override
    public boolean setSchemeName(String nameIn) {
        if (this.style == null) {
            return false;
        }
        this.style.setSchemeName(nameIn);
        return true;
    }

    @Override
    public String getSchemeDisplayName() {
        if (this.style == null) {
            return null;
        }
        return this.style.getDisplayName();
    }

    @Override
    public boolean setSchemeDisplayName(String displayIn) {
        return false;
    }

    @Override
    public Color[] getDataColors(boolean copy) {
        return this.getDataColors(copy, false);
    }

    @Override
    public Color[] getDataColors(boolean copy, boolean contrast) {
        if (this.style == null) {
            return null;
        }
        if (contrast) {
            return this.style.getDataLineColors();
        }
        return this.style.getDataFillColors();
    }

    @Override
    public boolean setDataColors(Object colors, boolean contrast) {
        return false;
    }

    @Override
    public Color[] getItemColors(boolean copy) {
        return null;
    }

    @Override
    public boolean setItemColors(Object colors) {
        return false;
    }

    @Override
    public Color[] getRampColors(boolean copy) {
        return this.getRampColors(copy, false, false);
    }

    @Override
    public Color[] getRampColors(boolean copy, boolean contrast, boolean alt) {
        if (this.style == null) {
            return null;
        }
        StyleElement rse = null;
        String name = null;
        name = contrast && alt ? "ThreeColorAltRamp" : (contrast ? "ThreeColorRamp" : (alt ? "ThreeColorAltRamp" : "ThreeColorRamp"));
        rse = this.style.getStyleElement(name);
        if (rse == null) {
            rse = defaultStyle.getStyleElement(name);
        }
        if (rse == null) {
            return null;
        }
        rse = rse.getAsRampStyle();
        return ((RampStyleElement)rse).getColors();
    }

    @Override
    public boolean setRampColors(Object colors, boolean contrast, boolean alt) {
        return false;
    }

    @Override
    public ColorInterface getRamp(boolean contrast, boolean alt) {
        Color[] clrs = this.getRampColors(false, contrast, alt);
        return new ColorRamp((Object)clrs, new Double(0.0), new Double(1.0), 0L);
    }

    @Override
    public boolean setRamp(ColorInterface ramp, boolean contrast, boolean alt) {
        return false;
    }

    @Override
    public Color getColorSchemeItemColor(int item) {
        if (this.style == null) {
            return null;
        }
        StyleElement se = null;
        Color rc = null;
        switch (item) {
            case 0: {
                se = this.style.getStyleElement("AxisLines");
                if (se == null || se.getAsLineStyle().getLineColor() == null) {
                    se = defaultStyle.getStyleElement("AxisLines");
                }
                if (se == null) break;
                rc = se.getAsLineStyle().getLineColor();
                break;
            }
            case 1: {
                se = this.style.getStyleElement("Backfill");
                if (se == null || se.getAsFillStyle().getFillColor() == null) {
                    se = defaultStyle.getStyleElement("Backfill");
                }
                if (se == null) break;
                rc = se.getAsFillStyle().getFillColor();
                break;
            }
            case 2: {
                se = this.style.getStyleElement("BorderLines");
                if (se == null || se.getAsLineStyle().getLineColor() == null) {
                    se = defaultStyle.getStyleElement("BorderLines");
                }
                if (se == null) break;
                rc = se.getAsLineStyle().getLineColor();
                break;
            }
            case 3: {
                se = this.style.getStyleElement("FloorFill");
                if (se == null || se.getAsFillStyle().getFillColor() == null) {
                    se = defaultStyle.getStyleElement("FloorFill");
                }
                if (se == null) break;
                rc = se.getAsFillStyle().getFillColor();
                break;
            }
            case 4: {
                se = this.style.getStyleElement("GridLines");
                if (se == null || se.getAsLineStyle().getLineColor() == null) {
                    se = defaultStyle.getStyleElement("GridLines");
                }
                if (se == null) break;
                rc = se.getAsLineStyle().getLineColor();
                break;
            }
            case 5: {
                se = this.style.getStyleElement("LegendFill");
                if (se == null || se.getAsFillStyle().getFillColor() == null) {
                    se = defaultStyle.getStyleElement("LegendFill");
                }
                if (se == null) break;
                rc = se.getAsFillStyle().getFillColor();
                break;
            }
            case 6: {
                se = this.style.getStyleElement("Outlines");
                if (se == null || se.getAsLineStyle().getLineColor() == null) {
                    se = defaultStyle.getStyleElement("Outlines");
                }
                if (se == null) break;
                rc = se.getAsLineStyle().getLineColor();
                break;
            }
            case 7: {
                rc = this.style.getFillStyleElement("RangeFill").getFillColor();
                double trans = this.style.getStyleElement("RangeFill").getDoubleAttribute("transparency", 0.5);
                rc = new Color(rc.getRed(), rc.getGreen(), rc.getBlue(), (int)(255.0 * trans));
                break;
            }
            case 8: {
                se = this.style.getStyleElement("Selection");
                if (se == null || se.getAsFillStyle().getFillColor() == null) {
                    se = defaultStyle.getStyleElement("Selection");
                }
                if (se == null) break;
                rc = se.getAsFillStyle().getFillColor();
                break;
            }
            case 9: {
                rc = new Color(128, 128, 128);
                break;
            }
            case 10: {
                rc = new Color(242, 242, 223);
                break;
            }
            case 11: {
                se = this.style.getStyleElement("LabelText");
                if (se == null || se.getAsTextStyle().getTextColor() == null) {
                    se = defaultStyle.getStyleElement("LabelText");
                }
                if (se == null) break;
                rc = se.getAsTextStyle().getTextColor();
                break;
            }
            case 12: {
                se = this.style.getStyleElement("ValueText");
                if (se == null || se.getAsTextStyle().getTextColor() == null) {
                    se = defaultStyle.getStyleElement("ValueText");
                }
                if (se == null) break;
                rc = se.getAsTextStyle().getTextColor();
                break;
            }
            case 13: {
                se = this.style.getStyleElement("TitleText");
                if (se == null || se.getAsTextStyle().getTextColor() == null) {
                    se = defaultStyle.getStyleElement("TitleText");
                }
                if (se == null) break;
                rc = se.getAsTextStyle().getTextColor();
                break;
            }
            case 14: {
                rc = new Color(242, 242, 223);
                break;
            }
            case 15: {
                se = this.style.getStyleElement("WallFill");
                if (se == null || se.getAsFillStyle().getFillColor() == null) {
                    se = defaultStyle.getStyleElement("WallFill");
                }
                if (se == null) break;
                rc = se.getAsFillStyle().getFillColor();
                break;
            }
            case 16: {
                se = this.style.getStyleElement("GraphDataStyleDefault");
                if (se == null || se.getAsDataStyle().getFillColor() == null) {
                    se = defaultStyle.getStyleElement("GraphDataStyleDefault");
                }
                if (se == null) break;
                rc = se.getAsDataStyle().getFillColor();
                break;
            }
            case 17: {
                se = this.style.getStyleElement("GraphDataStyleDefault");
                if (se == null || se.getAsDataStyle().getContrastColor() == null) {
                    se = defaultStyle.getStyleElement("GraphDataStyleDefault");
                }
                if (se == null) break;
                rc = se.getAsDataStyle().getContrastColor();
                break;
            }
            case 18: {
                rc = new Color(0, 0, 176);
                break;
            }
            case 19: {
                rc = new Color(128, 128, 0);
            }
        }
        return rc;
    }

    @Override
    public boolean setColorSchemeItemColor(int item, Object color) {
        return false;
    }

    @Override
    public Color getColorSchemeItemColorByName(String item) {
        return null;
    }

    @Override
    public boolean setColorSchemeItemColorByName(String name, Object color) {
        return false;
    }

    @Override
    public Style getStyle() {
        return this.style == null ? defaultStyle : this.style;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColorSchemeInterface)) {
            return false;
        }
        return this.getSchemeDisplayName().equals(((ColorSchemeInterface)o).getSchemeDisplayName());
    }

    public String toString() {
        if (this.style != null) {
            return this.style.toString();
        }
        return super.toString();
    }
}

