/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.xml.GraphParserUtils;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Clone {
    public static Object clone(Object o) {
        Object rc = null;
        try {
            rc = o.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        Hashtable<String, Object> context = new Hashtable<String, Object>();
        if (rc instanceof BaseElementComponent) {
            BaseElementComponent bec1 = (BaseElementComponent)o;
            BaseElementComponent bec2 = rc;
            BaseElement[] oldCharts = bec2.getCharts();
            for (int i = 0; i < oldCharts.length; ++i) {
                BaseElement element = oldCharts[i];
                element.dispose();
            }
            bec2.removeAllCharts();
            BaseElement[] elements = bec1.getCharts();
            for (int i = 0; i < elements.length; ++i) {
                BaseElement element = elements[i];
                Object[] dataIds = element.getDataIds();
                if (dataIds == null) {
                    Object data = element.getDataSource();
                    String name = ParserUtils.getNameForDataObject((Object)data, context);
                    context.put(name, data);
                    SILKParser.addData(context, name);
                    continue;
                }
                for (int j = 0; j < dataIds.length; ++j) {
                    Object data = element.getDataSource(dataIds[j]);
                    String name = ParserUtils.getNameForDataObject((Object)data, context);
                    context.put(name, data);
                    SILKParser.addData(context, name);
                }
            }
        }
        if (rc instanceof SourceInterface) {
            SourceInterface original = (SourceInterface)o;
            SourceInterface clone = rc;
            Object[] dataIds = original.getDataIds();
            if (dataIds == null) {
                clone.setDataSource(original.getDataSource());
            } else {
                for (int i = 0; i < dataIds.length; ++i) {
                    Object data;
                    if (dataIds[i] == null || (data = original.getDataSource(dataIds[i])) == null) continue;
                    String name = ParserUtils.getNameForDataObject((Object)data, context);
                    context.put(name, data);
                    SILKParser.addData(context, name);
                    clone.setDataSource(data, dataIds[i]);
                }
            }
        }
        context.put("SCRIPT_ROLES", new Boolean(true));
        context.put("SCRIPT_STATGRAPH", new Boolean(false));
        Element elem = SILKParser.getXMLElement(context, o, true);
        String xml = null;
        if (elem != null) {
            if (elem.hasAttribute("name")) {
                elem.removeAttribute("name");
            }
            xml = GraphParserUtils.toString((Node)elem);
        }
        SILKParser.initComponentFromXML(rc, xml, context);
        return rc;
    }
}

