/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.data.UniqueValueInterface;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.UniqueValueMapper;
import java.util.LinkedHashMap;

public class CharacterVariableMapper
implements DataFilterListenerInterface {
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DATA = 0;
    public static final int SORT_DESCENDING = -1;
    public static final int SORT_CUSTOM = -3;
    public static final int SORT_NONE = -2;
    protected boolean prepareCallRequired;
    private LinkedHashMap values = null;
    private LinkedHashMap indicies = null;
    private int sort = 0;
    private DataFilterReadInterface dfri = null;
    private Object variable = null;
    private boolean includeMissing = true;
    private boolean rebuildList = false;
    Object lock = new Object();

    public CharacterVariableMapper() {
        this.prepareCallRequired = false;
        this.values = new LinkedHashMap();
        this.indicies = new LinkedHashMap();
    }

    public CharacterVariableMapper(DataFilterReadInterface dfri, Object variableId) {
        this.dfri = dfri;
        this.variable = variableId;
        if (this.dfri != null) {
            this.dfri.addDataFilterListener((Object)this);
        }
        this.buildList();
    }

    public CharacterVariableMapper(DataFilterReadInterface dfri, Object variableId, int sort) {
        this.dfri = dfri;
        this.variable = variableId;
        this.sort = sort;
        if (this.dfri != null) {
            this.dfri.addDataFilterListener((Object)this);
        }
        this.buildList();
    }

    public void setVariable(Object varId) {
        this.variable = varId;
        this.rebuildList = true;
        this.buildList();
        this.rebuildList = false;
    }

    public Object getVariable() {
        return this.variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(Object value) {
        Object object = this.lock;
        synchronized (object) {
            Object o;
            if (this.values != null && this.values.containsKey(value) && (o = this.values.get(value)) instanceof Integer) {
                return (Integer)o;
            }
        }
        return -1;
    }

    public Object getValue(int index) {
        if (this.indicies != null && this.indicies.containsKey(new Integer(index))) {
            return this.indicies.get(new Integer(index));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildList() {
        if (this.dfri == null || this.variable == null) {
            return;
        }
        if (!(this.rebuildList || -3 != this.sort && -2 != this.sort)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Object[] values;
            this.removeAllValues();
            UniqueValueMapper uvm = new UniqueValueMapper();
            UniqueValueInterface uvi = (UniqueValueInterface)this.dfri.getAdapter(UniqueValueInterface.class);
            if (uvi != null && !this.includeMissing) {
                Object[] uv;
                boolean includeMissingDisc = true;
                Object o = SILKGlobal.getInstance().getPropertyValue(73);
                if (o instanceof Boolean) {
                    includeMissingDisc = (Boolean)o;
                }
                if ((uv = uvi.getUniqueValues(this.variable, true, Integer.MAX_VALUE, includeMissingDisc)) != null) {
                    for (int i = 0; i < uv.length; ++i) {
                        uvm.addValue(uv[i]);
                    }
                }
            } else if (this.dfri instanceof DataFilterInfoInterface) {
                Object[] uv = ((DataFilterInfoInterface)this.dfri).getUniqueValues(this.variable, true);
                if (uv != null) {
                    for (int i = 0; i < uv.length; ++i) {
                        uvm.addValue(uv[i]);
                    }
                }
            } else {
                for (int i = 0; i < this.dfri.getNumberObservations(-1); ++i) {
                    Object value = this.dfri.getValue(this.variable, (long)i);
                    String formattedValue = this.dfri.getFormattedValue(this.variable, value, null);
                    uvm.addValue(formattedValue);
                }
            }
            if ((values = uvm.getValues(this.sort)) != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.addValue(values[i]);
                }
            }
        }
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        if (sort == this.sort) {
            return;
        }
        switch (sort) {
            case -3: 
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.sort = sort;
        this.buildList();
    }

    public void removeAllValues() {
        if (this.values != null) {
            this.values.clear();
        }
        if (this.indicies != null) {
            this.indicies.clear();
        }
    }

    public boolean addValue(Object value) {
        if (value == null) {
            return false;
        }
        if (this.values == null) {
            this.values = new LinkedHashMap();
            this.indicies = new LinkedHashMap();
        }
        if (this.values.containsKey(value)) {
            return true;
        }
        Integer i = new Integer(this.values.size());
        this.values.put(value, i);
        this.indicies.put(i, value);
        return true;
    }

    public void removeValue(Object value) {
        if (value == null) {
            return;
        }
        if (this.values.containsKey(value)) {
            Integer index = (Integer)this.values.get(value);
            this.values.remove(value);
            if (this.indicies.containsKey(index)) {
                this.indicies.remove(index);
            }
        }
    }

    public int getNumberValues() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    public Object[] getValues() {
        if (this.values == null) {
            return null;
        }
        Object[] rc = new Object[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            rc[i] = this.getValue(i);
        }
        return rc;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.rebuildList = true;
                this.buildList();
                this.rebuildList = false;
            }
        }
    }

    public void setIncludeMissing(boolean includeMissing) {
        this.includeMissing = includeMissing;
    }

    public void dispose() {
        this.values = null;
        this.indicies = null;
        this.variable = null;
    }
}

