/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.BrushListener;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class Brush
implements MouseListener,
MouseMotionListener,
DataFilterListenerInterface {
    public static final int MOUSE_DOWN = 1;
    public static final int MOUSE_UP = 2;
    public static final int MOUSE_DRAG = 3;
    private Component component = null;
    private boolean componentIs3D = false;
    private LayerInterface layerInterface = null;
    protected Polygon polygon = null;
    protected Color polygonFillColor = null;
    protected int mouseDownX = 0;
    protected int mouseDownY = 0;
    protected boolean chartAction = false;
    protected Rectangle brushRect = null;
    protected boolean brushMove = false;
    protected boolean brushCreate = false;
    protected boolean brushActive = false;
    protected int actionMode = 1;
    protected int brushDragX = 0;
    protected int brushDragY = 0;
    protected boolean mySelectionEvent = false;
    private static final int MIN_BRUSH_SIZE = 4;
    private Vector filters = new Vector();
    private Rectangle chartArea = null;
    private EventListenerList listeners = null;
    private boolean defaultListenerEnabled = true;
    protected boolean selectInChartSpace = true;
    protected boolean selectOnDrilldown = true;

    public Brush(Component c) {
        this.component = c;
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        if (this.component instanceof LayerInterface) {
            this.layerInterface = (LayerInterface)((Object)this.component);
        }
    }

    public void setComponentIs3D(boolean b) {
        this.componentIs3D = b;
    }

    public void connectToElement(BaseElement element) {
        this.addFilter(element.getFilter());
        this.addBrushListener(element.getBrushListener());
        this.setLayerInterface(element);
    }

    public void draw(Graphics g) {
        if (this.actionMode == 14 && this.polygon != null && this.polygon.npoints > 0) {
            g.setColor(this.polygonFillColor);
            g.fillPolygon(this.polygon);
            return;
        }
        if (this.brushRect == null || this.brushRect.width < 3 || this.brushRect.height < 3) {
            return;
        }
        g.setColor(Color.black);
        g.drawRect(this.brushRect.x, this.brushRect.y, this.brushRect.width, this.brushRect.height);
    }

    public Rectangle getBrushRect() {
        if (this.brushRect == null) {
            return null;
        }
        return new Rectangle(this.brushRect);
    }

    public void dispose() {
        this.invalidateBrush();
        if (this.filters != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                ((DataFilterReadInterface)this.filters.elementAt(i)).removeDataFilterListener((Object)this);
            }
            this.filters.removeAllElements();
            this.filters = null;
        }
        this.brushRect = null;
    }

    public void setChartArea(Rectangle rect) {
        this.chartArea = new Rectangle(rect);
    }

    public Rectangle getChartArea() {
        return this.chartArea;
    }

    protected boolean isWithinChartArea(Rectangle region) {
        if (this.chartArea == null) {
            return true;
        }
        if (region == null) {
            return false;
        }
        return this.chartArea.contains(region);
    }

    protected boolean isWithinChartArea(int x, int y) {
        if (this.chartArea == null) {
            return true;
        }
        return this.chartArea.contains(x, y);
    }

    public int[] boundToChartArea(int x, int y) {
        int[] point = new int[2];
        if (!this.isWithinChartArea(x, y)) {
            if (x < this.chartArea.x) {
                x = this.chartArea.x;
            } else if (x > this.chartArea.x + this.chartArea.width) {
                x = this.chartArea.x + this.chartArea.width;
            }
            if (y < this.chartArea.y) {
                y = this.chartArea.y;
            } else if (y > this.chartArea.y + this.chartArea.height) {
                y = this.chartArea.y + this.chartArea.height;
            }
        }
        point[0] = x;
        point[1] = y;
        return point;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public boolean setActionMode(int mode) {
        boolean rc = false;
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: {
                this.actionMode = mode;
                rc = true;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.actionMode = 0;
                rc = true;
            }
        }
        return rc;
    }

    public void invalidateBrush() {
        this.brushActive = false;
        if (this.brushRect != null) {
            this.brushRect.x = 0;
            this.brushRect.y = 0;
            this.brushRect.height = 0;
            this.brushRect.width = 0;
        }
        if (this.polygon != null) {
            this.polygon.invalidate();
            this.polygon.reset();
        }
    }

    protected void select(int mouseAction, MouseEvent e) {
        int y;
        boolean isInExtendedSelelectionMode;
        if (e == null) {
            return;
        }
        if (this.brushRect == null) {
            this.brushRect = new Rectangle();
        }
        boolean bl = isInExtendedSelelectionMode = this.actionMode == 6 && (e.getModifiers() & 2) != 0;
        if (this.componentIs3D && (isInExtendedSelelectionMode || (e.getModifiers() & 1) != 0)) {
            return;
        }
        int x = e.getX();
        int[] point = this.boundToChartArea(x, y = e.getY());
        if (point != null && point.length == 2) {
            x = point[0];
            y = point[1];
        }
        boolean exclusiveSelect = false;
        if (this.component instanceof BaseComponentInterface) {
            exclusiveSelect = ((BaseComponentInterface)((Object)this.component)).isActionEnabled("EXCLUSIVE_SELECT");
        }
        switch (mouseAction) {
            case 1: {
                this.brushRect.x = this.mouseDownX;
                this.brushRect.y = this.mouseDownY;
                this.brushRect.width = 0;
                this.brushRect.height = 0;
                break;
            }
            case 2: 
            case 3: {
                if (!exclusiveSelect || mouseAction == 2) {
                    if (this.actionMode == 8) {
                        this.brushRect.width = 0;
                        this.brushRect.height = 0;
                        if (!this.selectOnDrilldown) {
                            return;
                        }
                    } else {
                        this.brushRect.width = Math.abs(this.mouseDownX - x);
                        this.brushRect.x = Math.min(this.mouseDownX, x);
                        this.brushRect.height = Math.abs(this.mouseDownY - y);
                        this.brushRect.y = Math.min(this.mouseDownY, y);
                    }
                }
                if (mouseAction != 2) break;
                this.mySelectionEvent = true;
                Rectangle pickRegion = new Rectangle(this.brushRect);
                if (pickRegion.width < 4) {
                    pickRegion.x -= 2;
                    pickRegion.width = 4;
                }
                if (pickRegion.height < 4) {
                    pickRegion.y -= 2;
                    pickRegion.height = 4;
                }
                if (this.chartArea != null && this.selectInChartSpace) {
                    pickRegion.translate(-this.chartArea.x, -this.chartArea.y);
                }
                if (exclusiveSelect) {
                    if (this.layerInterface != null) {
                        this.unselectAll();
                        if (this.layerInterface != null && this.layerInterface.isSelectable()) {
                            this.layerInterface.selectInLayer(true, pickRegion, e);
                        }
                    }
                } else {
                    if (!isInExtendedSelelectionMode) {
                        this.unselectAll();
                    }
                    if (this.layerInterface != null && this.layerInterface.isSelectable()) {
                        this.layerInterface.selectInLayer(true, pickRegion, e);
                    }
                }
                this.mySelectionEvent = false;
                this.invalidateBrush();
            }
        }
    }

    public void setPolygonFillColor(Color c) {
        this.polygonFillColor = new Color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 0.4f);
    }

    protected void selectRegion(int mouseAction, MouseEvent e) {
        int y;
        boolean isInExtendedSelelectionMode;
        if (e == null) {
            return;
        }
        if (this.polygon == null) {
            this.polygon = new Polygon(new int[1200], new int[1200], 0);
            if (this.polygonFillColor == null) {
                this.polygonFillColor = new Color(0.8f, 0.8f, 1.0f, 0.5f);
            }
        }
        boolean bl = isInExtendedSelelectionMode = (e.getModifiers() & 2) != 0;
        if (this.componentIs3D && (isInExtendedSelelectionMode || (e.getModifiers() & 1) != 0)) {
            return;
        }
        int x = e.getX();
        int[] point = this.boundToChartArea(x, y = e.getY());
        if (point != null && point.length == 2) {
            x = point[0];
            y = point[1];
        }
        switch (mouseAction) {
            case 1: {
                this.polygon.invalidate();
                this.polygon.reset();
                this.polygon.addPoint(x, y);
                break;
            }
            case 3: {
                this.polygon.addPoint(x, y);
                break;
            }
            case 2: {
                this.polygon.addPoint(this.polygon.xpoints[0], this.polygon.ypoints[0]);
                this.mySelectionEvent = true;
                if (!isInExtendedSelelectionMode) {
                    this.unselectAll();
                }
                if (this.layerInterface != null && this.layerInterface.isSelectable()) {
                    this.layerInterface.selectInLayer(true, new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints), e);
                }
                this.mySelectionEvent = false;
                this.invalidateBrush();
            }
        }
    }

    protected void drawViewport(int mouseAction, MouseEvent e) {
        int y;
        int x;
        int[] point;
        if (e == null) {
            return;
        }
        if (this.brushRect == null) {
            this.brushRect = new Rectangle();
        }
        if ((point = this.boundToChartArea(x = e.getX(), y = e.getY())) != null && point.length == 2) {
            x = point[0];
            y = point[1];
        }
        switch (mouseAction) {
            case 1: {
                this.brushRect.x = this.mouseDownX;
                this.brushRect.y = this.mouseDownY;
                this.brushRect.width = 0;
                this.brushRect.height = 0;
                break;
            }
            case 2: 
            case 3: {
                this.brushRect.width = Math.abs(this.mouseDownX - x);
                this.brushRect.x = Math.min(this.mouseDownX, x);
                this.brushRect.height = Math.abs(this.mouseDownY - y);
                this.brushRect.y = Math.min(this.mouseDownY, y);
                if (mouseAction != 2) break;
                this.invalidateBrush();
            }
        }
    }

    protected void brush(int mouseAction, MouseEvent e) {
        if (e == null) {
            return;
        }
        if (this.brushRect == null) {
            this.brushRect = new Rectangle();
        }
        int x = e.getX();
        int y = e.getY();
        int[] point = null;
        switch (mouseAction) {
            case 1: {
                point = this.boundToChartArea(x, y);
                if (point != null && point.length == 2) {
                    x = point[0];
                    y = point[1];
                }
                if (this.brushRect.contains(x, y)) {
                    this.brushDragX = x;
                    this.brushDragY = y;
                    this.brushMove = true;
                    break;
                }
                this.brushMove = false;
                this.brushCreate = true;
                this.brushRect.x = x;
                this.brushRect.y = y;
                this.brushRect.width = 0;
                this.brushRect.height = 0;
                break;
            }
            case 2: 
            case 3: {
                if (this.brushMove) {
                    int dx = x - this.brushDragX;
                    int dy = y - this.brushDragY;
                    this.brushRect.x += dx;
                    this.brushRect.y += dy;
                    point = this.boundToChartArea(this.brushRect.x, this.brushRect.y);
                    if (point != null && point.length == 2) {
                        this.brushRect.x = point[0];
                        this.brushRect.y = point[1];
                    }
                    if ((point = this.boundToChartArea(this.brushRect.x + this.brushRect.width, this.brushRect.y + this.brushRect.height)) != null && point.length == 2) {
                        this.brushRect.x += point[0] - (this.brushRect.x + this.brushRect.width);
                        this.brushRect.y += point[1] - (this.brushRect.y + this.brushRect.height);
                    }
                    this.brushDragX = x;
                    this.brushDragY = y;
                    if (mouseAction == 2) {
                        this.brushMove = false;
                    }
                } else if (this.brushCreate) {
                    point = this.boundToChartArea(x, y);
                    if (point != null && point.length == 2) {
                        x = point[0];
                        y = point[1];
                    }
                    this.brushRect.width = Math.abs(this.mouseDownX - x);
                    this.brushRect.x = Math.min(this.mouseDownX, x);
                    this.brushRect.height = Math.abs(this.mouseDownY - y);
                    this.brushRect.y = Math.min(this.mouseDownY, y);
                }
                if (mouseAction != 2 && (mouseAction != 3 || !this.brushMove)) break;
                this.brushCreate = false;
                this.mySelectionEvent = true;
                this.unselectAll();
                Rectangle pickRegion = new Rectangle(this.brushRect);
                if (this.chartArea != null && this.selectInChartSpace) {
                    pickRegion.translate(-this.chartArea.x, -this.chartArea.y);
                }
                if (pickRegion.width < 4) {
                    pickRegion.x -= 2;
                    pickRegion.width = 4;
                }
                if (pickRegion.height < 4) {
                    pickRegion.y -= 2;
                    pickRegion.height = 4;
                }
                if (this.layerInterface != null && this.layerInterface.isSelectable()) {
                    this.layerInterface.selectInLayer(true, pickRegion, null);
                }
                this.mySelectionEvent = false;
            }
        }
    }

    private void fireBrushEvent(int mouseAction, MouseEvent e) {
        if (this.listeners == null) {
            return;
        }
        EventListener[] list = this.listeners.getListeners(BrushListener.class);
        block6: for (int i = 0; i < list.length; ++i) {
            switch (this.actionMode) {
                case 1: {
                    ((BrushListener)list[i]).brush(this, mouseAction, e);
                    continue block6;
                }
                case 6: {
                    ((BrushListener)list[i]).select(this, mouseAction, e);
                    continue block6;
                }
                case 14: {
                    continue block6;
                }
                case 2: {
                    ((BrushListener)list[i]).drawViewport(this, mouseAction, e);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.actionMode == 14) {
            if (e.isPopupTrigger()) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            this.mouseDownX = e.getX();
            this.mouseDownY = e.getY();
            if (this.isWithinChartArea(this.mouseDownX, this.mouseDownY)) {
                this.brushActive = true;
                this.selectRegion(1, e);
                this.polygon.addPoint(e.getX() + 1, e.getY() + 1);
                this.selectRegion(2, e);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.mouseDownX = e.getX();
        this.mouseDownY = e.getY();
        if (this.isWithinChartArea(this.mouseDownX, this.mouseDownY)) {
            this.brushActive = true;
            this.chartAction = true;
            this.fireBrushEvent(1, e);
            if (this.defaultListenerEnabled) {
                switch (this.actionMode) {
                    case 1: {
                        this.brush(1, e);
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.select(1, e);
                        break;
                    }
                    case 14: {
                        this.selectRegion(1, e);
                        break;
                    }
                    case 2: {
                        this.drawViewport(1, e);
                    }
                }
            }
        } else {
            this.chartAction = false;
            this.brushActive = false;
            this.invalidateBrush();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || !this.brushActive) {
            return;
        }
        if (this.chartAction) {
            this.fireBrushEvent(2, e);
            if (this.defaultListenerEnabled) {
                switch (this.actionMode) {
                    case 1: {
                        this.brush(2, e);
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.select(2, e);
                        break;
                    }
                    case 14: {
                        this.selectRegion(2, e);
                        break;
                    }
                    case 2: {
                        this.drawViewport(2, e);
                    }
                }
            }
        }
        this.component.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.brushActive) {
            return;
        }
        this.fireBrushEvent(3, e);
        if (this.defaultListenerEnabled) {
            switch (this.actionMode) {
                case 1: {
                    this.brush(3, e);
                    break;
                }
                case 6: {
                    this.select(3, e);
                    break;
                }
                case 14: {
                    this.selectRegion(3, e);
                    break;
                }
                case 2: {
                    if (e.isShiftDown() || e.isControlDown()) break;
                    this.drawViewport(3, e);
                }
            }
        }
        this.component.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public LayerInterface getLayerInterface() {
        return this.layerInterface;
    }

    public void setLayerInterface(LayerInterface layerInterface) {
        this.layerInterface = layerInterface;
    }

    public DataFilterReadInterface[] getFilters() {
        Object[] rc = new DataFilterReadInterface[this.filters.size()];
        this.filters.copyInto(rc);
        return rc;
    }

    public void removeFilter(DataFilterReadInterface filter) {
        if (filter == null) {
            return;
        }
        if (this.filters.contains(filter)) {
            this.filters.remove(filter);
        }
        filter.removeDataFilterListener((Object)this);
    }

    public void addFilter(DataFilterReadInterface filter) {
        if (filter != null && !this.filters.contains(filter)) {
            this.filters.add(filter);
            filter.addDataFilterListener((Object)this);
        }
    }

    private void unselectAll() {
        for (int i = 0; i < this.filters.size(); ++i) {
            ((DataFilterReadInterface)this.filters.elementAt(i)).unselectAll();
        }
    }

    public void addBrushListener(BrushListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(BrushListener.class, listener);
    }

    public void removeAllBrushListeners() {
        if (this.listeners != null) {
            EventListener[] arr = this.listeners.getListeners(BrushListener.class);
            for (int i = 0; i < arr.length; ++i) {
                this.listeners.remove(BrushListener.class, (BrushListener)arr[i]);
            }
        }
    }

    public void removeBrushListener(BrushListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(BrushListener.class, listener);
        }
    }

    public boolean isDefaultBrushListenerEnabled() {
        return this.defaultListenerEnabled;
    }

    public void setDefaultBrushListenerEnabled(boolean enable) {
        this.defaultListenerEnabled = enable;
    }

    public boolean isSelectionInChartSpace() {
        return this.selectInChartSpace;
    }

    public void setSelectInChartSpace(boolean selectInChartSpace) {
        this.selectInChartSpace = selectInChartSpace;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (!this.mySelectionEvent && this.defaultListenerEnabled) {
            this.invalidateBrush();
        }
    }

    public void setSelectOnDrilldown(boolean selectOnDrilldown) {
        this.selectOnDrilldown = selectOnDrilldown;
    }
}

