/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.BandStyleInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;

public class BandAttrib
implements BandStyleInterface {
    protected boolean visible;
    protected double opacity;
    protected Color color;
    protected LineStyleInterface outline;
    protected String label;

    public BandAttrib(BandStyleInterface bsIn) {
        this.init(bsIn);
    }

    public BandAttrib(String label, Color c, double opacity) {
        this.init(label, c, opacity, null);
    }

    public BandAttrib() {
        this(null);
    }

    protected void init(BandStyleInterface bsIn) {
        this.init(bsIn == null ? null : bsIn.getLabel(), bsIn == null ? null : bsIn.getColor(), bsIn == null ? 0.5 : bsIn.getOpacity(), bsIn == null ? null : bsIn.getOutline());
    }

    protected void init(String label, Color c, double opacityIn, LineStyleInterface ol) {
        this.visible = true;
        this.color = c;
        this.opacity = opacityIn;
        this.setOutline(ol);
        this.label = label;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        long temp = Double.doubleToLongBits(this.opacity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.outline == null ? 0 : this.outline.hashCode());
        result = 31 * result + (this.visible ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BandAttrib)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BandAttrib other = (BandAttrib)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (Double.doubleToLongBits(this.opacity) != Double.doubleToLongBits(other.opacity)) {
            return false;
        }
        if (this.outline == null ? other.outline != null : !this.outline.equals(other.outline)) {
            return false;
        }
        return this.visible == other.visible;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public double getOpacity() {
        return this.opacity;
    }

    @Override
    public LineStyleInterface getOutline() {
        return this.outline;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean setColor(Object clr) {
        Color c = null;
        if (clr == null) {
            this.color = null;
            return true;
        }
        if (clr instanceof Color) {
            c = (Color)clr;
        } else if (clr instanceof String) {
            c = ColorParse.getColorFromString((String)((String)clr));
        }
        if (c == null) {
            return false;
        }
        this.color = c;
        return true;
    }

    @Override
    public boolean setOpacity(double in) {
        if (Double.isNaN(in) || Double.isInfinite(in)) {
            return false;
        }
        this.opacity = in;
        if (this.opacity < 0.0) {
            this.opacity = 0.0;
        } else if (this.opacity > 1.0) {
            this.opacity = 1.0;
        }
        return true;
    }

    @Override
    public boolean setOutline(Object in) {
        if (in == null) {
            this.outline = null;
            return true;
        }
        if (this.outline == null && (this.outline = new LineAttrib(true, null, 1)) == null) {
            return false;
        }
        if (in instanceof Boolean) {
            this.outline.setVisible((Boolean)in);
        } else if (in instanceof Color || in instanceof String) {
            this.outline.setColor(in);
        } else if (in instanceof Number) {
            this.outline.setWidth(((Number)in).intValue());
        } else if (in instanceof LineStyleInterface) {
            this.outline = new LineAttrib((LineStyleInterface)in);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean setLabel(String label) {
        this.label = label;
        return true;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

