/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.styles.Style;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class AxisZoomPanHandler
implements MouseListener,
MouseMotionListener,
ActionListener,
ViewportListenerInterface {
    public static final int PAN = 0;
    public static final int ZOOM = 1;
    public static final int SCROLLBAR_RESIZE = 2;
    public static final int PREFFERED_HEIGHT = 9;
    private Axes axis;
    private Rectangle axisArea;
    private Rectangle panArea = null;
    private Rectangle scrollbarRect = new Rectangle();
    private boolean mouseDownInPanArea = false;
    private boolean mouseDownInResizeArea = false;
    private int currentResizeHandle = 0;
    private boolean primaryZoomPanArea = false;
    private Color indicatorColor;
    private Color viewportIndicatorColor = Color.black;
    private Color topColor = Color.lightGray;
    private int viewportIndicatorSize = 9;
    private int indicatorSize = 40;
    private boolean active;
    private boolean userDefinedArea;
    private boolean enabled = true;
    private boolean panEnabled = true;
    private boolean zoomMinEnabled = true;
    private boolean zoomMaxEnabled = true;
    private boolean expandDataRange = false;
    private double minimumViewportRange = Double.NaN;
    private double dataMin = Double.NaN;
    private double dataMax = Double.NaN;
    private double viewportMin = Double.NaN;
    private double viewportMax = Double.NaN;
    private int prevx;
    private int prevy;
    private double zoomPoint;
    private ArrayList viewportListeners;
    private static Cursor zoomLRCursor;
    private static Cursor zoomUDCursor;
    private static JPopupMenu popup;
    private static ActionListener listener;
    private static int zoomPanStatus;

    public AxisZoomPanHandler(Axes axis) {
        this.axis = axis;
        this.axisArea = new Rectangle();
        this.userDefinedArea = false;
        this.viewportListeners = new ArrayList();
        this.indicatorColor = AxisZoomPanHandler.computeShadedColor(axis.getBackgroundColor());
        AxisZoomPanHandler.loadCustomCursors();
    }

    public void setDataRange(DataRange dr) {
        double min = Double.NaN;
        double max = Double.NaN;
        if (dr instanceof ContinuousRange) {
            min = ((ContinuousRange)dr).getMin();
            max = ((ContinuousRange)dr).getMax();
        } else if (dr instanceof DiscreteRange) {
            min = 0.0;
            max = ((DiscreteRange)dr).getValuesSize() - 1;
        }
        this.setDataRange(min, max);
    }

    public void setDataRange(double min, double max) {
        this.setDataRange(min, max, true);
    }

    public void setDataRange(double min, double max, boolean clearViewport) {
        this.dataMin = min;
        this.dataMax = max;
        if (!clearViewport) {
            return;
        }
        if (Double.isNaN(this.viewportMin) || this.dataMin > this.viewportMin) {
            this.viewportMin = this.dataMin;
        }
        if (Double.isNaN(this.viewportMax) || this.dataMax < this.viewportMax) {
            this.viewportMax = this.dataMax;
        }
        this.viewportMin = this.dataMin;
        this.viewportMax = this.dataMax;
    }

    public void setAxisArea(Rectangle area) {
        this.axisArea = area;
        this.panArea = new Rectangle(this.axisArea);
        if (this.axis.getDimension() == 1) {
            if (!this.axis.isPrimary()) {
                this.panArea.y += this.axisArea.height - this.viewportIndicatorSize;
            }
            this.panArea.height = this.viewportIndicatorSize;
        } else {
            if (this.axis.isPrimary()) {
                this.panArea.x += this.panArea.width - this.viewportIndicatorSize;
            }
            this.panArea.width = this.viewportIndicatorSize;
        }
        this.userDefinedArea = true;
    }

    public void setStyle(Style style) {
        if (style == null) {
            return;
        }
        this.indicatorColor = AxisZoomPanHandler.computeShadedColor(style.getFillStyleElement("Backfill").getFillColor());
        this.viewportIndicatorColor = style.getLineStyleElement("AxisLines").getLineColor();
        this.topColor = style.getFillStyleElement("WallFill").getFillColor();
    }

    public void setBackgroundColor(Color c) {
        this.indicatorColor = AxisZoomPanHandler.computeShadedColor(c);
    }

    public boolean isZoomPanEnabled() {
        return this.enabled;
    }

    public void setZoomPanEnabled(boolean e) {
        this.enabled = e;
    }

    public void setZoomPanEnabled(boolean pan, boolean zoomMin, boolean zoomMax) {
        this.panEnabled = pan;
        this.zoomMinEnabled = zoomMin;
        this.zoomMaxEnabled = zoomMax;
    }

    public void setPanEnabled(boolean pan) {
        this.panEnabled = pan;
    }

    public void setZoomMinEnabled(boolean b) {
        this.zoomMinEnabled = b;
    }

    public void setZoomMaxEnabled(boolean b) {
        this.zoomMaxEnabled = b;
    }

    public double getMinimumViewportRange() {
        return this.minimumViewportRange;
    }

    public void setMinimumViewportRange(double range) {
        this.minimumViewportRange = range;
    }

    public boolean isExpandDataRange() {
        return this.expandDataRange;
    }

    public void setExpandDataRange(boolean expand) {
        this.expandDataRange = expand;
    }

    public boolean isPrimaryZoomPanArea() {
        return this.primaryZoomPanArea;
    }

    public void setPrimaryZoomPanArea(boolean b) {
        this.primaryZoomPanArea = b;
    }

    public void addViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (!this.viewportListeners.contains(listener)) {
            this.viewportListeners.add(listener);
        }
    }

    public void removeViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners.contains(listener)) {
            this.viewportListeners.remove(listener);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.prevx = evt.getX();
        this.prevy = evt.getY();
        if (!this.active) {
            return;
        }
        if (evt.isPopupTrigger()) {
            this.bringUpPopupMenu(evt);
            return;
        }
        if (this.isMouseInPanArea(evt)) {
            this.mouseDownInPanArea = true;
        }
        if (this.isInScrollBarResizeRegion(evt.getPoint())) {
            this.mouseDownInResizeArea = true;
        }
        this.setCursor(evt, true);
        if (this.active && this.getCurrentZoomPanStatus() == 1) {
            this.zoomPoint = this.axis.getDimension() == 1 ? (double)(this.prevx - this.axisArea.x) / (double)this.axisArea.width : 1.0 - (double)(this.prevy - this.axisArea.y) / (double)this.axisArea.height;
        }
        evt.getComponent().requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.mouseDownInPanArea = false;
        this.mouseDownInResizeArea = false;
        if (!this.active) {
            return;
        }
        if (evt.isPopupTrigger()) {
            this.bringUpPopupMenu(evt);
            return;
        }
        this.setCursor(evt, false);
        evt.getComponent().repaint();
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.zoomPanAxis(evt.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.mouseDownInPanArea = false;
        this.mouseDownInResizeArea = false;
        this.setCursor(evt, false);
        evt.getComponent().repaint();
    }

    public boolean isMouseInPanArea(MouseEvent evt) {
        if (this.enabled) {
            this.updateAxisArea(evt);
            this.active = this.panArea.contains(evt.getX(), evt.getY());
        } else {
            this.active = this.enabled;
        }
        return this.active;
    }

    public Rectangle getPanArea() {
        return this.panArea;
    }

    private boolean isInScrollBarResizeRegion(Point p) {
        this.currentResizeHandle = 0;
        if (this.scrollbarRect == null) {
            return false;
        }
        if (!this.scrollbarRect.contains(p)) {
            return false;
        }
        if (this.scrollbarRect.width <= 10) {
            return false;
        }
        if (this.axis.getDimension() == 1) {
            if (p.x > this.scrollbarRect.x && p.x < this.scrollbarRect.x + 5) {
                this.currentResizeHandle = 7;
                return true;
            }
            if (p.x > this.scrollbarRect.x + this.scrollbarRect.width - 5 && p.x < this.scrollbarRect.x + this.scrollbarRect.width) {
                this.currentResizeHandle = 3;
                return true;
            }
        } else {
            if (p.y > this.scrollbarRect.y && p.y < this.scrollbarRect.y + 5) {
                this.currentResizeHandle = 1;
                return true;
            }
            if (p.y > this.scrollbarRect.y + this.scrollbarRect.height - 5 && p.y < this.scrollbarRect.y + this.scrollbarRect.height) {
                this.currentResizeHandle = 5;
                return true;
            }
        }
        return false;
    }

    public boolean isMouseInZoomPanArea(MouseEvent evt) {
        if (this.enabled) {
            this.updateAxisArea(evt);
            this.active = this.axisArea.contains(evt.getX(), evt.getY());
        } else {
            this.active = this.enabled;
        }
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public int getZoomPanStatus() {
        return zoomPanStatus;
    }

    public void drawViewportIndicator(Graphics g) {
        if (this.viewportMax == this.dataMax && this.viewportMin == this.dataMin || !this.enabled) {
            return;
        }
        if (Double.isNaN(this.dataMin) || Double.isNaN(this.dataMax) || Double.isNaN(this.viewportMin) || Double.isNaN(this.viewportMax)) {
            return;
        }
        this.updateAxisArea(null);
        g.setColor(this.viewportIndicatorColor);
        if (this.axis.getDimension() == 1) {
            int x1;
            int x2;
            int y2;
            int y1 = this.axis.isPrimary() ? (y2 = this.axisArea.y) : (y2 = this.axisArea.y + this.axisArea.height - this.viewportIndicatorSize - 2);
            if (this.axis.isReverse(0)) {
                x2 = this.axisArea.x + this.axisArea.width - (int)((double)this.axisArea.width * ((this.viewportMin - this.dataMin) / (this.dataMax - this.dataMin)));
                x1 = this.axisArea.x + this.axisArea.width - (int)((double)this.axisArea.width * ((this.viewportMax - this.dataMin) / (this.dataMax - this.dataMin)));
            } else {
                x1 = this.axisArea.x + (int)((double)this.axisArea.width * ((this.viewportMin - this.dataMin) / (this.dataMax - this.dataMin)));
                x2 = this.axisArea.x + (int)((double)this.axisArea.width * ((this.viewportMax - this.dataMin) / (this.dataMax - this.dataMin)));
            }
            if (x2 - x1 < 4) {
                x1 -= 2;
                x2 += 2;
            }
            int size = Math.min(9, this.indicatorSize);
            this.scrollbarRect.setBounds(x1, y1, x2 - x1, size);
            if (this.active) {
                Color c1 = ColorUtilities.brighter(this.indicatorColor, 0.25);
                Color c2 = ColorUtilities.darker(this.indicatorColor, 0.1);
                GradientPaint gp = new GradientPaint(new Point(x1, y1 + 1), c1, new Point(x1, y1 + 1 + size), c2);
                ((Graphics2D)g).setPaint(gp);
                g.fillRect(x1, y1 + 1, x2 - x1, size);
                Color lineColor = ColorUtilities.darker(this.indicatorColor, 0.25);
                if (x2 - x1 > 20) {
                    g.setColor(lineColor);
                    if (this.zoomMinEnabled) {
                        g.drawLine(x1 + 6, y1 + 1, x1 + 6, y1 + 1 + size);
                    }
                    if (this.zoomMaxEnabled) {
                        g.drawLine(x2 - 6, y1 + 1, x2 - 6, y1 + 1 + size);
                    }
                    if (this.zoomMinEnabled) {
                        g.drawLine(x1 + 3, y1 + 3, x1 + 3, y1 + 1 + size - 2);
                    }
                    if (this.zoomMaxEnabled) {
                        g.drawLine(x2 - 3, y1 + 3, x2 - 3, y1 + 1 + size - 2);
                    }
                }
                if (x2 - x1 > 10) {
                    int center = x1 + (x2 - x1) / 2;
                    g.setColor(this.topColor);
                    g.drawLine(center - 4, y1 + 3, center - 4, y1 + 1 + size - 2);
                    g.drawLine(center - 2, y1 + 3, center - 2, y1 + 1 + size - 2);
                    g.drawLine(center, y1 + 3, center, y1 + 1 + size - 2);
                    g.drawLine(center + 2, y1 + 3, center + 2, y1 + 1 + size - 2);
                    g.setColor(lineColor);
                    g.drawLine(center - 3, y1 + 3, center - 3, y1 + 1 + size - 2);
                    g.drawLine(center - 1, y1 + 3, center - 1, y1 + 1 + size - 2);
                    g.drawLine(center + 1, y1 + 3, center + 1, y1 + 1 + size - 2);
                    g.drawLine(center + 3, y1 + 3, center + 3, y1 + 1 + size - 2);
                }
                g.setColor(lineColor);
                g.drawRect(x1, y1 + 1, x2 - x1, size);
            } else {
                int y = this.axis.isPrimary() ? y1 : y1 + this.viewportIndicatorSize;
                g.drawLine(x1, y, x2, y);
                g.drawLine(x1, y + 1, x2, y + 1);
            }
        } else {
            int y1;
            int y2;
            int x2;
            int x1 = this.axis.isPrimary() ? (x2 = this.axisArea.x + this.axisArea.width - 1) : (x2 = this.axisArea.x + this.viewportIndicatorSize + 1);
            if (this.axis.isReverse(1)) {
                y2 = this.axisArea.y + (int)((double)this.axisArea.height * ((this.viewportMin - this.dataMin) / (this.dataMax - this.dataMin)));
                y1 = this.axisArea.y + (int)((double)this.axisArea.height * ((this.viewportMax - this.dataMin) / (this.dataMax - this.dataMin)));
            } else {
                y1 = this.axisArea.y + this.axisArea.height - (int)((double)this.axisArea.height * ((this.viewportMin - this.dataMin) / (this.dataMax - this.dataMin)));
                y2 = this.axisArea.y + this.axisArea.height - (int)((double)this.axisArea.height * ((this.viewportMax - this.dataMin) / (this.dataMax - this.dataMin)));
            }
            int size = Math.min(9, this.indicatorSize);
            this.scrollbarRect.setBounds(x1 - 1 - size, y2, size, y1 - y2);
            if (this.active) {
                Color c1 = ColorUtilities.brighter(this.indicatorColor, 0.25);
                Color c2 = ColorUtilities.darker(this.indicatorColor, 0.1);
                GradientPaint gp = new GradientPaint(new Point(x1 - 1, y1), c1, new Point(x1 - size - 1, y1), c2);
                ((Graphics2D)g).setPaint(gp);
                g.fillRect(x1 - 1 - size, y2, size, y1 - y2);
                Color lineColor = ColorUtilities.darker(this.indicatorColor, 0.25);
                if (y1 - y2 > 20) {
                    g.setColor(lineColor);
                    if (this.zoomMaxEnabled) {
                        g.drawLine(x1 - 1, y2 + 6, x1 - 1 - size, y2 + 6);
                    }
                    if (this.zoomMinEnabled) {
                        g.drawLine(x1 - 1, y1 - 6, x1 - 1 - size, y1 - 6);
                    }
                    if (this.zoomMaxEnabled) {
                        g.drawLine(x1 - 3, y2 + 3, x1 - 1 - size + 2, y2 + 3);
                    }
                    if (this.zoomMinEnabled) {
                        g.drawLine(x1 - 3, y1 - 3, x1 - 1 - size + 2, y1 - 3);
                    }
                }
                if (y1 - y2 > 10) {
                    int center = y2 + (y1 - y2) / 2;
                    g.setColor(this.topColor);
                    g.drawLine(x1 - 3, center + 4, x1 - 1 - size + 2, center + 4);
                    g.drawLine(x1 - 3, center + 2, x1 - 1 - size + 2, center + 2);
                    g.drawLine(x1 - 3, center, x1 - 1 - size + 2, center);
                    g.drawLine(x1 - 3, center - 2, x1 - 1 - size + 2, center - 2);
                    g.setColor(lineColor);
                    g.drawLine(x1 - 3, center + 3, x1 - 1 - size + 2, center + 3);
                    g.drawLine(x1 - 3, center + 1, x1 - 1 - size + 2, center + 1);
                    g.drawLine(x1 - 3, center - 1, x1 - 1 - size + 2, center - 1);
                    g.drawLine(x1 - 3, center - 3, x1 - 1 - size + 2, center - 3);
                }
                g.setColor(lineColor);
                g.drawRect(x1 - 1 - size, y2, size, y1 - y2);
            } else if (this.enabled) {
                int x = this.axis.isPrimary() ? x1 : x1 - this.viewportIndicatorSize;
                g.drawLine(x, y1, x, y2);
                g.drawLine(x - 1, y1, x - 1, y2);
            }
        }
    }

    public void drawZoomPanIndicator(Graphics g) {
        if (!this.active || !this.enabled) {
            return;
        }
        g.setColor(this.indicatorColor);
        int size = Math.min(9, this.indicatorSize);
        if (this.axis.getDimension() == 1) {
            int y1 = this.axis.isPrimary() ? this.axisArea.y : this.axisArea.y + this.axisArea.height - size;
            g.fillRoundRect(this.axisArea.x, y1, this.axisArea.width - 1, size, 5, 5);
        } else {
            int x1 = this.axis.isPrimary() ? this.axisArea.x + this.axisArea.width - size : this.axisArea.x;
            g.fillRoundRect(x1, this.axisArea.y, size, this.axisArea.height - 1, 5, 5);
        }
    }

    private void updateAxisArea(MouseEvent evt) {
        if (this.userDefinedArea) {
            return;
        }
        Graphics2D g = evt == null ? null : (Graphics2D)evt.getComponent().getGraphics();
        Rectangle bbox = this.axis.getScreenArea();
        if (this.axis.getDimension() == 1) {
            this.axisArea.x = bbox.x;
            this.axisArea.width = bbox.width;
            if (this.axis.isPrimary()) {
                this.indicatorSize = g == null ? this.indicatorSize : this.axis.getBottomHeight(g);
                this.indicatorSize = Math.min(40, Math.max(6, this.indicatorSize));
                this.axisArea.y = bbox.y + bbox.height;
                this.axisArea.height = this.indicatorSize;
            } else {
                this.indicatorSize = g == null ? this.indicatorSize : this.axis.getTopHeight(g);
                this.indicatorSize = Math.min(40, Math.max(6, this.indicatorSize));
                if (this.primaryZoomPanArea) {
                    this.axisArea.y = bbox.y + bbox.height - this.indicatorSize;
                    this.axisArea.height = this.indicatorSize;
                } else {
                    this.axisArea.y = Math.max(0, bbox.y - this.indicatorSize);
                    this.axisArea.height = Math.min(bbox.y, this.indicatorSize);
                }
            }
        } else {
            this.axisArea.y = bbox.y;
            this.axisArea.height = bbox.height;
            if (this.axis.isPrimary()) {
                this.indicatorSize = g == null ? this.indicatorSize : this.axis.getLeftWidth(g);
                this.indicatorSize = Math.min(40, Math.max(6, this.indicatorSize));
                this.axisArea.x = Math.max(0, bbox.x - this.indicatorSize);
                this.axisArea.width = Math.min(bbox.x, this.indicatorSize);
            } else {
                this.indicatorSize = g == null ? this.indicatorSize : this.axis.getRightWidth(g);
                this.indicatorSize = Math.min(40, Math.max(6, this.indicatorSize));
                if (this.primaryZoomPanArea) {
                    this.axisArea.x = bbox.x;
                    this.axisArea.width = this.indicatorSize;
                } else {
                    this.axisArea.x = bbox.x + bbox.width;
                    this.axisArea.width = this.indicatorSize;
                }
            }
        }
        this.panArea = new Rectangle(this.axisArea);
        if (this.axis.getDimension() == 1) {
            int size;
            if (!this.axis.isPrimary()) {
                this.panArea.y += this.axisArea.height - this.viewportIndicatorSize;
            }
            this.panArea.height = size = Math.min(9, this.indicatorSize);
        } else {
            if (this.axis.isPrimary()) {
                this.panArea.x += this.panArea.width - this.viewportIndicatorSize;
            }
            this.panArea.width = this.viewportIndicatorSize;
        }
    }

    public int getCurrentZoomPanStatus() {
        int status = this.mouseDownInResizeArea ? 2 : (this.mouseDownInPanArea ? 0 : zoomPanStatus);
        return status;
    }

    private void zoomPanAxis(Point pt) {
        if (!this.active) {
            return;
        }
        int which = this.axis.getDimension() == 1 ? 0 : 1;
        boolean reversed = ((TransformInterface)this.axis.getTransformObject()).isReverse(which);
        this.getCurrentViewport();
        double viewportMin_curr = this.viewportMin;
        double viewportMax_curr = this.viewportMax;
        double ratio = 0.0;
        double dpix = 0.0;
        double dval = 0.0;
        if (this.axis.getDimension() == 1) {
            ratio = (this.dataMax - this.dataMin) / (double)this.axisArea.width;
            dpix = this.prevx - pt.x;
            dval = dpix * ratio;
        } else if (this.axis.getDimension() == 2) {
            ratio = (this.dataMax - this.dataMin) / (double)this.axisArea.height;
            dpix = pt.y - this.prevy;
            dval = dpix * ratio;
        }
        double curVRange = this.viewportMax - this.viewportMin;
        double minVRange = Double.isNaN(this.minimumViewportRange) ? 0.0 : this.minimumViewportRange;
        curVRange = Math.max(curVRange, minVRange);
        switch (this.getCurrentZoomPanStatus()) {
            case 1: {
                if (dval < 0.0 && curVRange - minVRange <= 0.0) break;
                double vrange = this.viewportMax - this.viewportMin;
                if (reversed) {
                    double focusPoint = this.viewportMax - this.zoomPoint * vrange;
                    vrange += dval;
                    if (this.zoomMaxEnabled) {
                        this.viewportMax = focusPoint + this.zoomPoint * vrange;
                    }
                    if (this.zoomMinEnabled) {
                        this.viewportMin = focusPoint - (1.0 - this.zoomPoint) * vrange;
                    }
                } else {
                    double focusPoint = this.viewportMin + this.zoomPoint * vrange;
                    vrange += dval;
                    if (this.zoomMinEnabled) {
                        this.viewportMin = focusPoint - this.zoomPoint * vrange;
                    }
                    if (this.zoomMaxEnabled) {
                        this.viewportMax = focusPoint + (1.0 - this.zoomPoint) * vrange;
                    }
                }
                if (!this.zoomMaxEnabled) {
                    this.viewportMin = Math.min(this.viewportMin, this.viewportMax - minVRange);
                } else {
                    this.viewportMax = Math.max(this.viewportMax, this.viewportMin + minVRange);
                }
                if (this.expandDataRange) break;
                this.viewportMin = Math.max(this.viewportMin, this.dataMin);
                this.viewportMax = Math.min(this.viewportMax, this.dataMax);
                break;
            }
            case 2: {
                double sign;
                double diff = minVRange - curVRange;
                if (dval < 0.0 && diff >= 0.0 && (this.currentResizeHandle == 7 || this.currentResizeHandle == 1) || dval > 0.0 && diff >= 0.0 && (this.currentResizeHandle == 3 || this.currentResizeHandle == 5)) break;
                double d = sign = dval < 0.0 ? -1.0 : 1.0;
                if (Math.abs(dval) > Math.abs(this.viewportMax - this.viewportMin)) {
                    dval = Math.abs(minVRange) * sign;
                }
                switch (this.currentResizeHandle) {
                    case 1: {
                        if (!this.zoomMaxEnabled) break;
                        if (reversed) {
                            this.viewportMin += dval;
                            break;
                        }
                        this.viewportMax -= dval;
                        break;
                    }
                    case 7: {
                        if (!this.zoomMinEnabled) break;
                        if (reversed) {
                            this.viewportMax += dval;
                            break;
                        }
                        this.viewportMin -= dval;
                        break;
                    }
                    case 5: {
                        if (!this.zoomMinEnabled) break;
                        if (reversed) {
                            this.viewportMax += dval;
                            break;
                        }
                        this.viewportMin -= dval;
                        break;
                    }
                    case 3: {
                        if (!this.zoomMaxEnabled) break;
                        if (reversed) {
                            this.viewportMin += dval;
                            break;
                        }
                        this.viewportMax -= dval;
                    }
                }
                if (this.expandDataRange) break;
                this.viewportMax = Math.min(this.viewportMax, this.dataMax);
                this.viewportMin = Math.max(this.viewportMin, this.dataMin);
                break;
            }
            case 0: {
                if (!this.panEnabled) break;
                if (this.mouseDownInPanArea) {
                    dval *= -1.0;
                }
                double range = this.viewportMax - this.viewportMin;
                if (dval < 0.0) {
                    if (reversed) {
                        this.viewportMax -= dval;
                        if (!this.expandDataRange) {
                            this.viewportMax = Math.min(this.viewportMax, this.dataMax);
                        }
                        this.viewportMin = this.viewportMax - range;
                        break;
                    }
                    this.viewportMin += dval;
                    if (!this.expandDataRange) {
                        this.viewportMin = Math.max(this.viewportMin, this.dataMin);
                    }
                    this.viewportMax = this.viewportMin + range;
                    break;
                }
                if (reversed) {
                    this.viewportMin -= dval;
                    if (!this.expandDataRange) {
                        this.viewportMin = Math.max(this.viewportMin, this.dataMin);
                    }
                    this.viewportMax = this.viewportMin + range;
                    break;
                }
                this.viewportMax += dval;
                if (!this.expandDataRange) {
                    this.viewportMax = Math.min(this.viewportMax, this.dataMax);
                }
                this.viewportMin = this.viewportMax - range;
                break;
            }
        }
        if (this.viewportMin != viewportMin_curr || this.viewportMax != viewportMax_curr) {
            this.fireViewportChangeEvent();
        }
        this.prevx = pt.x;
        this.prevy = pt.y;
    }

    public void resetAxis() {
        this.viewportMin = this.dataMin;
        this.viewportMax = this.dataMax;
        this.scrollbarRect.setBounds(0, 0, -1, -1);
        this.fireViewportChangeEvent();
    }

    private void fireViewportChangeEvent() {
        double xmin = Double.NaN;
        double xmax = Double.NaN;
        double ymin = Double.NaN;
        double ymax = Double.NaN;
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        if (this.axis.getDimension() == 1) {
            xmin = this.viewportMin;
            xmax = this.viewportMax;
        } else if (this.axis.getDimension() == 2) {
            ymin = this.viewportMin;
            ymax = this.viewportMax;
        }
        ViewportEvent evt = new ViewportEvent(this, 1, xmin, xmax, ymin, ymax, zmin, zmax);
        for (int i = 0; i < this.viewportListeners.size(); ++i) {
            ((ViewportListenerInterface)this.viewportListeners.get(i)).viewportChanged(evt);
        }
        this.updateAxisArea(null);
    }

    private void setCursor(MouseEvent evt, boolean mouseDown) {
        if (this.isMouseInPanArea(evt)) {
            if (this.isInScrollBarResizeRegion(evt.getPoint())) {
                if (this.axis.getDimension() == 1) {
                    if (this.currentResizeHandle == 7 && this.zoomMinEnabled || this.currentResizeHandle == 3 && this.zoomMaxEnabled) {
                        evt.getComponent().setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (this.currentResizeHandle == 1 && this.zoomMaxEnabled || this.currentResizeHandle == 5 && this.zoomMinEnabled) {
                    evt.getComponent().setCursor(Cursor.getPredefinedCursor(8));
                }
                return;
            }
            evt.getComponent().setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (!this.isMouseInZoomPanArea(evt)) {
            evt.getComponent().setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.setCursor(evt.getComponent(), this.getCurrentZoomPanStatus(), mouseDown);
    }

    private void setCursor(Component parent, int status, boolean mouseDown) {
        Cursor zoomPanCursor = null;
        if (this.axis.getDimension() == 1) {
            if (status == 1 && (this.zoomMinEnabled || this.zoomMaxEnabled)) {
                zoomPanCursor = zoomLRCursor;
            }
        } else if (status == 1 && (this.zoomMinEnabled || this.zoomMaxEnabled)) {
            zoomPanCursor = zoomUDCursor;
        }
        parent.setCursor(zoomPanCursor);
    }

    public boolean hasViewport() {
        this.getCurrentViewport();
        if (Double.isNaN(this.viewportMax) || Double.isNaN(this.viewportMin) || Double.isNaN(this.dataMax) || Double.isNaN(this.dataMin)) {
            return false;
        }
        double d1 = this.viewportMax - this.viewportMin;
        double d2 = this.dataMax - this.dataMin;
        if (this.viewportMax - this.viewportMin >= this.dataMax - this.dataMin) {
            return false;
        }
        return !(Math.abs(d1 - d2) < d2 / 10000.0);
    }

    private void getCurrentViewport() {
        if (!Double.isNaN(this.viewportMin) && !Double.isNaN(this.viewportMax)) {
            return;
        }
        this.viewportMin = this.dataMin;
        this.viewportMax = this.dataMax;
    }

    private void bringUpPopupMenu(MouseEvent evt) {
        if (evt.getSource() instanceof JComponent) {
            if (popup == null) {
                popup = AxisZoomPanHandler.createAxisPopupMenu();
            }
            if (listener != this) {
                this.removeListenerFromPopup(listener);
                this.addListenerToPopup(this);
                listener = this;
                if (popup.getParent() == null) {
                    ((JComponent)evt.getComponent()).add(popup);
                } else if (popup.getParent() != evt.getComponent()) {
                    popup.getParent().remove(popup);
                    ((JComponent)evt.getComponent()).add(popup);
                }
            }
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void addListenerToPopup(ActionListener l) {
        if (popup == null) {
            return;
        }
        int count = popup.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!(popup.getComponent(i) instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)popup.getComponent(i);
            mi.addActionListener(l);
        }
    }

    private void removeListenerFromPopup(ActionListener l) {
        if (popup == null) {
            return;
        }
        int count = popup.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!(popup.getComponent(i) instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)popup.getComponent(i);
            mi.removeActionListener(l);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("Reset")) {
            this.resetAxis();
        }
    }

    public static void setSelectedItemInPopUp(JPopupMenu popup, JMenuItem item) {
        if (popup == null) {
            return;
        }
        int count = popup.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!(popup.getComponent(i) instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)popup.getComponent(i);
            if (mi == item) {
                mi.setSelected(true);
                continue;
            }
            mi.setSelected(false);
        }
    }

    public static void loadCustomCursors() {
        Image image;
        URL url;
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Class<AxisZoomPanHandler> theClass = AxisZoomPanHandler.class;
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (zoomLRCursor == null) {
            url = theClass.getResource("/icons/ZoomLR.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            zoomLRCursor = tk.createCustomCursor(image, new Point(14, 7), "ZoomLR");
        }
        if (zoomUDCursor == null) {
            url = theClass.getResource("/icons/ZoomUD.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            zoomUDCursor = tk.createCustomCursor(image, new Point(14, 14), "zoomUD");
        }
    }

    public static Color computeShadedColor(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float fac = (double)hsb[2] > 0.5 ? 0.85f : 1.15f;
        Color newCol = Color.getHSBColor(hsb[0], hsb[1], Math.min(1.0f, hsb[2] * fac));
        Color shadedColor = new Color(newCol.getRed(), newCol.getGreen(), newCol.getBlue(), 100);
        return shadedColor;
    }

    public static JPopupMenu createAxisPopupMenu() {
        ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = new JMenuItem(ResourceLoader.getResourceString((Object)rb, (String)"AxisZoomPanHandler.resetAxis.txt", (String)"Reset Axis"));
        mi.setMnemonic(82);
        mi.setActionCommand("Reset");
        menu.add(mi);
        return menu;
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (evt.type == 0) {
            this.resetAxis();
        }
        if (this.axis.getDimension() == 1) {
            if (!Double.isNaN(evt.xMin)) {
                this.viewportMin = evt.xMin;
            }
            if (!Double.isNaN(evt.xMax)) {
                this.viewportMax = evt.xMax;
            }
        } else {
            if (!Double.isNaN(evt.yMin)) {
                this.viewportMin = evt.yMin;
            }
            if (!Double.isNaN(evt.yMax)) {
                this.viewportMax = evt.yMax;
            }
        }
    }

    public void setViewport(double min, double max) {
        double minVRange;
        if (Double.isNaN(min) || Double.isNaN(max)) {
            this.viewportMin = min;
            this.viewportMax = max;
            this.fireViewportChangeEvent();
            return;
        }
        double min1 = Math.min(min, max);
        double max1 = Math.max(min, max);
        if (min1 < this.dataMin && max1 > this.dataMax) {
            min1 = this.dataMin;
            max1 = this.dataMax;
        } else {
            if (min1 < this.dataMin && max1 < this.dataMin || min1 > this.dataMax && max1 > this.dataMax) {
                return;
            }
            if (min1 < this.dataMin && max1 > this.dataMin) {
                min1 = this.dataMin;
            } else if (min1 < this.dataMax && max1 > this.dataMax) {
                max1 = this.dataMax;
            }
        }
        double d = minVRange = Double.isNaN(this.minimumViewportRange) ? 0.0 : this.minimumViewportRange;
        if (max1 - min1 < minVRange) {
            double mid = (max1 - min1) / 2.0 + min1;
            double half = minVRange / 2.0;
            mid = Math.min(this.dataMax - half, Math.max(this.dataMin + half, mid));
            max1 = mid + minVRange / 2.0;
            min1 = mid - minVRange / 2.0;
        }
        if (this.zoomMinEnabled) {
            this.viewportMin = min1;
        }
        if (this.zoomMaxEnabled) {
            this.viewportMax = max1;
        }
        this.fireViewportChangeEvent();
    }

    public static double[] panTickValues(double min, double max, double[] tickvalues) {
        if (tickvalues == null || tickvalues.length < 2) {
            return null;
        }
        double intv = tickvalues[1] - tickvalues[0];
        double start = tickvalues[0];
        if (min < start) {
            while (start - min >= intv) {
                start -= intv;
            }
        } else {
            while (start < min) {
                start += intv;
            }
        }
        int num = (int)((max - start) / intv) + 1;
        double[] ticks = new double[num];
        for (int i = 0; i < num; ++i) {
            ticks[i] = start + (double)i * intv;
        }
        return ticks;
    }

    public static Object[] panTickValues(double min, double max, Object[] tickValues) {
        if (tickValues == null || tickValues.length < 2) {
            return null;
        }
        if (!(tickValues[0] instanceof Number)) {
            return null;
        }
        double[] oldValues = new double[tickValues.length];
        for (int i = 0; i < tickValues.length; ++i) {
            oldValues[i] = ((Number)tickValues[i]).doubleValue();
        }
        double[] newValues = AxisZoomPanHandler.panTickValues(min, max, oldValues);
        Object[] ticks = new Object[newValues.length];
        for (int i = 0; i < newValues.length; ++i) {
            ticks[i] = new Double(newValues[i]);
        }
        return ticks;
    }

    public double getViewportMax() {
        return this.viewportMax;
    }

    public double getViewportMin() {
        return this.viewportMin;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    public Axes getAxis() {
        return this.axis;
    }

    public String toString() {
        return "AxisZoomPanHandler: data min/max=(" + this.dataMin + "," + this.dataMax + ") viewportMin/max=(" + this.viewportMin + "," + this.viewportMax + ")";
    }

    static {
        popup = null;
        listener = null;
        zoomPanStatus = 1;
    }
}

