/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListenerList;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ColorParse;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class AxisComponent
extends JComponent
implements MouseListener,
GridAxisInterface,
PropertyInterface,
AxisInterface,
RenderInterface {
    private static final long serialVersionUID = 3217122989729501086L;
    private static final int INNER = 1;
    private static final int OUTER = 2;
    private int dimension;
    private ContinuousRange numericRange = null;
    private DiscreteRange discreteRange = null;
    private Axes axis = null;
    private Insets prefInnerMargin = new Insets(0, 0, 0, 0);
    private Insets prefOuterMargin = new Insets(0, 0, 0, 0);
    private Insets innerMargin = new Insets(0, 0, 0, 0);
    private Insets outerMargin = new Insets(0, 0, 0, 0);
    private Rectangle axisArea = null;
    private boolean primary = true;
    private boolean axisReady = false;
    private boolean innerMarginSet = false;
    private boolean outerMarginSet = false;
    private MarginListenerList marginListeners = null;
    private boolean autoCalculate = true;
    private boolean marginEvent = false;
    private boolean calculateMargin = true;
    private boolean fontHeightSet = false;
    private int numMajorTicks = -1;
    private boolean innerMarginAdjust = true;
    private Color backgroundColor = null;
    private Color wallColor = Color.LIGHT_GRAY;
    private int compWidth;
    private int compHeight;
    private Boolean equalSpace = null;
    private Object tempColorScheme = null;
    private boolean addNotifyCalled = false;
    private boolean isZooming = false;
    private boolean isPanning = false;
    private boolean hasViewport = false;
    private AxisZoomPanHandler zoomPanHandler = null;
    private int minDiscreteTickCount = -1;
    private Object[] fixedTickValues = null;
    private boolean firstCompute = true;

    public AxisComponent() {
        this.axis = new Axes();
        this.axis.setMargin(0);
        this.axis.setLayoutRangeModel(false);
        this.axis.setExternalAxis(true);
        this.axisArea = new Rectangle();
        this.marginListeners = new MarginListenerList();
        this.addMouseListener(this);
        this.equalSpace = new Boolean(true);
    }

    public AxisComponent(int dim, String label) {
        this();
        if (dim == 1 || dim == 2) {
            TextStyleInterface l;
            this.setDimension(dim);
            this.setLabel(label);
            if (this.axis != null && (l = this.axis.getLabel()) instanceof TextAttrib) {
                TextAttrib text = (TextAttrib)l;
                text.userSetProperties.clear(9015);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
    }

    public boolean setDimension(int dim) {
        if (dim != 1 && dim != 2) {
            return false;
        }
        this.dimension = dim;
        this.axis.setDimension(this.dimension);
        return true;
    }

    public void setEqualSpace(boolean flag) {
        this.equalSpace = new Boolean(flag);
    }

    public boolean setAutoCalculate(boolean flag) {
        this.autoCalculate = flag;
        return true;
    }

    public boolean setLabelFormat(Object fmt) {
        if (fmt == null) {
            return false;
        }
        SASFormat format = null;
        if (fmt instanceof SASFormat) {
            format = (SASFormat)fmt;
        } else if (fmt instanceof String) {
            format = SASFormat.getInstance((String)((String)fmt));
        } else {
            return false;
        }
        this.axis.setLabel(format);
        return true;
    }

    public boolean setValuesFormat(Object fmt) {
        if (fmt == null) {
            return false;
        }
        SASFormat format = null;
        if (fmt instanceof SASFormat) {
            format = (SASFormat)fmt;
        } else if (fmt instanceof String) {
            format = SASFormat.getInstance((String)((String)fmt));
        } else {
            return false;
        }
        this.axis.setValues(format);
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawToGraphicsContext(g);
    }

    private void drawToGraphicsContext(Graphics g) {
        if (!this.axisReady) {
            this.updateAxis();
        }
        if (this.backgroundColor != null) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.compWidth, this.compHeight);
        }
        Shape oldClip = g.getClip();
        if (!this.addNotifyCalled) {
            g.setClip(this.getBounds().x, this.getBounds().y, this.getBounds().width + 1, this.getBounds().height + 1);
            g.translate(this.getBounds().x, this.getBounds().y);
        }
        this.axis.draw((Graphics2D)g, false);
        if (!this.addNotifyCalled) {
            g.translate(-this.getBounds().x, -this.getBounds().y);
            g.setClip(oldClip);
        }
    }

    private void computeAxisRegion() {
        this.axisArea.x = this.outerMargin.left;
        this.axisArea.y = this.outerMargin.top;
        this.axisArea.width = this.compWidth - this.outerMargin.left - this.outerMargin.right;
        this.axisArea.height = this.compHeight - this.outerMargin.top - this.outerMargin.bottom;
        if (this.axisArea.width == 0) {
            this.axisArea.width = -1;
        }
        if (this.axisArea.height == 0) {
            this.axisArea.height = -1;
        }
    }

    public boolean updateAxis() {
        if (this.innerMarginSet && this.outerMarginSet) {
            if (this.dimension == 1) {
                if (this.hasViewport && this.axis.isDiscrete()) {
                    this.axis.setOffset(0, 0);
                } else {
                    this.axis.setOffset(this.innerMargin.left, this.innerMargin.right);
                }
            } else if (this.dimension == 2) {
                if (this.hasViewport && this.axis.isDiscrete()) {
                    this.axis.setOffset(0, 0);
                } else {
                    this.axis.setOffset(this.innerMargin.bottom, this.innerMargin.top);
                }
            }
            this.axis.setScreenArea(this.axisArea.x, this.axisArea.y, this.axisArea.width, this.axisArea.height);
            this.axisReady = true;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.axis.setVisible(aFlag);
    }

    public boolean isAxisHidingLabels() {
        return this.axis.isHideValues();
    }

    private void calcPrefMargin(boolean throwEvent) {
        boolean adjustOuterMargin = false;
        boolean adjustInnerMargin = false;
        Insets tempOuterMargin = new Insets(0, 0, 0, 0);
        boolean hidingValueLabels = this.axis.isHideValues();
        if (this.dimension == 1) {
            int halfTickWidth = 0;
            if (!hidingValueLabels) {
                halfTickWidth = (int)(0.5 * (double)this.axis.getValueWidth((Graphics2D)this.getGraphics()));
            }
            if (this.innerMarginAdjust) {
                this.prefInnerMargin.left = halfTickWidth;
                this.prefInnerMargin.right = halfTickWidth;
            } else {
                this.prefOuterMargin.left = halfTickWidth;
                this.prefOuterMargin.right = halfTickWidth;
            }
            if (this.primary) {
                this.prefOuterMargin.bottom = this.axis.getBottomHeight((Graphics2D)this.getGraphics());
                tempOuterMargin.bottom = this.getHeight();
            } else {
                this.prefOuterMargin.top = this.axis.getTopHeight((Graphics2D)this.getGraphics());
                tempOuterMargin.top = this.getHeight();
            }
            tempOuterMargin.left = this.outerMargin.left;
            tempOuterMargin.right = this.outerMargin.right;
        } else if (this.dimension == 2) {
            int halfTopTickHeight;
            int halfBottomTickHeight;
            int n = halfBottomTickHeight = hidingValueLabels ? 0 : (int)(0.5 * (double)this.axis.getValueHeight((Graphics2D)this.getGraphics(), 0));
            int n2 = hidingValueLabels ? 0 : (halfTopTickHeight = (int)(0.5 * (double)this.axis.getValueHeight((Graphics2D)this.getGraphics(), this.numMajorTicks > 0 ? this.numMajorTicks - 1 : 0)));
            if (this.innerMarginAdjust) {
                this.prefInnerMargin.top = halfTopTickHeight;
                this.prefInnerMargin.bottom = halfBottomTickHeight;
            } else {
                this.prefOuterMargin.top = halfTopTickHeight;
                this.prefOuterMargin.bottom = halfBottomTickHeight;
            }
            if (this.primary) {
                this.prefOuterMargin.left = this.axis.getLeftWidth((Graphics2D)this.getGraphics());
                tempOuterMargin.left = this.getWidth();
            } else {
                this.prefOuterMargin.right = this.axis.getRightWidth((Graphics2D)this.getGraphics());
                tempOuterMargin.right = this.getWidth();
            }
            tempOuterMargin.top = this.outerMargin.top;
            tempOuterMargin.bottom = this.outerMargin.bottom;
        }
        if (tempOuterMargin.top < this.prefOuterMargin.top || tempOuterMargin.bottom < this.prefOuterMargin.bottom || tempOuterMargin.left < this.prefOuterMargin.left || tempOuterMargin.right < this.prefOuterMargin.right) {
            adjustOuterMargin = true;
        }
        if (this.innerMargin.top < this.prefInnerMargin.top || this.innerMargin.bottom < this.prefInnerMargin.bottom || this.innerMargin.left < this.prefInnerMargin.left || this.innerMargin.right < this.prefInnerMargin.right) {
            adjustInnerMargin = true;
        }
        if (!this.marginEvent && throwEvent) {
            if (adjustOuterMargin) {
                this.throwMarginChangedEvent(2);
            }
            if (this.innerMarginAdjust && adjustInnerMargin) {
                this.throwMarginChangedEvent(1);
            }
        }
    }

    public void recompute() {
        if (this.fontHeightSet) {
            this.computeAxisRegion();
            if (this.updateAxis() && this.calculateMargin) {
                this.calcPrefMargin(!this.firstCompute);
            }
        }
    }

    private void throwMarginChangedEvent(int margin) {
        this.marginEvent = true;
        MarginChangeEvent e = new MarginChangeEvent((Object)this);
        if (margin == 1) {
            e.setInnerChanged(true);
            e.setOuterChanged(false);
        } else {
            e.setOuterChanged(true);
            e.setInnerChanged(false);
        }
        this.marginListeners.marginChanged(e);
        this.marginEvent = false;
    }

    public boolean setInnerMarginAdjust(boolean flag) {
        this.innerMarginAdjust = flag;
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    public void setDimension(byte dim) {
        this.dimension = dim;
    }

    public byte getDimension() {
        return (byte)this.dimension;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
        this.axis.setPrimary(primary);
    }

    public void setRange(DataRange range) {
        if (range == null) {
            this.numericRange = null;
            this.discreteRange = null;
            if (this.axis != null) {
                this.axis.resetRange();
            }
            return;
        }
        if (range instanceof ContinuousRange) {
            this.numericRange = (ContinuousRange)range;
            this.discreteRange = null;
            Object[] tickValueList = null;
            if (this.isTickValueListValid(true)) {
                tickValueList = this.boundTickValueList(true, (DataRange)this.numericRange);
            }
            Object[] tickValues = null;
            if (this.fixedTickValues != null) {
                tickValues = this.fixedTickValues;
            } else if (tickValueList != null) {
                tickValues = tickValueList;
            } else if (this.isPanning && this.hasViewport) {
                tickValues = AxisZoomPanHandler.panTickValues(this.numericRange.getMin(), this.numericRange.getMax(), this.axis.getTickMarkValues(false));
            }
            Boolean esd = Boolean.FALSE;
            Double min = new Double(this.numericRange.getMin());
            Double max = new Double(this.numericRange.getMax());
            if (Double.isNaN(min) || Double.isNaN(max)) {
                this.axis.resetRange();
                return;
            }
            if (tickValues == null) {
                esd = null;
            }
            this.axis.setUseUserSetMinMax(this.hasViewport || this.fixedTickValues != null);
            this.axis.setAxis(min, max, this.numMajorTicks, -1, tickValues, this.autoCalculate, esd);
        } else if (range instanceof DiscreteRange) {
            if (this.discreteRange == null && (this.isZooming || this.isPanning)) {
                return;
            }
            boolean rangeChanged = false;
            if (((DiscreteRange)range).isEmpty()) {
                this.axis.resetRange();
                return;
            }
            if (this.zoomPanHandler == null || !this.zoomPanHandler.hasViewport()) {
                this.discreteRange = (DiscreteRange)range;
                rangeChanged = true;
            }
            this.numericRange = null;
            if (this.discreteRange.getValuesSize() > 0) {
                int size = Math.max(this.minDiscreteTickCount, this.discreteRange.getValuesSize());
                Object[] values = new Object[size];
                DiscreteRange dr = SILKUtilities.createPaddedRange(this.discreteRange, this.minDiscreteTickCount);
                if (rangeChanged) {
                    this.discreteRange = dr;
                }
                int i = 0;
                Enumeration list = dr.getEnumeration();
                while (list.hasMoreElements()) {
                    values[i++] = list.nextElement();
                }
                Double min = null;
                Double max = null;
                Boolean auto = null;
                if (!this.hasViewport || this.isZooming) {
                    auto = Boolean.TRUE;
                }
                if (this.zoomPanHandler != null) {
                    if (this.zoomPanHandler.hasViewport()) {
                        min = new Double(this.zoomPanHandler.getViewportMin());
                        max = new Double(this.zoomPanHandler.getViewportMax());
                    }
                    this.axis.setUseUserSetMinMax(this.zoomPanHandler.hasViewport());
                }
                this.axis.setAxis(min, max, -1, -1, values, auto, this.equalSpace);
            }
        }
    }

    public DataRange getDataRange() {
        if (this.numericRange != null) {
            return this.numericRange;
        }
        if (this.zoomPanHandler != null && this.zoomPanHandler.hasViewport()) {
            return new ContinuousRange(this.zoomPanHandler.getViewportMin(), this.zoomPanHandler.getViewportMax());
        }
        return this.discreteRange;
    }

    public DataRange getOutputRange() {
        if (this.numericRange != null) {
            if (this.axis.getTransformType() == 1 && this.axis.hasUserSetMax() && this.axis.hasUserSetMin()) {
                return new ContinuousRange(this.axis.getUserMin(), this.axis.getUserMax());
            }
            double[] range = this.axis.getEndPoint(false, false);
            if (range != null) {
                double d1 = Math.min(range[0], range[1]);
                double d2 = Math.max(range[0], range[1]);
                Object[] tickValueList = this.axis.getTickValueList();
                if (this.fixedTickValues != null) {
                    d1 = Math.min(this.numericRange.getMin(), d1);
                    d2 = Math.max(this.numericRange.getMax(), d2);
                } else if (tickValueList != null && tickValueList.length > 0 && this.isTickValueListValid(true)) {
                    return new ContinuousRange(this.numericRange.getMin(), this.numericRange.getMax());
                }
                return new ContinuousRange(d1, d2);
            }
            return this.numericRange;
        }
        return this.discreteRange;
    }

    private Object[] boundTickValueList(boolean numericList, DataRange range) {
        if (!this.isTickValueListValid(numericList)) {
            return null;
        }
        if (this.isZooming || this.isPanning) {
            return this.axis.getInternalTickValueList();
        }
        Object[] tickValueList = this.axis.getTickValueList();
        if (numericList) {
            if (range instanceof ContinuousRange) {
                ContinuousRange cr = (ContinuousRange)range;
                Vector<Object> v = new Vector<Object>();
                Vector<String> display = new Vector<String>();
                String[] tickDisplayList = this.axis.getTickDisplayList();
                for (int i = 0; i < tickValueList.length; ++i) {
                    double tv = ((Number)tickValueList[i]).doubleValue();
                    if (!(cr.getMin() <= tv) || !(cr.getMax() >= tv)) continue;
                    v.add(tickValueList[i]);
                    if (tickDisplayList == null || i >= tickDisplayList.length) continue;
                    display.add(tickDisplayList[i]);
                }
                if (v.size() == tickValueList.length) {
                    this.axis.setInternalTickValueList(this.axis.getTickValueList());
                    this.axis.setInternalTickDisplayList(this.axis.getTickDisplayList());
                }
                if (v.size() > 0) {
                    this.axis.setInternalTickValueList(v.toArray());
                    if (display.size() > 0) {
                        String[] tdl = new String[display.size()];
                        for (int i = 0; i < tdl.length; ++i) {
                            Object td = display.elementAt(i);
                            if (td == null) continue;
                            tdl[i] = td.toString();
                        }
                        this.axis.setInternalTickDisplayList(tdl);
                    }
                } else {
                    this.axis.setInternalTickValueList(null);
                    this.axis.setInternalTickDisplayList(null);
                }
                return this.axis.getInternalTickValueList();
            }
            return null;
        }
        return tickValueList;
    }

    private boolean isTickValueListValid(boolean numericList) {
        Object[] tickValueList = this.axis.getTickValueList();
        if (tickValueList == null || tickValueList.length == 0) {
            return false;
        }
        if (numericList) {
            if (this.axis.getTransformType() == 1 && !this.axis.isDateTime()) {
                for (int i = 0; i < tickValueList.length; ++i) {
                    if (tickValueList[i] instanceof Number) continue;
                    this.axis.clearTickValueList();
                    return false;
                }
                return true;
            }
            this.axis.clearTickValueList();
        }
        return false;
    }

    public Insets getPreferredInnerMargin() {
        return this.prefInnerMargin;
    }

    public Insets getPreferredOuterMargin() {
        return this.prefOuterMargin;
    }

    public void setInnerMargin(Insets margin) {
        this.innerMargin = margin;
        this.innerMarginSet = true;
        this.recompute();
    }

    public void setOuterMargin(Insets margin) {
        this.outerMargin = margin;
        this.outerMarginSet = true;
        this.recompute();
    }

    public Insets getInnerMargin() {
        return this.innerMargin;
    }

    public Insets getOuterMargin() {
        return this.outerMargin;
    }

    public void enableMarginPrefCalc() {
        this.calculateMargin = true;
    }

    public void disableMarginPrefCalc() {
        this.calculateMargin = false;
    }

    public void addMarginListener(MarginListener listener) {
        if (listener != null) {
            this.marginListeners.add(listener);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        if (listener != null) {
            this.marginListeners.remove(listener);
        }
    }

    @Override
    public Rectangle getBounds() {
        return super.getBounds();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.compWidth = width;
        this.compHeight = height;
        if (this.firstCompute) {
            this.firstCompute = false;
        }
        if (this.dimension == 1) {
            if (this.primary) {
                this.axis.setMargin(height);
            } else {
                this.axis.setMargin(0);
            }
        } else if (this.dimension == 2) {
            if (this.primary) {
                this.axis.setMargin(0);
            } else {
                this.axis.setMargin(width);
            }
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setDefaultFont(double height) {
        this.axis.setDefaultFontSize((int)height);
        this.fontHeightSet = true;
        this.recompute();
    }

    public boolean setNumMajorTickMarks(int nticks) {
        if (nticks < 0) {
            return false;
        }
        this.numMajorTicks = nticks;
        return true;
    }

    public boolean isPropertySupported(int id) {
        if (this.axis != null) {
            return this.axis.isPropertySupported(id);
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        if (this.axis != null) {
            return this.axis.isPropertyPending(id);
        }
        return false;
    }

    public Object getPropertyValue(int id) {
        if (this.axis != null) {
            return this.axis.getPropertyValue(id);
        }
        return null;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (id == 0) {
            this.tempColorScheme = value;
        }
        if (this.axis != null) {
            return this.axis.setPropertyValue(id, value);
        }
        return false;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        if (this.axis != null) {
            rc = this.axis.hasUserSetValue(id);
        }
        return rc;
    }

    public int getNumberPendingProperties() {
        if (this.axis != null) {
            return this.axis.getNumberPendingProperties();
        }
        return 0;
    }

    public boolean applyPropertyChanges() {
        if (this.axis != null) {
            boolean returnVal = this.axis.applyPropertyChanges();
            if (this.fontHeightSet) {
                this.calcPrefMargin(true);
            }
            if (this.tempColorScheme != null && this.tempColorScheme instanceof Style) {
                this.setStyle((Style)this.tempColorScheme);
            }
            this.tempColorScheme = null;
            return returnVal;
        }
        return false;
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.axis != null) {
            boolean returnVal = this.axis.applyPropertyChanges(source);
            if (returnVal && this.fontHeightSet) {
                this.calcPrefMargin(true);
            }
            return returnVal;
        }
        return false;
    }

    public void cancelPropertyChanges() {
        if (this.axis != null) {
            this.axis.cancelPropertyChanges();
        }
        this.tempColorScheme = null;
    }

    public void cancelPropertyChanges(Object source) {
        if (this.axis != null) {
            this.axis.cancelPropertyChanges(source);
        }
        this.tempColorScheme = null;
    }

    public int[] getPendingChanges() {
        if (this.axis != null) {
            return this.axis.getPendingChanges();
        }
        return null;
    }

    public int[] getPendingChanges(Object source) {
        if (this.axis != null) {
            return this.axis.getPendingChanges(source);
        }
        return null;
    }

    public void setStyle(Style style) {
        if (style == null) {
            return;
        }
        this.setSolidBackground(style.getFillStyleElement("Backfill").getFillColor());
        this.setWall(style.getFillStyleElement("WallFill").getFillColor());
        this.axis.applyStyle(style);
    }

    public boolean setSolidBackground(Object c) {
        if (c == null) {
            this.backgroundColor = null;
        } else if (c instanceof Color) {
            this.backgroundColor = (Color)c;
        } else if (c instanceof String) {
            this.backgroundColor = ColorParse.getColorFromString((String)((String)c));
            if (this.backgroundColor == null) {
                return false;
            }
        } else {
            return false;
        }
        this.axis.setBackgroundColor(this.backgroundColor);
        this.repaint();
        return true;
    }

    public boolean setWall(Object c) {
        if (c == null) {
            this.wallColor = null;
        } else if (c instanceof Color) {
            this.wallColor = (Color)c;
        } else if (c instanceof String) {
            this.wallColor = ColorParse.getColorFromString((String)((String)c));
            if (this.wallColor == null) {
                return false;
            }
        } else {
            return false;
        }
        this.axis.setWallColor(this.wallColor);
        this.repaint();
        return true;
    }

    @Override
    public LineStyleInterface getLine() {
        return this.axis.getLine();
    }

    @Override
    public boolean setLine(Object line) {
        return this.axis.setLine(line);
    }

    @Override
    public TextStyleInterface getLabel() {
        return this.axis.getLabel();
    }

    @Override
    public boolean setLabel(Object labelIn) {
        return this.axis.setLabel(labelIn);
    }

    @Override
    public String getLabelString() {
        return this.axis.getLabelString();
    }

    @Override
    public TextStyleInterface getValues() {
        return this.axis.getValues();
    }

    @Override
    public boolean setValues(Object valuesIn) {
        return this.axis.setValues(valuesIn);
    }

    @Override
    public LineStyleInterface getMajorTicks() {
        return this.axis.getMajorTicks();
    }

    @Override
    public boolean setMajorTicks(Object ticks) {
        return this.axis.setMajorTicks(ticks);
    }

    @Override
    public LineStyleInterface getMinorTicks() {
        return this.axis.getMinorTicks();
    }

    @Override
    public boolean setMinorTicks(Object ticks) {
        return this.axis.setMinorTicks(ticks);
    }

    @Override
    public LineStyleInterface getGridLines() {
        return this.axis.getGridLines();
    }

    @Override
    public boolean setGridLines(Object lines) {
        return this.axis.setGridLines(lines);
    }

    @Override
    public boolean setAxis(Object low, Object high, int nMajor, int nMinor, Object[] values, Boolean autoCalculate, Boolean equallySpacedDiscrete) {
        return this.axis.setAxis(low, high, nMajor, nMinor, values, autoCalculate, equallySpacedDiscrete);
    }

    @Override
    public boolean isAxisAutoCalculated() {
        return this.axis.isAxisAutoCalculated();
    }

    @Override
    public double[] getEndPoint(boolean high, boolean screen) {
        return this.axis.getEndPoint(high, screen);
    }

    @Override
    public Object[] getTickMarkValues(boolean formatted) {
        return this.axis.getTickMarkValues(formatted);
    }

    @Override
    public int getNumberMajorTicks() {
        return this.axis.getNumberMajorTicks();
    }

    @Override
    public int getNumberMinorTicks() {
        return this.axis.getNumberMinorTicks();
    }

    @Override
    public void setMultiRole(boolean multi) {
        this.axis.setMultiRole(multi);
    }

    @Override
    public ReferenceLineInterface addReferenceLine(Object value, String label) {
        return this.axis.addReferenceLine(value, label);
    }

    @Override
    public boolean removeReferenceLine(Object id, boolean nearest) {
        return this.removeReferenceLine(id, nearest);
    }

    @Override
    public boolean removeAllReferenceLines() {
        return this.axis.removeAllReferenceLines();
    }

    @Override
    public ReferenceLineInterface getReferenceLineByValue(Object value, boolean nearest) {
        return this.axis.getReferenceLineByValue(value, nearest);
    }

    @Override
    public ReferenceLineInterface getReferenceLine(int index) {
        return this.axis.getReferenceLine(index);
    }

    @Override
    public int getNumberReferenceLines() {
        return this.axis.getNumberReferenceLines();
    }

    @Override
    public boolean setRangeModel(Object obj) {
        return this.axis.setRangeModel(obj);
    }

    @Override
    public Object getRangeModel(boolean createFlag) {
        return this.axis.getRangeModel(createFlag);
    }

    @Override
    public int getTimeSplittingPolicy() {
        return this.axis.getTimeSplittingPolicy();
    }

    @Override
    public void setTimeSplittingPolicy(int policy) {
        this.axis.setTimeSplittingPolicy(policy);
    }

    @Override
    public boolean isFixedFormat() {
        return this.axis.isFixedFormat();
    }

    @Override
    public void setFixedFormat(boolean fix) {
        this.axis.setFixedFormat(fix);
    }

    @Override
    public void setTransformType(int type, Object transInfo) {
        if (this.axis != null) {
            this.axis.setTransformType(type, transInfo);
        }
    }

    @Override
    public int getTransformType() {
        if (this.axis != null) {
            return this.axis.getTransformType();
        }
        return -1;
    }

    @Override
    public Object getTransformInfo(int transformType) {
        if (this.axis != null) {
            return this.axis.getTransformInfo(transformType);
        }
        return null;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public Object getOpacityValue() {
        return null;
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        return false;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        if (p instanceof Graphics) {
            Graphics g = (Graphics)p;
            this.drawToGraphicsContext(g);
        }
    }

    @Override
    public void drawHighlight(Object p) {
    }

    public AxisInterface getInternalAxis() {
        return this.axis;
    }

    public boolean isPanning() {
        return this.isPanning;
    }

    public void setPanning(boolean isPanning) {
        this.isPanning = isPanning;
        if (isPanning) {
            this.isZooming = false;
        }
    }

    public boolean isZooming() {
        return this.isZooming;
    }

    public void setZooming(boolean isZooming) {
        this.isZooming = isZooming;
        if (isZooming) {
            this.isPanning = false;
        }
    }

    public boolean isHasViewport() {
        return this.hasViewport;
    }

    public void setHasViewport(boolean hasViewport) {
        this.hasViewport = hasViewport;
    }

    @Override
    public void setThreshold(double value) {
        if (this.axis != null) {
            this.axis.setThreshold(value);
            this.calcPrefMargin(true);
        }
    }

    public AxisZoomPanHandler getZoomPanHandler() {
        return this.zoomPanHandler;
    }

    public void setZoomPanHandler(AxisZoomPanHandler zoomPanHansler) {
        this.zoomPanHandler = zoomPanHansler;
    }

    public void setFullDataRange(DataRange range) {
        if (this.axis != null) {
            if (range instanceof ContinuousRange) {
                this.axis.setFullDataRange(((ContinuousRange)range).getMin(), ((ContinuousRange)range).getMax());
            } else if (range instanceof DiscreteRange) {
                this.axis.setFullDataRange(0.0, ((DiscreteRange)range).getValuesSize() - 1);
            } else {
                this.axis.setFullDataRange(Double.NaN, Double.NaN);
            }
        }
    }

    public int getMinDiscreteTickCount() {
        return this.minDiscreteTickCount;
    }

    public void setMinDiscreteTickCount(int minDiscreteTickCount) {
        this.minDiscreteTickCount = minDiscreteTickCount;
    }

    public boolean hasUserSetMin() {
        return this.axis.hasUserSetMin();
    }

    public boolean hasUserSetMax() {
        return this.axis.hasUserSetMax();
    }

    public double getUserSetMin() {
        return this.axis.getUserMin();
    }

    public double getUserSetMax() {
        return this.axis.getUserMax();
    }

    public Object[] getFixedTickValues() {
        return this.fixedTickValues;
    }

    public void setFixedTickValues(Object[] fixedTickValues, boolean updateInternalAxis) {
        this.fixedTickValues = fixedTickValues;
        if (this.axis != null) {
            this.axis.setFixedTicks(fixedTickValues);
        }
        if (updateInternalAxis) {
            this.setRange((DataRange)this.numericRange);
        }
    }

    public void setAxisSize() {
        this.computeAxisRegion();
        this.updateAxis();
    }

    public void layoutValueLabels(Graphics g) {
        this.axis.layoutValueLabels(null);
    }
}

