/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.AlphaInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.Search;
import com.sas.graphics.util.Sort;
import java.util.List;
import java.util.Vector;

public class AlphaRamp
implements AlphaInterface,
CompareInterface {
    protected boolean isChar;
    protected boolean ignoreCase;
    protected long flags;
    protected double missingAlpha;
    protected double underflowAlpha;
    protected double overflowAlpha;
    protected double minBreak;
    protected double maxBreak;
    protected Vector breakPoints;
    protected DynamicIntArray sortIndicies;
    protected double[] defaultAlphas;

    public AlphaRamp(Object alphas, Object breaks, long flagsIn) {
        this.setup(flagsIn);
        this.setAlphas(alphas, breaks);
    }

    public AlphaRamp(Object alphas, Object min, Object max, long flagsIn) {
        this.setup(flagsIn);
        this.setAlphas(alphas, min, max);
    }

    public AlphaRamp(Object alphas, double min, double max, long flagsIn) {
        this.setup(flagsIn);
        this.setAlphas(alphas, min, max);
    }

    public AlphaRamp() {
        this(null, null, 0L);
    }

    protected void setup(long flagsIn) {
        GlobalDefaults gblDefs = new GlobalDefaults();
        this.defaultAlphas = new double[2];
        if (this.defaultAlphas != null) {
            this.defaultAlphas[0] = 0.1;
            this.defaultAlphas[1] = 1.0;
            if (gblDefs != null) {
                this.defaultAlphas[0] = gblDefs.alphaMin;
                this.defaultAlphas[1] = gblDefs.alphaMax;
            }
            this.defaultAlphas[0] = Math.min(this.defaultAlphas[0], 1.0);
            this.defaultAlphas[0] = Math.max(this.defaultAlphas[0], 0.0);
            this.defaultAlphas[1] = Math.min(this.defaultAlphas[1], 1.0);
            this.defaultAlphas[1] = Math.max(this.defaultAlphas[1], 0.0);
        }
        this.isChar = false;
        this.ignoreCase = false;
        this.flags = flagsIn;
        this.missingAlpha = 1.0;
        this.underflowAlpha = 1.0;
        this.overflowAlpha = 1.0;
        this.minBreak = 0.0;
        this.maxBreak = 1.0;
        this.breakPoints = new Vector();
        if (this.breakPoints == null) {
            throw new OutOfMemoryError();
        }
        this.sortIndicies = new DynamicIntArray(20);
        if (this.sortIndicies == null) {
            throw new OutOfMemoryError();
        }
    }

    public double getNumericElement(Object entry) {
        return ((Number)((AlphaBreak)entry).value).doubleValue();
    }

    public String getStringElement(Object entry) {
        return (String)((AlphaBreak)entry).value;
    }

    protected void clearAllBreakPoints(Vector points, DynamicIntArray indicies) {
        points.removeAllElements();
        indicies.removeAll();
    }

    protected boolean addBreak(int idx, Object value, double alpha, Vector breaks, DynamicIntArray indicies) {
        if (value == null || Double.isNaN(alpha) || Double.isInfinite(alpha) || breaks == null || indicies == null) {
            return false;
        }
        if (!(value instanceof String) && !(value instanceof Number)) {
            return false;
        }
        if (breaks.size() > 0) {
            if (this.isChar && value instanceof Number) {
                return false;
            }
            if (!this.isChar && value instanceof String) {
                return false;
            }
        } else {
            this.isChar = value instanceof String;
        }
        switch (idx) {
            case -1: {
                breaks.addElement(new AlphaBreak(value, alpha));
                break;
            }
            case -2: {
                breaks.setElementAt(new AlphaBreak(value, alpha), 0);
                break;
            }
            case -3: {
                idx = Search.binarylookup((Object)value, (Vector)breaks, (int[])indicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
                if (idx >= 0) {
                    breaks.setElementAt(new AlphaBreak(value, alpha), idx);
                    return true;
                }
                idx = -idx - 1;
                breaks.insertElementAt(new AlphaBreak(value, alpha), idx);
                break;
            }
            default: {
                if (idx < 0 || idx >= breaks.size()) {
                    return false;
                }
                breaks.setElementAt(new AlphaBreak(value, alpha), idx);
            }
        }
        indicies.add(breaks.size() - 1);
        if (this.isChar) {
            Sort.heapsort(String.class, (List)breaks, (int[])indicies.getElements(), (int)-1, (CompareInterface)this);
        } else {
            Sort.heapsort(Double.class, (List)breaks, (int[])indicies.getElements(), (int)-1, (CompareInterface)this);
        }
        if (!this.isChar) {
            if (indicies.getNumberElements() == 1) {
                AlphaBreak cb = (AlphaBreak)breaks.elementAt(indicies.get(0));
                if (cb != null) {
                    this.minBreak = this.maxBreak = ((Number)cb.value).doubleValue();
                }
            } else if (indicies.getNumberElements() > 1) {
                AlphaBreak cb = (AlphaBreak)breaks.elementAt(indicies.get(0));
                if (cb != null) {
                    this.minBreak = ((Number)cb.value).doubleValue();
                }
                if ((cb = (AlphaBreak)breaks.elementAt(indicies.get(indicies.getNumberElements() - 1))) != null) {
                    this.maxBreak = ((Number)cb.value).doubleValue();
                }
            }
        }
        return true;
    }

    protected boolean delBreak(int idx, Vector breaks, DynamicIntArray indicies) {
        if (idx < 0 || idx >= breaks.size()) {
            return false;
        }
        int delIdx = indicies.get(idx);
        breaks.removeElementAt(idx);
        indicies.removeAt(idx);
        for (int i = 0; i < indicies.getNumberElements(); ++i) {
            int curIdx = indicies.get(i);
            if (curIdx < delIdx) continue;
            indicies.setAt(curIdx - 1, i);
        }
        return true;
    }

    protected double clampAlpha(double aa) {
        double a = aa;
        if (a < 0.0) {
            a = 0.0;
        } else if (a > 1.0) {
            a = 1.0;
        }
        return a;
    }

    protected double interpolate(AlphaBreak cb1, AlphaBreak cb2, double v, boolean discrete) {
        if (cb1 == null || cb2 == null) {
            return Double.NaN;
        }
        double v1 = ((Number)cb1.value).doubleValue();
        double v2 = ((Number)cb2.value).doubleValue();
        double fraction = (v - v1) / (v2 - v1);
        if (discrete) {
            if (fraction < 0.5) {
                return cb1.alpha;
            }
            return cb2.alpha;
        }
        double a1 = this.clampAlpha(cb1.alpha);
        double a2 = this.clampAlpha(cb2.alpha);
        double a = (a2 - a1) * fraction + a1;
        return a;
    }

    protected int setAlphas(Object alphas, Object breaks, Vector breaksTarget, DynamicIntArray sortTarget) {
        int nBreaks;
        int n;
        int i;
        int nDone = 0;
        int aType = 0;
        int brkType = 0;
        double[] defaultBreaks = null;
        if (alphas == null) {
            return 0;
        }
        aType = Extract.getSourceType((Object)alphas);
        int nAlphas = Extract.getNumberItems((Object)alphas, (int)aType);
        if (breaks == null) {
            defaultBreaks = new double[nAlphas];
            breaks = defaultBreaks;
            if (defaultBreaks != null) {
                for (i = 0; i < nAlphas; ++i) {
                    defaultBreaks[i] = (double)i / (double)(nAlphas - 1);
                }
            }
        }
        if ((n = Math.min(nAlphas, nBreaks = Extract.getNumberItems((Object)breaks, (int)(brkType = Extract.getSourceType((Object)breaks))))) <= 0) {
            return nDone;
        }
        this.clearAllBreakPoints(breaksTarget, sortTarget);
        this.isChar = false;
        this.minBreak = 0.0;
        this.maxBreak = 1.0;
        for (i = 0; i < n; ++i) {
            if (!this.addBreak(-1, Extract.getObject((Object)breaks, (int)i, (int)brkType), Extract.getNumeric((Object)alphas, (int)i, (int)aType), breaksTarget, sortTarget)) continue;
            ++nDone;
        }
        return nDone;
    }

    @Override
    public long getMasks() {
        return this.flags;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return this.flags;
    }

    @Override
    public Object[] getBreaks() {
        AlphaBreak cb = null;
        Object[] out = null;
        if (this.breakPoints == null || this.breakPoints.size() <= 0) {
            return null;
        }
        int n = this.breakPoints.size();
        out = new Object[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            cb = (AlphaBreak)this.breakPoints.elementAt(i);
            if (cb == null) {
                return null;
            }
            out[i] = cb.value;
        }
        return out;
    }

    @Override
    public double getMinAlpha() {
        if (this.breakPoints == null || this.breakPoints.size() <= 0) {
            return Double.NaN;
        }
        AlphaBreak bp = (AlphaBreak)this.breakPoints.elementAt(0);
        if (bp == null) {
            return Double.NaN;
        }
        return bp.alpha;
    }

    @Override
    public double getMaxAlpha() {
        int n = 0;
        if (this.breakPoints == null || (n = this.breakPoints.size()) <= 0) {
            return Double.NaN;
        }
        AlphaBreak bp = (AlphaBreak)this.breakPoints.elementAt(n - 1);
        if (bp == null) {
            return Double.NaN;
        }
        return bp.alpha;
    }

    @Override
    public double[] getAlphas() {
        AlphaBreak cb = null;
        double[] out = null;
        if (this.breakPoints == null || this.breakPoints.size() <= 0) {
            return null;
        }
        int n = this.breakPoints.size();
        out = new double[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            cb = (AlphaBreak)this.breakPoints.elementAt(i);
            if (cb == null) {
                return null;
            }
            out[i] = cb.alpha;
        }
        return out;
    }

    @Override
    public int setAlphas(Object alphas, Object breaks) {
        return this.setAlphas(alphas, breaks, this.breakPoints, this.sortIndicies);
    }

    @Override
    public int setAlphas(Object alphas, Object min, Object max) {
        if (min == null || max == null || !(min instanceof Number) || !(max instanceof Number)) {
            return 0;
        }
        return this.setAlphas(alphas, ((Number)min).doubleValue(), ((Number)max).doubleValue());
    }

    @Override
    public int setAlphas(Object alphas, double min, double max) {
        int n;
        double[] darray = null;
        if (Double.isInfinite(min) || Double.isInfinite(max) || Double.isNaN(min) || Double.isNaN(max)) {
            return 0;
        }
        if (alphas == null) {
            alphas = this.defaultAlphas;
        }
        if ((n = Extract.getNumberItems((Object)alphas, (int)Extract.getSourceType((Object)alphas))) <= 0) {
            return 0;
        }
        darray = new double[n];
        if (darray == null) {
            return 0;
        }
        darray[0] = min;
        darray[n - 1] = max;
        for (int i = 1; i < n - 1; ++i) {
            darray[i] = (double)i / (double)(n - 1) * (max - min) + min;
        }
        return this.setAlphas(alphas, darray);
    }

    @Override
    public int setAlphas(Object alphas) {
        AlphaBreak cb = null;
        if (this.breakPoints == null || this.breakPoints.size() <= 0) {
            return -1;
        }
        cb = (AlphaBreak)this.breakPoints.elementAt(0);
        if (cb == null) {
            return -1;
        }
        Object min = cb.value;
        cb = (AlphaBreak)this.breakPoints.elementAt(this.breakPoints.size() - 1);
        if (cb == null) {
            return -1;
        }
        Object max = cb.value;
        return this.setAlphas(alphas, min, max);
    }

    @Override
    public boolean setRange(Object min, Object max) {
        double[] clrs = this.getAlphas();
        if (clrs == null) {
            return false;
        }
        return this.setAlphas((Object)clrs, min, max) == clrs.length;
    }

    @Override
    public boolean setRange(double min, double max) {
        double[] clrs = this.getAlphas();
        if (clrs == null) {
            return false;
        }
        return this.setAlphas((Object)clrs, min, max) == clrs.length;
    }

    @Override
    public double query(int index, boolean wrap) {
        AlphaBreak cb;
        boolean sortedGet = (this.flags & 1L) != 0L;
        int idx = index;
        if (index < 0) {
            return Double.NaN;
        }
        if (wrap) {
            idx %= this.breakPoints.size();
        }
        if (idx >= this.breakPoints.size()) {
            return Double.NaN;
        }
        if (sortedGet) {
            idx = this.sortIndicies.get(idx);
        }
        if ((cb = (AlphaBreak)this.breakPoints.elementAt(idx)) == null) {
            return Double.NaN;
        }
        return cb.alpha;
    }

    @Override
    public double query(Object breakValue, boolean discrete) {
        Number dObj = null;
        AlphaBreak cb1 = null;
        AlphaBreak cb2 = null;
        if (breakValue == null) {
            return Double.NaN;
        }
        if (this.isChar && breakValue instanceof Number) {
            return Double.NaN;
        }
        if (!this.isChar && breakValue instanceof String) {
            return Double.NaN;
        }
        if (breakValue instanceof String) {
            int idx = Search.binarylookup((Object)breakValue, (Vector)this.breakPoints, (int[])this.sortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
            if (idx < 0) {
                return Double.NaN;
            }
            cb1 = (AlphaBreak)this.breakPoints.elementAt(idx);
            if (cb1 == null) {
                return Double.NaN;
            }
            return cb1.alpha;
        }
        if (!(breakValue instanceof Number)) {
            return Double.NaN;
        }
        dObj = (Number)breakValue;
        if (dObj instanceof Double && ((Double)dObj).isNaN()) {
            return this.missingAlpha;
        }
        if (dObj instanceof Double && ((Double)dObj).isInfinite()) {
            if (dObj.doubleValue() == Double.NEGATIVE_INFINITY) {
                return this.underflowAlpha;
            }
            return this.overflowAlpha;
        }
        int idx = Search.binarylookup((Object)dObj, (Vector)this.breakPoints, (int[])this.sortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
        if (idx < 0) {
            if ((idx = -idx - 1) <= 0) {
                return this.underflowAlpha;
            }
            if (idx >= this.breakPoints.size()) {
                return this.overflowAlpha;
            }
            cb1 = (AlphaBreak)this.breakPoints.elementAt(idx - 1);
            cb2 = (AlphaBreak)this.breakPoints.elementAt(idx);
            return this.interpolate(cb1, cb2, dObj.doubleValue(), discrete);
        }
        cb1 = (AlphaBreak)this.breakPoints.elementAt(idx);
        if (cb1 == null) {
            return Double.NaN;
        }
        return cb1.alpha;
    }

    @Override
    public double queryDouble(double breakValue, boolean discrete) {
        return this.query(new Double(breakValue), discrete);
    }

    @Override
    public double queryDouble(double response, double low, double high, boolean discrete) {
        if (Double.isNaN(response) || Double.isNaN(low) || Double.isNaN(high) || high <= low) {
            return this.queryDouble(Double.NaN, discrete);
        }
        return this.queryDouble((this.maxBreak - this.minBreak) * ((response - low) / (high - low)) + this.minBreak, discrete);
    }

    @Override
    public double query(Object response, Object low, Object high, boolean discrete) {
        if (!(response != null && low != null && high != null && response instanceof Double && low instanceof Double && high instanceof Double)) {
            return Double.NaN;
        }
        return this.queryDouble((((Number)response).doubleValue() - ((Number)low).doubleValue()) / (((Number)high).doubleValue() - ((Number)low).doubleValue()), discrete);
    }

    @Override
    public int getNumberAlphas() {
        if (this.breakPoints == null) {
            return 0;
        }
        return this.breakPoints.size();
    }

    @Override
    public double getUnderflowAlpha() {
        return this.underflowAlpha;
    }

    @Override
    public boolean setUnderflowAlpha(double underAlpha) {
        if (Double.isNaN(underAlpha) || Double.isInfinite(underAlpha) || underAlpha < 0.0 || underAlpha > 1.0) {
            return false;
        }
        this.underflowAlpha = underAlpha;
        return true;
    }

    @Override
    public double getOverflowAlpha() {
        return this.overflowAlpha;
    }

    @Override
    public boolean setOverflowAlpha(double overAlpha) {
        if (Double.isNaN(overAlpha) || Double.isInfinite(overAlpha) || overAlpha < 0.0 || overAlpha > 1.0) {
            return false;
        }
        this.overflowAlpha = overAlpha;
        return true;
    }

    @Override
    public double getMissingAlpha() {
        return this.missingAlpha;
    }

    @Override
    public boolean setMissingAlpha(double missAlpha) {
        if (Double.isNaN(missAlpha) || Double.isInfinite(missAlpha) || missAlpha < 0.0 || missAlpha > 1.0) {
            return false;
        }
        this.missingAlpha = missAlpha;
        return true;
    }

    @Override
    public boolean setBreakPoint(int idx, Object value, double a) {
        return this.addBreak(idx, value, a, this.breakPoints, this.sortIndicies);
    }

    @Override
    public boolean removeBreakPoint(int idx, Object value, boolean nearest) {
        switch (idx) {
            case -3: {
                idx = Search.binarylookup((Object)value, (Vector)this.breakPoints, (int[])this.sortIndicies.getElements(), (boolean)false, (int)-1, (CompareInterface)this);
                if (idx >= 0) break;
                if (nearest && !this.isChar) {
                    if ((idx = -idx - 1) == 0) break;
                    if (idx == this.breakPoints.size()) {
                        --idx;
                        break;
                    }
                    AlphaBreak cb1 = (AlphaBreak)this.breakPoints.elementAt(idx - 1);
                    AlphaBreak cb2 = (AlphaBreak)this.breakPoints.elementAt(idx);
                    if (cb1 == null || cb2 == null) {
                        return false;
                    }
                    double v1 = ((Number)cb1.value).doubleValue();
                    double v2 = ((Number)cb2.value).doubleValue();
                    double v = ((Number)value).doubleValue();
                    double fraction = (v - v1) / (v2 - v1);
                    if (!(fraction < 0.5)) break;
                    --idx;
                    break;
                }
                return false;
            }
        }
        return this.delBreak(idx, this.breakPoints, this.sortIndicies);
    }

    @Override
    public int getScaledAlpha(double alpha) {
        double a = alpha;
        if (Double.isNaN(a)) {
            a = 1.0;
        } else if (Double.isInfinite(a)) {
            a = a == Double.NEGATIVE_INFINITY ? 0.0 : 1.0;
        }
        int iAlpha = (int)(255.0 * a);
        if (iAlpha < 0) {
            iAlpha = 0;
        } else if (iAlpha > 255) {
            iAlpha = 255;
        }
        return iAlpha;
    }

    class AlphaBreak {
        public Object value;
        public double alpha;

        public AlphaBreak(Object valueIn, double alphaIn) {
            this.value = valueIn;
            this.alpha = alphaIn;
        }
    }
}

