/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ChartFactoryInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.LegendBuilder;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.PropertyMulticaster;
import java.awt.Dialog;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;

public abstract class AbstractChartFactory
implements ChartFactoryInterface,
RoleInterface,
PropertyInterface,
BaseComponentInterface {
    protected String DEFAULT_DATA_ID = "_DEFAULT_DATA_ID_";
    protected PropertyMulticaster propertyMulticaster = new PropertyMulticaster();
    protected Vector dataIds = new Vector();
    protected Hashtable dataSources = new Hashtable();
    protected Hashtable dataFilters = new Hashtable();
    protected LegendBuilder legendBuilder = new LegendBuilder();
    protected SILKNumber currentLegend = null;
    protected Style style = null;

    public boolean applyPropertyChanges() {
        boolean returnVal = false;
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                returnVal = legend.applyPropertyChanges() || returnVal;
            }
        }
        returnVal = this.propertyMulticaster.applyPropertyChanges() || returnVal;
        return returnVal;
    }

    public boolean applyPropertyChanges(Object source) {
        boolean returnVal = false;
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                returnVal = legend.applyPropertyChanges(source) || returnVal;
            }
        }
        returnVal = this.propertyMulticaster.applyPropertyChanges(source) || returnVal;
        return returnVal;
    }

    public void cancelPropertyChanges() {
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                legend.cancelPropertyChanges();
            }
        }
        this.propertyMulticaster.cancelPropertyChanges();
    }

    public void cancelPropertyChanges(Object source) {
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                legend.cancelPropertyChanges(source);
            }
        }
        this.propertyMulticaster.cancelPropertyChanges(source);
    }

    public int getNumberPendingProperties() {
        return this.propertyMulticaster.getNumberPendingProperties();
    }

    public int[] getPendingChanges() {
        return this.propertyMulticaster.getPendingChanges();
    }

    public int[] getPendingChanges(Object source) {
        return this.propertyMulticaster.getPendingChanges(source);
    }

    public Object getPropertyValue(int id) {
        LegendObjectJ2D legend;
        switch (id) {
            case 23: {
                if (this.legendBuilder.getLegendNames() != null) {
                    return this.legendBuilder.getLegend(this.currentLegend);
                }
                return null;
            }
            case 39: {
                return Boolean.FALSE;
            }
            case 24: 
            case 25: {
                return this.legendBuilder.getLegendNames();
            }
        }
        if (this.currentLegend != null && (legend = this.legendBuilder.getLegend(this.currentLegend)) != null && legend.isPropertySupported(id)) {
            return legend.getPropertyValue(id);
        }
        return this.propertyMulticaster.getPropertyValue(id);
    }

    public boolean hasUserSetValue(int id) {
        return this.propertyMulticaster.hasUserSetValue(id);
    }

    public boolean isPropertyPending(int id) {
        LegendObjectJ2D legend;
        if (this.currentLegend != null && (legend = this.legendBuilder.getLegend(this.currentLegend)) != null && legend.isPropertySupported(id)) {
            return legend.isPropertyPending(id);
        }
        return this.propertyMulticaster.isPropertyPending(id);
    }

    public boolean isPropertySupported(int id) {
        LegendObjectJ2D legend;
        if (this.currentLegend != null && (legend = this.legendBuilder.getLegend(this.currentLegend)) != null && legend.isPropertySupported(id)) {
            return true;
        }
        return this.propertyMulticaster.isPropertySupported(id);
    }

    public boolean setPropertyValue(int id, Object value) {
        LegendObjectJ2D legend;
        if (this.currentLegend != null && (legend = this.legendBuilder.getLegend(this.currentLegend)) != null && legend.isPropertySupported(id)) {
            return legend.setPropertyValue(id, value);
        }
        return this.propertyMulticaster.setPropertyValue(id, value);
    }

    public Object[] getDataIds() {
        if (this.dataIds.size() == 0) {
            return null;
        }
        return this.dataIds.toArray();
    }

    public Object getDataSource() {
        return this.dataSources.get(this.DEFAULT_DATA_ID);
    }

    public Object getDataSource(Object id) {
        if (id == null) {
            return null;
        }
        return this.dataSources.get(id);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null) {
            return false;
        }
        if (id == null) {
            return this.setDataSource(source);
        }
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)source);
        if (dfri == null) {
            return false;
        }
        this.dataFilters.put(id, dfri);
        this.dataSources.put(id, dfri.getSource());
        return true;
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)source);
        if (dfri == null) {
            return false;
        }
        this.dataFilters.put(this.DEFAULT_DATA_ID, dfri);
        this.dataSources.put(this.DEFAULT_DATA_ID, dfri.getSource());
        return true;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    @Override
    public boolean areChartTipsOn() {
        return false;
    }

    @Override
    public void dispose() {
        if (this.propertyMulticaster != null) {
            this.propertyMulticaster.removeAllListeners();
        }
        this.propertyMulticaster = null;
        if (this.dataIds != null) {
            this.dataIds.clear();
        }
        this.dataIds = null;
        if (this.dataFilters != null) {
            Enumeration e = this.dataFilters.elements();
            while (e.hasMoreElements()) {
                FilterFactory.detachFilter((DataFilterReadInterface)((DataFilterReadInterface)e.nextElement()));
            }
            this.dataFilters.clear();
        }
        this.dataFilters = null;
        if (this.dataSources != null) {
            this.dataSources.clear();
        }
        this.dataSources = null;
        if (this.legendBuilder != null) {
            this.legendBuilder.removeAllCharts();
        }
        this.legendBuilder = null;
    }

    @Override
    public int getActionMode() {
        return 0;
    }

    @Override
    public AnnotateInterface getAnnotate() {
        return null;
    }

    @Override
    public Object getChartObject(Object id) {
        return null;
    }

    @Override
    public ColorSchemeInterface getColorScheme() {
        return null;
    }

    @Override
    public String getColorSchemeName() {
        return null;
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return null;
    }

    @Override
    public DataFilterReadInterface getFilter(Object id) {
        return null;
    }

    @Override
    public Object getId() {
        return null;
    }

    @Override
    public boolean getUsageMode(int mode) {
        return false;
    }

    @Override
    public String getWhereClause() {
        return null;
    }

    @Override
    public boolean isActionEnabled(String action) {
        return false;
    }

    @Override
    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    @Override
    public boolean isDataListening() {
        return false;
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    @Override
    public boolean setActionMode(int mode) {
        return false;
    }

    @Override
    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    @Override
    public void setChartTipsOn(boolean on) {
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        return false;
    }

    @Override
    public boolean setDataListening(boolean listen) {
        return false;
    }

    @Override
    public void setId(Object id) {
    }

    @Override
    public void setUsageMode(int mode, boolean on) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            this.style = null;
        } else {
            if (newStyle.equals(this.style)) {
                return true;
            }
            if (newStyle instanceof Style) {
                this.style = (Style)newStyle;
            } else if (newStyle instanceof String) {
                StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
                if (sc.getStyle((String)newStyle) == null) return false;
                this.style = sc.getStyle((String)newStyle);
            } else {
                if (!(newStyle instanceof ColorScheme)) return false;
                this.style = ((ColorScheme)newStyle).getStyle();
            }
        }
        if (this.style != null) return this.legendBuilder.setStyle(newStyle);
        return false;
    }

    public boolean areChangesPending(Object source) {
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                int[] list = legend.getPendingChanges(source);
                if (list == null || list.length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    protected void addPropertyListener(PropertyInterface p) {
        if (p == null || this.propertyMulticaster == null) {
            return;
        }
        if (!this.propertyMulticaster.contains(p)) {
            this.propertyMulticaster.addListener(p);
        }
    }

    protected void removePropertyListener(PropertyInterface p) {
        if (p == null || this.propertyMulticaster == null) {
            return;
        }
        this.propertyMulticaster.removeListener(p);
    }

    protected void addPropertyListeners(Collection c) {
        if (c == null || this.propertyMulticaster == null) {
            return;
        }
        Iterator it = c.iterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof PropertyInterface) || this.propertyMulticaster.contains((PropertyInterface)o)) continue;
            this.propertyMulticaster.addListener((PropertyInterface)o);
        }
    }

    protected void removePropertyListeners(Collection c) {
        if (c == null || this.propertyMulticaster == null) {
            return;
        }
        Iterator it = c.iterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof PropertyInterface)) continue;
            this.propertyMulticaster.removeListener((PropertyInterface)o);
        }
    }

    protected void setDataIds(Collection c) {
        if (this.dataIds == null) {
            return;
        }
        this.dataIds.clear();
        this.dataIds.addAll(c);
        this.dataSources.clear();
        this.dataFilters.clear();
    }

    protected DataFilterReadInterface getDataFilter() {
        return this.getDataFilter(this.DEFAULT_DATA_ID);
    }

    protected DataFilterReadInterface getDataFilter(String dataId) {
        if (dataId == null) {
            return null;
        }
        return (DataFilterReadInterface)this.dataFilters.get(dataId);
    }

    public void initLegendsFromXML(Element element) {
    }

    public Element getLegendStatgraphXML(Hashtable context) {
        return null;
    }

    @Override
    public LegendInterface[] getLegends() {
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names == null || names.length == 0) {
            return null;
        }
        Vector<LegendObjectJ2D> legends = new Vector<LegendObjectJ2D>();
        for (int i = 0; i < names.length; ++i) {
            LegendObjectJ2D o = this.legendBuilder.getLegend(names[i]);
            if (!(o instanceof LegendInterface)) continue;
            legends.add(o);
        }
        LegendInterface[] legInterfaces = new LegendInterface[legends.size()];
        for (int i = 0; i < legends.size(); ++i) {
            legInterfaces[i] = (LegendInterface)legends.elementAt(i);
        }
        return legInterfaces;
    }

    protected void setDefaultDataId(String id) {
        this.DEFAULT_DATA_ID = id;
    }

    protected String getDefaultDataId() {
        return this.DEFAULT_DATA_ID;
    }
}

