/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.silk.base.DistributionElement;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.DateTimePanel;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.DataValue;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WherePanelValueDialog
extends JDialog {
    private static final long serialVersionUID = 6809308997955223075L;
    public static final int LESS_THAN = -1;
    public static final int EQUALS = 0;
    public static final int GREATER_THAN = 1;
    private JPanel jContentPane = null;
    private JRadioButton jRadioButton = null;
    private JRadioButton jRadioButton1 = null;
    private JScrollPane jScrollPane = null;
    private JList jList = null;
    private DataFilterReadInterface filter = null;
    private Object variable = null;
    private int operator = 0;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private boolean cancelChanges = false;
    private DistributionElement distribution = null;
    private Object selectedItem = null;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private DateTimePanel dateChooser = new DateTimePanel();
    private JPanel dateChooserPanel = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel4 = null;
    private JSlider jSlider = null;
    private JPanel jPanel5 = null;
    private JLabel jLabel = null;

    public WherePanelValueDialog() {
        this.initialize();
    }

    private JPanel getDateChooserPanel() {
        if (this.dateChooserPanel == null) {
            this.dateChooserPanel = new JPanel(new BorderLayout());
            this.dateChooserPanel.setName("DateChooserPanel");
            this.dateChooserPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.dateChooserPanel.add("Center", this.dateChooser);
        }
        return this.dateChooserPanel;
    }

    private Component getChooserComponent() {
        if (this.filter == null) {
            return this.getJScrollPane();
        }
        if (this.getJRadioButton1().isSelected()) {
            return this.getJScrollPane();
        }
        if (this.filter.isNumericVariable(this.variable)) {
            SASFormat format = (SASFormat)this.filter.getFormat(this.variable, SASFormat.class);
            if (format instanceof SASDateTimeFormat) {
                if (this.filter instanceof DataFilterInfoInterface) {
                    double min = (Double)((DataFilterInfoInterface)this.filter).getMinimumValue(this.variable);
                    double max = (Double)((DataFilterInfoInterface)this.filter).getMaximumValue(this.variable);
                    this.dateChooser.setFormat(format);
                    this.dateChooser.setValue(min + (max - min) / 2.0);
                }
                return this.getDateChooserPanel();
            }
            this.distribution = new DistributionElement();
            this.distribution.setControlMode(true);
            this.distribution.setDataSource(this.filter.getSource());
            this.distribution.setRole(this.variable, RoleInterface.ROLE_X);
            this.updateValueLabel();
            return this.getJPanel3();
        }
        return this.getJScrollPane();
    }

    boolean isChooserVariables() {
        return this.getJRadioButton1().isSelected();
    }

    private void setupChooser() {
        Component c = this.getChooserComponent();
        if (this.getJRadioButton().isSelected() && c == this.jScrollPane && this.filter instanceof DataFilterInfoInterface) {
            DataFilterReadInterface myFilter = FilterFactory.getDataSourceFilter((Object)this.filter.getSource());
            if (myFilter == null) {
                this.getJList().setListData(((DataFilterInfoInterface)this.filter).getUniqueValues(this.variable, false));
            } else {
                int index = myFilter.getVariableIndex(this.variable);
                int nobs = myFilter.getNumberObservations(-1);
                LinkedHashMap<String, DataValue> items = new LinkedHashMap<String, DataValue>();
                for (int i = 0; i < nobs; ++i) {
                    Object value = myFilter.getValue(index, (long)i);
                    String formattedValue = myFilter.getFormattedValue(this.variable, value, null);
                    if (formattedValue == null || items.containsKey(formattedValue)) continue;
                    items.put(formattedValue, new DataValue(value, formattedValue.toString()));
                }
                this.getJList().setListData(items.values().toArray());
            }
        } else if (this.getJRadioButton1().isSelected()) {
            Object[] variableList = new Object[this.filter.getNumberVariables()];
            for (int i = 0; i < variableList.length; ++i) {
                variableList[i] = this.filter.getVariableId(i);
            }
            this.getJList().setListData(variableList);
        }
        CardLayout cl = (CardLayout)this.getJPanel2().getLayout();
        cl.show(this.getJPanel2(), c.getName());
    }

    public Object showDialog(DataFilterReadInterface filter, Object variable, int operator) {
        if (filter == null || variable == null) {
            return null;
        }
        this.filter = filter;
        this.variable = variable;
        this.operator = operator;
        this.cancelChanges = false;
        this.setupChooser();
        this.setVisible(true);
        if (this.cancelChanges) {
            return null;
        }
        return this.selectedItem;
    }

    private void initialize() {
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"WherePanelValueDialog.Pick_a_Variable_or_Value.txt", (String)"Pick a Variable or Value"));
        this.setModal(true);
        this.setSize(319, 267);
        UIUtilities.center(this);
        this.setContentPane(this.getJContentPane());
        this.dateChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WherePanelValueDialog.this.selectedItem = new DataValue(WherePanelValueDialog.this.dateChooser.getValue(), WherePanelValueDialog.this.dateChooser.getFormattedValue());
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "North");
            this.jContentPane.add((Component)this.getJPanel1(), "South");
            this.jContentPane.add((Component)this.getJPanel2(), "Center");
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.jRadioButton);
            bg.add(this.jRadioButton1);
        }
        return this.jContentPane;
    }

    private JRadioButton getJRadioButton() {
        if (this.jRadioButton == null) {
            this.jRadioButton = new JRadioButton();
            this.jRadioButton.setSelected(true);
            this.jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WherePanelValueDialog.this.setupChooser();
                }
            });
            this.jRadioButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.jRadioButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WherePanelValueDialog.Unique_Values.txt", (String)"Unique Values"));
        }
        return this.jRadioButton;
    }

    private JRadioButton getJRadioButton1() {
        if (this.jRadioButton1 == null) {
            this.jRadioButton1 = new JRadioButton();
            this.jRadioButton1.setFont(TabbedPropertiesDialog.dialogFont);
            this.jRadioButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WherePanelValueDialog.this.setupChooser();
                }
            });
            this.jRadioButton1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WherePanelValueDialog.Variables.txt", (String)"Variables"));
        }
        return this.jRadioButton1;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setName("jScrollPane");
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setSelectionMode(0);
            this.jList.setFont(TabbedPropertiesDialog.dialogFont);
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    WherePanelValueDialog.this.selectedItem = WherePanelValueDialog.this.jList.getSelectedValue();
                }
            });
        }
        return this.jList;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WherePanelValueDialog.this.setVisible(false);
                }
            });
            this.jButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WherePanelValueDialog.OK.txt", (String)"OK"));
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setFont(TabbedPropertiesDialog.dialogFont);
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WherePanelValueDialog.this.cancelChanges = true;
                    WherePanelValueDialog.this.setVisible(false);
                }
            });
            this.jButton1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WherePanelValueDialog.Cancel.txt", (String)"Cancel"));
        }
        return this.jButton1;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJRadioButton(), "North");
            this.jPanel.add((Component)this.getJRadioButton1(), "Center");
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout);
            this.jPanel1.add((Component)this.getJButton(), null);
            this.jPanel1.add((Component)this.getJButton1(), null);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new CardLayout());
            this.jPanel2.add((Component)this.getJScrollPane(), this.getJScrollPane().getName());
            this.jPanel2.add((Component)this.getJPanel3(), this.getJPanel3().getName());
            this.jPanel2.add((Component)this.getDateChooserPanel(), this.getDateChooserPanel().getName());
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new BorderLayout());
            this.jPanel3.setName("jPanel3");
            this.jPanel3.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.jPanel3.add((Component)this.getJPanel4(), "Center");
            this.jPanel3.add((Component)this.getJPanel5(), "South");
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel(){
                private static final long serialVersionUID = 2957120409007925412L;

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    super.setBounds(x, y, width, height);
                    if (WherePanelValueDialog.this.distribution != null) {
                        WherePanelValueDialog.this.distribution.setBounds(5, 0, this.getWidth() - 10, this.getHeight());
                    }
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (WherePanelValueDialog.this.distribution != null) {
                        WherePanelValueDialog.this.distribution.draw(g, false);
                    }
                    int sliderValue = WherePanelValueDialog.this.getJSlider().getValue();
                    ContinuousRange range = (ContinuousRange)WherePanelValueDialog.this.distribution.getOutputRange((byte)1);
                    if (range == null) {
                        return;
                    }
                    double d = range.getMin() + (double)sliderValue / 100.0 * (range.getMax() - range.getMin());
                    double[] vals = WherePanelValueDialog.this.distribution.getTransformObject().project(d, 0.0, 0.0, null);
                    double[] vals1 = null;
                    if (WherePanelValueDialog.this.operator == 0) {
                        g.setColor(new Color(255, 255, 0));
                        g.drawLine((int)vals[0], 0, (int)vals[0], this.getHeight());
                    } else {
                        g.setColor(new Color(255, 255, 0, 128));
                        if (WherePanelValueDialog.this.operator == -1) {
                            vals1 = WherePanelValueDialog.this.distribution.getTransformObject().project(range.getMin(), 0.0, 0.0, null);
                            g.fillRect((int)vals1[0], 0, (int)vals[0], this.getHeight());
                        } else {
                            vals1 = WherePanelValueDialog.this.distribution.getTransformObject().project(range.getMax(), 0.0, 0.0, null);
                            g.fillRect((int)vals[0], 0, (int)vals1[0], this.getHeight());
                        }
                    }
                }
            };
            this.jPanel4.setOpaque(true);
            this.jPanel4.setBackground(Color.white);
            this.jPanel4.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        return this.jPanel4;
    }

    private void updateValueLabel() {
        int sliderValue = this.getJSlider().getValue();
        ContinuousRange range = (ContinuousRange)this.distribution.getOutputRange((byte)1);
        if (range == null) {
            range = (ContinuousRange)this.distribution.getPreferredRange("X");
        }
        if (range == null) {
            return;
        }
        double d = range.getMin() + (double)sliderValue / 100.0 * (range.getMax() - range.getMin());
        this.selectedItem = new Double(d);
        this.jLabel.setText(this.filter.getFormattedValue(this.variable, (Object)new Double(d), null));
    }

    private JSlider getJSlider() {
        if (this.jSlider == null) {
            this.jSlider = new JSlider();
            this.jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    WherePanelValueDialog.this.updateValueLabel();
                    WherePanelValueDialog.this.repaint();
                }
            });
        }
        return this.jSlider;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(" ");
            this.jLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.jLabel.setHorizontalAlignment(0);
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new BorderLayout());
            this.jPanel5.add((Component)this.getJSlider(), "North");
            this.jPanel5.add((Component)this.jLabel, "Center");
        }
        return this.jPanel5;
    }
}

