/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.ui.ButtonPanel;
import com.sas.graphics.silk.ui.CenterWherePanel;
import com.sas.graphics.silk.ui.EditDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WherePanel
extends JPanel
implements ActionListener,
DataFilterListenerInterface {
    private static final long serialVersionUID = -4825305031595841710L;
    public static final int ADD_BUTTON = 0;
    public static final int APPLY_BUTTON = 1;
    public static final int EDIT_BUTTON = 2;
    public static final int REMOVE_BUTTON = 3;
    public static final int RESET_BUTTON = 4;
    CenterWherePanel centerPanel = null;
    DataFilterReadInterface data = null;
    BaseComponentInterface graph = null;
    ButtonPanel buttons = null;
    Vector listeners = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    boolean ignoreDataEvents = false;

    public WherePanel() {
        this.centerPanel = new CenterWherePanel(this.rb);
        this.listeners = new Vector();
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.centerPanel));
        this.buttons = new ButtonPanel(this.rb);
        this.buttons.addButton.addActionListener(this);
        this.buttons.resetButton.addActionListener(this);
        this.buttons.removeButton.addActionListener(this);
        this.buttons.editButton.addActionListener(this);
        this.buttons.applyButton.addActionListener(this);
        this.add("South", this.buttons);
    }

    public Vector getClauses() {
        return this.centerPanel.clauses;
    }

    public JButton getButton(int button) {
        JButton rc = null;
        switch (button) {
            case 0: {
                rc = this.buttons.addButton;
                break;
            }
            case 1: {
                rc = this.buttons.applyButton;
                break;
            }
            case 2: {
                rc = this.buttons.editButton;
                break;
            }
            case 3: {
                rc = this.buttons.removeButton;
                break;
            }
            case 4: {
                rc = this.buttons.resetButton;
            }
        }
        return rc;
    }

    public JPanel getButtonPanel() {
        return this.buttons;
    }

    public boolean setData(Object dataIn) {
        if (dataIn instanceof BaseComponentInterface) {
            this.graph = (BaseComponentInterface)dataIn;
            this.data = this.graph.getFilter();
        } else {
            this.data = FilterFactory.getDataSourceFilter((Object)dataIn);
        }
        if (this.data == null) {
            return false;
        }
        this.data.addDataFilterListener((Object)this);
        this.centerPanel.setData(this.data);
        if (this.data.getWhereClause() != null && this.data.getWhereClause().length() > 0) {
            this.centerPanel.setCustom(this.data.getWhereClause());
        } else if (this.centerPanel.clauses.size() == 0) {
            this.centerPanel.addClause();
        }
        return true;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (!this.ignoreDataEvents && evt.type == 3) {
            this.setCustom(this.data.getWhereClause());
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag) {
            this.init();
        }
        super.setVisible(aFlag);
    }

    public void init() {
        String[] strs;
        this.centerPanel.removeAllClauses();
        if (this.data != null && this.data.getWhereClause() != null && this.data.getWhereClause().length() > 0) {
            this.centerPanel.setCustom(this.data.getWhereClause());
        }
        if ((strs = this.centerPanel.getAllClauses(false)) != null) {
            boolean enable = false;
            for (int i = 0; i < strs.length; ++i) {
                if (strs[i] == null || strs[i].trim().length() <= 0) continue;
                enable = true;
            }
            this.buttons.removeButton.setEnabled(enable);
        }
    }

    public boolean addListener(Object o) {
        if (o == null || !(o instanceof ComponentInterface) && !(o instanceof DataFilterReadInterface)) {
            return false;
        }
        this.listeners.addElement(o);
        return true;
    }

    public void apply(String clause) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.graph != null) {
            this.graph.applyWhereClause(clause, true);
        } else if (this.data != null) {
            this.data.applyWhereClause(clause, true);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object o = this.listeners.elementAt(i);
            if (o instanceof ComponentInterface) {
                ((ComponentInterface)o).applyWhereClause(clause, true);
                continue;
            }
            ((DataFilterReadInterface)o).applyWhereClause(clause, true);
        }
        this.centerPanel.removeAllClauses();
        this.validate();
        this.centerPanel.validate();
        this.centerPanel.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.buttons.addButton) {
            this.centerPanel.addClause();
            this.validate();
            this.centerPanel.validate();
            this.centerPanel.repaint();
        } else if (source == this.buttons.resetButton) {
            if (this.graph != null) {
                this.graph.applyWhereClause(null, true);
            } else if (this.data != null) {
                this.data.applyWhereClause(null, true);
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                Object o = this.listeners.elementAt(i);
                if (o instanceof ComponentInterface) {
                    ((ComponentInterface)o).applyWhereClause(null, true);
                    continue;
                }
                ((DataFilterReadInterface)o).applyWhereClause(null, true);
            }
            this.centerPanel.removeAllClauses();
            this.validate();
            this.centerPanel.validate();
            this.centerPanel.repaint();
        } else if (source == this.buttons.removeButton) {
            String[] strs = this.centerPanel.getAllClauses(true);
            if (strs.length == 0) {
                return;
            }
            JCheckBox[] checks = new JCheckBox[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                checks[i] = new JCheckBox(strs[i]);
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            for (int i = 0; i < checks.length; ++i) {
                panel.add(checks[i]);
            }
            JOptionPane optionPane = new JOptionPane(panel, 3, 2);
            JDialog dialog = optionPane.createDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Choose_clauses_to_delete.txt", (String)"Choose clauses to delete"));
            UIUtilities.center(dialog, UIUtilities.getParentFrame(this));
            dialog.setVisible(true);
            if (optionPane.getValue() != null && optionPane.getValue() instanceof Number && ((Number)optionPane.getValue()).intValue() != 0) {
                return;
            }
            Vector<Integer> v = new Vector<Integer>();
            for (int i = 0; i < checks.length; ++i) {
                if (!checks[i].isSelected()) continue;
                v.addElement(new Integer(i));
            }
            int[] k = new int[v.size()];
            for (int j = 0; j < k.length; ++j) {
                k[j] = (Integer)v.elementAt(j);
            }
            this.centerPanel.remove(k);
            this.validate();
            this.centerPanel.validate();
            this.centerPanel.repaint();
        } else if (source == this.buttons.editButton) {
            EditDialog dialog = new EditDialog(this, this.rb);
            dialog.setVisible(true);
        } else if (source == this.buttons.applyButton) {
            this.apply();
        }
        String[] strs = this.centerPanel.getAllClauses(false);
        if (strs != null) {
            boolean enable = false;
            for (int i = 0; i < strs.length; ++i) {
                if (strs[i] == null || strs[i].trim().length() <= 0) continue;
                enable = true;
            }
            this.buttons.removeButton.setEnabled(enable);
        }
    }

    public void apply() {
        this.ignoreDataEvents = true;
        String where = this.centerPanel.getWhereClause();
        if (where == null || where.trim().length() == 0) {
            where = null;
        }
        if (this.graph != null) {
            this.graph.applyWhereClause(where, true);
        } else if (this.data != null) {
            this.data.applyWhereClause(where, true);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object o = this.listeners.elementAt(i);
            if (o instanceof ComponentInterface) {
                ((ComponentInterface)o).applyWhereClause(where, true);
                continue;
            }
            ((DataFilterReadInterface)o).applyWhereClause(where, true);
        }
        this.centerPanel.setApplied();
        this.ignoreDataEvents = false;
    }

    public String getWhereClause() {
        return this.centerPanel.getWhereClause();
    }

    public void setCustom(String str) {
        if (str == null || str.trim().length() == 0) {
            this.centerPanel.removeAllClauses();
        } else {
            this.centerPanel.setCustom(str);
        }
        this.validate();
        this.centerPanel.validate();
        this.centerPanel.repaint();
    }
}

