/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.ui.WherePanelValueDialog;
import com.sas.graphics.silk.util.DataValue;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.Sort;
import com.sas.graphics.util.SortKeyInterface;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;

public class WhereClausePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8728568789901096215L;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private boolean valueVariable;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JComboBox jComboBox = null;
    private JCheckBox jCheckBox = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel1 = null;
    private JComboBox oprCombo = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel2 = null;
    private JTextField jTextField = null;
    private JButton jButton = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel4 = null;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private CardLayout cardLayout = null;
    private boolean isCustom = false;
    DataValue selectedValue = null;
    DataFilterReadInterface data = null;
    private JPanel jPanel5 = null;
    private JPanel jPanel6 = null;

    public WhereClausePanel() {
        this.initialize();
    }

    public WhereClausePanel(String custom) {
        this();
        this.cardLayout.show(this, "jPanel4");
        this.isCustom = true;
        this.getJTextArea().setText(custom);
    }

    public WhereClausePanel(DataFilterReadInterface data) {
        this();
        this.cardLayout.show(this, "jPanel3");
        this.data = data;
        JComboBox varCombo = this.getJComboBox();
        varCombo.addItem(new DataValue(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.none.txt", (String)"(none)"), null));
        if (data != null) {
            int i;
            int[] indexes = new int[data.getNumberVariables()];
            Vector<String> vec = new Vector<String>();
            Vector<DataValue> vecDV = new Vector<DataValue>();
            for (i = 0; i < data.getNumberVariables(); ++i) {
                String name = data.getVariableId(i).toString();
                vec.add(name);
                indexes[i] = i;
                Object description = data.getVariableDescription(i);
                String desc = description == null ? name : description.toString();
                String str = "";
                str = !desc.equals(name) ? str + desc + " (" + name + ")" : name;
                DataValue dv = new DataValue(name, str);
                vecDV.add(dv);
            }
            Sort.heapsort(String.class, vec, (int[])indexes, (int)-1, (CompareInterface)new WhereClausePanelCompareInterface());
            for (i = 0; i < data.getNumberVariables(); ++i) {
                varCombo.addItem(vecDV.elementAt(indexes[i]));
            }
        }
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setApplied() {
        if (this.isCustom) {
            return;
        }
        if (this.getValueAsString(false).length() == 0 || this.getSelectedVariable() == null) {
            return;
        }
        this.getJComboBox().setEnabled(false);
        this.getJCheckBox().setEnabled(false);
        this.oprCombo.setEnabled(false);
        this.getJTextField().setEnabled(false);
        this.getJButton().setEnabled(false);
    }

    private String getValueAsString(boolean formatted) {
        if (this.selectedValue != null && this.selectedValue.getValue() != null) {
            if (formatted) {
                return this.selectedValue.getFormattedValue();
            }
            return this.selectedValue.getValue().toString();
        }
        return this.getJTextField().getText();
    }

    private String getSelectedVariable() {
        if (this.getJComboBox().getSelectedItem().toString().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.none.txt", (String)"(none)"))) {
            return null;
        }
        DataValue dv = (DataValue)this.getJComboBox().getSelectedItem();
        return dv.getValue().toString();
    }

    public String getClause(boolean formatted) {
        if (this.isCustom) {
            return this.getJTextArea().getText();
        }
        if (this.getJComboBox().getSelectedItem().toString().equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.none.txt", (String)"(none)"))) {
            return null;
        }
        String val = this.getValueAsString(formatted);
        String clause = null;
        clause = this.data.isNumericVariable((Object)this.getSelectedVariable()) ? this.getSelectedVariable() + this.getOpr() + val : this.getSelectedVariable() + this.getOpr() + "\"" + val + "\"";
        String s = this.oprCombo.getSelectedItem().toString();
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Contains.txt", (String)"Contains")) && this.getJCheckBox().isSelected()) {
            clause = "^( " + clause + " )";
        }
        return clause;
    }

    public String getOpr() {
        String s = this.oprCombo.getSelectedItem().toString();
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Equal_to.txt", (String)"Equal to"))) {
            if (this.getJCheckBox().isSelected()) {
                return " ^= ";
            }
            return " = ";
        }
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Greater_than.txt", (String)"Greater than"))) {
            if (this.getJCheckBox().isSelected()) {
                return " <= ";
            }
            return " > ";
        }
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Greater_than_or_equal_to.txt", (String)"Greater than or equal to"))) {
            if (this.getJCheckBox().isSelected()) {
                return " < ";
            }
            return " >= ";
        }
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Less_than.txt", (String)"Less than"))) {
            if (this.getJCheckBox().isSelected()) {
                return " >= ";
            }
            return " < ";
        }
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Less_than_or_equal_to.txt", (String)"Less than or equal to"))) {
            if (this.getJCheckBox().isSelected()) {
                return " > ";
            }
            return " <= ";
        }
        if (s.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Contains.txt", (String)"Contains"))) {
            return " ? ";
        }
        return "";
    }

    private void initialize() {
        CompoundBorder cb = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        CompoundBorder cb1 = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), cb);
        this.setBorder(cb1);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.setSize(522, 63);
        this.add((Component)this.getJPanel3(), this.getJPanel3().getName());
        this.add((Component)this.getJPanel4(), this.getJPanel4().getName());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Column_name.txt", (String)"Column name"));
            this.jLabel.setFont(UIUtilities.getSILKDialogFont());
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setName("jPanel");
            this.jPanel.add((Component)this.jLabel, "North");
            this.jPanel.add((Component)this.getJComboBox(), "Center");
        }
        return this.jPanel;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setFont(UIUtilities.getSILKDialogFont());
            this.jComboBox.setBackground(Color.white);
            this.jComboBox.setPreferredSize(new Dimension(170, 25));
            this.jComboBox.addActionListener(this);
        }
        return this.jComboBox;
    }

    private JCheckBox getJCheckBox() {
        if (this.jCheckBox == null) {
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.setName("jCheckBox");
            this.jCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.not.txt", (String)"not"));
            this.jCheckBox.setFont(UIUtilities.getSILKDialogFont());
        }
        return this.jCheckBox;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Operator.txt", (String)"Operator"));
            this.jLabel1.setFont(UIUtilities.getSILKDialogFont());
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.setName("jPanel1");
            this.jPanel1.add((Component)this.jLabel1, "North");
            this.jPanel1.add((Component)this.getOprCombo(), "Center");
        }
        return this.jPanel1;
    }

    private JComboBox getOprCombo() {
        if (this.oprCombo == null) {
            this.oprCombo = new JComboBox();
            this.oprCombo.setPreferredSize(new Dimension(130, 25));
            this.oprCombo.setBackground(Color.white);
            this.oprCombo.setFont(UIUtilities.getSILKDialogFont());
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Equal_to.txt", (String)"Equal to"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Greater_than.txt", (String)"Greater than"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Greater_than_or_equal_to.txt", (String)"Greater than or equal to"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Less_than.txt", (String)"Less than"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Less_than_or_equal_to.txt", (String)"Less than or equal to"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Contains.txt", (String)"Contains"));
        }
        return this.oprCombo;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Value.txt", (String)"Value"));
            this.jLabel2.setFont(UIUtilities.getSILKDialogFont());
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new BorderLayout());
            this.jPanel2.setName("jPanel2");
            this.jPanel2.add((Component)this.jLabel2, "North");
            this.jPanel2.add((Component)this.getJTextField(), "Center");
            this.jPanel2.add((Component)this.getJButton(), "East");
        }
        return this.jPanel2;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setHorizontalAlignment(2);
            this.jTextField.setPreferredSize(new Dimension(100, 25));
            this.jTextField.setFont(UIUtilities.getSILKDialogFont());
            this.jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    WhereClausePanel.this.selectedValue = null;
                }
            });
        }
        return this.jTextField;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setPreferredSize(new Dimension(25, 25));
            this.jButton.setText("...");
            this.jButton.setFont(UIUtilities.getSILKDialogFont());
            this.jButton.addActionListener(this);
        }
        return this.jButton;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.jPanel3 = new JPanel();
            this.jPanel3.setPreferredSize(new Dimension(170, 25));
            this.jPanel3.setLayout(flowLayout);
            this.jPanel3.setName("jPanel3");
            this.jPanel3.add((Component)this.getJPanel(), null);
            this.jPanel3.add((Component)this.getJPanel5(), null);
            this.jPanel3.add((Component)this.getJPanel1(), null);
            this.jPanel3.add((Component)this.getJPanel2(), null);
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.setName("jPanel4");
            this.jPanel4.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel4;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setLineWrap(true);
        }
        return this.jTextArea;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.getJButton()) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            String selectedVariable = this.getSelectedVariable();
            DataFilterReadInterface myData = FilterFactory.getDataSourceFilter((Object)this.data.getSource());
            String opr = this.getOpr();
            int operator = 0;
            if (opr.equals(" > ") || opr.equals(" >= ")) {
                operator = 1;
            } else if (opr.equals(" < ") || opr.equals(" <= ")) {
                operator = -1;
            }
            WherePanelValueDialog dialog = new WherePanelValueDialog();
            UIUtilities.center(dialog, UIUtilities.getParentFrame(this));
            Object o = dialog.showDialog(myData, selectedVariable, operator);
            if (o instanceof DataValue) {
                this.selectedValue = (DataValue)o;
            }
            if (o != null) {
                this.getJTextField().setText(o.toString());
            }
            this.valueVariable = dialog.isChooserVariables();
            this.getJTextField().setCaretPosition(0);
            this.setCursor(cursor);
        } else if (source == this.getJComboBox()) {
            this.getJTextField().setText("");
            if (this.getJComboBox().getSelectedItem().toString().equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.none.txt", (String)"(none)"))) {
                this.getJButton().setEnabled(false);
            } else {
                this.getJButton().setEnabled(true);
            }
            if (this.data == null) {
                return;
            }
            this.getJTextField().setEditable(!(this.data.getFormat(this.getJComboBox().getSelectedItem(), SASFormat.class) instanceof SASDateTimeFormat));
            Object obj = this.oprCombo.getSelectedItem();
            this.oprCombo.removeAllItems();
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Equal_to.txt", (String)"Equal to"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Greater_than.txt", (String)"Greater than"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Greater_than_or_equal_to.txt", (String)"Greater than or equal to"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Less_than.txt", (String)"Less than"));
            this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Less_than_or_equal_to.txt", (String)"Less than or equal to"));
            if (!this.data.isNumericVariable((Object)this.getSelectedVariable())) {
                this.oprCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"WhereClausePanel.Contains.txt", (String)"Contains"));
            }
            this.oprCombo.setSelectedItem(obj);
        }
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new BorderLayout());
            this.jPanel5.add((Component)this.getJCheckBox(), "South");
            this.jPanel5.add((Component)this.getJPanel6(), "North");
        }
        return this.jPanel5;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
        }
        return this.jPanel6;
    }

    public boolean isValueVariable() {
        return this.valueVariable;
    }

    private class WhereClausePanelCompareInterface
    implements CompareInterface {
        private WhereClausePanelCompareInterface() {
        }

        public double getNumericElement(Object entry) {
            if (entry instanceof SortKeyInterface) {
                return ((SortKeyInterface)entry).getNumericKeyValue();
            }
            return ((Number)entry).doubleValue();
        }

        public String getStringElement(Object entry) {
            return (String)entry;
        }
    }
}

