/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.util.SILKGlobal;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class UIUtilities {
    public static void addMenu(JMenu src, JMenu dest) {
        if (src == null || dest == null) {
            return;
        }
        int n = src.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            EventListener[] al;
            Component c = src.getMenuComponent(i);
            if (c == null) continue;
            if (c instanceof JMenu) {
                JMenu m = new JMenu(((JMenu)c).getText());
                dest.add(m);
                UIUtilities.addMenu((JMenu)c, m);
                continue;
            }
            if (c instanceof JCheckBoxMenuItem) {
                ActionListener[] actionListeners;
                JCheckBoxMenuItem cmi = new JCheckBoxMenuItem(((JCheckBoxMenuItem)c).getText());
                cmi.setEnabled(((JMenuItem)c).isEnabled());
                cmi.setState(((JCheckBoxMenuItem)c).getState());
                cmi.setActionCommand(((JCheckBoxMenuItem)c).getActionCommand());
                al = ((JCheckBoxMenuItem)c).getItemListeners();
                if (al != null) {
                    for (int j = 0; j < al.length; ++j) {
                        cmi.addItemListener((ItemListener)al[j]);
                    }
                }
                if ((actionListeners = ((JCheckBoxMenuItem)c).getActionListeners()) != null) {
                    for (int j = 0; j < actionListeners.length; ++j) {
                        cmi.addActionListener(actionListeners[j]);
                    }
                }
                dest.add(cmi);
                continue;
            }
            if (c instanceof JMenuItem) {
                JMenuItem mi = new JMenuItem(((JMenuItem)c).getText());
                mi.setEnabled(((JMenuItem)c).isEnabled());
                mi.setActionCommand(((JMenuItem)c).getActionCommand());
                al = ((JMenuItem)c).getActionListeners();
                if (al != null) {
                    for (int j = 0; j < al.length; ++j) {
                        mi.addActionListener((ActionListener)al[j]);
                    }
                }
                dest.add(mi);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            dest.addSeparator();
        }
    }

    public static void addMenu(JMenu src, JPopupMenu dest) {
        if (src == null || dest == null) {
            return;
        }
        int n = src.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            EventListener[] al;
            Component c = src.getMenuComponent(i);
            if (c == null) continue;
            if (c instanceof JMenu) {
                JMenu m = new JMenu(((JMenu)c).getText());
                dest.add(m);
                UIUtilities.addMenu((JMenu)c, m);
                continue;
            }
            if (c instanceof JCheckBoxMenuItem) {
                ActionListener[] actionListeners;
                JCheckBoxMenuItem cmi = new JCheckBoxMenuItem(((JCheckBoxMenuItem)c).getText());
                cmi.setEnabled(((JMenuItem)c).isEnabled());
                cmi.setState(((JCheckBoxMenuItem)c).getState());
                cmi.setActionCommand(((JCheckBoxMenuItem)c).getActionCommand());
                al = ((JCheckBoxMenuItem)c).getItemListeners();
                if (al != null) {
                    for (int j = 0; j < al.length; ++j) {
                        cmi.addItemListener((ItemListener)al[j]);
                    }
                }
                if ((actionListeners = ((JCheckBoxMenuItem)c).getActionListeners()) != null) {
                    for (int j = 0; j < actionListeners.length; ++j) {
                        cmi.addActionListener(actionListeners[i]);
                    }
                }
                dest.add(cmi);
                continue;
            }
            if (c instanceof JMenuItem) {
                JMenuItem mi = new JMenuItem(((JMenuItem)c).getText());
                mi.setEnabled(((JMenuItem)c).isEnabled());
                mi.setActionCommand(((JMenuItem)c).getActionCommand());
                mi.setIcon(((JMenuItem)c).getIcon());
                al = ((JMenuItem)c).getActionListeners();
                if (al != null) {
                    for (int j = 0; j < al.length; ++j) {
                        mi.addActionListener((ActionListener)al[j]);
                    }
                }
                dest.add(mi);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            dest.addSeparator();
        }
    }

    public static void addMenu(JPopupMenu src, JMenu dest) {
        if (src == null || dest == null) {
            return;
        }
        int n = src.getComponentCount();
        for (int i = 0; i < n; ++i) {
            int j;
            EventListener[] al;
            Component c = src.getComponent(i);
            if (c == null) continue;
            if (c instanceof JMenu) {
                JMenu m = new JMenu(((JMenu)c).getText());
                dest.add(m);
                UIUtilities.addMenu((JMenu)c, m);
                continue;
            }
            if (c instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem cmi = new JCheckBoxMenuItem(((JCheckBoxMenuItem)c).getText());
                cmi.setEnabled(((JMenuItem)c).isEnabled());
                cmi.setState(((JCheckBoxMenuItem)c).getState());
                cmi.setActionCommand(((JCheckBoxMenuItem)c).getActionCommand());
                al = ((JCheckBoxMenuItem)c).getItemListeners();
                if (al != null) {
                    for (j = 0; j < al.length; ++j) {
                        cmi.addItemListener((ItemListener)al[j]);
                    }
                }
                dest.add(cmi);
                continue;
            }
            if (c instanceof JMenuItem) {
                JMenuItem mi = new JMenuItem(((JMenuItem)c).getText());
                mi.setEnabled(((JMenuItem)c).isEnabled());
                mi.setActionCommand(((JMenuItem)c).getActionCommand());
                al = ((JMenuItem)c).getActionListeners();
                if (al != null) {
                    for (j = 0; j < al.length; ++j) {
                        mi.addActionListener((ActionListener)al[j]);
                    }
                }
                dest.add(mi);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            dest.addSeparator();
        }
    }

    public static void addMenu(JPopupMenu src, JPopupMenu dest) {
        if (src == null || dest == null) {
            return;
        }
        int n = src.getComponentCount();
        for (int i = 0; i < n; ++i) {
            int j;
            EventListener[] al;
            Component c = src.getComponent(i);
            if (c == null) continue;
            if (c instanceof JMenu) {
                JMenu m = new JMenu(((JMenu)c).getText());
                dest.add(m);
                UIUtilities.addMenu((JMenu)c, m);
                continue;
            }
            if (c instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem cmi = new JCheckBoxMenuItem(((JCheckBoxMenuItem)c).getText());
                cmi.setEnabled(((JMenuItem)c).isEnabled());
                cmi.setState(((JCheckBoxMenuItem)c).getState());
                cmi.setActionCommand(((JCheckBoxMenuItem)c).getActionCommand());
                al = ((JCheckBoxMenuItem)c).getItemListeners();
                if (al != null) {
                    for (j = 0; j < al.length; ++j) {
                        cmi.addItemListener((ItemListener)al[j]);
                    }
                }
                dest.add(cmi);
                continue;
            }
            if (c instanceof JMenuItem) {
                JMenuItem mi = new JMenuItem(((JMenuItem)c).getText());
                mi.setEnabled(((JMenuItem)c).isEnabled());
                mi.setActionCommand(((JMenuItem)c).getActionCommand());
                al = ((JMenuItem)c).getActionListeners();
                if (al != null) {
                    for (j = 0; j < al.length; ++j) {
                        mi.addActionListener((ActionListener)al[j]);
                    }
                }
                dest.add(mi);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            dest.addSeparator();
        }
    }

    public static void center(Window win) {
        Object p = null;
        Object fsize = null;
        Dimension wsize = win.getSize();
        int w = -1;
        int h = -1;
        if (p != null && fsize != null) {
            w = p.x + fsize.width / 2 - wsize.width / 2;
            h = p.y + fsize.height / 2 - wsize.height / 2;
        }
        if (w < 0 || h < 0) {
            Dimension ssize = Toolkit.getDefaultToolkit().getScreenSize();
            w = ssize.width / 2 - wsize.width / 2;
            h = ssize.height / 2 - wsize.height / 2;
        }
        win.setLocation(w, h);
    }

    public static void center(Window win, Window centerOn) {
        if (centerOn == null) {
            UIUtilities.center(win);
            return;
        }
        Object p = null;
        Object fsize = null;
        Dimension wsize = win.getSize();
        int w = -1;
        int h = -1;
        if (p != null && fsize != null) {
            w = p.x + fsize.width / 2 - wsize.width / 2;
            h = p.y + fsize.height / 2 - wsize.height / 2;
        }
        if (w < 0 || h < 0) {
            Dimension ssize = centerOn.getSize();
            w = ssize.width / 2 - wsize.width / 2;
            h = ssize.height / 2 - wsize.height / 2;
            w += centerOn.getX();
            h += centerOn.getY();
            w = Math.max(w, 0);
            h = Math.max(h, 0);
        }
        win.setLocation(w, h);
    }

    public static Frame getParentFrame(Component c) {
        Container parent;
        for (parent = c.getParent(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        return (Frame)parent;
    }

    public static Font getSILKDialogFont() {
        return (Font)SILKGlobal.getInstance().getPropertyValue(55);
    }

    public static boolean useStyleFontSizes() {
        return (Boolean)SILKGlobal.getInstance().getPropertyValue(56);
    }

    public static Dialog getParentDialog(Component c) {
        Container parent;
        for (parent = c.getParent(); parent != null && !(parent instanceof Dialog); parent = parent.getParent()) {
        }
        return (Dialog)parent;
    }
}

