/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TitlePropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.util.PropertyEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class TitlePanel
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener,
TabPanelInterface,
TitlePropertyInterface {
    private static final long serialVersionUID = 3041905941755319728L;
    protected static int BORDER = 4;
    protected static int GAP = 4;
    protected Vector listeners = new Vector();
    protected boolean[] textExisting;
    protected JCheckBox[] showCheckBox;
    protected JTextField[] textField;
    protected JButton[] textButton;
    protected JPanel[] subPanel;
    protected TextDialog textDialog;
    protected Color GRAYOUT;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public TitlePanel(PropertyInterface graph, JComponent component) {
        this.addPropertyListener(graph);
        this.textExisting = new boolean[3];
        this.showCheckBox = new JCheckBox[3];
        this.textField = new JTextField[3];
        this.textButton = new JButton[3];
        this.subPanel = new JPanel[3];
        this.setSize(265, 410);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.textDialog = new TextDialog((Frame)null, component);
        this.textDialog.setVerticalJustificationSupported(false);
        this.GRAYOUT = this.getBackground().darker();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
            if (!(c instanceof JComboBox)) continue;
            c.setBackground(Color.white);
        }
    }

    protected void layoutPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(BORDER, BORDER, BORDER, BORDER));
        this.setLayout(new GridBagLayout());
        for (int i = 0; i < this.subPanel.length; ++i) {
            this.textField[i] = new JTextField(30);
            this.textButton[i] = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Text_options.txt", (String)"Text options..."));
        }
        this.showCheckBox[0] = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Show_title.txt", (String)"Show title"));
        this.subPanel[0] = this.makeSubPanel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Title.txt", (String)"Title"), this.showCheckBox[0], this.textField[0], this.textButton[0]);
        this.showCheckBox[1] = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Show_subtitle.txt", (String)"Show subtitle"));
        this.subPanel[1] = this.makeSubPanel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Subtitle.txt", (String)"Subtitle"), this.showCheckBox[1], this.textField[1], this.textButton[1]);
        this.showCheckBox[2] = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Show_footnote.txt", (String)"Show footnote"));
        this.subPanel[2] = this.makeSubPanel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Footnote.txt", (String)"Footnote"), this.showCheckBox[2], this.textField[2], this.textButton[2]);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        this.add((Component)this.subPanel[0], constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        this.add((Component)this.subPanel[1], constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.subPanel[2], constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)new JPanel(), constraints);
    }

    protected JPanel makeSubPanel(String title, JCheckBox show, JTextField text, JButton textButton) {
        JPanel panel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        panel.setBorder(border);
        panel.setLayout(new BorderLayout());
        JPanel sPanel = new JPanel();
        sPanel.setLayout(new BoxLayout(sPanel, 0));
        sPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        sPanel.add(show);
        sPanel.add(Box.createHorizontalGlue());
        JPanel tPanel = new JPanel();
        tPanel.setLayout(new BoxLayout(tPanel, 0));
        JLabel tLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Text.txt", (String)"Text:"));
        tPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        tPanel.add(tLabel);
        tPanel.add(Box.createRigidArea(new Dimension(tLabel.getPreferredSize().width, 0)));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)text, "Center");
        tPanel.add(p);
        tPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel button = new JPanel(new FlowLayout(2));
        button.add(textButton);
        panel.add((Component)sPanel, "North");
        panel.add((Component)tPanel, "Center");
        panel.add((Component)button, "South");
        return panel;
    }

    protected void setEnablePanel(JPanel panel, boolean all, boolean enable) {
        Serializable c;
        Border b = panel.getBorder();
        if (all && b != null && b instanceof TitledBorder) {
            c = enable ? Color.black : this.GRAYOUT;
            ((TitledBorder)b).setTitleColor((Color)c);
        }
        int count = panel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            c = panel.getComponent(i);
            if (c instanceof JPanel) {
                this.setEnablePanel((JPanel)c, all, enable);
                continue;
            }
            if (!all && c instanceof JCheckBox) continue;
            ((Component)c).setEnabled(enable);
        }
        panel.repaint();
    }

    private void setInitialValues() {
        if (this.listeners.isEmpty()) {
            this.setEnablePanel(this, true, false);
        }
        for (int i = 0; i < this.subPanel.length; ++i) {
            this.initSubPanel(i);
        }
    }

    private void initSubPanel(int index) {
        int j = -1;
        if (index == 0) {
            j = 601;
        } else if (index == 1) {
            j = 602;
        } else if (index == 2) {
            j = 603;
        }
        Object obj = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)j);
        if (obj == null || !(obj instanceof PropertyInterface)) {
            return;
        }
        PropertyInterface src = (PropertyInterface)obj;
        Object value = src.getPropertyValue(9015);
        if (value != null) {
            if (((String)value).length() > 0) {
                this.textField[index].setText(value.toString());
            } else {
                String t = "";
                if (index == 0) {
                    t = ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Title.txt", (String)"Title");
                }
                if (index == 1) {
                    t = ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Subtitle.txt", (String)"Subtitle");
                }
                if (index == 2) {
                    t = ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Footnote.txt", (String)"Footnote");
                }
                this.textField[index].setText(t);
                this.updateTextField(this.textField[index].getDocument());
            }
        } else {
            this.textField[index].setText(null);
            this.textExisting[index] = false;
        }
        Object vis = src.getPropertyValue(9000);
        if (vis == null || !(vis instanceof Boolean)) {
            this.showCheckBox[index].setSelected(false);
            this.setEnablePanel(this.subPanel[index], false, false);
        } else {
            boolean b = (Boolean)vis;
            this.showCheckBox[index].setSelected(b);
            this.setEnablePanel(this.subPanel[index], false, b);
        }
    }

    private void addListeners() {
        for (int i = 0; i < this.showCheckBox.length; ++i) {
            this.showCheckBox[i].addItemListener(this);
            this.textButton[i].addActionListener(this);
            this.textField[i].getDocument().addDocumentListener(this);
        }
    }

    private void removeListeners() {
        for (int i = 0; i < this.showCheckBox.length; ++i) {
            this.showCheckBox[i].removeItemListener(this);
            this.textButton[i].removeActionListener(this);
            this.textField[i].getDocument().removeDocumentListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        Object object = null;
        if (source == this.textButton[0]) {
            object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)601);
        } else if (source == this.textButton[1]) {
            object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)602);
        } else if (source == this.textButton[2]) {
            object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)603);
        }
        if (object != null && object instanceof PropertyInterface) {
            this.textDialog.showDialog((PropertyInterface)object, ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Text_options_title.txt", (String)"Text options"));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        boolean on = evt.getStateChange() == 1;
        for (int i = 0; i < this.showCheckBox.length; ++i) {
            Object object;
            int j = -1;
            if (i == 0) {
                j = 601;
            } else if (i == 1) {
                j = 602;
            } else if (i == 2) {
                j = 603;
            }
            Object prop = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)j);
            if (prop == null || !(prop instanceof PropertyInterface)) {
                return;
            }
            PropertyInterface txt = (PropertyInterface)prop;
            if (source != this.showCheckBox[i]) continue;
            this.setEnablePanel(this.subPanel[i], false, on);
            txt.setPropertyValue(9000, (Object)new PropertyEvent(9000, (Object)this, (Object)new Boolean(on)));
            if (this.textExisting[i] || !on) break;
            if (i == 0) {
                j = 601;
            }
            if (i == 1) {
                j = 602;
            }
            if (i == 2) {
                j = 603;
            }
            if (!((object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)j)) instanceof Text)) {
                this.textButton[i].setEnabled(false);
            }
            if (this.textField[i].getText().length() != 0) break;
            String t = "";
            if (i == 0) {
                t = ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Title.txt", (String)"Title");
            }
            if (i == 1) {
                t = ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Subtitle.txt", (String)"Subtitle");
            }
            if (i == 2) {
                t = ResourceLoader.getResourceString((Object)this.rb, (String)"TitlePanel.Footnote.txt", (String)"Footnote");
            }
            this.textField[i].setText(t);
            this.textField[i].selectAll();
            this.textField[i].requestFocus();
            break;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.updateTextField(evt.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.updateTextField(evt.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.updateTextField(evt.getDocument());
    }

    protected void updateTextField(Document document) {
        for (int i = 0; i < this.textField.length; ++i) {
            int j = -1;
            if (i == 0) {
                j = 601;
            } else if (i == 1) {
                j = 602;
            } else if (i == 2) {
                j = 603;
            }
            Object obj = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)j);
            if (obj == null || !(obj instanceof PropertyInterface)) {
                return;
            }
            PropertyInterface txt = (PropertyInterface)obj;
            if (this.textField[i].getText().length() <= 0) continue;
            txt.setPropertyValue(9015, (Object)new PropertyEvent(9015, (Object)this, (Object)this.textField[i].getText()));
        }
    }

    @Override
    public boolean cancelChanges() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            PropertyInterface chart = (PropertyInterface)this.listeners.elementAt(i);
            chart.cancelPropertyChanges();
            Object obj = chart.getPropertyValue(601);
            if (obj != null && obj instanceof PropertyInterface) {
                ((PropertyInterface)obj).cancelPropertyChanges();
            }
            if ((obj = chart.getPropertyValue(602)) != null && obj instanceof PropertyInterface) {
                ((PropertyInterface)obj).cancelPropertyChanges();
            }
            if ((obj = chart.getPropertyValue(603)) == null || !(obj instanceof PropertyInterface)) continue;
            ((PropertyInterface)obj).cancelPropertyChanges();
        }
        this.setInitialValues();
        return true;
    }

    @Override
    public boolean applyChanges() {
        for (int i = 0; i < this.subPanel.length; ++i) {
            String str;
            if (this.textExisting[i] || (str = this.textField[i].getText()) == null || str.trim().equals("")) continue;
            if (i == 0) {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)604, (Object)new PropertyEvent(604, (Object)this, (Object)str));
            } else if (i == 1) {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)605, (Object)new PropertyEvent(605, (Object)this, (Object)str));
            } else {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)606, (Object)new PropertyEvent(606, (Object)this, (Object)str));
            }
            this.textExisting[i] = true;
        }
        Object object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)601);
        if (object != null && object instanceof PropertyInterface) {
            ((PropertyInterface)object).applyPropertyChanges();
        }
        if ((object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)602)) != null && object instanceof PropertyInterface) {
            ((PropertyInterface)object).applyPropertyChanges();
        }
        if ((object = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)603)) != null && object instanceof PropertyInterface) {
            ((PropertyInterface)object).applyPropertyChanges();
        }
        return true;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners != null && this.listeners.contains(prop)) {
            return false;
        }
        this.listeners.addElement(prop);
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null || !this.listeners.contains(prop)) {
            return false;
        }
        return this.listeners.remove(prop);
    }
}

