/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SpiralPropertyInterface;
import com.sas.graphics.silk.ui.NumericTextField;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.ScatterDialogDefaults;
import com.sas.graphics.util.PropertyUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class SpiralPanel
extends JPanel
implements ActionListener,
TabPanelInterface,
SpiralPropertyInterface {
    private static final long serialVersionUID = 8630076510931810483L;
    protected Vector propListeners;
    protected String sliderPattern;
    protected ScatterDialogDefaults defaults;
    protected Object[] sliderArgs;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private JLabel plotStyleLabel = null;
    private JComboBox plotStyleComboBox = null;
    private JLabel drawSpiralLabel = null;
    private JCheckBox drawSpiralCheckBox = null;
    private JLabel periodLabel = null;
    private JComboBox periodComboBox = null;
    private JLabel bucketLabel = null;
    private JComboBox bucketComboBox = null;
    private JLabel combinationLabel = null;
    private JComboBox combinationComboBox = null;
    private JLabel drawAxesLabel = null;
    private JCheckBox drawAxesCheckBox = null;
    private JLabel numberOfAxesLabel = null;
    private JLabel radiusBaseLabel = null;
    private JLabel radiusSpacingLabel = null;
    private JLabel radiusDeltaMaxLabel = null;
    private JLabel revolutionAngleLabel = null;
    private JLabel responseBaseLineLabel = null;
    private JComboBox responseBaselineComboBox = null;
    private JTextField numberOfAxesTextField = null;
    private JTextField revolutionAngleTextField = null;
    private JTextField radiusDeltaTextField = null;
    private JTextField radiusBaseTextField = null;
    private JTextField radiusSpacingTextField = null;
    private JLabel drawSpiralLabelsLabel = null;
    private JCheckBox drawSpiralLabelsCheckBox = null;
    private JLabel drawAxisLabelsLabel = null;
    private JCheckBox drawAxisLabelsCheckBox = null;
    private JLabel needleWidthLabel = null;
    private JTextField needleWidthTextField = null;
    private JLabel needleAALabel = null;
    private JCheckBox needleAACheckBox = null;
    private JPanel spiralPanel = null;
    private JPanel axisPanel = null;
    private JPanel dataPanel = null;
    private JPanel dataDisplayPanel = null;
    protected TitledBorder border;

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges((Vector)this.propListeners);
    }

    @Override
    public boolean cancelChanges() {
        this.setInitialValues();
        return PropertyUtils.cancelChanges((Vector)this.propListeners);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    private JTextField getRevolutionAngleTextField() {
        if (this.revolutionAngleTextField == null) {
            this.revolutionAngleTextField = new NumericTextField();
            this.revolutionAngleTextField.setSize(200, 200);
            this.revolutionAngleTextField.setFont(TabbedPropertiesDialog.dialogFont);
            this.revolutionAngleTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        PropertyUtils.setPropertyValue((Vector)SpiralPanel.this.propListeners, (int)1306, (Object)new Double(SpiralPanel.this.revolutionAngleTextField.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.revolutionAngleTextField;
    }

    private JTextField getNeedleWidthTextField() {
        if (this.needleWidthTextField == null) {
            this.needleWidthTextField = new NumericTextField();
            this.needleWidthTextField.setSize(200, 200);
            this.needleWidthTextField.setFont(TabbedPropertiesDialog.dialogFont);
            this.needleWidthTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        PropertyUtils.setPropertyValue((Vector)SpiralPanel.this.propListeners, (int)1310, (Object)new Double(SpiralPanel.this.needleWidthTextField.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.needleWidthTextField;
    }

    private JTextField getRadiusDeltaTextField() {
        if (this.radiusDeltaTextField == null) {
            this.radiusDeltaTextField = new NumericTextField();
            this.radiusDeltaTextField.setSize(200, 200);
            this.radiusDeltaTextField.setFont(TabbedPropertiesDialog.dialogFont);
            this.radiusDeltaTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        PropertyUtils.setPropertyValue((Vector)SpiralPanel.this.propListeners, (int)1305, (Object)new Double(SpiralPanel.this.radiusDeltaTextField.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.radiusDeltaTextField;
    }

    private JTextField getRadiusBaseTextField() {
        if (this.radiusBaseTextField == null) {
            this.radiusBaseTextField = new NumericTextField();
            this.radiusBaseTextField.setSize(2000, 200);
            this.radiusBaseTextField.setFont(TabbedPropertiesDialog.dialogFont);
            this.radiusBaseTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        PropertyUtils.setPropertyValue((Vector)SpiralPanel.this.propListeners, (int)1303, (Object)new Double(SpiralPanel.this.radiusBaseTextField.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.radiusBaseTextField;
    }

    private JTextField getRadiusSpacingTextField() {
        if (this.radiusSpacingTextField == null) {
            this.radiusSpacingTextField = new NumericTextField();
            this.radiusSpacingTextField.setSize(200, 200);
            this.radiusSpacingTextField.setFont(TabbedPropertiesDialog.dialogFont);
            this.radiusSpacingTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        PropertyUtils.setPropertyValue((Vector)SpiralPanel.this.propListeners, (int)1304, (Object)new Double(SpiralPanel.this.radiusSpacingTextField.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.radiusSpacingTextField;
    }

    private JLabel getPeriodLabel() {
        if (this.periodLabel == null) {
            this.periodLabel = new JLabel();
            this.periodLabel.setText("Period Criterion: ");
            this.periodLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.periodLabel;
    }

    private JLabel getNeedleWidthLabel() {
        if (this.needleWidthLabel == null) {
            this.needleWidthLabel = new JLabel();
            this.needleWidthLabel.setText("Needle Width (px): ");
            this.needleWidthLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.needleWidthLabel;
    }

    private JLabel getNeedleAALabel() {
        if (this.needleAALabel == null) {
            this.needleAALabel = new JLabel();
            this.needleAALabel.setText("Anti-Aliasing: ");
            this.needleAALabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.needleAALabel;
    }

    private JComboBox getPeriodComboBox() {
        if (this.periodComboBox == null) {
            this.periodComboBox = new JComboBox();
            this.periodComboBox.addItem("Day");
            this.periodComboBox.addItem("Week");
            this.periodComboBox.addItem("Month");
            this.periodComboBox.addItem("Year");
            this.periodComboBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.periodComboBox;
    }

    private JLabel getBucketLabel() {
        if (this.bucketLabel == null) {
            this.bucketLabel = new JLabel();
            this.bucketLabel.setText("Sector: ");
            this.bucketLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.bucketLabel;
    }

    private JComboBox getBucketComboBox() {
        if (this.bucketComboBox == null) {
            this.bucketComboBox = new JComboBox();
            this.bucketComboBox.addItem("Day");
            this.bucketComboBox.addItem("Week");
            this.bucketComboBox.addItem("Month");
            this.bucketComboBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.bucketComboBox;
    }

    private JLabel getRadiusBaseLabel() {
        if (this.radiusBaseLabel == null) {
            this.radiusBaseLabel = new JLabel();
            this.radiusBaseLabel.setText("Offset: ");
            this.radiusBaseLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.radiusBaseLabel;
    }

    private JLabel getRadiusSpacingLabel() {
        if (this.radiusSpacingLabel == null) {
            this.radiusSpacingLabel = new JLabel();
            this.radiusSpacingLabel.setText("Radius Spacing: ");
            this.radiusSpacingLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.radiusSpacingLabel;
    }

    private JLabel getRadiusDeltaMaxLabel() {
        if (this.radiusDeltaMaxLabel == null) {
            this.radiusDeltaMaxLabel = new JLabel();
            this.radiusDeltaMaxLabel.setText("Needle Height:");
            this.radiusDeltaMaxLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.radiusDeltaMaxLabel;
    }

    private JLabel getDrawSpiralLabel() {
        if (this.drawSpiralLabel == null) {
            this.drawSpiralLabel = new JLabel();
            this.drawSpiralLabel.setText("Display Spiral:");
            this.drawSpiralLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawSpiralLabel;
    }

    private JLabel getDrawAxesLabel() {
        if (this.drawAxesLabel == null) {
            this.drawAxesLabel = new JLabel();
            this.drawAxesLabel.setText("Diplay Axes:");
            this.drawAxesLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawAxesLabel;
    }

    private JLabel getPlotStyleLabel() {
        if (this.plotStyleLabel == null) {
            this.plotStyleLabel = new JLabel();
            this.plotStyleLabel.setText("Plot Style:");
            this.plotStyleLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.plotStyleLabel;
    }

    private JLabel getResponseBaseLineLabel() {
        if (this.responseBaseLineLabel == null) {
            this.responseBaseLineLabel = new JLabel();
            this.responseBaseLineLabel.setText("Baseline: ");
            this.responseBaseLineLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.responseBaseLineLabel;
    }

    private JLabel getRevolutionAngleLabel() {
        if (this.revolutionAngleLabel == null) {
            this.revolutionAngleLabel = new JLabel();
            this.revolutionAngleLabel.setText("Revolution Angle: ");
            this.revolutionAngleLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.revolutionAngleLabel;
    }

    private JCheckBox getDrawSpiralCheckBox() {
        if (this.drawSpiralCheckBox == null) {
            this.drawSpiralCheckBox = new JCheckBox();
            this.drawSpiralCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawSpiralCheckBox;
    }

    private JCheckBox getNeedleAACheckBox() {
        if (this.needleAACheckBox == null) {
            this.needleAACheckBox = new JCheckBox();
            this.needleAACheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.needleAACheckBox;
    }

    private JCheckBox getDrawAxesCheckBox() {
        if (this.drawAxesCheckBox == null) {
            this.drawAxesCheckBox = new JCheckBox();
            this.drawAxesCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawAxesCheckBox;
    }

    private JLabel getNumberOfAxesLabel() {
        if (this.numberOfAxesLabel == null) {
            this.numberOfAxesLabel = new JLabel();
            this.numberOfAxesLabel.setText("Number Of Axes:");
            this.numberOfAxesLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.numberOfAxesLabel;
    }

    private JTextField getNumberOfAxesTextField() {
        if (this.numberOfAxesTextField == null) {
            this.numberOfAxesTextField = new NumericTextField();
            this.numberOfAxesTextField.setSize(200, 200);
            this.numberOfAxesTextField.setFont(TabbedPropertiesDialog.dialogFont);
            this.numberOfAxesTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        PropertyUtils.setPropertyValue((Vector)SpiralPanel.this.propListeners, (int)1302, (Object)new Double(SpiralPanel.this.numberOfAxesTextField.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.numberOfAxesTextField;
    }

    private JComboBox getPlotStyleComboBox() {
        if (this.plotStyleComboBox == null) {
            this.plotStyleComboBox = new JComboBox();
            this.plotStyleComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.plotStyleComboBox.addItem("Needle");
        }
        return this.plotStyleComboBox;
    }

    private JComboBox getResponseBaselineComboBox() {
        if (this.responseBaselineComboBox == null) {
            this.responseBaselineComboBox = new JComboBox();
            this.responseBaselineComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.responseBaselineComboBox.addItem("Zero");
            this.responseBaselineComboBox.addItem("Median");
            this.responseBaselineComboBox.addItem("Mean");
        }
        return this.responseBaselineComboBox;
    }

    private JLabel getDrawSpiralLabelsLabel() {
        if (this.drawSpiralLabelsLabel == null) {
            this.drawSpiralLabelsLabel = new JLabel();
            this.drawSpiralLabelsLabel.setText("Display SpiralLabels: ");
            this.drawSpiralLabelsLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawSpiralLabelsLabel;
    }

    private JCheckBox getDrawSpiralLabelsCheckBox() {
        if (this.drawSpiralLabelsCheckBox == null) {
            this.drawSpiralLabelsCheckBox = new JCheckBox();
            this.drawSpiralLabelsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawSpiralLabelsCheckBox;
    }

    private JLabel getDrawAxisLabelsLabel() {
        if (this.drawAxisLabelsLabel == null) {
            this.drawAxisLabelsLabel = new JLabel();
            this.drawAxisLabelsLabel.setText("Display AxisLabels: ");
            this.drawAxisLabelsLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawAxisLabelsLabel;
    }

    private JCheckBox getDrawAxisLabelsCheckBox() {
        if (this.drawAxisLabelsCheckBox == null) {
            this.drawAxisLabelsCheckBox = new JCheckBox();
            this.drawAxisLabelsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.drawAxisLabelsCheckBox;
    }

    private JLabel getCombinationLabel() {
        if (this.combinationLabel == null) {
            this.combinationLabel = new JLabel();
            this.combinationLabel.setText("Statistic: ");
            this.combinationLabel.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.combinationLabel;
    }

    private JComboBox getCombinationComboBox() {
        if (this.combinationComboBox == null) {
            this.combinationComboBox = new JComboBox();
            this.combinationComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.combinationComboBox.addItem("Sum");
            this.combinationComboBox.addItem("Max");
            this.combinationComboBox.addItem("Min");
            this.combinationComboBox.addItem("Mean");
        }
        return this.combinationComboBox;
    }

    private void addListeners() {
        this.periodComboBox.addActionListener(this);
        this.bucketComboBox.addActionListener(this);
        this.responseBaselineComboBox.addActionListener(this);
        this.plotStyleComboBox.addActionListener(this);
        this.drawSpiralCheckBox.addActionListener(this);
        this.drawAxesCheckBox.addActionListener(this);
        this.radiusBaseTextField.addActionListener(this);
        this.radiusDeltaTextField.addActionListener(this);
        this.drawSpiralLabelsCheckBox.addActionListener(this);
        this.drawAxisLabelsCheckBox.addActionListener(this);
        this.combinationComboBox.addActionListener(this);
        this.numberOfAxesTextField.addActionListener(this);
        this.needleAACheckBox.addActionListener(this);
        this.needleWidthTextField.addActionListener(this);
    }

    private void removeListeners() {
        this.periodComboBox.removeActionListener(this);
        this.bucketComboBox.removeActionListener(this);
        this.responseBaselineComboBox.removeActionListener(this);
        this.plotStyleComboBox.removeActionListener(this);
        this.drawSpiralCheckBox.removeActionListener(this);
        this.drawAxesCheckBox.removeActionListener(this);
        this.radiusBaseTextField.removeActionListener(this);
        this.radiusDeltaTextField.removeActionListener(this);
        this.drawSpiralLabelsCheckBox.removeActionListener(this);
        this.drawAxisLabelsCheckBox.removeActionListener(this);
        this.combinationComboBox.removeActionListener(this);
        this.numberOfAxesTextField.removeActionListener(this);
        this.needleAACheckBox.removeActionListener(this);
        this.needleWidthTextField.removeActionListener(this);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        if (source instanceof JCheckBox) {
            JCheckBox check = (JCheckBox)source;
            boolean status = check.isSelected();
            if (check.equals(this.drawAxesCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1301, (Object)new Boolean(status));
            } else if (check.equals(this.drawSpiralCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1300, (Object)new Boolean(status));
            } else if (check.equals(this.drawSpiralLabelsCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1307, (Object)new Boolean(status));
            } else if (check.equals(this.drawAxisLabelsCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1308, (Object)new Boolean(status));
            } else if (check.equals(this.needleAACheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1309, (Object)new Boolean(status));
            }
        } else if (source instanceof JComboBox) {
            JComboBox box = (JComboBox)source;
            String value = box.getSelectedItem().toString();
            if (box.equals(this.plotStyleComboBox)) {
                if (value.equals("Needle")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1100, (Object)new Integer(1102));
                } else if (value.equals("Marker")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1100, (Object)new Integer(1101));
                }
            } else if (box.equals(this.periodComboBox)) {
                if (value.equals("Year")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1001, (Object)new Integer(1002));
                } else if (value.equals("Month")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1001, (Object)new Integer(1003));
                } else if (value.equals("Week")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1001, (Object)new Integer(1004));
                } else if (value.equals("Day")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1001, (Object)new Integer(1005));
                }
            } else if (box.equals(this.bucketComboBox)) {
                if (value.equals("Year")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1401, (Object)new Integer(1402));
                } else if (value.equals("Month")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1401, (Object)new Integer(1403));
                } else if (value.equals("Week")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1401, (Object)new Integer(1404));
                } else if (value.equals("Day")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1401, (Object)new Integer(1405));
                }
            } else if (box.equals(this.responseBaselineComboBox)) {
                if (value.equals("Zero")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1200, (Object)new Integer(1201));
                } else if (value.equals("Median")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1200, (Object)new Integer(1202));
                } else if (value.equals("Mean")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1200, (Object)new Integer(1203));
                }
            } else if (box.equals(this.combinationComboBox)) {
                if (value.equals("Sum")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1500, (Object)new Integer(1501));
                } else if (value.equals("Max")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1500, (Object)new Integer(1502));
                } else if (value.equals("Min")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1500, (Object)new Integer(1503));
                } else if (value.equals("Mean")) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)1500, (Object)new Integer(1504));
                }
            }
        } else {
            return;
        }
    }

    protected double getNumericProperty(Vector props, int id, double defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    protected boolean getBooleanProperty(Vector props, int id, boolean defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (!(c instanceof JPanel)) continue;
            this.updatePanelUI((JComponent)c);
        }
    }

    public void setInitialValues() {
        int key = 0;
        key = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1001)).intValue();
        if (key == 1002) {
            this.periodComboBox.setSelectedItem("Year");
        } else if (key == 1003) {
            this.periodComboBox.setSelectedItem("Month");
        } else if (key == 1004) {
            this.periodComboBox.setSelectedItem("Week");
        } else if (key == 1005) {
            this.periodComboBox.setSelectedItem("Day");
        }
        key = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1401)).intValue();
        if (key == 1403) {
            this.bucketComboBox.setSelectedItem("Month");
        } else if (key == 1404) {
            this.bucketComboBox.setSelectedItem("Week");
        } else if (key == 1405) {
            this.bucketComboBox.setSelectedItem("Day");
        }
        key = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1500)).intValue();
        if (key == 1501) {
            this.combinationComboBox.setSelectedItem("Sum");
        } else if (key == 1504) {
            this.combinationComboBox.setSelectedItem("Mean");
        } else if (key == 1503) {
            this.combinationComboBox.setSelectedItem("Min");
        } else if (key == 1502) {
            this.combinationComboBox.setSelectedItem("Max");
        } else if (key == 1503) {
            this.combinationComboBox.setSelectedItem("Min");
        }
        key = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1200)).intValue();
        if (key == 1201) {
            this.responseBaselineComboBox.setSelectedItem("Zero");
        } else if (key == 1202) {
            this.responseBaselineComboBox.setSelectedItem("Median");
        } else if (key == 1203) {
            this.responseBaselineComboBox.setSelectedItem("Mean");
        }
        key = ((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1100)).intValue();
        if (key == 1102) {
            this.plotStyleComboBox.setSelectedItem("Needle");
        } else if (key == 1101) {
            this.plotStyleComboBox.setSelectedItem("Marker");
        }
        this.drawSpiralCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1300));
        this.drawAxesCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1301));
        this.drawSpiralLabelsCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1307));
        this.drawAxisLabelsCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1308));
        this.needleAACheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1309));
        this.radiusBaseTextField.setText(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1303)).toString());
        this.radiusDeltaTextField.setText(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1305)).toString());
        this.numberOfAxesTextField.setText(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1302)).toString());
        this.needleWidthTextField.setText(((Number)PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)1310)).toString());
    }

    private JPanel getSpiralPanel() {
        if (this.spiralPanel == null) {
            this.spiralPanel = new JPanel();
            this.spiralPanel.setLayout(new GridLayout(0, 2));
            this.spiralPanel.setSize(new Dimension(260, 80));
            this.border = new TitledBorder(new EtchedBorder());
            this.border.setTitleFont(TabbedPropertiesDialog.dialogFont);
            this.border.setTitle("Spiral Settings");
            this.spiralPanel.setBorder(this.border);
            this.spiralPanel.add(this.getDrawSpiralLabel());
            this.spiralPanel.add(this.getDrawSpiralCheckBox());
            this.spiralPanel.add(this.getDrawSpiralLabelsLabel());
            this.spiralPanel.add(this.getDrawSpiralLabelsCheckBox());
        }
        return this.spiralPanel;
    }

    private JPanel getAxisPanel() {
        if (this.axisPanel == null) {
            this.axisPanel = new JPanel();
            this.axisPanel.setLayout(new GridLayout(0, 2));
            this.axisPanel.setSize(new Dimension(260, 100));
            this.border = new TitledBorder(new EtchedBorder());
            this.border.setTitleFont(TabbedPropertiesDialog.dialogFont);
            this.border.setTitle("Axis Settings");
            this.axisPanel.setBorder(this.border);
            this.axisPanel.add(this.getDrawAxesLabel());
            this.axisPanel.add(this.getDrawAxesCheckBox());
            this.axisPanel.add(this.getDrawAxisLabelsLabel());
            this.axisPanel.add(this.getDrawAxisLabelsCheckBox());
            this.axisPanel.add(this.getNumberOfAxesLabel());
            this.axisPanel.add(this.getNumberOfAxesTextField());
        }
        return this.axisPanel;
    }

    private JPanel getDataPanel() {
        if (this.dataPanel == null) {
            this.dataPanel = new JPanel();
            this.dataPanel.setLayout(new GridLayout(0, 2));
            this.dataPanel.setSize(new Dimension(260, 160));
            this.border = new TitledBorder(new EtchedBorder());
            this.border.setTitleFont(TabbedPropertiesDialog.dialogFont);
            this.border.setTitle("Data Settings");
            this.dataPanel.setBorder(this.border);
            this.dataPanel.add(this.getPeriodLabel());
            this.dataPanel.add(this.getPeriodComboBox());
            this.dataPanel.add(this.getBucketLabel());
            this.dataPanel.add(this.getBucketComboBox());
            this.dataPanel.add(this.getCombinationLabel());
            this.dataPanel.add(this.getCombinationComboBox());
            this.dataPanel.add(this.getResponseBaseLineLabel());
            this.dataPanel.add(this.getResponseBaselineComboBox());
        }
        return this.dataPanel;
    }

    private JPanel getDataDisplayPanel() {
        if (this.dataDisplayPanel == null) {
            this.dataDisplayPanel = new JPanel();
            this.dataDisplayPanel.setLayout(new GridLayout(0, 2));
            this.dataDisplayPanel.setSize(new Dimension(260, 160));
            this.border = new TitledBorder(new EtchedBorder());
            this.border.setTitleFont(TabbedPropertiesDialog.dialogFont);
            this.border.setTitle("Data Display Settings");
            this.dataDisplayPanel.setBorder(this.border);
            this.dataDisplayPanel.add(this.getPlotStyleLabel());
            this.dataDisplayPanel.add(this.getPlotStyleComboBox());
            this.dataDisplayPanel.add(this.getNeedleWidthLabel());
            this.dataDisplayPanel.add(this.getNeedleWidthTextField());
            this.dataDisplayPanel.add(this.getNeedleAALabel());
            this.dataDisplayPanel.add(this.getNeedleAACheckBox());
            this.dataDisplayPanel.add(this.getRadiusBaseLabel());
            this.dataDisplayPanel.add(this.getRadiusBaseTextField());
            this.dataDisplayPanel.add(this.getRadiusDeltaMaxLabel());
            this.dataDisplayPanel.add(this.getRadiusDeltaTextField());
        }
        return this.dataDisplayPanel;
    }

    public SpiralPanel() {
        this.sliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Size_Slider_Text.fmt", (String)"Size: {0,number,integer}");
        Insets ins = this.getInsets();
        this.propListeners = new Vector();
        this.setLayout(new BoxLayout(this, 3));
        this.setSize(ins.left + ins.right + 280, ins.top + ins.bottom + 270);
        this.layoutPanel();
        this.updateUI();
    }

    private void layoutPanel() {
        this.add(this.getDataPanel());
        this.add(this.getDataDisplayPanel());
        this.add(this.getAxisPanel());
        this.add(this.getSpiralPanel());
    }
}

