/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

class SortEntry
extends JComponent
implements ItemListener {
    private static final long serialVersionUID = -5584209993906695240L;
    JLabel label = null;
    JComboBox combo = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    Object role = null;
    RoleInterface callback = null;
    JRadioButton radioButton = null;
    boolean ignoreEvents = false;

    public SortEntry(Object role, int[] sorts, boolean dependent) {
        this.role = role;
        this.setMaximumSize(new Dimension(1000, 30));
        this.setPreferredSize(new Dimension(500, 30));
        this.label = new JLabel(role.toString());
        this.label.setFont(TabbedPropertiesDialog.dialogFont);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.combo = new JComboBox();
        this.combo.setFont(TabbedPropertiesDialog.dialogFont);
        this.combo.setBackground(Color.white);
        boolean a = false;
        boolean data = false;
        boolean d = false;
        boolean none = false;
        this.combo.setEnabled(sorts != null);
        if (sorts != null) {
            for (int i = 0; i < sorts.length; ++i) {
                if (sorts[i] == 1) {
                    a = true;
                    continue;
                }
                if (sorts[i] == 0) {
                    data = true;
                    continue;
                }
                if (sorts[i] == -1) {
                    d = true;
                    continue;
                }
                if (sorts[i] != -2) continue;
                none = true;
            }
            if (none) {
                this.combo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.None.txt", (String)"None"));
            }
            if (a) {
                this.combo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Ascending.txt", (String)"Ascending"));
            }
            if (data) {
                this.combo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Data.txt", (String)"Data"));
            }
            if (d) {
                this.combo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Descending.txt", (String)"Descending"));
            }
            this.combo.addItemListener(this);
        }
        this.setLayout(new BoxLayout(this, 0));
        if (dependent) {
            this.radioButton = new JRadioButton();
            this.radioButton.addItemListener(this);
            this.radioButton.setPreferredSize(new Dimension(25, 25));
            this.add(this.radioButton);
            this.combo.setEnabled(false);
        } else {
            JLabel l = new JLabel();
            l.setPreferredSize(new Dimension(25, 25));
            this.add(l);
        }
        this.add(this.label);
        this.add(this.combo);
    }

    public void init(RoleInterface chart, boolean setOnCallback) {
        this.callback = chart;
        this.combo.removeItemListener(this);
        Object sort = chart.getSortOrder(this.role);
        if (sort == null) {
            sort = RoleInterface.ROLE_SORT_DATA;
        }
        if (sort.equals(RoleInterface.ROLE_SORT_ASCENDING)) {
            this.combo.setSelectedItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Ascending.txt", (String)"Ascending"));
        } else if (sort.equals(RoleInterface.ROLE_SORT_DATA) || sort.equals(RoleInterface.ROLE_SORT_CUSTOM)) {
            String str = ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Data.txt", (String)"Data");
            this.combo.setSelectedItem(str);
            String str1 = (String)this.combo.getSelectedItem();
            if (str1 != null && !str1.equalsIgnoreCase(str)) {
                this.combo.setSelectedItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.None.txt", (String)"None"));
            }
        } else if (sort.equals(RoleInterface.ROLE_SORT_NONE)) {
            this.combo.setSelectedItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.None.txt", (String)"None"));
        } else if (sort.equals(RoleInterface.ROLE_SORT_DESCENDING)) {
            this.combo.setSelectedItem(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Descending.txt", (String)"Descending"));
        }
        this.combo.addItemListener(this);
        if (setOnCallback) {
            this.setSortOnCallback();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.combo) {
            this.setSortOnCallback();
        } else if (e.getSource() == this.radioButton) {
            boolean sel = this.radioButton.isSelected();
            this.combo.setEnabled(sel);
            if (sel) {
                this.setSortOnCallback();
            }
        }
    }

    void setSortOnCallback() {
        Integer so;
        if (this.ignoreEvents) {
            return;
        }
        Object sort = this.combo.getSelectedItem();
        if (sort == null) {
            return;
        }
        Integer n = so = this.callback == null ? RoleInterface.ROLE_SORT_DATA : this.callback.getSortOrder(this.role);
        if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Ascending.txt", (String)"Ascending"))) {
            so = RoleInterface.ROLE_SORT_ASCENDING;
        } else if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Data.txt", (String)"Data"))) {
            so = RoleInterface.ROLE_SORT_DATA;
        } else if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.Descending.txt", (String)"Descending"))) {
            so = RoleInterface.ROLE_SORT_DESCENDING;
        } else if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"SortPanel.None.txt", (String)"None"))) {
            so = RoleInterface.ROLE_SORT_NONE;
        }
        if (this.callback != null && so != null) {
            this.callback.setSortOrder(this.role, so);
            if (this.callback instanceof Component) {
                ((Component)((Object)this.callback)).repaint();
            }
        }
    }
}

